/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.constraints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.TransactableTable;
import org.axiondb.constraints.BaseConstraint;
import org.axiondb.constraints.PrimaryKeyConstraint;
import org.axiondb.constraints.UniqueConstraint;
import org.axiondb.engine.SnapshotIsolationTransaction;
import org.axiondb.engine.visitors.ResolveSelectableVisitor;
import org.axiondb.event.RowEvent;
import org.axiondb.event.RowInsertedEvent;

public class ForeignKeyConstraint
extends BaseConstraint {
    public static final int CASCADE = 10;
    public static final int RESTRICT = 40;
    public static final int SETDEFAULT = 30;
    public static final int SETNULL = 20;
    private static final long serialVersionUID = -54506312013696264L;
    private List _childColumns;
    private transient Table _childTable;
    private String _childTableName;
    private int _onDeleteActionType = 40;
    private int _onUpdateActionType = 40;
    private List _parentColumns;
    private transient Table _parentTable;
    private String _parentTableName;

    public ForeignKeyConstraint(String name) {
        this(name, "FOREIGN KEY");
        this._childColumns = new ArrayList();
        this._parentColumns = new ArrayList();
    }

    public ForeignKeyConstraint(String name, String type) {
        super(name, type);
    }

    public void addColumns(List list) {
        this._childColumns = list;
    }

    public void addForeignColumns(List list) {
        this._parentColumns = list;
    }

    public boolean evaluate(RowEvent event) throws AxionException {
        return this.evaluate(event, event.getTable().makeRowDecorator());
    }

    public boolean evaluate(RowEvent event, RowDecorator dec) throws AxionException {
        if (null != event.getNewRow()) {
            return this.handleInsertOrUpdate(event, dec);
        }
        if (null != event.getOldRow()) {
            return this.handleDelete(event, dec);
        }
        return true;
    }

    public List getChildTableColumns() {
        return this._childColumns;
    }

    public String getChildTableName() {
        return this._childTableName;
    }

    public int getOnDeleteActionType() {
        return this._onDeleteActionType;
    }

    public int getOnUpdateActionType() {
        return this._onUpdateActionType;
    }

    public List getParentTableColumns() {
        return this._parentColumns;
    }

    public String getParentTableName() {
        return this._parentTableName;
    }

    public void resolve(Database db, TableIdentifier table) throws AxionException {
        int i;
        if (!db.hasTable(this.getParentTableName())) {
            throw new AxionException("Parent Table not found");
        }
        this._childTableName = table.getTableName();
        this._childTable = db.getTable(this._childTableName);
        if (this._childTable instanceof TransactableTable) {
            this._childTable = ((TransactableTable)this._childTable).getTable();
        }
        this._parentTable = db.getTable(this.getParentTableName());
        this.resolveColumns();
        if (this._childColumns.isEmpty()) {
            throw new AxionException("Column reference not found...");
        }
        if (this._childColumns.size() != this._parentColumns.size()) {
            throw new AxionException("parent-child columns don't match...");
        }
        TableIdentifier[] tables = this.toArray(table);
        ResolveSelectableVisitor resolveSel = new ResolveSelectableVisitor(db);
        int I = this._childColumns.size();
        for (i = 0; i < I; ++i) {
            this._childColumns.set(i, resolveSel.visit((Selectable)this._childColumns.get(i), null, tables));
        }
        tables = this.toArray(new TableIdentifier(this.getParentTableName()));
        I = this._childColumns.size();
        for (i = 0; i < I; ++i) {
            this._parentColumns.set(i, resolveSel.visit((Selectable)this._parentColumns.get(i), null, tables));
        }
    }

    public void setChildTable(Table table) {
        this._childTable = table;
    }

    public void setChildTableName(String tableName) {
        this._childTableName = tableName;
    }

    public void setOnDeleteActionType(int actionType) {
        this._onDeleteActionType = actionType;
    }

    public void setOnUpdateActionType(int actionType) {
        this._onUpdateActionType = actionType;
    }

    public void setParentTable(Table table) {
        this._parentTable = table;
    }

    public void setParentTableName(String tableName) {
        this._parentTableName = tableName;
    }

    private boolean handleDelete(RowEvent event, RowDecorator dec) throws AxionException {
        Table table = event.getTable();
        dec.setRow(event.getOldRow());
        if (table.getName().equals(this.getParentTableName())) {
            RowIterator matching;
            ArrayList<Object> values = new ArrayList<Object>(this._parentColumns.size());
            int I = this._parentColumns.size();
            for (int i = 0; i < I; ++i) {
                values.add(((Selectable)this._parentColumns.get(i)).evaluate(dec));
            }
            Table childTable = this._childTable;
            if (table instanceof TransactableTable) {
                Iterator iter = ((TransactableTable)table).getTableModificationListeners();
                while (iter.hasNext()) {
                    Object db = iter.next();
                    if (!(db instanceof SnapshotIsolationTransaction)) continue;
                    childTable = ((SnapshotIsolationTransaction)db).getTable(this.getChildTableName());
                    break;
                }
            }
            if ((matching = childTable.getMatchingRows(this._childColumns, values, true)).hasNext()) {
                return this._onDeleteActionType == 10 || this._onDeleteActionType == 20 || this._onDeleteActionType == 30;
            }
            return true;
        }
        return true;
    }

    private boolean handleInsertOrUpdate(RowEvent event, RowDecorator dec) throws AxionException {
        Table table = event.getTable();
        dec.setRow(event.getNewRow());
        if (table.getName().equals(this.getChildTableName())) {
            RowIterator matching;
            ArrayList<Object> values = new ArrayList<Object>(this._childColumns.size());
            if (this._childTable == null && !this._childColumns.isEmpty()) {
                this._childTable = table;
            }
            int I = this._childColumns.size();
            for (int i = 0; i < I; ++i) {
                ColumnIdentifier colid = (ColumnIdentifier)this._childColumns.get(i);
                Object val = colid.evaluate(dec);
                if (val == null || val.equals(this._childTable.getColumn(colid.getName()).getDefault())) {
                    return true;
                }
                values.add(val);
            }
            Table parentTable = this._parentTable;
            if (table instanceof TransactableTable) {
                Iterator iter = ((TransactableTable)table).getTableModificationListeners();
                while (iter.hasNext()) {
                    Object db = iter.next();
                    if (!(db instanceof SnapshotIsolationTransaction)) continue;
                    parentTable = ((SnapshotIsolationTransaction)db).getTable(this.getParentTableName());
                    break;
                }
            }
            return (matching = parentTable.getMatchingRows(this._parentColumns, values, true)).hasNext();
        }
        return true;
    }

    public boolean evaluate(RowIterator oldRows, RowIterator newRows, Table table) throws AxionException {
        if (null == newRows || newRows.isEmpty()) {
            return true;
        }
        RowDecorator dec = table.makeRowDecorator();
        Row oldRow = null;
        newRows.reset();
        if (oldRows != null) {
            oldRows.reset();
        }
        while (newRows.hasNext()) {
            oldRow = null != oldRows && oldRows.hasNext() ? oldRows.next() : null;
            RowInsertedEvent event = new RowInsertedEvent(table, oldRow, newRows.next());
            if (this.evaluate(event, dec)) continue;
            return false;
        }
        return true;
    }

    private boolean matchColumns(List tableCols, List pkCols) {
        if (tableCols.size() != pkCols.size()) {
            return false;
        }
        int I = pkCols.size();
        for (int i = 0; i < I; ++i) {
            ColumnIdentifier colid = (ColumnIdentifier)tableCols.get(i);
            ColumnIdentifier pkcolid = (ColumnIdentifier)pkCols.get(i);
            if (colid.getName().equals(pkcolid.getName())) continue;
            return false;
        }
        return true;
    }

    private void resolveColumns() throws AxionException {
        Object constraint;
        boolean foundKey = false;
        UniqueConstraint uc = null;
        Iterator iter = this._parentTable.getConstraints();
        while (!foundKey && iter != null && iter.hasNext()) {
            constraint = iter.next();
            if (!(constraint instanceof PrimaryKeyConstraint)) continue;
            uc = (UniqueConstraint)constraint;
            foundKey = this.resolveColumn(uc);
        }
        iter = this._parentTable.getConstraints();
        while (!foundKey && iter != null && iter.hasNext()) {
            constraint = iter.next();
            if (!(constraint instanceof UniqueConstraint)) continue;
            uc = (UniqueConstraint)constraint;
            foundKey = this.resolveColumn(uc);
        }
        if (!foundKey) {
            throw new AxionException("Primary/Unique Key Constraint not found for the given keys in parent table");
        }
        uc.addFK(this.getName());
    }

    private boolean resolveColumn(UniqueConstraint uc) {
        boolean foundKey = false;
        if (this._parentColumns.isEmpty() && !this._childColumns.isEmpty() && this._childColumns.size() == uc.getSelectableCount()) {
            int I = this._childColumns.size();
            for (int i = 0; i < I; ++i) {
                this._parentColumns.add(new ColumnIdentifier(((ColumnIdentifier)uc.getSelectable(i)).getName()));
            }
            foundKey = true;
        } else if (this._childColumns.isEmpty() && !this._parentColumns.isEmpty() && this._parentColumns.size() == uc.getSelectableCount()) {
            int I = this._parentColumns.size();
            for (int i = 0; i < I; ++i) {
                this._childColumns.add(new ColumnIdentifier(((ColumnIdentifier)uc.getSelectable(i)).getName()));
            }
            foundKey = true;
        } else if (this._childColumns.isEmpty() && this._parentColumns.isEmpty()) {
            int I = uc.getSelectableCount();
            for (int i = 0; i < I; ++i) {
                this._parentColumns.add(new ColumnIdentifier(((ColumnIdentifier)uc.getSelectable(i)).getName()));
                this._childColumns.add(new ColumnIdentifier(((ColumnIdentifier)uc.getSelectable(i)).getName()));
            }
            foundKey = true;
        } else if (!this._childColumns.isEmpty() && !this._parentColumns.isEmpty() && this._childColumns.size() == this._parentColumns.size() && this.matchColumns(this._parentColumns, uc.getSelectableList())) {
            foundKey = true;
        }
        return foundKey;
    }
}

