/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.DatabaseLink;
import org.axiondb.Index;
import org.axiondb.IndexFactory;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TableFactory;
import org.axiondb.TableIdentifier;
import org.axiondb.TransactableTable;
import org.axiondb.Transaction;
import org.axiondb.TransactionManager;
import org.axiondb.VariableContext;
import org.axiondb.event.ColumnEvent;
import org.axiondb.event.ConstraintEvent;
import org.axiondb.event.DatabaseModificationListener;
import org.axiondb.event.RowEvent;
import org.axiondb.event.TableModificationListener;
import org.axiondb.functions.ConcreteFunction;

public class SnapshotIsolationTransaction
implements Transaction,
TableModificationListener,
VariableContext {
    private Map _contextVariables = new HashMap();
    private Set _modifiedTables = new HashSet();
    private Database _openOnTransaction;
    private Set _readTables = new HashSet();
    private int _state = 0;
    private Map _wrappedTables = new HashMap();

    public SnapshotIsolationTransaction(Database db) {
        this._openOnTransaction = db;
    }

    public void addDatabaseModificationListener(DatabaseModificationListener l) {
    }

    public void addIndex(Index index, Table table) throws AxionException {
        this._openOnTransaction.addIndex(index, table);
    }

    public void addIndex(Index index, Table table, boolean doPopulate) throws AxionException {
        this._openOnTransaction.addIndex(index, table, doPopulate);
    }

    public void addTable(Table table) throws AxionException {
        this._openOnTransaction.addTable(table);
    }

    public void apply() throws AxionException {
        if (1 != this._state) {
            throw new AxionException("Not committed, can't apply.");
        }
        for (TransactableTable ttable : this._wrappedTables.values()) {
            ttable.apply();
        }
        this._state = 3;
    }

    public void checkpoint() throws AxionException {
        this._openOnTransaction.checkpoint();
    }

    public void columnAdded(ColumnEvent event) throws AxionException {
    }

    public void commit() throws AxionException {
        this.assertOpen();
        for (TransactableTable ttable : this._wrappedTables.values()) {
            ttable.commit();
        }
        this._contextVariables.clear();
        this._state = 1;
    }

    public TransactableTable commit(TableIdentifier tid) throws AxionException {
        this.assertOpen();
        if (this._wrappedTables.containsKey(tid.getTableName())) {
            TransactableTable ttable = (TransactableTable)this._wrappedTables.remove(tid.getTableName());
            ttable.commit();
            ttable.apply();
            this._readTables.remove(tid.getTableName());
            this._modifiedTables.remove(tid.getTableName());
        }
        return this.getWrappedTable(tid);
    }

    public void constraintAdded(ConstraintEvent event) throws AxionException {
    }

    public void constraintRemoved(ConstraintEvent event) throws AxionException {
    }

    public boolean containsKey(Object key) {
        return this._contextVariables.containsKey(key);
    }

    public void createDatabaseLink(DatabaseLink server) throws AxionException {
        this._openOnTransaction.createDatabaseLink(server);
    }

    public void createSequence(Sequence seq) throws AxionException {
        this._openOnTransaction.createSequence(seq);
    }

    public int defragTable(String tableName) throws AxionException {
        if (this._wrappedTables.containsKey(tableName)) {
            TransactableTable ttable = (TransactableTable)this._wrappedTables.get(tableName);
            ttable.commit();
            ttable.apply();
            this._wrappedTables.remove(tableName);
            this._readTables.remove(tableName);
        }
        return this._openOnTransaction.defragTable(tableName);
    }

    public void dropDatabaseLink(String server) throws AxionException {
        this._openOnTransaction.dropDatabaseLink(server);
    }

    public void dropDependentExternalDBTable(List tables) throws AxionException {
        this._openOnTransaction.dropDependentExternalDBTable(tables);
    }

    public void dropDependentViews(List views) throws AxionException {
        this._openOnTransaction.dropDependentViews(views);
    }

    public void dropIndex(String name) throws AxionException {
        this._openOnTransaction.dropIndex(name);
    }

    public void dropSequence(String name) throws AxionException {
        this._openOnTransaction.dropSequence(name);
    }

    public void dropTable(String name) throws AxionException {
        this._openOnTransaction.dropTable(name);
        if (this._wrappedTables.containsKey(name)) {
            this._wrappedTables.remove(name);
            this._readTables.remove(name);
        }
    }

    public Object get(Object key) {
        return this._contextVariables.get(key);
    }

    public DatabaseLink getDatabaseLink(String name) {
        return this._openOnTransaction.getDatabaseLink(name);
    }

    public List getDatabaseModificationListeners() {
        return null;
    }

    public DataType getDataType(String name) {
        return this._openOnTransaction.getDataType(name);
    }

    public File getDBDirectory() {
        return this._openOnTransaction.getDBDirectory();
    }

    public List getDependentExternalDBTable(String name) {
        return this._openOnTransaction.getDependentExternalDBTable(name);
    }

    public List getDependentViews(String tableName) {
        return this._openOnTransaction.getDependentViews(tableName);
    }

    public ConcreteFunction getFunction(String name) {
        return this._openOnTransaction.getFunction(name);
    }

    public Object getGlobalVariable(String key) {
        return this._openOnTransaction.getGlobalVariable(key);
    }

    public IndexFactory getIndexFactory(String name) {
        return this._openOnTransaction.getIndexFactory(name);
    }

    public Set getModifiedTables() {
        return this._modifiedTables;
    }

    public String getName() {
        return this._openOnTransaction.getName();
    }

    public Database getOpenOnTransaction() {
        return this._openOnTransaction;
    }

    public Set getReadTables() {
        return this._readTables;
    }

    public Sequence getSequence(String name) {
        return this._openOnTransaction.getSequence(name);
    }

    public int getState() {
        return this._state;
    }

    public Table getTable(String name) throws AxionException {
        return this.getWrappedTable(new TableIdentifier(name));
    }

    public Table getTable(TableIdentifier table) throws AxionException {
        return this.getWrappedTable(table);
    }

    public TableFactory getTableFactory(String name) {
        return this._openOnTransaction.getTableFactory(name);
    }

    public TransactionManager getTransactionManager() {
        return this._openOnTransaction.getTransactionManager();
    }

    public boolean hasDatabaseLink(String name) throws AxionException {
        return this._openOnTransaction.hasDatabaseLink(name);
    }

    public boolean hasIndex(String name) throws AxionException {
        return this._openOnTransaction.hasIndex(name);
    }

    public boolean hasSequence(String name) throws AxionException {
        return this._openOnTransaction.hasSequence(name);
    }

    public boolean hasTable(String name) throws AxionException {
        return this._openOnTransaction.hasTable(name);
    }

    public boolean hasTable(TableIdentifier table) throws AxionException {
        return this._openOnTransaction.hasTable(table);
    }

    public boolean isReadOnly() {
        return this._openOnTransaction.isReadOnly();
    }

    public void migrate(int version) throws AxionException {
        this._openOnTransaction.migrate(version);
    }

    public void put(Object key, Object value) {
        this._contextVariables.put(key, value);
    }

    public void remount(File newdir) throws AxionException {
        this._openOnTransaction.remount(newdir);
    }

    public void remove(Object key) {
        this._contextVariables.remove(key);
    }

    public void renameTable(String oldName, String newName) throws AxionException {
        this.renameTable(oldName, newName, null);
    }

    public void renameTable(String oldName, String newName, Properties newTableProp) throws AxionException {
        if (this._wrappedTables.containsKey(oldName)) {
            TransactableTable ttable = (TransactableTable)this._wrappedTables.get(oldName);
            ttable.commit();
            ttable.apply();
            this._wrappedTables.remove(oldName);
            this._readTables.remove(oldName);
        }
        this._openOnTransaction.renameTable(oldName, newName, newTableProp);
    }

    public void rollback() throws AxionException {
        this.assertOpen();
        for (TransactableTable ttable : this._wrappedTables.values()) {
            ttable.rollback();
        }
        this._contextVariables.clear();
        this._state = 2;
    }

    public void rowDeleted(RowEvent event) throws AxionException {
        this._modifiedTables.add(event.getTable().getName());
    }

    public void rowInserted(RowEvent event) throws AxionException {
        this._modifiedTables.add(event.getTable().getName());
    }

    public void rowUpdated(RowEvent event) throws AxionException {
        this._modifiedTables.add(event.getTable().getName());
    }

    public void shutdown() throws AxionException {
        this._openOnTransaction.shutdown();
    }

    public void tableAltered(Table table) throws AxionException {
        this._openOnTransaction.tableAltered(table);
    }

    private void assertOpen() throws AxionException {
        if (0 != this._state) {
            throw new AxionException("Already committed or rolled back.");
        }
    }

    private TransactableTable getWrappedTable(TableIdentifier id) throws AxionException {
        TransactableTable ttable = (TransactableTable)this._wrappedTables.get(id.getTableName());
        if (null == ttable) {
            Table table = this._openOnTransaction.getTable(id);
            if (null == table) {
                return null;
            }
            ttable = table.makeTransactableTable();
            ttable.addTableModificationListener(this);
            this._wrappedTables.put(id.getTableName(), ttable);
            this._readTables.add(ttable.getName());
        }
        return ttable;
    }
}

