/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.axiondb.FromNode;
import org.axiondb.Literal;
import org.axiondb.OrderNode;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.TableIdentifier;

public class AxionQueryContext {
    private String _aliasName;
    private boolean _distinct = false;
    private boolean _explain = false;
    private boolean _foundAggregateFunction = false;
    private FromNode _from;
    private List _groupBy;
    private Selectable _having;
    private boolean _isCorrelatedSubQuery;
    private Literal _limit;
    private Literal _offset;
    private List _orderBy;
    private RowDecorator _parentRow;
    private TableIdentifier[] _parentTables;
    private boolean _resolved = false;
    private List _resolvedSelect;
    private RowIterator _rows;
    private List _select = new ArrayList();
    private Selectable[] _selected;
    private TableIdentifier[] _tables;
    private Selectable _where;

    public void addAllSelectToResolvedSelect() {
        if (this._resolvedSelect == null) {
            this._resolvedSelect = new ArrayList(this._select.size());
        }
        this._resolvedSelect.addAll(this._select);
    }

    public void addFrom(TableIdentifier table) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        if (this._from == null) {
            this._from = new FromNode();
            this._from.setType(0);
        }
        if (this._from.getLeft() == null) {
            this._from.setLeft(table);
        } else {
            this._from.setRight(table);
            this._from.setType(1);
        }
    }

    public void addOrderBy(OrderNode orderby) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        if (this._orderBy == null) {
            this._orderBy = new ArrayList(4);
        }
        this._orderBy.add(orderby);
    }

    public void addSelect(Selectable column) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        this._select.add(column);
    }

    public boolean foundAggregateFunction() {
        return this._foundAggregateFunction;
    }

    public String getAliasName() {
        return this._aliasName;
    }

    public boolean getDistinct() {
        return this._distinct;
    }

    public FromNode getFrom() {
        return this._from;
    }

    public TableIdentifier getFrom(int i) {
        TableIdentifier[] tableIDs = this._from.toTableArray();
        return tableIDs[i];
    }

    public TableIdentifier[] getFromArray() {
        if (this._from != null) {
            return this._from.toTableArray();
        }
        return null;
    }

    public int getFromCount() {
        return this._from.getTableCount();
    }

    public List getGroupBy() {
        if (this._groupBy != null) {
            return Collections.unmodifiableList(this._groupBy);
        }
        return Collections.EMPTY_LIST;
    }

    public Selectable getGroupBy(int i) {
        if (this._groupBy != null) {
            return (Selectable)this._groupBy.get(i);
        }
        return null;
    }

    public int getGroupByCount() {
        return null == this._groupBy ? 0 : this._groupBy.size();
    }

    public Literal getLimit() {
        return this._limit;
    }

    public Literal getOffset() {
        return this._offset;
    }

    public List getOrderBy() {
        if (this._orderBy != null) {
            return Collections.unmodifiableList(this._orderBy);
        }
        return Collections.EMPTY_LIST;
    }

    public OrderNode getOrderBy(int i) {
        if (this._orderBy != null) {
            return (OrderNode)this._orderBy.get(i);
        }
        return null;
    }

    public int getOrderByCount() {
        return null == this._orderBy ? 0 : this._orderBy.size();
    }

    public RowDecorator getParentRow() {
        return this._parentRow;
    }

    public TableIdentifier[] getParentTables() {
        return this._parentTables;
    }

    public List getResolvedSelect() {
        if (this._resolvedSelect == null) {
            this._resolvedSelect = new ArrayList();
        }
        return this._resolvedSelect;
    }

    public RowIterator getRows() {
        return this._rows;
    }

    public List getSelect() {
        return this._select;
    }

    public Selectable getSelect(int i) {
        return (Selectable)this._select.get(i);
    }

    public int getSelectCount() {
        return this._select.size();
    }

    public Selectable[] getSelected() {
        return this._selected;
    }

    public TableIdentifier[] getTables() {
        return this._tables;
    }

    public TableIdentifier getTables(int i) {
        return this._tables[i];
    }

    public int getTableCount() {
        return null == this._tables ? 0 : this._tables.length;
    }

    public Selectable getWhere() {
        return this._where;
    }

    public Selectable getHaving() {
        return this._having;
    }

    public boolean isCorrelatedSubQuery() {
        return this._isCorrelatedSubQuery;
    }

    public boolean isExplain() {
        return this._explain;
    }

    public boolean isResolved() {
        return this._resolved;
    }

    public boolean isTablePartOfSelect(TableIdentifier tid) {
        for (int i = 0; i < this._tables.length; ++i) {
            if (!tid.equals(this._tables[i])) continue;
            return true;
        }
        return false;
    }

    public void setAliasName(String name) {
        this._aliasName = name;
    }

    public void setCorrelatedSubQuery(boolean isCorrelatedSubQuery) {
        this._isCorrelatedSubQuery = isCorrelatedSubQuery;
    }

    public void setDistinct(boolean distinct) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        this._distinct = distinct;
    }

    public void setExplain(boolean explain) {
        this._explain = explain;
    }

    public void setFoundAggregateFunction(boolean found) {
        this._foundAggregateFunction = found;
    }

    public void setFrom(FromNode from) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        this._from = from;
    }

    public void setGroupBy(List groupby) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        this._groupBy = groupby;
    }

    void setGroupBy(int i, Selectable column) {
        if (this._groupBy == null) {
            throw new IllegalArgumentException("GroupBy List is Empty");
        }
        this._groupBy.set(i, column);
    }

    public void setLimit(Literal limit) {
        this._limit = limit;
    }

    public void setOffset(Literal offset) {
        this._offset = offset;
    }

    public void setOrderBy(List orderby) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        this._orderBy = orderby;
    }

    public void setParentRow(RowDecorator row) {
        this._parentRow = row;
    }

    public void setParentTables(TableIdentifier[] tables) {
        this._parentTables = tables;
    }

    public void setResolved(boolean resolved) {
        this._resolved = resolved;
    }

    public void setResolvedSelect(List select) {
        this._resolvedSelect = select;
    }

    public void setRows(RowIterator rows) {
        this._rows = rows;
    }

    public void setSelect(int i, Selectable sel) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        this._select.set(i, sel);
    }

    public void setSelect(List columns) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        this._select = columns;
    }

    public void setSelected(Selectable[] selected) {
        this._selected = selected;
    }

    public void setTables(TableIdentifier[] tables) {
        this._tables = tables;
    }

    public void setWhere(Selectable where) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        this._where = where;
    }

    public void setHaving(Selectable having) {
        if (this._resolved) {
            throw new IllegalStateException("Already resolved.");
        }
        this._having = having;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        if (this._distinct) {
            buf.append("DISTINCT ");
        }
        Iterator iter = this._select.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (null != this._from) {
            buf.append(" FROM ");
            buf.append(this._from);
        }
        if (null != this._where) {
            buf.append(" WHERE ");
            buf.append(this._where);
        }
        if (null != this._groupBy && !this._groupBy.isEmpty()) {
            buf.append(" GROUP BY ");
            iter = this._groupBy.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next());
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
        }
        if (null != this._having) {
            buf.append(" HAVING ");
            buf.append(this._having);
        }
        if (null != this._orderBy && !this._orderBy.isEmpty()) {
            buf.append(" ORDER BY ");
            iter = this._orderBy.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next());
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public List createLiteralList() {
        ArrayList<Selectable> literals = null;
        int I = this.getSelectCount();
        for (int i = 0; i < I; ++i) {
            if (!(this.getSelect(i) instanceof Literal)) continue;
            if (null == literals) {
                literals = new ArrayList<Selectable>();
            }
            literals.add(this.getSelect(i));
        }
        return literals;
    }
}

