/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Function;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.SnapshotIsolationTransaction;
import org.axiondb.engine.commands.ChildTableUpdater;
import org.axiondb.engine.commands.DMLWhenClause;
import org.axiondb.engine.commands.InsertIntoClause;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.engine.rowcollection.IntSet;
import org.axiondb.engine.rows.JoinedRow;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.ExternalDatabaseTable;
import org.axiondb.engine.visitors.FindBindVariableVisitor;
import org.axiondb.engine.visitors.TableColumnsUsedInFunctionVisitor;
import org.axiondb.jdbc.AxionResultSet;
import org.axiondb.util.ValuePool;

public class UpsertCommand
extends ChildTableUpdater {
    private List _columnsForInsert;
    private List _columnsForUpdate = new ArrayList();
    private Selectable _condition;
    private int _count;
    private ExceptionWhenClause _exceptionWhenClause;
    private boolean _resolved = false;
    private boolean _populateSequence = true;
    private boolean _isExternalDBTable = false;
    private SubSelectCommand _selectCommand;
    private Table _sourceTable;
    private TableIdentifier _sourceTableId;
    private Table _targetTable;
    private RowDecorator _dec;
    private RowDecorator _trgtDec;
    private TableIdentifier _targetTableId;
    private SubSelectCommand _usingSubselect;
    private String _usingSubSelectAlias;
    private List _valuesForInsert;
    private List _valuesForUpdate = new ArrayList();

    public void addUpdateColumn(ColumnIdentifier col) {
        this._columnsForUpdate.add(col);
    }

    public void addUpdateValue(Selectable val) {
        this._valuesForUpdate.add(val);
    }

    public boolean execute(Database database) throws AxionException {
        this.executeUpdate(database);
        return false;
    }

    public AxionResultSet executeQuery(Database database) throws AxionException {
        throw new UnsupportedOperationException("Use executeUpdate.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        IntSet rowcount = new IntSet();
        int exTblCnt = 0;
        int rowId = -1;
        Set sourceColsUsedInCondition = new HashSet();
        Set targetColsUsedInCondition = new HashSet();
        HashSet uniqueSourceRowSet = new HashSet();
        try {
            this.preProcess(db);
            this.resolve(db);
            RowIterator joinedRowIter = this._selectCommand.makeRowIterator(db, true);
            RowDecorator dec = this.buildDecorator(this._sourceTable, this._targetTable);
            TableColumnsUsedInFunctionVisitor tVisitor = new TableColumnsUsedInFunctionVisitor();
            tVisitor.visit((Function)this._condition, this._targetTable);
            targetColsUsedInCondition = tVisitor.getColumnsUsedInFunction();
            if (this.isTargetColumnUsedInUpdate(targetColsUsedInCondition)) {
                throw new AxionException("Updates Not allowed for cols used in Merge/Upsert Condition");
            }
            TableColumnsUsedInFunctionVisitor sVisitor = new TableColumnsUsedInFunctionVisitor();
            sVisitor.visit((Function)this._condition, this._sourceTable);
            sourceColsUsedInCondition = sVisitor.getColumnsUsedInFunction();
            int ttColCount = this._targetTable.getColumnCount();
            this.setDeferAllConstraintIfRequired(this._targetTable);
            while (joinedRowIter.hasNext()) {
                Iterator values;
                Iterator colids;
                SimpleRow newrow;
                JoinedRow joinRow = (JoinedRow)joinedRowIter.next();
                Row sourceRow = joinRow.getRow(0);
                Row targetRow = joinRow.getRow(1);
                dec.setRow(joinedRowIter.currentIndex(), joinRow);
                if (this.hasDuplicateRow(dec, sourceColsUsedInCondition, uniqueSourceRowSet)) {
                    throw new AxionException("Unable to get a stable set of rows in the source tables...");
                }
                if (this._exceptionWhenClause != null && this._exceptionWhenClause.insertMatchingRow(db, dec, sourceRow)) continue;
                if (this.isNullRow(targetRow)) {
                    newrow = new SimpleRow(ttColCount);
                    colids = this.getInsertColumnIterator();
                    values = this.getInsertValueIterator();
                    this.prepareRow(newrow, colids, values, dec, this._targetTable, db);
                    RowDecorator trgtDec = this.makeTargetRowDecorator();
                    trgtDec.setRow(newrow);
                    this.populateDefaultValues(db, this._targetTable, this._targetTableId, trgtDec);
                    if (this._populateSequence) {
                        this._populateSequence = this.populateSequenceColumns(db, this._targetTable, newrow);
                    }
                    this._targetTable.addRow(newrow);
                    rowId = newrow.getIdentifier();
                    if (rowId == -9999999) {
                        ++exTblCnt;
                    } else {
                        rowcount.add(rowId);
                    }
                } else {
                    newrow = new SimpleRow(targetRow);
                    colids = this.getUpdateColumnIterator();
                    values = this.getUpdateValueIterator();
                    this.prepareRow(newrow, colids, values, dec, this._targetTable, db);
                    if (this._isExternalDBTable) {
                        ((ExternalDatabaseTable)this._targetTable).updateRow(targetRow, newrow, this._columnsForUpdate);
                        rowId = newrow.getIdentifier();
                        if (rowId == -9999999) {
                            ++exTblCnt;
                        } else {
                            rowcount.add(rowId);
                        }
                    } else {
                        this.updateGeneratedValues(db, this._targetTable, this._targetTableId, newrow);
                        if (!((Object)targetRow).equals(newrow)) {
                            this._targetTable.updateRow(targetRow, newrow);
                            this.updateOrSetNullChildRows(db, this._targetTable, targetRow, newrow);
                            rowId = newrow.getIdentifier();
                            if (rowId == -9999999) {
                                ++exTblCnt;
                            } else {
                                rowcount.add(rowId);
                            }
                        }
                    }
                }
                this.commitIfRequired(db);
            }
        }
        finally {
            if (this._usingSubselect != null && this._sourceTable != null && db.hasTable(this._sourceTable.getName())) {
                db.dropTable(this._sourceTable.getName());
            }
        }
        this.setEffectedRowCount(rowcount.size() + exTblCnt);
        return rowcount.size() + exTblCnt;
    }

    public void setColumnsForInsert(List columnForInsert) {
        this._columnsForInsert = columnForInsert;
    }

    public void setCondition(Selectable condition) {
        this._condition = condition;
    }

    public Selectable getCondition() {
        return this._condition;
    }

    public void setExceptionWhenClause(DMLWhenClause w, TableIdentifier t, List cols, List vals) {
        this._exceptionWhenClause = new ExceptionWhenClause(w, t, cols, vals);
    }

    public ExceptionWhenClause getExceptionWhenClause() {
        return this._exceptionWhenClause;
    }

    public void setSelectCommand(SubSelectCommand command) {
        this._selectCommand = command;
    }

    public void setSourceTable(TableIdentifier table) {
        this._sourceTableId = table;
    }

    public void setTargetTable(TableIdentifier table) {
        this._targetTableId = table;
    }

    public void setUsingSubSelectAlias(String alias) {
        this._usingSubSelectAlias = alias;
    }

    public void setUsingSubSelectCommand(SubSelectCommand command) {
        this._usingSubselect = command;
    }

    public SubSelectCommand getUsingSubSelectCommand() {
        return this._usingSubselect;
    }

    public void setValuesForInsert(List valuesForInsert) {
        this._valuesForInsert = valuesForInsert;
    }

    protected void buildBindVariables() {
        this.setBindVariableVisitor(new FindBindVariableVisitor());
        this.getBindVariableVisitor().visit(this);
    }

    private RowDecorator buildDecorator(Table sourceTable, Table targetTable) throws AxionException {
        if (this._dec == null) {
            HashMap indexMap = new HashMap();
            int index = 0;
            Iterator iter = this.getColIdentifierList(sourceTable, this.getSourceTable()).iterator();
            while (iter.hasNext()) {
                indexMap.put(iter.next(), ValuePool.getInt(index++));
            }
            iter = this.getColIdentifierList(targetTable, this.getTargetTable()).iterator();
            while (iter.hasNext()) {
                indexMap.put(iter.next(), ValuePool.getInt(index++));
            }
            this._dec = new RowDecorator(indexMap);
        }
        return this._dec;
    }

    private void commitIfRequired(Database db) throws AxionException {
        if (this.getCommitSize(db) == 0) {
            return;
        }
        if (db instanceof SnapshotIsolationTransaction && ++this._count % this.getCommitSize(db) == 0) {
            this._targetTable = ((SnapshotIsolationTransaction)db).commit(this._targetTableId);
        }
    }

    private TableIdentifier[] getAllTables() {
        return new TableIdentifier[]{this.getSourceTable(), this.getTargetTable()};
    }

    private Iterator getInsertColumnIterator() {
        return this._columnsForInsert.iterator();
    }

    public Iterator getInsertValueIterator() {
        return this._valuesForInsert.iterator();
    }

    private TableIdentifier getSourceTable() {
        return this._sourceTableId;
    }

    private TableIdentifier getTargetTable() {
        return this._targetTableId;
    }

    private Iterator getUpdateColumnIterator() {
        return this._columnsForUpdate.iterator();
    }

    public Iterator getUpdateValueIterator() {
        return this._valuesForUpdate.iterator();
    }

    private String getUsingSubSelectAlias() {
        return this._usingSubSelectAlias;
    }

    private boolean hasDuplicateRow(RowDecorator dec, Set sourceColsUsedInCondition, Set uniqueSourceRowSet) throws AxionException {
        SimpleRow row = new SimpleRow(dec.getRowIndex(), sourceColsUsedInCondition.size());
        int i = 0;
        boolean found = false;
        for (Selectable colid : sourceColsUsedInCondition) {
            Object val = colid.evaluate(dec);
            row.set(i++, val);
        }
        if (uniqueSourceRowSet.contains(row)) {
            found = true;
        } else {
            uniqueSourceRowSet.add(row);
        }
        return found;
    }

    private boolean isNullRow(Row row) {
        return row.getIdentifier() == -1;
    }

    private boolean isTargetColumnUsedInUpdate(Set cols) {
        Iterator colItr = this.getUpdateColumnIterator();
        while (colItr.hasNext()) {
            if (!cols.contains(colItr.next())) continue;
            return true;
        }
        return false;
    }

    private void prepareRow(Row newrow, Iterator colids, Iterator values, RowDecorator dec, Table targetTable, Database db) throws AxionException {
        while (colids.hasNext()) {
            ColumnIdentifier colid = (ColumnIdentifier)colids.next();
            Selectable sel = (Selectable)values.next();
            Object val = sel.evaluate(dec);
            DataType type = db.getTable(colid.getTableName()).getColumn(colid.getName()).getDataType();
            val = this.attemptToConvertValue(val, type, colid);
            newrow.set(targetTable.getColumnIndex(colid.getName()), val);
        }
    }

    private void preProcess(Database db) throws AxionException {
        this._count = 0;
        if (null != this._usingSubselect) {
            this._sourceTable = this._usingSubselect.getTableView(db, null, true);
            TableIdentifier tid = new TableIdentifier(this._sourceTable.getName(), this.getUsingSubSelectAlias());
            this.setSourceTable(tid);
            this._selectCommand.getQueryContext().getFrom().setLeft(tid);
            this._sourceTable = db.getTable(this.getSourceTable());
        }
        if (null == this._usingSubselect && null != this.getSourceTable()) {
            this._sourceTable = db.getTable(this.getSourceTable());
        }
        if (null == this._sourceTable) {
            throw new AxionException("Table " + this.getSourceTable() + " not found.");
        }
        this._targetTable = db.getTable(this.getTargetTable());
        if (null == this._targetTable) {
            throw new AxionException("Table " + this.getTargetTable() + " not found.");
        }
        if (this._exceptionWhenClause != null) {
            this._exceptionWhenClause.preProcess(db);
        }
    }

    protected void resolve(Database db) throws AxionException {
        if (!this._resolved) {
            this.preProcess(db);
            this.resolveSelectableList(this._columnsForInsert, db, this.getTargetTable());
            this.resolveSelectableList(this._valuesForInsert, db, this.getAllTables());
            this.resolveSelectableList(this._columnsForUpdate, db, this.getTargetTable());
            this.resolveSelectableList(this._valuesForUpdate, db, this.getAllTables());
            this.resolveGeneratedColumns(this._targetTable, this._targetTableId, this._columnsForInsert);
            this.resolveGeneratedColumns(this._targetTable, this._targetTableId, this._columnsForUpdate);
            this._condition = this.resolveSelectable(this._condition, db, this.getAllTables());
            if (this._exceptionWhenClause != null) {
                this._exceptionWhenClause.resolve(db);
            }
            this._isExternalDBTable = this._targetTable instanceof ExternalDatabaseTable;
            this._resolved = true;
        }
    }

    protected final RowDecorator makeTargetRowDecorator() {
        if (this._trgtDec == null) {
            this._trgtDec = this._targetTable.makeRowDecorator();
        }
        return this._trgtDec;
    }

    public class ExceptionWhenClause
    extends InsertIntoClause {
        private boolean _isTargetPartOfSubQuery;

        public ExceptionWhenClause(DMLWhenClause when, TableIdentifier tid, List cols, List vals) {
            super(when, tid, cols, vals);
            this._isTargetPartOfSubQuery = false;
        }

        protected boolean isTargetTablePartOfSubQuery() throws AxionException {
            return this._isTargetPartOfSubQuery;
        }

        protected void resolve(Database db) throws AxionException {
            super.resolve(db);
            this.getWhenClause().resolve(db, new TableIdentifier[]{UpsertCommand.this.getSourceTable()});
            if (UpsertCommand.this._usingSubselect != null) {
                this._isTargetPartOfSubQuery = UpsertCommand.this._usingSubselect.getQueryContext().isTablePartOfSelect(this.getTargetTableId());
            }
            this.resolveSelectableList(this.getValues(), db, UpsertCommand.this.getSourceTable());
            this.assertRules(UpsertCommand.this._sourceTable);
        }
    }
}

