/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.indexes;

import java.io.File;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.Function;
import org.axiondb.Index;
import org.axiondb.engine.indexes.BaseIndex;
import org.axiondb.functions.EqualFunction;
import org.axiondb.functions.GreaterThanFunction;
import org.axiondb.functions.GreaterThanOrEqualFunction;
import org.axiondb.functions.IsNotNullFunction;
import org.axiondb.functions.IsNullFunction;
import org.axiondb.functions.LessThanFunction;
import org.axiondb.functions.LessThanOrEqualFunction;

public abstract class BaseBTreeIndex
extends BaseIndex
implements Index {
    public BaseBTreeIndex(String name, Column column, boolean unique) {
        super(name, column, unique);
    }

    public String getType() {
        return "btree";
    }

    public void save(File dataDirectory) throws AxionException {
        this.getIndexLoader().saveIndex(this, dataDirectory);
    }

    public void saveAfterTruncate(File dataDirectory) throws AxionException {
        this.getIndexLoader().saveIndexAfterTruncate(this, dataDirectory);
    }

    public boolean supportsFunction(Function fn) {
        if (fn instanceof EqualFunction) {
            if (this.isUnique()) {
                return true;
            }
            return this.getIndexedColumn().getDataType().supportsSuccessor();
        }
        if (fn instanceof LessThanFunction) {
            return true;
        }
        if (fn instanceof LessThanOrEqualFunction) {
            return this.getIndexedColumn().getDataType().supportsSuccessor();
        }
        if (fn instanceof GreaterThanFunction) {
            return true;
        }
        if (fn instanceof GreaterThanOrEqualFunction) {
            return this.getIndexedColumn().getDataType().supportsSuccessor();
        }
        if (fn instanceof IsNotNullFunction) {
            return true;
        }
        return fn instanceof IsNullFunction;
    }
}

