/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.indexes;

import java.util.List;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.adapters.IntListList;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.IndexLoader;
import org.axiondb.engine.IntArrayIndexLoader;
import org.axiondb.engine.indexes.BaseArrayIndex;

public class IntArrayIndex
extends BaseArrayIndex {
    private static final IndexLoader LOADER = new IntArrayIndexLoader();
    private IntList _keys = null;

    public IntArrayIndex(String name, Column column, boolean unique) {
        super(name, column, unique);
        this._keys = new ArrayIntList();
    }

    public IntArrayIndex(String name, Column column, boolean unique, IntList keys, IntList values) {
        super(name, column, unique, values);
        this._keys = keys;
    }

    public IndexLoader getIndexLoader() {
        return LOADER;
    }

    public List getKeyList() {
        return IntListList.wrap(this._keys);
    }

    public void truncate() throws AxionException {
        super.truncate();
        if (this._keys != null) {
            this._keys.clear();
        }
    }

    protected int find(int seeking, boolean required) {
        int high = this._keys.size();
        int low = 0;
        int cur = 0;
        boolean found = false;
        while (low < high) {
            cur = (high + low) / 2;
            if (this._keys.get(cur) == seeking) {
                found = true;
                break;
            }
            if (this._keys.get(cur) > seeking) {
                high = cur;
                continue;
            }
            if (low == cur) {
                // empty if block
            }
            low = ++cur;
        }
        if (!this.isUnique()) {
            while (cur > 0 && seeking == this._keys.get(cur - 1)) {
                --cur;
            }
        }
        if (!found) {
            return required ? -1 : cur;
        }
        return cur;
    }

    protected int find(Object value, boolean required) {
        return this.find((Integer)value, required);
    }

    protected List getKeyList(int minIndex, int maxIndex) {
        return IntListList.wrap(this._keys.subList(minIndex, maxIndex));
    }

    protected int insertKey(int seeking) throws AxionException {
        int high = this._keys.size();
        int low = 0;
        int cur = 0;
        while (low < high) {
            cur = (high + low) / 2;
            if (this._keys.get(cur) == seeking) {
                if (!this.isUnique()) break;
                throw new AxionException("Expected " + this.getIndexedColumn() + " to be unique, found " + seeking + " already.");
            }
            if (this._keys.get(cur) > seeking) {
                high = cur;
                continue;
            }
            if (low == cur) {
                // empty if block
            }
            low = ++cur;
        }
        this._keys.add(cur, seeking);
        return cur;
    }

    protected int insertKey(Object value) throws AxionException {
        int seeking = (Integer)value;
        return this.insertKey(seeking);
    }

    protected int removeKey(int seeking) throws AxionException {
        int index = this.find(seeking, true);
        if (-1 != index) {
            this._keys.removeElementAt(index);
        }
        return index;
    }

    protected int removeKey(Object value) throws AxionException {
        int seeking = (Integer)value;
        return this.removeKey(seeking);
    }

    protected void removeKeyAt(int index) throws AxionException {
        this._keys.removeElementAt(index);
    }
}

