/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.indexes;

import java.io.File;
import java.io.IOException;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntListIterator;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.DataType;
import org.axiondb.Function;
import org.axiondb.IndexLoader;
import org.axiondb.Row;
import org.axiondb.RowIterator;
import org.axiondb.RowSource;
import org.axiondb.Table;
import org.axiondb.engine.ObjectBTreeIndexLoader;
import org.axiondb.engine.indexes.BaseBTreeIndex;
import org.axiondb.engine.rowiterators.EmptyRowIterator;
import org.axiondb.engine.rowiterators.LazyRowRowIterator;
import org.axiondb.event.RowEvent;
import org.axiondb.event.TableModificationListener;
import org.axiondb.functions.ComparisonFunction;
import org.axiondb.functions.EqualFunction;
import org.axiondb.functions.GreaterThanFunction;
import org.axiondb.functions.GreaterThanOrEqualFunction;
import org.axiondb.functions.IsNotNullFunction;
import org.axiondb.functions.IsNullFunction;
import org.axiondb.functions.LessThanFunction;
import org.axiondb.functions.LessThanOrEqualFunction;
import org.axiondb.util.IntListIteratorChain;
import org.axiondb.util.NullObject;
import org.axiondb.util.ObjectBTree;

public class ObjectBTreeIndex
extends BaseBTreeIndex
implements TableModificationListener {
    private static final IndexLoader LOADER = new ObjectBTreeIndexLoader();
    protected int _minimizationFactor;
    private File _dataDirectory;
    private ObjectBTree _tree = null;

    public ObjectBTreeIndex(String name, Column column, boolean unique) throws AxionException {
        this(name, column, unique, null);
    }

    public ObjectBTreeIndex(String name, Column column, boolean unique, File dataDirectory) throws AxionException {
        this(name, column, unique, 1000, dataDirectory);
    }

    private ObjectBTreeIndex(String name, Column column, boolean unique, int minimizationFactor, File dataDirectory) throws AxionException {
        super(name, column, unique);
        try {
            this._dataDirectory = dataDirectory;
            this._minimizationFactor = minimizationFactor;
            this._tree = this.createTree(this._dataDirectory, this.getName(), this._minimizationFactor, this.getDataType());
        }
        catch (IOException e) {
            throw new AxionException("Unable to create index file", e);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Unable to create index file", e);
        }
    }

    public final void changeRowId(Table table, Row row, int oldId, int newId) throws AxionException {
        try {
            int colnum = table.getColumnIndex(this.getIndexedColumn().getName());
            Object key = row.get(colnum);
            this._tree.replaceId(key, oldId, newId);
        }
        catch (IOException e) {
            throw new AxionException("Unable to change row id", e);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Unable to change row id", e);
        }
    }

    public final ObjectBTree getBTree() {
        return this._tree;
    }

    public IndexLoader getIndexLoader() {
        return LOADER;
    }

    public final RowIterator getInorderRowIterator(RowSource source) throws AxionException {
        IntListIteratorChain resultIds = null;
        try {
            resultIds = this._tree.inorderIterator();
        }
        catch (IOException e) {
            throw new AxionException("Unable to retrieve values from index" + this.getName(), e);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Unable to retrieve values from index" + this.getName(), e);
        }
        return new LazyRowRowIterator(source, resultIds, this._tree.size());
    }

    public final RowIterator getRowIterator(RowSource source, Function function, Object value) throws AxionException {
        IntListIterator resultIds;
        block15: {
            resultIds = null;
            try {
                if (function instanceof ComparisonFunction) {
                    Object convertedValue = this.getIndexedColumn().getDataType().convert(value);
                    if (null == convertedValue) {
                        return EmptyRowIterator.INSTANCE;
                    }
                    if (function instanceof EqualFunction) {
                        if (!this.isUnique()) {
                            resultIds = this._tree.getAll(convertedValue);
                            break block15;
                        }
                        Integer result = this._tree.get(convertedValue);
                        if (result == null) {
                            return EmptyRowIterator.INSTANCE;
                        }
                        ArrayIntList ids = new ArrayIntList(1);
                        ids.add(result);
                        return new LazyRowRowIterator(source, ids.listIterator(), 1);
                    }
                    if (function instanceof LessThanFunction) {
                        resultIds = this._tree.getAllTo(convertedValue);
                        break block15;
                    }
                    if (function instanceof LessThanOrEqualFunction) {
                        resultIds = this._tree.getAllTo(this.getIndexedColumn().getDataType().successor(convertedValue));
                        break block15;
                    }
                    if (function instanceof GreaterThanFunction) {
                        resultIds = this._tree.getAllFrom(this.getIndexedColumn().getDataType().successor(convertedValue));
                        break block15;
                    }
                    if (function instanceof GreaterThanOrEqualFunction) {
                        resultIds = this._tree.getAllFrom(convertedValue);
                        break block15;
                    }
                    throw new AxionException("Unsupported function " + function);
                }
                if (function instanceof IsNotNullFunction) {
                    resultIds = this._tree.getAllExcludingNull();
                    break block15;
                }
                if (function instanceof IsNullFunction) {
                    value = value == null ? this.getNullKey() : value;
                    resultIds = this._tree.getAll(value);
                    break block15;
                }
                throw new AxionException("Unsupported function " + function);
            }
            catch (IOException e) {
                throw new AxionException("Unable to retrieve values from index" + this.getName(), e);
            }
            catch (ClassNotFoundException e) {
                throw new AxionException("Unable to retrieve values from index" + this.getName(), e);
            }
        }
        ArrayIntList ids = new ArrayIntList();
        while (resultIds.hasNext()) {
            ids.add(resultIds.next());
        }
        return new LazyRowRowIterator(source, ids.listIterator(), ids.size());
    }

    public final void rowDeleted(RowEvent event) throws AxionException {
        String colName = this.getIndexedColumn().getName();
        int colIndex = event.getTable().getColumnIndex(colName);
        Object key = event.getOldRow().get(colIndex);
        int rowid = event.getOldRow().getIdentifier();
        key = key == null ? this.getNullKey() : key;
        try {
            this._tree.delete(key, rowid);
        }
        catch (IOException e) {
            throw new AxionException("Unable to delete from index " + this.getName(), e);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Unable to delete from index " + this.getName(), e);
        }
    }

    public final void rowInserted(RowEvent event) throws AxionException {
        String colName = this.getIndexedColumn().getName();
        int colIndex = event.getTable().getColumnIndex(colName);
        Object value = event.getNewRow().get(colIndex);
        value = value == null ? this.getNullKey() : value;
        try {
            this._tree.insert(value, event.getNewRow().getIdentifier());
        }
        catch (IOException e) {
            throw new AxionException("Unable to insert into index " + this.getName(), e);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Unable to insert into index " + this.getName(), e);
        }
    }

    public final void rowUpdated(RowEvent event) throws AxionException {
        this.rowDeleted(event);
        this.rowInserted(event);
    }

    public void truncate() throws AxionException {
        this._tree.truncate();
    }

    protected ObjectBTree createTree(File dataDirectory, String name, int minimizationFactor, DataType dataType) throws IOException, ClassNotFoundException {
        return new ObjectBTree(dataDirectory, name, minimizationFactor, dataType);
    }

    protected Object getNullKey() {
        return NullObject.INSTANCE;
    }
}

