/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.metaupdaters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.Constraint;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.Selectable;
import org.axiondb.constraints.ForeignKeyConstraint;
import org.axiondb.constraints.PrimaryKeyConstraint;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.event.BaseDatabaseModificationListener;
import org.axiondb.event.ColumnEvent;
import org.axiondb.event.ConstraintEvent;
import org.axiondb.event.DatabaseModifiedEvent;
import org.axiondb.event.RowEvent;
import org.axiondb.event.TableModificationListener;

public class AxionConstraintsMetaTableUpdater
extends BaseDatabaseModificationListener
implements TableModificationListener {
    private static Logger _log = Logger.getLogger(AxionConstraintsMetaTableUpdater.class.getName());
    private Database _db = null;
    private ArrayList addedKeys = new ArrayList();
    private static int PK_SEQ = 0;
    private static int FK_SEQ = 0;

    public AxionConstraintsMetaTableUpdater() {
    }

    public AxionConstraintsMetaTableUpdater(Database db) {
        this._db = db;
    }

    private ArrayList createPkFkConstraintRows(Constraint pkFkConstraint, String tablename) {
        ArrayList<Row> rowlist = new ArrayList<Row>();
        if (pkFkConstraint instanceof PrimaryKeyConstraint) {
            for (int i = 0; i < ((PrimaryKeyConstraint)pkFkConstraint).getSelectableCount(); ++i) {
                rowlist.add(this.createPKConstraintRow((PrimaryKeyConstraint)pkFkConstraint, tablename, ((PrimaryKeyConstraint)pkFkConstraint).getSelectable(i)));
            }
        } else if (pkFkConstraint instanceof ForeignKeyConstraint) {
            rowlist.add(this.createFKConstraintRow((ForeignKeyConstraint)pkFkConstraint, tablename));
        }
        return rowlist;
    }

    private Row createPKConstraintRow(PrimaryKeyConstraint constraint, String table, Selectable s) {
        SimpleRow constraintrow = new SimpleRow(14);
        constraintrow.set(0, ++PK_SEQ);
        constraintrow.set(1, "");
        constraintrow.set(2, "");
        constraintrow.set(3, table);
        constraintrow.set(4, constraint.getName());
        constraintrow.set(5, s.getName());
        return constraintrow;
    }

    private Row createFKConstraintRow(ForeignKeyConstraint constraint, String table) {
        SimpleRow constraintrow = new SimpleRow(14);
        constraintrow.set(0, ++FK_SEQ);
        constraintrow.set(1, "");
        constraintrow.set(2, "");
        constraintrow.set(3, constraint.getParentTableName());
        if (constraint.getParentTableColumns() != null) {
            constraintrow.set(5, ((Selectable)constraint.getParentTableColumns().get(0)).getName());
        }
        constraintrow.set(6, "");
        constraintrow.set(7, "");
        constraintrow.set(8, constraint.getChildTableName());
        constraintrow.set(9, constraint.getName());
        if (constraint.getChildTableColumns() != null) {
            constraintrow.set(10, ((Selectable)constraint.getChildTableColumns().get(0)).getName());
        }
        constraintrow.set(11, constraint.getOnUpdateActionType());
        constraintrow.set(12, constraint.getOnDeleteActionType());
        constraintrow.set(13, 20);
        return constraintrow;
    }

    private boolean checkIfKeyConstraintAdded(String keyname) {
        boolean available = false;
        for (int i = 0; i < this.addedKeys.size(); ++i) {
            if (!keyname.equals(this.addedKeys.get(i))) continue;
            available = true;
            break;
        }
        return available;
    }

    public void columnAdded(ColumnEvent event) throws AxionException {
    }

    public void rowInserted(RowEvent event) throws AxionException {
    }

    public void rowDeleted(RowEvent event) throws AxionException {
    }

    public void rowUpdated(RowEvent event) throws AxionException {
    }

    public void constraintAdded(ConstraintEvent event) throws AxionException {
    }

    public void constraintRemoved(ConstraintEvent event) throws AxionException {
    }

    public void tableAdded(DatabaseModifiedEvent e) {
        Iterator i = e.getTable().getConstraints();
        while (i.hasNext()) {
            Constraint c = (Constraint)i.next();
            try {
                if (this.checkIfKeyConstraintAdded(c.getName())) continue;
                ArrayList rowlist = this.createPkFkConstraintRows(c, e.getTable().getName());
                for (int j = 0; j < rowlist.size(); ++j) {
                    this._db.getTable("AXION_KEYS").addRow((Row)rowlist.get(j));
                }
                this.addedKeys.add(c.getName());
            }
            catch (AxionException ex) {
                _log.severe("Unable to Enter Constraint into AXION_KEYS : " + ex);
            }
        }
    }
}

