/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.metaupdaters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Database;
import org.axiondb.ExternalTable;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.engine.TransactableTableImpl;
import org.axiondb.engine.commands.DeleteCommand;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.event.BaseDatabaseModificationListener;
import org.axiondb.event.DatabaseModificationListener;
import org.axiondb.event.DatabaseModifiedEvent;
import org.axiondb.functions.FunctionIdentifier;

public class AxionTablePropertiesMetaTableUpdater
extends BaseDatabaseModificationListener
implements DatabaseModificationListener {
    private static Logger _log = Logger.getLogger(AxionTablePropertiesMetaTableUpdater.class.getName());
    private Database _db = null;

    public AxionTablePropertiesMetaTableUpdater(Database db) {
        this._db = db;
    }

    public void tableAdded(DatabaseModifiedEvent e) {
        Table tbl = e.getTable();
        Table propsTable = null;
        try {
            propsTable = this._db.getTable("AXION_TABLE_PROPERTIES");
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to locate system table AXION_TABLE_PROPERTIES for update", ex);
        }
        List rows = this.createRowsForAddedTable(tbl);
        Iterator iter = rows.iterator();
        while (iter.hasNext() && propsTable != null) {
            try {
                propsTable.addRow((Row)iter.next());
            }
            catch (AxionException ex) {
                _log.log(Level.SEVERE, "Unable to mention table in system tables", ex);
            }
        }
    }

    private List createRowsForAddedTable(Table table) {
        ArrayList<SimpleRow> rowList = Collections.EMPTY_LIST;
        if (table instanceof TransactableTableImpl) {
            table = ((TransactableTableImpl)table).getTable();
        }
        if (table instanceof ExternalTable) {
            rowList = new ArrayList<SimpleRow>();
            String tableName = table.getName();
            ExternalTable ffTable = (ExternalTable)table;
            Properties p = ffTable.getTableProperties();
            if (p != null) {
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    String key = (String)entry.getKey();
                    SimpleRow row = new SimpleRow(3);
                    row.set(0, tableName);
                    row.set(1, key);
                    row.set(2, entry.getValue());
                    rowList.add(row);
                }
            }
        }
        return rowList;
    }

    public void tableDropped(DatabaseModifiedEvent e) {
        FunctionIdentifier fn = new FunctionIdentifier("=");
        fn.addArgument(new ColumnIdentifier("TABLE_NAME"));
        fn.addArgument(new Literal(e.getTable().getName()));
        DeleteCommand cmd = new DeleteCommand("AXION_TABLE_PROPERTIES", (Selectable)fn);
        try {
            cmd.execute(this._db);
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to remove mention of table in system tables", ex);
        }
    }
}

