/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.IntList;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.Constraint;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Index;
import org.axiondb.IndexLoader;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowIterator;
import org.axiondb.Sequence;
import org.axiondb.TableFactory;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.tables.BaseTable;
import org.axiondb.event.RowInsertedEvent;
import org.axiondb.io.AxionFileSystem;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.io.BufferedDataOutputStream;
import org.axiondb.io.FileUtil;
import org.axiondb.types.LOBType;
import org.axiondb.util.ExceptionConverter;

public abstract class BaseDiskTable
extends BaseTable {
    private static final FilenameFilter DOT_TYPE_FILE_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            File idx;
            File file = new File(dir, name);
            return file.isDirectory() && (idx = new File(file, name + BaseDiskTable.TYPE_FILE_EXT)).exists();
        }
    };
    protected static AxionFileSystem FS = new AxionFileSystem();
    protected static final long INVALID_OFFSET = Long.MAX_VALUE;
    protected static final int CURRENT_META_VERSION = 4;
    protected static final String FRID_FILE_EXT = ".FRID";
    protected static final String INDICES_DIR_NAME = "INDICES";
    protected static final String META_FILE_EXT = ".META";
    protected static final String PIDX_FILE_EXT = ".PIDX";
    protected static final String SEQ_FILE_EXT = ".SEQ";
    protected static final String TYPE_FILE_EXT = ".TYPE";
    protected File _dataFile = null;
    protected File _dbdir = null;
    protected IntList _freeIds = null;
    private int _nextFreeId = -1;
    private int _freeIdPos = -1;
    private AxionFileSystem.PidxList _pidx = null;
    protected boolean _readOnly = false;
    protected int _rowCount = 0;
    private File _dir = null;
    private File _indexRootDir = null;
    protected BufferedDataInputStream _readStream = null;
    protected BufferedDataOutputStream _writeStream = null;
    private static final Logger _log = Logger.getLogger(BaseDiskTable.class.getName());

    public BaseDiskTable(String name, Database db, TableFactory factory) throws AxionException {
        super(name);
        this._dbdir = db.getDBDirectory();
        this._readOnly = db.isReadOnly();
        this.createOrLoadTableFiles(name, db, factory);
    }

    public void addColumn(Column col) throws AxionException {
        this.addColumn(col, true);
    }

    public void addColumn(Column col, boolean metaUpdateNeeded) throws AxionException {
        this.resetLobColumn(col);
        super.addColumn(col);
        if (metaUpdateNeeded) {
            this.writeMetaFile();
        }
    }

    public void addConstraint(Constraint constraint) throws AxionException {
        super.addConstraint(constraint);
        this.writeMetaFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyDeletes(IntCollection rowIds) throws AxionException {
        BaseDiskTable baseDiskTable = this;
        synchronized (baseDiskTable) {
            this.applyDeletesToIndices(rowIds);
            this.applyDeletesToRows(rowIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyInserts(RowCollection rows) throws AxionException {
        BaseDiskTable baseDiskTable = this;
        synchronized (baseDiskTable) {
            Iterator indexIter = this.getIndices();
            while (indexIter.hasNext()) {
                Index index = (Index)indexIter.next();
                RowIterator iter = rows.rowIterator();
                while (iter.hasNext()) {
                    Row row = iter.next();
                    RowInsertedEvent event = new RowInsertedEvent(this, null, row);
                    index.rowInserted(event);
                }
                this.saveIndex(index);
            }
            this.applyInsertsToRows(rows.rowIterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyUpdates(RowCollection rows) throws AxionException {
        BaseDiskTable baseDiskTable = this;
        synchronized (baseDiskTable) {
            this.applyUpdatesToIndices(rows);
            this.applyUpdatesToRows(rows.rowIterator());
        }
    }

    public void checkpoint() throws AxionException {
        super.checkpoint();
        DataOutputStream out = null;
        try {
            if (this.getSequence() != null) {
                File seqFile = this.getTableFile(SEQ_FILE_EXT);
                out = FS.createDataOutputSteam(seqFile);
                this.getSequence().write(out);
            }
        }
        catch (IOException e) {
            String msg = "Unable to persist sequence file";
            throw new AxionException(msg);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    public void drop() throws AxionException {
        this.closeFiles();
        if (!FileUtil.delete(this.getRootDir())) {
            throw new AxionException("Unable to delete \"" + this.getRootDir() + "\" during drop table " + this.getName());
        }
    }

    public void freeRowId(int id) {
        if (this._freeIdPos >= 0 && id == this._freeIds.get(this._freeIdPos)) {
            --this._freeIdPos;
        } else if (this._nextFreeId > this.getPidxList().size() - 1) {
            --this._nextFreeId;
        }
    }

    public int getNextRowId() {
        if (this._freeIds.isEmpty() || this._freeIdPos >= this._freeIds.size() - 1) {
            this._nextFreeId = this._nextFreeId == -1 ? this.getPidxList().size() : this._nextFreeId + 1;
            return this._nextFreeId;
        }
        return this._freeIds.get(++this._freeIdPos);
    }

    public Row getRow(int id) throws AxionException {
        long ptr = this.getPidxList().get(id);
        Row row = this.getRowByOffset(id, ptr);
        return row;
    }

    public void migrate(Database db) throws AxionException {
        File metaFile = this.getTableFile(META_FILE_EXT);
        if (!metaFile.exists()) {
            return;
        }
        int version = 4;
        ObjectInputStream in = null;
        try {
            in = FS.openObjectInputSteam(metaFile);
            version = in.readInt();
            _log.log(Level.FINE, "Version number for " + this.getName() + " in migrate() is " + version);
            if (version < 0 || version > 4) {
                throw new AxionException("Unrecognized version " + version);
            }
            if (version == 0) {
                this.parseV0MetaFile(in);
            } else {
                this.parseV1MetaFile(in, db);
            }
            this.parseTableProperties(in);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Unable to parse meta file " + metaFile + " for table " + this.getName(), e);
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse meta file " + metaFile + " for table " + this.getName(), e);
        }
        finally {
            FS.closeInputStream(in);
        }
        if (version > 1 && version < 4) {
            this._pidx = FS.parseLongPidx(this.getTableFile(PIDX_FILE_EXT), this._readOnly);
        }
        if (version < 3) {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                Column col = this.getColumn(i);
                col.getConfiguration().put("name", col.getName().toUpperCase());
            }
        }
        if (version != 4) {
            this.writeMetaFile();
        }
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public void populateIndex(Index index) throws AxionException {
        int I = this.getPidxList().size();
        for (int i = 0; i < I; ++i) {
            long ptr = this.getPidxList().get(i);
            if (ptr == Long.MAX_VALUE) continue;
            index.rowInserted(new RowInsertedEvent(this, null, this.getRowByOffset(i, ptr)));
        }
        File indexDir = new File(this._indexRootDir, index.getName());
        if (!indexDir.exists()) {
            indexDir.mkdirs();
        }
        File typefile = new File(indexDir, index.getName() + TYPE_FILE_EXT);
        IndexLoader loader = index.getIndexLoader();
        this.writeNameToFile(typefile, loader);
        index.save(indexDir);
    }

    public void remount(File newdir, boolean datafilesonly) throws AxionException {
        this.closeFiles();
        this.initFiles(newdir, datafilesonly);
        this.writeMetaFile();
        this.resetLobColumns();
        super.remount(newdir, datafilesonly);
    }

    public void removeIndex(Index index) throws AxionException {
        super.removeIndex(index);
        File indexdir = new File(this._indexRootDir, index.getName());
        if (!FileUtil.delete(indexdir)) {
            throw new AxionException("Unable to delete \"" + indexdir + "\" during remove index " + index.getName());
        }
    }

    public void rename(String oldName, String newName, Properties newTableProp) throws AxionException {
        try {
            this.closeFiles();
            if (newTableProp == null) {
                this.renameTableFiles(oldName, newName);
            } else {
                this.renameTableFiles(oldName, newName, newTableProp);
            }
            super.rename(oldName, newName);
            this.clearDataFileReference();
            this.writeMetaFile();
            this.initFiles(this.getRootDir(), false);
            this.resetLobColumns();
        }
        catch (Exception e) {
            throw new AxionException("Fail to alter table: " + newName);
        }
    }

    public void rename(String oldName, String newName) throws AxionException {
        this.rename(oldName, newName, null);
    }

    public void setSequence(Sequence seq) throws AxionException {
        super.setSequence(seq);
        this.checkpoint();
    }

    public void shutdown() throws AxionException {
        this.closeFiles();
    }

    public void truncate() throws AxionException {
        if (this.getRowCount() == 0) {
            return;
        }
        File df = this.getDataFile();
        File pidxFile = this.getTableFile(PIDX_FILE_EXT);
        File bkupFile = new File(df.getParentFile(), df.getName() + ".backup");
        File bkupPidxFile = new File(pidxFile + ".backup");
        FileUtil.assertFileNotLocked(bkupFile);
        try {
            this.closeFiles();
            FileUtil.delete(bkupFile);
            if (!df.renameTo(bkupFile)) {
                FileUtil.truncate(df, 0L);
            }
            if (!pidxFile.renameTo(bkupPidxFile)) {
                FileUtil.truncate(pidxFile, 0L);
            }
            this.reloadFilesAfterTruncate();
            this.truncateIndices();
            this.saveIndicesAfterTruncate();
            FileUtil.delete(bkupFile);
            FileUtil.delete(bkupPidxFile);
        }
        catch (Exception e) {
            this.closeFiles();
            FileUtil.delete(df);
            FileUtil.delete(pidxFile);
            bkupFile.renameTo(df);
            bkupPidxFile.renameTo(pidxFile);
            this.reloadFilesAfterTruncate();
            this.recreateIndices();
            throw new AxionException(e);
        }
    }

    protected void clearDataFileReference() {
        this._dataFile = null;
    }

    protected void closeFiles() {
        if (null != this._readStream) {
            try {
                this._readStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this._readStream = null;
        }
        if (null != this._writeStream) {
            try {
                this._writeStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this._writeStream = null;
        }
        if (null != this._pidx) {
            try {
                this._pidx.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._pidx = null;
        }
    }

    protected void createOrLoadDataFile() throws AxionException {
        if (!this.isReadOnly()) {
            FS.createNewFile(this.getDataFile());
        }
        this.getOutputStream();
        this.getInputStream();
    }

    protected void createOrLoadFreeIdsFile() throws AxionException {
        if (this._freeIds == null) {
            File freeIdsFile = this.getTableFile(FRID_FILE_EXT);
            if (!this.isReadOnly()) {
                FS.createNewFile(freeIdsFile);
            }
            this._freeIds = FS.parseIntFile(freeIdsFile);
        }
    }

    protected void loadOrMigrateMetaFile(Database db) throws AxionException {
        this.migrate(db);
    }

    protected abstract File getDataFile();

    protected String getDefaultDataFileExtension() {
        return "DATA";
    }

    protected synchronized BufferedDataInputStream getInputStream() throws AxionException {
        if (null == this._readStream) {
            this._readStream = FS.openBufferedDIS(this.getDataFile());
        }
        return this._readStream;
    }

    protected abstract File getLobDir();

    protected synchronized BufferedDataOutputStream getOutputStream() throws AxionException {
        if (!this.isReadOnly() && null == this._writeStream) {
            this._writeStream = FS.openBufferedDOSAppend(this.getDataFile(), 1024);
        }
        return this._writeStream;
    }

    protected synchronized AxionFileSystem.PidxList getPidxList() {
        if (this._pidx == null) {
            File pidxFile = this.getTableFile(PIDX_FILE_EXT);
            try {
                if (!this.isReadOnly()) {
                    FS.createNewFile(pidxFile);
                }
                this._pidx = this.parsePidxFile(pidxFile);
            }
            catch (AxionException e) {
                throw ExceptionConverter.convertToRuntimeException(e);
            }
            this._nextFreeId = -1;
        }
        return this._pidx;
    }

    protected File getRootDir() {
        return this._dir;
    }

    protected RowIterator getRowIterator() throws AxionException {
        return new BaseRowIterator(){
            Row _current = null;
            int _currentId = -1;
            int _currentIndex = -1;
            int _nextId = 0;
            int _nextIndex = 0;

            public Row current() {
                if (!this.hasCurrent()) {
                    throw new NoSuchElementException("No current row.");
                }
                return this._current;
            }

            public int currentIndex() {
                return this._currentIndex;
            }

            public boolean hasCurrent() {
                return null != this._current;
            }

            public boolean hasNext() {
                return this.nextIndex() < BaseDiskTable.this.getRowCount();
            }

            public boolean hasPrevious() {
                return this.nextIndex() > 0;
            }

            public Row last() throws AxionException {
                if (this.isEmpty()) {
                    throw new IllegalStateException("No rows in table.");
                }
                this._nextIndex = BaseDiskTable.this.getRowCount();
                this._nextId = BaseDiskTable.this.getPidxList().size();
                this.previous();
                ++this._nextId;
                ++this._nextIndex;
                return this.current();
            }

            public Row next() throws AxionException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next row");
                }
                this.next(1);
                this.setCurrentRow();
                return this.current();
            }

            public int next(int count) throws AxionException {
                int start = 0;
                while (start < count) {
                    ++this._nextId;
                    this._currentId = this._currentId;
                    if (!this.hasNext() || this._currentId > BaseDiskTable.this.getPidxList().size()) {
                        throw new NoSuchElementException("No next row");
                    }
                    if (BaseDiskTable.this.getPidxList().get(this._currentId) == Long.MAX_VALUE) continue;
                    ++this._nextIndex;
                    this._currentIndex = this._currentIndex;
                    ++start;
                }
                this._current = null;
                return this._currentId;
            }

            public int nextIndex() {
                return this._nextIndex;
            }

            public Row previous() throws AxionException {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous row");
                }
                this.previous(1);
                this.setCurrentRow();
                return this.current();
            }

            public int previous(int count) throws AxionException {
                int start = 0;
                while (start < count) {
                    this._currentId = --this._nextId;
                    if (!this.hasPrevious() || this._currentId < 0) {
                        throw new NoSuchElementException("No Previous row");
                    }
                    if (BaseDiskTable.this.getPidxList().get(this._currentId) == Long.MAX_VALUE) continue;
                    this._currentIndex = --this._nextIndex;
                    ++start;
                }
                this._current = null;
                return this._currentId;
            }

            public int previousIndex() {
                return this._nextIndex - 1;
            }

            public void remove() throws AxionException {
                if (-1 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                BaseDiskTable.this.deleteRow(this._current);
                --this._nextIndex;
                this._currentIndex = -1;
            }

            public void reset() {
                this._current = null;
                this._nextIndex = 0;
                this._currentIndex = -1;
                this._nextId = 0;
            }

            public void set(Row row) throws AxionException {
                if (-1 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                BaseDiskTable.this.updateRow(this._current, row);
            }

            public int size() throws AxionException {
                return BaseDiskTable.this.getRowCount();
            }

            public String toString() {
                return "DiskTable(" + BaseDiskTable.this.getName() + ")";
            }

            private Row setCurrentRow() throws AxionException {
                Row row = BaseDiskTable.this.getRowByOffset(this._currentId, BaseDiskTable.this.getPidxList().get(this._currentId));
                if (row != null) {
                    this._current = row;
                    return this._current;
                }
                throw new IllegalStateException("No valid row at position " + this._currentIndex);
            }
        };
    }

    protected abstract Row getRowByOffset(int var1, long var2) throws AxionException;

    protected File getTableFile(String extension) {
        return new File(this.getRootDir(), this.getName().toUpperCase() + extension);
    }

    protected boolean isReadOnly() {
        return this._readOnly;
    }

    protected void initFiles(File basedir, boolean datafilesonly) throws AxionException {
        if (!datafilesonly) {
            this._dir = basedir;
            this._indexRootDir = new File(this._dir, INDICES_DIR_NAME);
        }
        this.clearDataFileReference();
        this.getDataFile();
        this._readStream = this.getInputStream();
        this._writeStream = this.getOutputStream();
    }

    protected void initializeRowCount() throws AxionException {
        this._rowCount = 0;
        int I = this.getPidxList().size();
        for (int i = 0; i < I; ++i) {
            long ptr = this.getPidxList().get(i);
            if (ptr == Long.MAX_VALUE) continue;
            ++this._rowCount;
        }
    }

    protected synchronized AxionFileSystem.PidxList parsePidxFile(File pidxFile) throws AxionException {
        return FS.parseLongPidxList(pidxFile, this._readOnly);
    }

    protected void parseTableProperties(ObjectInputStream in) throws AxionException {
    }

    protected abstract void reloadFilesAfterTruncate() throws AxionException;

    protected void renameTableFiles(String oldName, String name) {
        File olddir = new File(this._dbdir, oldName);
        this._dir = new File(this._dbdir, name);
        olddir.renameTo(this._dir);
        FileUtil.renameFile(this._dir, oldName, name, TYPE_FILE_EXT);
        FileUtil.renameFile(this._dir, oldName, name, PIDX_FILE_EXT);
        FileUtil.renameFile(this._dir, oldName, name, FRID_FILE_EXT);
        FileUtil.renameFile(this._dir, oldName, name, META_FILE_EXT);
        FileUtil.renameFile(this._dir, oldName, name, SEQ_FILE_EXT);
    }

    protected void renameTableFiles(String oldName, String name, Properties newTblProps) {
        this.renameTableFiles(oldName, name, null);
    }

    protected void saveIndicesAfterTruncate() throws AxionException {
        Iterator iter = this.getIndices();
        while (iter.hasNext()) {
            Index index = (Index)iter.next();
            this.saveIndexAfterTruncate(index);
        }
    }

    protected void tryToRemove(RowIterator iter) throws AxionException {
        try {
            iter.remove();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected final void writeFridFile() throws AxionException {
        FS.writeIntFile(this.getTableFile(FRID_FILE_EXT), this._freeIds);
    }

    protected void writeMetaFile() throws AxionException {
        ObjectOutputStream out = null;
        File metaFile = this.getTableFile(META_FILE_EXT);
        try {
            out = FS.createObjectOutputSteam(metaFile);
            out.writeInt(4);
            this.writeColumns(out);
            out.flush();
            this.writeConstraints(out);
            out.flush();
            this.writeTableProperties(out);
            out.flush();
        }
        catch (IOException e) {
            throw new AxionException("Unable to write meta file " + metaFile + " for table " + this.getName(), e);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    protected void writeNameToFile(File file, Object obj) throws AxionException {
        ObjectOutputStream out = null;
        try {
            out = FS.createObjectOutputSteam(file);
            out.writeUTF(obj.getClass().getName());
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    protected abstract void writeRow(BufferedDataOutputStream var1, Row var2) throws AxionException;

    protected void writeTableProperties(ObjectOutputStream out) throws AxionException {
    }

    private void applyDeletesToRows(IntCollection rowids) throws AxionException {
        try {
            IntIterator iter = rowids.iterator();
            if (iter.hasNext()) {
                while (iter.hasNext()) {
                    int rowid = iter.next();
                    if (rowid > this.getPidxList().size() - 1) {
                        throw new AxionException("Can't delete non-existent row");
                    }
                    this.getPidxList().set(rowid, Long.MAX_VALUE);
                    --this._rowCount;
                }
                this._pidx.flush();
                this._freeIds.addAll(rowids);
                this.writeFridFile();
            }
        }
        catch (IOException e) {
            throw new AxionException("Error writing data.", e);
        }
    }

    private void applyInsertsToRows(RowIterator rows) throws AxionException {
        try {
            BufferedDataOutputStream out = this.getOutputStream();
            while (rows.hasNext()) {
                Row row = rows.next();
                ++this._rowCount;
                if (!this._freeIds.isEmpty() && this._freeIdPos > -1) {
                    this.getPidxList().set(this._freeIds.removeElementAt(0), out.getPos());
                    --this._freeIdPos;
                } else {
                    this.getPidxList().add(out.getPos());
                }
                this.writeRow(out, row);
                this.tryToRemove(rows);
            }
            this._writeStream.flush();
            this._pidx.flush();
            this.writeFridFile();
            this._nextFreeId = -1;
        }
        catch (IOException e) {
            throw new AxionException("Error writing data.", e);
        }
    }

    private void applyUpdatesToRows(RowIterator rows) throws AxionException {
        try {
            BufferedDataOutputStream out = this.getOutputStream();
            while (rows.hasNext()) {
                Row row = rows.next();
                if (row.getIdentifier() > this.getPidxList().size() - 1) {
                    throw new AxionException("Can't update non-existent row");
                }
                this.getPidxList().set(row.getIdentifier(), out.getPos());
                this.writeRow(out, row);
                this.tryToRemove(rows);
            }
            this._writeStream.flush();
            this._pidx.flush();
            this.getInputStream().reset();
        }
        catch (IOException e) {
            throw new AxionException("Error writing data.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrLoadTableFiles(String name, Database db, TableFactory factory) throws AxionException {
        Class<BaseDiskTable> clazz = BaseDiskTable.class;
        synchronized (BaseDiskTable.class) {
            this._dir = new File(db.getDBDirectory(), name.toUpperCase());
            if (!this._dir.exists() && !this._dir.mkdirs()) {
                throw new AxionException("Unable to create directory \"" + this._dir + "\" for Table \"" + name + "\".");
            }
            File typefile = this.getTableFile(TYPE_FILE_EXT);
            if (!typefile.exists()) {
                this.writeNameToFile(typefile, factory);
            }
            this._freeIds = new ArrayIntList();
            this.loadOrMigrateMetaFile(db);
            this.createOrLoadFreeIdsFile();
            this.initializeRowCount();
            this._indexRootDir = new File(this._dir, INDICES_DIR_NAME);
            if (this._indexRootDir.exists()) {
                this.loadIndices(this._indexRootDir, db);
            } else {
                this._indexRootDir.mkdirs();
            }
            File seqfile = this.getTableFile(SEQ_FILE_EXT);
            if (seqfile.exists()) {
                this.loadSequences();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private void loadIndices(File parentdir, Database db) throws AxionException {
        String[] indices = parentdir.list(DOT_TYPE_FILE_FILTER);
        for (int i = 0; i < indices.length; ++i) {
            File indexdir = new File(parentdir, indices[i]);
            File typefile = new File(indexdir, indices[i] + TYPE_FILE_EXT);
            String loadername = null;
            ObjectInputStream in = null;
            try {
                in = FS.openObjectInputSteam(typefile);
                loadername = in.readUTF();
            }
            catch (IOException e) {
                throw new AxionException(e);
            }
            finally {
                FS.closeInputStream(in);
            }
            IndexLoader loader = null;
            try {
                Class<?> clazz = Class.forName(loadername);
                loader = (IndexLoader)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AxionException(e);
            }
            Index index = loader.loadIndex(this, indexdir);
            db.addIndex(index, this);
        }
    }

    private void loadSequences() throws AxionException {
        File seqFile = this.getTableFile(SEQ_FILE_EXT);
        DataInputStream in = null;
        if (seqFile.exists()) {
            try {
                in = FS.openDataInputSteam(seqFile);
                Sequence seq = new Sequence();
                seq.read(in);
                super.setSequence(seq);
            }
            catch (Exception e) {
                throw new AxionException("Unable to read sequence file", e);
            }
            finally {
                FS.closeInputStream(in);
            }
        }
    }

    private void parseV0MetaFile(ObjectInputStream in) throws IOException, AxionException {
        int I = in.readInt();
        for (int i = 0; i < I; ++i) {
            String name = in.readUTF();
            String dtypename = in.readUTF();
            DataType type = null;
            try {
                Class<?> clazz = Class.forName(dtypename);
                type = (DataType)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AxionException("Can't load table " + this.getName() + ", data type " + dtypename + " not found.", e);
            }
            this.addColumn(new Column(name, type), false);
        }
    }

    private void parseV1MetaFile(ObjectInputStream in, Database db) throws AxionException, IOException, ClassNotFoundException {
        this.readColumns(in);
        this.readConstraints(in, db);
    }

    private void resetLobColumn(Column col) throws AxionException {
        if (col.getDataType() instanceof LOBType) {
            LOBType lob = (LOBType)col.getDataType();
            lob.setLobDir(new File(this.getLobDir(), col.getName().toUpperCase()));
        }
    }

    protected void resetLobColumns() throws AxionException {
        int I = this.getColumnCount();
        for (int i = 0; i < I; ++i) {
            Column col = this.getColumn(i);
            this.resetLobColumn(col);
        }
    }

    private void saveIndex(Index index) throws AxionException {
        File dataDir = new File(this._indexRootDir, index.getName());
        index.save(dataDir);
    }

    private void saveIndexAfterTruncate(Index index) throws AxionException {
        File dataDir = new File(this._indexRootDir, index.getName());
        index.saveAfterTruncate(dataDir);
    }
}

