/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntCollections;
import org.apache.commons.collections.primitives.IntIterator;
import org.axiondb.AxionException;
import org.axiondb.BindVariable;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Constraint;
import org.axiondb.ConstraintViolationException;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Function;
import org.axiondb.Index;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.RowSource;
import org.axiondb.Selectable;
import org.axiondb.Sequence;
import org.axiondb.TableIdentifier;
import org.axiondb.TransactableTable;
import org.axiondb.constraints.ForeignKeyConstraint;
import org.axiondb.constraints.PrimaryKeyConstraint;
import org.axiondb.constraints.UniqueConstraint;
import org.axiondb.engine.TransactableTableImpl;
import org.axiondb.engine.rowcollection.RowCollections;
import org.axiondb.engine.rowiterators.RebindableIndexedRowIterator;
import org.axiondb.engine.rowiterators.UnmodifiableRowIterator;
import org.axiondb.engine.tables.AbstractBaseTable;
import org.axiondb.event.ColumnEvent;
import org.axiondb.event.ConstraintEvent;
import org.axiondb.event.RowDeletedEvent;
import org.axiondb.event.RowInsertedEvent;
import org.axiondb.event.RowUpdatedEvent;
import org.axiondb.event.TableModificationListener;
import org.axiondb.functions.ComparisonFunction;
import org.axiondb.types.LOBType;
import org.axiondb.util.ValuePool;

public abstract class BaseTable
extends AbstractBaseTable {
    private String _name;
    private String _type;
    private List _cols = new ArrayList();
    private List _indices = new ArrayList(4);
    private Map _constraints = new HashMap(4);
    private Map _colIndexToColIdMap;
    private Sequence _sequence;
    private static Logger _log = Logger.getLogger(BaseTable.class.getName());

    public abstract void applyDeletes(IntCollection var1) throws AxionException;

    public abstract void applyInserts(RowCollection var1) throws AxionException;

    public abstract void applyUpdates(RowCollection var1) throws AxionException;

    public abstract void freeRowId(int var1);

    public abstract int getNextRowId();

    public abstract int getRowCount();

    public abstract void populateIndex(Index var1) throws AxionException;

    public abstract Row getRow(int var1) throws AxionException;

    protected abstract RowIterator getRowIterator() throws AxionException;

    public BaseTable(String name) {
        this._name = (name + "").toUpperCase();
        this.setType("TABLE");
    }

    public RowIterator getRowIterator(boolean readOnly) throws AxionException {
        if (readOnly) {
            return UnmodifiableRowIterator.wrap(this.getRowIterator());
        }
        return this.getRowIterator();
    }

    public void addRow(Row row) throws AxionException {
        int rowid = this.getNextRowId();
        row.setIdentifier(rowid);
        RowInsertedEvent event = new RowInsertedEvent(this, null, row);
        try {
            this.checkConstraints(event, this.makeRowDecorator());
        }
        catch (AxionException e) {
            this.freeRowId(rowid);
            throw e;
        }
        this.applyInserts(RowCollections.singletonList(row));
    }

    public void checkpoint() throws AxionException {
    }

    public void setSequence(Sequence seq) throws AxionException {
        this._sequence = seq;
    }

    public final Sequence getSequence() {
        return this._sequence;
    }

    public void deleteRow(Row row) throws AxionException {
        RowDeletedEvent event = new RowDeletedEvent(this, row, null);
        this.checkConstraints(event, this.makeRowDecorator());
        this.applyDeletes(IntCollections.singletonIntList(row.getIdentifier()));
    }

    public void updateRow(Row oldrow, Row newrow) throws AxionException {
        newrow.setIdentifier(oldrow.getIdentifier());
        RowUpdatedEvent event = new RowUpdatedEvent(this, oldrow, newrow);
        this.checkConstraints(event, this.makeRowDecorator());
        this.applyUpdates(RowCollections.singletonList(newrow));
    }

    protected void truncateIndices() throws AxionException {
        int I = this._indices.size();
        for (int i = 0; i < I; ++i) {
            ((Index)this._indices.get(i)).truncate();
        }
    }

    protected void recreateIndices() throws AxionException {
        int I = this._indices.size();
        for (int i = 0; i < I; ++i) {
            this.populateIndex((Index)this._indices.get(i));
        }
    }

    public String toString() {
        return this.getName();
    }

    public final String getName() {
        return this._name;
    }

    public final String getType() {
        return this._type;
    }

    protected void setType(String type) {
        this._type = type;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public void addConstraint(Constraint constraint) throws AxionException {
        this.addConstraint(constraint, true);
    }

    private void addConstraint(Constraint constraint, boolean checkExistingRows) throws AxionException {
        if (constraint instanceof PrimaryKeyConstraint && null != this.getPrimaryKey()) {
            throw new AxionException("This table already has a primary key");
        }
        if (this._constraints.containsKey(constraint.getName())) {
            throw new AxionException("A constraint named " + constraint.getName() + " already exists.");
        }
        if (checkExistingRows) {
            RowDecorator dec = this.makeRowDecorator();
            RowIterator iter = this.getRowIterator();
            while (iter.hasNext()) {
                Row current = iter.next();
                RowUpdatedEvent event = new RowUpdatedEvent(this, current, current);
                if (constraint.evaluate(event, dec)) continue;
                throw new ConstraintViolationException(constraint);
            }
        }
        this._constraints.put(constraint.getName(), constraint);
        Iterator iter = this.getTableModificationListeners();
        while (iter.hasNext()) {
            TableModificationListener listener = (TableModificationListener)iter.next();
            listener.constraintAdded(new ConstraintEvent(this, constraint));
        }
    }

    public final Constraint getConstraint(String name) {
        return (Constraint)this._constraints.get(name);
    }

    public Constraint removeConstraint(String name) {
        if (name != null && "PRIMARYKEY".equals(name)) {
            PrimaryKeyConstraint pk = this.getPrimaryKey();
            name = pk != null ? pk.getName() : null;
        }
        if (this._constraints.containsKey(name)) {
            Constraint constraint = (Constraint)this._constraints.get(name);
            Iterator iter = this.getTableModificationListeners();
            while (iter.hasNext()) {
                TableModificationListener listener = (TableModificationListener)iter.next();
                try {
                    listener.constraintRemoved(new ConstraintEvent(this, constraint));
                }
                catch (AxionException e) {
                    _log.log(Level.SEVERE, "Unable to publish constraint removed event", e);
                }
            }
            return (Constraint)this._constraints.remove(name);
        }
        return null;
    }

    public boolean isUniqueConstraintExists(String columnName) {
        boolean result = false;
        for (Object constraint : this._constraints.values()) {
            ColumnIdentifier cid;
            UniqueConstraint uk;
            if (!(constraint instanceof UniqueConstraint) || (uk = (UniqueConstraint)constraint).getSelectableCount() != 1 || !columnName.equals((cid = (ColumnIdentifier)uk.getSelectableList().get(0)).getName())) continue;
            result = true;
        }
        return result;
    }

    public boolean isPrimaryKeyConstraintExists(String columnName) {
        boolean result = false;
        for (Object constraint : this._constraints.values()) {
            ColumnIdentifier cid;
            UniqueConstraint uk;
            if (!(constraint instanceof PrimaryKeyConstraint) || (uk = (UniqueConstraint)constraint).getSelectableCount() != 1 || !columnName.equals((cid = (ColumnIdentifier)uk.getSelectableList().get(0)).getName())) continue;
            result = true;
        }
        return result;
    }

    private PrimaryKeyConstraint getPrimaryKey() {
        for (Constraint constraint : this._constraints.values()) {
            if (!(constraint instanceof PrimaryKeyConstraint)) continue;
            return (PrimaryKeyConstraint)constraint;
        }
        return null;
    }

    public Iterator getConstraints() {
        return this._constraints.values().iterator();
    }

    public void addIndex(Index index) throws AxionException {
        this._indices.add(index);
        this.addTableModificationListener(index);
    }

    public void removeIndex(Index index) throws AxionException {
        this._indices.remove(index);
        this.removeTableModificationListener(index);
    }

    public Index getIndexForColumn(Column column) {
        int I = this._indices.size();
        for (int i = 0; i < I; ++i) {
            Index index = (Index)this._indices.get(i);
            if (!column.equals(index.getIndexedColumn())) continue;
            return index;
        }
        return null;
    }

    public boolean isColumnIndexed(Column column) {
        int I = this._indices.size();
        for (int i = 0; i < I; ++i) {
            Index index = (Index)this._indices.get(i);
            if (!column.equals(index.getIndexedColumn())) continue;
            return true;
        }
        return false;
    }

    public RowIterator getIndexedRows(Selectable node, boolean readOnly) throws AxionException {
        return this.getIndexedRows(this, node, readOnly);
    }

    public RowIterator getIndexedRows(RowSource source, Selectable node, boolean readOnly) throws AxionException {
        if (readOnly) {
            return UnmodifiableRowIterator.wrap(this.getIndexedRows(source, node));
        }
        return this.getIndexedRows(source, node);
    }

    public void addColumn(Column col) throws AxionException {
        LOBType lob;
        if (this.getRowCount() > 0) {
            throw new AxionException("Cannot add column because table already contains rows.");
        }
        if (col.getDataType() instanceof LOBType && null == (lob = (LOBType)col.getDataType()).getLobDir()) {
            File lobDir = new File(System.getProperty("axiondb.lobdir", ".").toUpperCase(), col.getName().toUpperCase());
            lob.setLobDir(lobDir);
        }
        this._cols.add(col);
        this.clearCache();
        this.publishEvent(new ColumnEvent(this, col));
    }

    protected final void clearCache() {
        this._colIndexToColIdMap = null;
    }

    public boolean hasColumn(ColumnIdentifier id) {
        boolean result = false;
        String tableName = id.getTableName();
        if (tableName == null || tableName.equals(this.getName())) {
            result = this.getColumn(id.getName()) != null;
        }
        return result;
    }

    public final Column getColumn(int index) {
        return (Column)this._cols.get(index);
    }

    public Column getColumn(String name) {
        int I = this._cols.size();
        for (int i = 0; i < I; ++i) {
            Column col = (Column)this._cols.get(i);
            if (!col.getName().equalsIgnoreCase(name)) continue;
            return col;
        }
        return null;
    }

    public int getColumnIndex(String name) throws AxionException {
        int I = this._cols.size();
        for (int i = 0; i < I; ++i) {
            Column col = (Column)this._cols.get(i);
            if (!col.getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new AxionException("Column " + name + " not found.");
    }

    public List getColumnIdentifiers() {
        ArrayList<ColumnIdentifier> colids = new ArrayList<ColumnIdentifier>();
        int I = this._cols.size();
        for (int i = 0; i < I; ++i) {
            Column col = (Column)this._cols.get(i);
            colids.add(new ColumnIdentifier(new TableIdentifier(this.getName()), col.getName(), null, col.getDataType()));
        }
        return Collections.unmodifiableList(colids);
    }

    public final int getColumnCount() {
        return this._cols.size();
    }

    public final DataType[] getDataTypes() {
        DataType[] types = new DataType[this._cols.size()];
        int I = this._cols.size();
        for (int i = 0; i < I; ++i) {
            types[i] = this.getColumn(i).getDataType();
        }
        return types;
    }

    public void drop() throws AxionException {
    }

    public void remount(File dir, boolean datafilesonly) throws AxionException {
    }

    public void rename(String oldName, String newName) throws AxionException {
        this.setName(newName);
        this.clearCache();
    }

    public void shutdown() throws AxionException {
    }

    public RowDecorator makeRowDecorator() {
        if (null == this._colIndexToColIdMap) {
            int size = this._cols.size();
            HashMap<ColumnIdentifier, Integer> map = new HashMap<ColumnIdentifier, Integer>(size);
            for (int i = 0; i < size; ++i) {
                Column col = (Column)this._cols.get(i);
                ColumnIdentifier colid = new ColumnIdentifier(new TableIdentifier(this.getName()), col.getName(), null, col.getDataType());
                map.put(colid, ValuePool.getInt(i));
            }
            this._colIndexToColIdMap = map;
        }
        return new RowDecorator(this._colIndexToColIdMap);
    }

    public TransactableTable makeTransactableTable() {
        return new TransactableTableImpl(this);
    }

    public Iterator getIndices() {
        return this._indices.iterator();
    }

    public boolean hasIndex(String name) {
        String upperName = name.toUpperCase();
        int I = this._indices.size();
        for (int i = 0; i < I; ++i) {
            Index index = (Index)this._indices.get(i);
            if (!upperName.equals(index.getName())) continue;
            return true;
        }
        return false;
    }

    protected void notifyColumnsOfNewLobDir(File directory) throws AxionException {
        int I = this._cols.size();
        for (int i = 0; i < I; ++i) {
            Column col = (Column)this._cols.get(i);
            if (!(col.getDataType() instanceof LOBType)) continue;
            LOBType lob = (LOBType)col.getDataType();
            lob.setLobDir(new File(directory, col.getName()));
        }
    }

    protected void writeColumns(ObjectOutputStream out) throws IOException {
        out.writeObject(this._cols);
    }

    protected void readColumns(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._cols = (List)in.readObject();
    }

    protected void writeConstraints(ObjectOutputStream out) throws IOException {
        out.writeObject(this._constraints);
    }

    protected void readConstraints(ObjectInputStream in, Database db) throws IOException, ClassNotFoundException, AxionException {
        this._constraints = (Map)in.readObject();
        for (Constraint constraint : this._constraints.values()) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint fk = (ForeignKeyConstraint)constraint;
            fk.setParentTable(db.getTable(fk.getParentTableName()));
            fk.setChildTable(db.getTable(fk.getChildTableName()));
        }
    }

    protected void applyDeletesToIndices(IntCollection rowIds) throws AxionException {
        IntIterator ids = rowIds.iterator();
        while (ids.hasNext()) {
            Row deleted = this.getRow(ids.next());
            if (deleted == null) continue;
            RowDeletedEvent event = new RowDeletedEvent(this, deleted, null);
            int I = this._indices.size();
            for (int i = 0; i < I; ++i) {
                Index index = (Index)this._indices.get(i);
                index.rowDeleted(event);
            }
        }
    }

    protected void applyUpdatesToIndices(RowCollection rows) throws AxionException {
        RowIterator iter = rows.rowIterator();
        while (iter.hasNext()) {
            Row newrow = iter.next();
            Row oldrow = this.getRow(newrow.getIdentifier());
            if (oldrow == null) continue;
            RowUpdatedEvent event = new RowUpdatedEvent(this, oldrow, newrow);
            int I = this._indices.size();
            for (int i = 0; i < I; ++i) {
                Index index = (Index)this._indices.get(i);
                index.rowUpdated(event);
            }
        }
    }

    protected void applyInsertsToIndices(RowCollection rows) throws AxionException {
        RowIterator iter = rows.rowIterator();
        while (iter.hasNext()) {
            Row row = iter.next();
            RowInsertedEvent event = new RowInsertedEvent(this, null, row);
            int I = this._indices.size();
            for (int i = 0; i < I; ++i) {
                Index index = (Index)this._indices.get(i);
                index.rowInserted(event);
            }
        }
    }

    private RowIterator getIndexedRows(RowSource source, Selectable node) throws AxionException {
        if (node instanceof ComparisonFunction) {
            ComparisonFunction function = (ComparisonFunction)node;
            Column column = null;
            Literal literal = null;
            Selectable left = function.getArgument(0);
            Selectable right = function.getArgument(1);
            if (left instanceof ColumnIdentifier && right instanceof Literal) {
                column = this.getColumn(((ColumnIdentifier)left).getName());
                literal = (Literal)right;
            } else if (left instanceof Literal && right instanceof ColumnIdentifier) {
                column = this.getColumn(((ColumnIdentifier)right).getName());
                literal = (Literal)left;
                function = function.flip();
            } else {
                return null;
            }
            if (!this.isColumnIndexed(column)) {
                return null;
            }
            Index index = this.getIndexForColumn(column);
            if (!index.supportsFunction(function)) {
                return null;
            }
            if (literal instanceof BindVariable) {
                return new RebindableIndexedRowIterator(index, source, function, (BindVariable)literal);
            }
            return index.getRowIterator(source, function, literal.evaluate(null));
        }
        if (node instanceof ColumnIdentifier) {
            Column column = this.getColumn(((ColumnIdentifier)node).getName());
            Index index = this.getIndexForColumn(column);
            if (index != null) {
                return index.getInorderRowIterator(source);
            }
        } else if (node instanceof Function) {
            Function function = (Function)node;
            if (function.getArgumentCount() != 1) {
                return null;
            }
            Selectable colid = function.getArgument(0);
            if (colid instanceof ColumnIdentifier) {
                Column column = this.getColumn(((ColumnIdentifier)colid).getName());
                if (!this.isColumnIndexed(column)) {
                    return null;
                }
                Index index = this.getIndexForColumn(column);
                if (!index.supportsFunction(function)) {
                    return null;
                }
                return index.getRowIterator(source, function, null);
            }
        }
        return null;
    }
}

