/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.ExternalTableLoader;
import org.axiondb.Row;
import org.axiondb.engine.tables.BaseFlatfileTable;
import org.axiondb.engine.tables.DelimitedFlatfileTableLoader;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.io.BufferedDataOutputStream;
import org.axiondb.io.CharStreamTokenizer;
import org.axiondb.io.FileUtil;

public class DelimitedFlatfileTable
extends BaseFlatfileTable {
    protected static final String EMPTY_STRING = "";
    protected static final String COMMA = ",";
    public static final String PROP_FIELDDELIMITER = "FIELDDELIMITER";
    public static final String PROP_QUALIFIER = "QUALIFIER";
    public static final String PROP_VALIDATION = "VALIDATION";
    byte[] QUALIFIER_BYTES;
    byte[] EMPTY_STRING_BYTES = "".getBytes();
    byte[] LINESEP_BYTES;
    byte[] FIELDSEP_BYTES;
    private static final Set PROPERTY_KEYS = new HashSet(2);
    private static final Set REQUIRED_KEYS = new HashSet(1);
    protected String _fieldSep;
    private char[] _fieldSepChar;
    protected String _preferredLineSep;
    protected String[] _lineSeps;
    protected char[][] _lineSepsChar;
    protected String _qualifier;
    private char[] _qualifierChar;
    protected boolean _isQuoted;
    protected Pattern _qPattern;
    private boolean _validate = true;
    private DataType[] _dataTypes;
    private int _colCount;
    private CharStreamTokenizer _streamTokenizer;

    public DelimitedFlatfileTable(String name, Database db) throws AxionException {
        super(name, db, new DelimitedFlatfileTableLoader());
        this.setType("DELIMITED TEXT TABLE");
    }

    public DelimitedFlatfileTable(String name, Database db, ExternalTableLoader loader) throws AxionException {
        super(name, db, loader);
    }

    protected String getDefaultDataFileExtension() {
        return "csv";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row getRowByOffset(int idToAssign, long ptr) throws AxionException {
        Row row = null;
        try {
            if (null == this._readStream) {
                this._readStream = this.getInputStream();
            }
            BufferedDataInputStream bufferedDataInputStream = this._readStream;
            synchronized (bufferedDataInputStream) {
                row = this._streamTokenizer.readAndSplitLine(this._readStream, ptr, this._colCount, this._trimWhiteSpace, this._dataTypes);
            }
            row.setIdentifier(idToAssign);
        }
        catch (IOException e) {
            throw new AxionException(e, 22031);
        }
        return row;
    }

    protected boolean isEndOfRecord(int recLength, int nextChar, BufferedDataInputStream data) throws IOException {
        return this._streamTokenizer.isEndOfRecord(nextChar, data);
    }

    public boolean loadExternalTable(Properties props) throws AxionException {
        this.context = new DelimitedTableOrganizationContext();
        return super.loadExternalTable(props);
    }

    /*
     * Unable to fully structure code
     */
    protected void initializeTable() throws AxionException {
        try {
            faultCount = 0;
            endOffset = FileUtil.getLength(this.getDataFile());
            fileOffset = this.ignoreRowsToSkip();
            pidx = this.getPidxList();
            while (-1L != fileOffset && fileOffset + (long)this._lineSep.length() < endOffset - 1L) {
                pidx.add(fileOffset);
                if (this._validate) {
                    try {
                        row = this._streamTokenizer.readAndSplitLine(this._readStream, fileOffset, this._colCount, this._trimWhiteSpace, this._dataTypes);
                        for (i = 0; i < this._colCount; ++i) {
                            row = this.trySettingColumn(row, i, row.get(i));
                        }
                        ++this._rowCount;
                    }
                    catch (AxionException ex) {
                        pidx.set(pidx.size() - 1, 0x7FFFFFFFFFFFFFFFL);
                        if ((long)(++faultCount) <= this._maxFaults) ** GOTO lbl23
                        msg = "Fault tolerance threshold (" + this._maxFaults + ") exceeded for table " + this.getName() + ". ";
                        throw new AxionException(msg + ex.getMessage(), ex);
                    }
                } else {
                    this._streamTokenizer.skipLine(this._readStream);
                    ++this._rowCount;
                }
lbl23:
                // 3 sources

                fileOffset = this._readStream.getPos();
            }
            this.getPidxList().flush();
        }
        catch (Exception e) {
            throw new AxionException(e);
        }
    }

    public Properties getTableProperties() {
        return this.context.getTableProperties();
    }

    protected void parseTableProperties(ObjectInputStream in) throws AxionException {
        try {
            this._lineSep = in.readUTF();
            this._fieldSep = in.readUTF();
            this._isFirstLineHeader = Boolean.valueOf(in.readUTF());
            this._fileName = in.readUTF();
            in.readUTF();
            this._qualifier = in.readUTF();
            in.readUTF();
            try {
                this._rowCount = in.readInt();
            }
            catch (EOFException ignore) {
                // empty catch block
            }
            this.context = new DelimitedTableOrganizationContext();
            this.context.updateProperties();
            this.context.readOrSetDefaultProperties(this.context.getTableProperties());
            this.createOrLoadDataFile();
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to parse meta file for table " + this.getName(), ioex);
        }
    }

    protected void writeHeader(BufferedDataOutputStream dataFile) throws AxionException {
        if (this._isFirstLineHeader) {
            try {
                CharArrayWriter header = new CharArrayWriter();
                for (int i = 0; i < this._colCount; ++i) {
                    if (i != 0) {
                        header.write(this._fieldSep);
                    }
                    header.write(this.getColumn(i).getName());
                }
                header.write(this._preferredLineSep);
                dataFile.write(header.toString().getBytes());
                header.close();
            }
            catch (IOException ioex) {
                throw new AxionException("Unable to write header for table: " + this.getName(), ioex);
            }
        }
    }

    protected void writeRow(BufferedDataOutputStream buffer, Row row) throws AxionException {
        Object colValue = null;
        try {
            for (int i = 0; i < this._colCount; ++i) {
                byte[] qualifier;
                colValue = row.get(i);
                if (i != 0) {
                    buffer.write(this.FIELDSEP_BYTES);
                }
                byte[] byArray = qualifier = this.isEscapeRequired(this._dataTypes[i]) ? this.QUALIFIER_BYTES : this.EMPTY_STRING_BYTES;
                if (colValue != null) {
                    buffer.write(qualifier);
                    String val = this._dataTypes[i].toString(colValue);
                    if (this._isQuoted && val.indexOf(this._qualifier) != -1) {
                        val = this._qPattern.matcher(val).replaceAll(this._qualifier + this._qualifier);
                    }
                    buffer.write(val.getBytes());
                    buffer.write(qualifier);
                    continue;
                }
                buffer.write(this.EMPTY_STRING_BYTES);
            }
            buffer.write(this.LINESEP_BYTES);
        }
        catch (IOException e) {
            throw new AxionException("Error writing row: " + row, e);
        }
    }

    protected void writeTableProperties(ObjectOutputStream out) throws AxionException {
        try {
            if (this._lineSep != null && this._fieldSep != null && this._fileName != null) {
                out.writeUTF(this._lineSep);
                out.writeUTF(this._fieldSep);
                out.writeUTF(Boolean.toString(this._isFirstLineHeader));
                out.writeUTF(this._fileName);
                out.writeUTF(this._lineSep);
                out.writeUTF(this._qualifier);
                out.writeUTF("true");
                out.writeInt(this._rowsToSkip);
                out.writeBoolean(this._validate);
            }
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to write meta file for table " + this.getName(), ioex);
        }
    }

    private boolean isEscapeRequired(DataType type) {
        switch (type.getJdbcType()) {
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ char[] access$202(DelimitedFlatfileTable x0, char[] x1) {
        x0._fieldSepChar = x1;
        return x1;
    }

    static /* synthetic */ char[] access$402(DelimitedFlatfileTable x0, char[] x1) {
        x0._qualifierChar = x1;
        return x1;
    }

    static /* synthetic */ DataType[] access$602(DelimitedFlatfileTable x0, DataType[] x1) {
        x0._dataTypes = x1;
        return x1;
    }

    static {
        PROPERTY_KEYS.add(PROP_VALIDATION);
        PROPERTY_KEYS.add(PROP_FIELDDELIMITER);
        PROPERTY_KEYS.add(PROP_QUALIFIER);
    }

    private class DelimitedTableOrganizationContext
    extends BaseFlatfileTable.BaseFlatfileTableOrganizationContext {
        private DelimitedTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            Set baseKeys = super.getPropertyKeys();
            HashSet keys = new HashSet(baseKeys.size() + PROPERTY_KEYS.size());
            keys.addAll(baseKeys);
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            String validation;
            super.readOrSetDefaultProperties(props);
            String rawFieldSep = props.getProperty(DelimitedFlatfileTable.PROP_FIELDDELIMITER);
            if (rawFieldSep == null || rawFieldSep.length() == 0) {
                rawFieldSep = DelimitedFlatfileTable.COMMA;
            }
            DelimitedFlatfileTable.this._fieldSep = BaseFlatfileTable.fixEscapeSequence(rawFieldSep);
            DelimitedFlatfileTable.access$202(DelimitedFlatfileTable.this, DelimitedFlatfileTable.this._fieldSep.toCharArray());
            String lineSep = System.getProperty("line.separator");
            if (DelimitedFlatfileTable.EMPTY_STRING.equals(DelimitedFlatfileTable.this._lineSep)) {
                DelimitedFlatfileTable.this._lineSep = BaseFlatfileTable.fixEscapeSequence(lineSep);
            }
            if (!DelimitedFlatfileTable.this.isNullString(validation = props.getProperty(DelimitedFlatfileTable.PROP_VALIDATION)) && "false".equalsIgnoreCase(validation)) {
                DelimitedFlatfileTable.this._validate = false;
            }
            StringTokenizer tokenizer = new StringTokenizer(DelimitedFlatfileTable.this._lineSep, " ");
            ArrayList<String> tmpList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                tmpList.add(token);
                if (!token.equals(lineSep)) continue;
                DelimitedFlatfileTable.this._preferredLineSep = token;
            }
            DelimitedFlatfileTable.this._lineSeps = tmpList.toArray(new String[0]);
            DelimitedFlatfileTable.this._lineSepsChar = new char[tmpList.size()][];
            int I = tmpList.size();
            for (int i = 0; i < I; ++i) {
                DelimitedFlatfileTable.this._lineSepsChar[i] = ((String)tmpList.get(i)).toCharArray();
            }
            if (DelimitedFlatfileTable.this._preferredLineSep == null || DelimitedFlatfileTable.this._preferredLineSep.length() == 0) {
                DelimitedFlatfileTable.this._preferredLineSep = DelimitedFlatfileTable.this._lineSeps[0];
            }
            DelimitedFlatfileTable.this._qualifier = BaseFlatfileTable.fixEscapeSequence(props.getProperty(DelimitedFlatfileTable.PROP_QUALIFIER));
            if (DelimitedFlatfileTable.this.isNullString(DelimitedFlatfileTable.this._qualifier)) {
                DelimitedFlatfileTable.this._qualifier = DelimitedFlatfileTable.EMPTY_STRING;
                DelimitedFlatfileTable.this._isQuoted = false;
                DelimitedFlatfileTable.access$402(DelimitedFlatfileTable.this, new char[0]);
            } else {
                DelimitedFlatfileTable.this._qPattern = Pattern.compile(DelimitedFlatfileTable.this._qualifier);
                DelimitedFlatfileTable.this._isQuoted = true;
                DelimitedFlatfileTable.access$402(DelimitedFlatfileTable.this, DelimitedFlatfileTable.this._qualifier.toCharArray());
            }
            DelimitedFlatfileTable.this._colCount = DelimitedFlatfileTable.this.getColumnCount();
            DelimitedFlatfileTable.access$602(DelimitedFlatfileTable.this, DelimitedFlatfileTable.this.getDataTypes());
            DelimitedFlatfileTable.this.QUALIFIER_BYTES = DelimitedFlatfileTable.this._qualifier.getBytes();
            DelimitedFlatfileTable.this.LINESEP_BYTES = DelimitedFlatfileTable.this._preferredLineSep.getBytes();
            DelimitedFlatfileTable.this.FIELDSEP_BYTES = DelimitedFlatfileTable.this._fieldSep.getBytes();
            DelimitedFlatfileTable.this._streamTokenizer = new CharStreamTokenizer(DelimitedFlatfileTable.this._fieldSepChar, DelimitedFlatfileTable.this._lineSepsChar, DelimitedFlatfileTable.this._qualifierChar, DelimitedFlatfileTable.this._isQuoted);
        }

        public void updateProperties() {
            super.updateProperties();
            this._props.setProperty(DelimitedFlatfileTable.PROP_VALIDATION, String.valueOf(DelimitedFlatfileTable.this._validate));
            this._props.setProperty("LOADTYPE", "DELIMITED");
            this._props.setProperty(DelimitedFlatfileTable.PROP_FIELDDELIMITER, BaseFlatfileTable.addEscapeSequence(DelimitedFlatfileTable.this._fieldSep));
            this._props.setProperty(DelimitedFlatfileTable.PROP_QUALIFIER, DelimitedFlatfileTable.this._qualifier);
        }

        public Set getRequiredPropertyKeys() {
            Set baseRequiredKeys = this.getBaseRequiredPropertyKeys();
            HashSet keys = new HashSet(baseRequiredKeys.size() + REQUIRED_KEYS.size());
            keys.addAll(baseRequiredKeys);
            keys.addAll(REQUIRED_KEYS);
            return keys;
        }
    }
}

