/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.File;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.primitives.IntCollection;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Constraint;
import org.axiondb.ConstraintViolationException;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.DatabaseLink;
import org.axiondb.ExternalTable;
import org.axiondb.Function;
import org.axiondb.Index;
import org.axiondb.IndexLoader;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.RowSource;
import org.axiondb.Selectable;
import org.axiondb.SelectableBasedConstraint;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.TransactableTable;
import org.axiondb.constraints.NotNullConstraint;
import org.axiondb.constraints.PrimaryKeyConstraint;
import org.axiondb.constraints.UniqueConstraint;
import org.axiondb.engine.indexes.BaseIndex;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.rowiterators.FilteringRowIterator;
import org.axiondb.engine.rowiterators.ListIteratorRowIterator;
import org.axiondb.engine.rowiterators.UnmodifiableRowIterator;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseTableOrganizationContext;
import org.axiondb.event.ColumnEvent;
import org.axiondb.event.ConstraintEvent;
import org.axiondb.event.RowEvent;
import org.axiondb.event.RowUpdatedEvent;
import org.axiondb.event.TableModificationListener;
import org.axiondb.event.TableModifiedEvent;
import org.axiondb.functions.AndFunction;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ComparisonFunction;
import org.axiondb.functions.EqualFunction;
import org.axiondb.jdbc.AxionConnection;
import org.axiondb.types.TimestampType;
import org.axiondb.util.ExceptionConverter;
import org.axiondb.util.Utils;
import org.axiondb.util.ValuePool;

public class ExternalDatabaseTable
implements ExternalTable,
TransactableTable {
    private static final Set PROPERTY_KEYS = new HashSet(6);
    private static final Set REQUIRED_KEYS = new HashSet(1);
    private static Logger _log;
    private static final String XTERNAL_DB = "externalDB";
    private static final int NULL_CHECK = 1;
    private static final int EQUALITY_CHECK = 0;
    private static final int BATCH_SIZE = 1000;
    private static final int FETCH_SIZE = 100;
    private static final String[] JDBC_TABLE_OBJECT_TYPE;
    private Boolean _sybase = null;
    private List _indexes;
    private String _catalogName;
    private Map _colIndexToColIdMap;
    private List _cols = new ArrayList();
    private Connection _conn;
    private Map _constraints = new HashMap(4);
    private Database _db;
    private String _dblink;
    private int _deleteModCount;
    private PreparedStatement _deletePS;
    private ResultSet _externalRs;
    private int _insertModCount;
    private PreparedStatement _insertPS;
    private List _insertCols;
    private boolean _isAxion = false;
    private boolean _isCreateIfNotExist = false;
    private boolean _isUpdatable = true;
    private int _modCount = 0;
    private String _name;
    private Set _notNullColumns = new HashSet(4);
    private PrimaryKeyConstraint _pk;
    private String _qualifiedTableName;
    private String _remoteTableName;
    private int _rowCount = 0;
    private PreparedStatement _rowCountPS;
    private String _schemaName;
    private Statement _stmt;
    private List _tableModificationListeners = new ArrayList();
    private String _trunncateSQL;
    private Map _typeInfoMap = new HashMap(20);
    private List _uniqueConstraints = new ArrayList(2);
    private List _updateCols;
    private int _updateModCount;
    private PreparedStatement _updatePS;
    private Map _indexSelectPSs = new HashMap();
    private String _where;
    private ExternalDatabaseTableOrganizationContext context;

    public ExternalDatabaseTable(String name, Database db) {
        this._name = (name + "").toUpperCase();
        this._db = db;
    }

    public void addColumn(Column col) throws AxionException {
        if (this.getRowCount() > 0) {
            throw new AxionException("Cannot add column because table already contains rows.");
        }
        if (col.isDerivedColumn() || col.isIdentityColumn() || col.isGeneratedAlways()) {
            throw new AxionException("Generated column is not supported for table type");
        }
        this._cols.add(new CaseSensitiveColumn(col));
        this.clearCache();
        this.publishEvent(new ColumnEvent(this, col));
    }

    public void addConstraint(Constraint constraint) throws AxionException {
        if (this._constraints.containsKey(constraint.getName())) {
            throw new AxionException("A constraint named " + constraint.getName() + " already exists.");
        }
        if (constraint instanceof PrimaryKeyConstraint) {
            if (null != this._pk) {
                throw new AxionException("This table already has a primary key");
            }
            this._pk = (PrimaryKeyConstraint)constraint;
        } else if (constraint instanceof NotNullConstraint) {
            NotNullConstraint notNull = (NotNullConstraint)constraint;
            this._notNullColumns.addAll(this.getConstraintColumns(notNull));
        } else if (constraint instanceof UniqueConstraint) {
            this._uniqueConstraints.add(constraint);
        } else {
            return;
        }
        this.doAddConstraint(constraint);
    }

    public void addConstraint(Constraint constraint, boolean checkExistingRows) throws AxionException {
        if (constraint instanceof PrimaryKeyConstraint && null != this.getPrimaryKey()) {
            throw new AxionException("This table already has a primary key");
        }
        if (this._constraints.containsKey(constraint.getName())) {
            throw new AxionException("A constraint named " + constraint.getName() + " already exists.");
        }
        if (checkExistingRows) {
            RowDecorator dec = this.makeRowDecorator();
            RowIterator iter = this.getRowIterator();
            while (iter.hasNext()) {
                Row current = iter.next();
                RowUpdatedEvent event = new RowUpdatedEvent(this, current, current);
                if (constraint.evaluate(event, dec)) continue;
                throw new ConstraintViolationException(constraint);
            }
        }
        this._constraints.put(constraint.getName(), constraint);
        Iterator iter = this.getTableModificationListeners();
        while (iter.hasNext()) {
            TableModificationListener listener = (TableModificationListener)iter.next();
            listener.constraintAdded(new ConstraintEvent(this, constraint));
        }
    }

    public void addIndex(Index index) throws AxionException {
        Column idxCol = index.getIndexedColumn();
        if (!this.isColumnIndexed(idxCol)) {
            String colName = idxCol.getName();
            this._indexes.add(colName);
        }
    }

    public void addRow(Row row) throws AxionException {
        this.addRow(row, null);
    }

    public void addRow(Row row, List cols) throws AxionException {
        this.assertConnection();
        try {
            if (this._insertPS == null) {
                this.createInsertPS(cols);
            } else if (this._insertCols != null && cols == null) {
                this.createInsertPS(cols);
            } else if (!(cols == null || this._insertCols != null && ((Object)this._insertCols).equals(cols))) {
                this.createInsertPS(cols);
            }
            this.setValueParamsForInsert(this._insertPS, row);
            this._insertModCount = this.addBatch(this._insertPS, this._insertModCount);
            row.setIdentifier(-9999999);
        }
        catch (Exception e) {
            throw new AxionException(e);
        }
    }

    public void addTableModificationListener(TableModificationListener listener) {
        this._tableModificationListeners.add(listener);
    }

    public void apply() throws AxionException {
    }

    public void applyDeletes(IntCollection rowIds) throws AxionException {
        throw new UnsupportedOperationException();
    }

    public void applyInserts(RowCollection rows) {
        throw new UnsupportedOperationException();
    }

    public void applyUpdates(RowCollection rows) {
        throw new UnsupportedOperationException();
    }

    public void checkpoint() throws AxionException {
    }

    public void commit() throws AxionException {
        if (this._conn == null) {
            return;
        }
        try {
            if (this._modCount > 0) {
                if (this._insertModCount > 0 && this._insertPS != null) {
                    this._insertPS.executeBatch();
                    this._insertModCount = 0;
                }
                if (this._updateModCount > 0 && this._updatePS != null) {
                    this._updatePS.executeBatch();
                    this._updateModCount = 0;
                }
                if (this._deleteModCount > 0 && this._deletePS != null) {
                    this._deletePS.executeBatch();
                    this._deleteModCount = 0;
                }
                this._conn.commit();
                this._modCount = 0;
                this.remount();
            }
        }
        catch (SQLException ex) {
            int sqlState = 0;
            this.rollback();
            if (ex instanceof BatchUpdateException && ex.getNextException() != null) {
                ex = ex.getNextException();
            }
            try {
                sqlState = Integer.parseInt(ex.getSQLState());
            }
            catch (NumberFormatException numEx) {
                sqlState = 0;
            }
            throw new AxionException(ex, sqlState);
        }
    }

    public void deleteRow(Row row) throws AxionException {
        this.assertUpdatable();
        this.assertConnection();
        try {
            if (this._deletePS == null) {
                this._deletePS = this._conn.prepareStatement(this.getDeleteSQL());
            }
            this.setWhereParams(this._deletePS, row, 0);
            this._deleteModCount = this.addBatch(this._deletePS, this._deleteModCount);
        }
        catch (SQLException e) {
            this.rollback();
            throw this.convertException("Failed to apply deletes ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() throws AxionException {
        if (this._conn == null || this._stmt == null) {
            throw new AxionException("Invalid State: Remote connection has been already closed");
        }
        try {
            this._stmt.executeUpdate("DROP TABLE " + this._remoteTableName);
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.shutdown();
        }
    }

    public void freeRowId(int id) {
    }

    public final Column getColumn(int index) {
        return (Column)this._cols.get(index);
    }

    public Column getColumn(String name) {
        int I = this._cols.size();
        for (int i = 0; i < I; ++i) {
            Column col = (Column)this._cols.get(i);
            if (!col.getName().equalsIgnoreCase(name)) continue;
            return col;
        }
        return null;
    }

    public final int getColumnCount() {
        return this._cols.size();
    }

    public List getColumnIdentifiers() {
        ArrayList<ColumnIdentifier> colids = new ArrayList<ColumnIdentifier>();
        int I = this._cols.size();
        for (int i = 0; i < I; ++i) {
            Column col = (Column)this._cols.get(i);
            colids.add(new ColumnIdentifier(new TableIdentifier(this.getName()), col.getName(), null, col.getDataType()));
        }
        return Collections.unmodifiableList(colids);
    }

    public int getColumnIndex(String name) throws AxionException {
        int I = this._cols.size();
        for (int i = 0; i < I; ++i) {
            Column col = (Column)this._cols.get(i);
            if (!col.getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new AxionException("Column " + name + " not found.");
    }

    public final Constraint getConstraint(String name) {
        return null;
    }

    public Iterator getConstraints() {
        return this._constraints.values().iterator();
    }

    public String getDBLinkName() {
        return this._dblink;
    }

    public RowIterator getIndexedRows(RowSource source, Selectable node, boolean readOnly) throws AxionException {
        if (readOnly) {
            return UnmodifiableRowIterator.wrap(this.getIndexedRows(source, node));
        }
        return this.getIndexedRows(source, node);
    }

    public RowIterator getIndexedRows(Selectable node, boolean readOnly) throws AxionException {
        return this.getIndexedRows(this, node, readOnly);
    }

    public Index getIndexForColumn(Column column) {
        if (this._indexes != null && this._indexes.contains(column.getName())) {
            return new ExternalTableIndex(column);
        }
        return null;
    }

    public Iterator getIndices() {
        return Collections.EMPTY_LIST.iterator();
    }

    public RowIterator getMatchingRows(List selectables, List values, boolean readOnly) throws AxionException {
        if (null == selectables || selectables.isEmpty()) {
            return this.getRowIterator(readOnly);
        }
        RowIterator baseIterator = null;
        BaseFunction filter = null;
        int I = selectables.size();
        for (int i = 0; i < I; ++i) {
            Selectable sel = (Selectable)selectables.get(i);
            Object val = values.get(i);
            EqualFunction function = new EqualFunction();
            function.addArgument(sel);
            function.addArgument(new Literal(val));
            if (null == baseIterator && (baseIterator = this.getIndexedRows(function, readOnly)) != null) {
                function = null;
            }
            if (function == null) continue;
            if (null == filter) {
                filter = function;
                continue;
            }
            AndFunction fn = new AndFunction();
            fn.addArgument(filter);
            fn.addArgument(function);
            filter = fn;
        }
        if (null == baseIterator) {
            baseIterator = this.getRowIterator(readOnly);
        }
        if (null != filter) {
            return new FilteringRowIterator(baseIterator, this.makeRowDecorator(), filter);
        }
        return baseIterator;
    }

    public final String getName() {
        return this._name;
    }

    public int getNextRowId() {
        return 0;
    }

    public Row getRow(int id) throws AxionException {
        return this.getRowByOffset(id);
    }

    public int getRowCount() {
        if (-1 == this._rowCount) {
            this._rowCount = this.getTableSize();
        }
        return this._rowCount;
    }

    public RowIterator getRowIterator(boolean readOnly) throws AxionException {
        if (readOnly) {
            return UnmodifiableRowIterator.wrap(this.getRowIterator());
        }
        return this.getRowIterator();
    }

    public final Sequence getSequence() {
        return null;
    }

    public Iterator getTableModificationListeners() {
        return this._tableModificationListeners.iterator();
    }

    public Properties getTableProperties() {
        return this.context.getTableProperties();
    }

    public final String getType() {
        return "EXTERNAL DB TABLE";
    }

    public boolean hasColumn(ColumnIdentifier id) {
        boolean result = false;
        String tableName = id.getTableName();
        if (tableName == null || tableName.equals(this.getName())) {
            result = this.getColumn(id.getName()) != null;
        }
        return result;
    }

    public boolean hasIndex(String name) {
        return false;
    }

    public boolean isColumnIndexed(Column column) {
        try {
            return this.isColumnIndexed(column.getName());
        }
        catch (AxionException e) {
            throw ExceptionConverter.convertToRuntimeException(e);
        }
    }

    public boolean isPrimaryKeyConstraintExists(String columnName) {
        boolean result = false;
        for (Object constraint : this._constraints.values()) {
            ColumnIdentifier cid;
            UniqueConstraint uk;
            if (!(constraint instanceof PrimaryKeyConstraint) || (uk = (UniqueConstraint)constraint).getSelectableCount() != 1 || !columnName.equals((cid = (ColumnIdentifier)uk.getSelectableList().get(0)).getName())) continue;
            result = true;
        }
        return result;
    }

    public boolean isUniqueConstraintExists(String columnName) {
        boolean result = false;
        for (Object constraint : this._constraints.values()) {
            ColumnIdentifier cid;
            UniqueConstraint uk;
            if (!(constraint instanceof UniqueConstraint) || (uk = (UniqueConstraint)constraint).getSelectableCount() != 1 || !columnName.equals((cid = (ColumnIdentifier)uk.getSelectableList().get(0)).getName())) continue;
            result = true;
        }
        return result;
    }

    public boolean loadExternalTable(Properties props) throws AxionException {
        this.context = new ExternalDatabaseTableOrganizationContext();
        this.context.readOrSetDefaultProperties(props);
        this.context.updateProperties();
        return true;
    }

    public RowDecorator makeRowDecorator() {
        if (null == this._colIndexToColIdMap) {
            int size = this._cols.size();
            HashMap<ColumnIdentifier, Integer> map = new HashMap<ColumnIdentifier, Integer>(size);
            for (int i = 0; i < size; ++i) {
                Column col = (Column)this._cols.get(i);
                ColumnIdentifier colid = new ColumnIdentifier(new TableIdentifier(this.getName()), col.getName(), null, col.getDataType());
                map.put(colid, ValuePool.getInt(i));
            }
            this._colIndexToColIdMap = map;
        }
        return new RowDecorator(this._colIndexToColIdMap);
    }

    public Table getTable() {
        return this;
    }

    public TransactableTable makeTransactableTable() {
        return this;
    }

    public void migrate() throws AxionException {
    }

    public void populateIndex(Index index) throws AxionException {
    }

    public void remount() throws AxionException {
        if (this._externalRs != null) {
            try {
                this._externalRs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._externalRs = null;
        }
        this._rowCount = -1;
    }

    public void remount(File dir, boolean datafilesonly) throws AxionException {
    }

    public Constraint removeConstraint(String name) {
        if (name != null && "PRIMARYKEY".equals(name = name.toUpperCase())) {
            name = this._pk != null ? this._pk.getName() : null;
        }
        if (this._constraints.containsKey(name)) {
            Constraint constraint = (Constraint)this._constraints.get(name);
            Iterator iter = this.getTableModificationListeners();
            while (iter.hasNext()) {
                TableModificationListener listener = (TableModificationListener)iter.next();
                try {
                    listener.constraintRemoved(new ConstraintEvent(this, constraint));
                }
                catch (AxionException e) {
                    _log.log(Level.SEVERE, "Unable to publish constraint removed event", e);
                }
            }
            this._constraints.remove(name);
            if (constraint == this._pk) {
                this._pk = null;
            } else if (constraint instanceof NotNullConstraint) {
                List columns = this.getConstraintColumns((NotNullConstraint)constraint);
                this._notNullColumns.removeAll(columns);
            } else if (constraint instanceof UniqueConstraint) {
                this._uniqueConstraints.remove(constraint);
            }
            return constraint;
        }
        return null;
    }

    public void removeIndex(Index index) throws AxionException {
        this.removeTableModificationListener(index);
    }

    public void removeTableModificationListener(TableModificationListener listener) {
        this._tableModificationListeners.remove(listener);
    }

    public void rename(String oldName, String newName) throws AxionException {
        this.setName(newName);
        this.clearCache();
    }

    public void rollback() throws AxionException {
        if (this._conn == null) {
            return;
        }
        try {
            if (this._insertModCount > 0 && this._insertPS != null) {
                this._insertPS.clearBatch();
                this._insertPS.clearWarnings();
                this._insertModCount = 0;
            }
            if (this._updateModCount > 0 && this._updatePS != null) {
                this._updatePS.clearBatch();
                this._updatePS.clearWarnings();
                this._updateModCount = 0;
            }
            if (this._deleteModCount > 0 && this._deletePS != null) {
                this._deletePS.clearBatch();
                this._deletePS.clearWarnings();
                this._deleteModCount = 0;
            }
            this._conn.rollback();
            this._modCount = 0;
            this.remount();
        }
        catch (SQLException e) {
            throw new AxionException(e);
        }
    }

    public void setDeferAllConstraints(boolean deferAll) {
    }

    public void setSequence(Sequence seq) throws AxionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws AxionException {
        try {
            if (this._externalRs != null) {
                this._externalRs.close();
            }
            if (this._stmt != null) {
                this._stmt.close();
            }
            if (this._insertPS != null) {
                this._insertPS.close();
            }
            if (this._updatePS != null) {
                this._updatePS.close();
            }
            if (this._deletePS != null) {
                this._deletePS.close();
            }
            if (this._rowCountPS != null) {
                this._rowCountPS.close();
            }
            if (this._indexSelectPSs != null) {
                Iterator itr = this._indexSelectPSs.values().iterator();
                Statement stmnt = null;
                while (itr.hasNext()) {
                    stmnt = (Statement)itr.next();
                    try {
                        stmnt.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this._conn != null) {
                this._conn.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this._externalRs = null;
            this._conn = null;
            this._stmt = null;
            this._rowCountPS = null;
            this._insertPS = null;
            this._updatePS = null;
            this._deletePS = null;
            this._indexSelectPSs = null;
            this._db = null;
        }
    }

    public String toString() {
        return this.getName();
    }

    public void truncate() throws AxionException {
        this.assertConnection();
        Statement stmt = null;
        try {
            stmt = this._conn.createStatement();
            stmt.executeUpdate(this.getTruncateSQL());
            ++this._modCount;
            this.commit();
        }
        catch (SQLException e) {
            throw new AxionException(e);
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    public void updateRow(Row oldrow, Row newrow) throws AxionException {
        this.updateRow(oldrow, newrow, null);
    }

    public void updateRow(Row oldrow, Row newrow, List cols) throws AxionException {
        this.assertUpdatable();
        this.assertConnection();
        try {
            if (this._updatePS == null) {
                this.createUpdatePS(cols);
            } else if (this._updateCols != null && cols == null) {
                this.createUpdatePS(cols);
            } else if (!(cols == null || this._updateCols != null && ((Object)this._updateCols).equals(cols))) {
                this.createUpdatePS(cols);
            }
            this.setValueParamsForUpdate(this._updatePS, newrow);
            this.setWhereParams(this._updatePS, oldrow, this._updateCols != null ? this._updateCols.size() : oldrow.size());
            this._updateModCount = this.addBatch(this._updatePS, this._updateModCount);
        }
        catch (SQLException e) {
            this.rollback();
            throw this.convertException("Failed to apply updates ", e);
        }
    }

    protected void checkConstraints(RowEvent event) throws AxionException {
    }

    protected String getDeleteSQL() {
        StringBuffer stmtBuf = new StringBuffer(30);
        String rTable = this.getQualifiedTable();
        stmtBuf.append("DELETE FROM ").append(rTable);
        this.populateWhere(stmtBuf.append(" WHERE "));
        return stmtBuf.toString();
    }

    protected String getInsertSQL() {
        StringBuffer stmtBuf = new StringBuffer(30);
        String rTable = this.getQualifiedTable();
        stmtBuf.append("INSERT INTO ").append(rTable).append(" ");
        stmtBuf.append(" (");
        this.populateColumns(stmtBuf, null);
        this.populateValues(stmtBuf.append(") VALUES ("));
        stmtBuf.append(")");
        return stmtBuf.toString();
    }

    private RowIterator getBaseRowIterator() {
        return new BaseRowIterator(){
            Row _current = null;
            int _currentId = -1;
            int _currentIndex = -1;
            int _nextId = 0;
            int _nextIndex = 0;

            public Row current() {
                if (!this.hasCurrent()) {
                    throw new NoSuchElementException("No current row.");
                }
                return this._current;
            }

            public int currentIndex() {
                return this._currentIndex;
            }

            public boolean hasCurrent() {
                return null != this._current;
            }

            public boolean hasNext() {
                return this.nextIndex() < ExternalDatabaseTable.this.getRowCount();
            }

            public boolean hasPrevious() {
                return this.nextIndex() > 0;
            }

            public Row next() throws AxionException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next row");
                }
                do {
                    ++this._nextId;
                    this._currentId = this._currentId;
                    this._current = ExternalDatabaseTable.this.getRowByOffset(this._currentId);
                } while (null == this._current);
                this._currentIndex = this._nextIndex++;
                return this._current;
            }

            public int nextIndex() {
                return this._nextIndex;
            }

            public Row previous() throws AxionException {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous row");
                }
                do {
                    this._currentId = --this._nextId;
                    this._current = ExternalDatabaseTable.this.getRowByOffset(this._currentId);
                } while (null == this._current);
                --this._nextIndex;
                this._currentIndex = this._nextIndex;
                return this._current;
            }

            public int previousIndex() {
                return this._nextIndex - 1;
            }

            public void remove() throws AxionException {
                if (-1 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                ExternalDatabaseTable.this.deleteRow(this._current);
                this._currentIndex = -1;
            }

            public void reset() {
                this._current = null;
                this._nextIndex = 0;
                this._currentIndex = -1;
                this._nextId = 0;
            }

            public void set(Row row) throws AxionException {
                if (-1 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                ExternalDatabaseTable.this.updateRow(this._current, row);
            }

            public int size() throws AxionException {
                return ExternalDatabaseTable.this.getRowCount();
            }

            public String toString() {
                return "ExternalDatabaseTable(" + ExternalDatabaseTable.this.getName() + ")";
            }
        };
    }

    private RowIterator getForwardOnlyRowIterator() {
        return new BaseRowIterator(){
            Row _current = null;
            int _currentId = -1;
            int _currentIndex = -1;
            int _nextId = 0;
            int _nextIndex = 0;

            public Row current() {
                if (!this.hasCurrent()) {
                    throw new NoSuchElementException("No current row.");
                }
                return this._current;
            }

            public int currentIndex() {
                return this._currentIndex;
            }

            public boolean hasCurrent() {
                return null != this._current;
            }

            public boolean hasNext() {
                return this.nextIndex() < ExternalDatabaseTable.this.getRowCount();
            }

            public boolean hasPrevious() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Row getNextResultSetRow(int rowId) throws AxionException {
                ExternalDatabaseTable.this.assertExternalResultSet();
                try {
                    ResultSet resultSet = ExternalDatabaseTable.this._externalRs;
                    synchronized (resultSet) {
                        if (ExternalDatabaseTable.this._externalRs.next()) {
                            return ExternalDatabaseTable.this.getRowFromRS(rowId, ExternalDatabaseTable.this._externalRs);
                        }
                        return null;
                    }
                }
                catch (Exception e) {
                    throw new AxionException(e);
                }
            }

            public Row next() throws AxionException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next row");
                }
                this._currentId = this._nextId++;
                this._current = this.getNextResultSetRow(this._currentId);
                this._currentIndex = this._nextIndex++;
                return this._current;
            }

            public int nextIndex() {
                return this._nextIndex;
            }

            public Row previous() throws AxionException {
                throw new UnsupportedOperationException("previous() not supported.");
            }

            public int previousIndex() {
                return this._nextIndex - 1;
            }

            public void remove() throws AxionException {
                if (-1 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                ExternalDatabaseTable.this.deleteRow(this._current);
                this._currentIndex = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reset() {
                this._current = null;
                this._currentId = -1;
                this._currentIndex = -1;
                this._nextId = 0;
                this._nextIndex = 0;
                ResultSet resultSet = ExternalDatabaseTable.this._externalRs;
                synchronized (resultSet) {
                    try {
                        if (ExternalDatabaseTable.this._externalRs != null) {
                            ExternalDatabaseTable.this._externalRs.close();
                        }
                    }
                    catch (Exception ex) {
                        ExternalDatabaseTable.this._externalRs = null;
                    }
                    try {
                        ExternalDatabaseTable.this._externalRs = ExternalDatabaseTable.this.getResultSet(ExternalDatabaseTable.this.getSelectSQL(ExternalDatabaseTable.this._where));
                    }
                    catch (Exception ex) {
                        ExternalDatabaseTable.this._externalRs = null;
                    }
                }
            }

            public void set(Row row) throws AxionException {
                if (-1 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                ExternalDatabaseTable.this.updateRow(this._current, row);
            }

            public int size() throws AxionException {
                return ExternalDatabaseTable.this.getRowCount();
            }

            public String toString() {
                return "ExternalDatabaseTable(" + ExternalDatabaseTable.this.getName() + ")";
            }
        };
    }

    protected RowIterator getRowIterator() throws AxionException {
        this.createOrLoadResultSet();
        DatabaseLink server = this._db.getDatabaseLink(this._dblink);
        if (server.getJdbcUrl().toUpperCase().indexOf("ORACLE") != -1) {
            return this.getForwardOnlyRowIterator();
        }
        return this.getBaseRowIterator();
    }

    protected String getSchemaWildcardForRemoteDB() {
        String wildcard = "%";
        try {
            String dbName = this._conn.getMetaData().getDatabaseProductName();
            if (dbName.lastIndexOf("DB2") != -1) {
                wildcard = null;
            }
        }
        catch (SQLException ignore) {
            wildcard = "%";
        }
        return wildcard;
    }

    protected String getSelectSQL(String where) {
        StringBuffer stmtBuf = new StringBuffer(60);
        String rTable = this.getQualifiedTable();
        stmtBuf.append("SELECT ");
        this.populateColumns(stmtBuf, rTable);
        stmtBuf.append(" FROM ").append(rTable);
        if (where != null && where.trim().length() != 0) {
            stmtBuf.append(" WHERE " + where.trim());
        }
        return stmtBuf.toString();
    }

    protected String getUpdateSQL() {
        StringBuffer stmtBuf = new StringBuffer(30);
        String rTable = this.getQualifiedTable();
        stmtBuf.append("UPDATE ").append(rTable);
        this.populateSet(stmtBuf.append(" SET "));
        this.populateWhere(stmtBuf.append(" WHERE "));
        return stmtBuf.toString();
    }

    protected void setUp(DatabaseLink server) throws AxionException {
        try {
            this._conn = server.getConnection();
            this.assertConnection();
            this._isAxion = this._conn instanceof AxionConnection;
            if (server.getJdbcUrl().toUpperCase().indexOf("ORACLE") >= 0) {
                this._stmt = this._conn.createStatement(1003, 1007);
                this._stmt.setFetchSize(100);
            } else if (this._conn.getMetaData().supportsResultSetConcurrency(1004, 1007)) {
                this._stmt = this._conn.createStatement(1004, 1007);
                this._stmt.setFetchSize(100);
            } else {
                this._stmt = this._isAxion || server.getJdbcUrl().toUpperCase().indexOf("DERBY") >= 0 ? this._conn.createStatement(1005, 1007) : this._conn.createStatement();
            }
            this.setAutoCommit(this._conn, true);
            if (this._isCreateIfNotExist) {
                this.createRemoteTableIfNotExists();
            } else if (!this.tableExistsInRemoteDB()) {
                throw new AxionException("Table " + this._name + " does not exists.");
            }
        }
        catch (SQLException e) {
            throw this.convertException("Initialization error for remote table " + this.getName(), e);
        }
        finally {
            this.setAutoCommit(this._conn, false);
        }
    }

    private int addBatch(PreparedStatement pstmt, int stmtModCount) throws SQLException {
        pstmt.addBatch();
        if (++stmtModCount == 1000) {
            pstmt.executeBatch();
            stmtModCount = 0;
        }
        ++this._modCount;
        return stmtModCount;
    }

    private void appendColumnNames(List cols, StringBuffer buf) {
        ListIterator listIter = cols.listIterator();
        while (listIter.hasNext()) {
            String colName = (String)listIter.next();
            if (listIter.previousIndex() != 0) {
                buf.append(", ");
            }
            buf.append(colName);
        }
    }

    private void assertConnection() throws AxionException {
        if (this._conn == null) {
            throw new AxionException("Could not connect to remote database: " + this._dblink);
        }
    }

    private void assertExternalResultSet() throws AxionException {
        if (this._externalRs == null) {
            throw new AxionException("Invalid state: <null> ResultSet for external table " + this.getName());
        }
    }

    private void assertUpdatable() throws AxionException {
        if (!this._isUpdatable) {
            throw new AxionException("Not an updatable view - operation not allowed.");
        }
    }

    private void buildDBSpecificDatatypeMap() throws SQLException {
        this._typeInfoMap.clear();
        ResultSet typeInfo = this._conn.getMetaData().getTypeInfo();
        HashMap<Integer, Integer> tmpTypeSizeMap = new HashMap<Integer, Integer>();
        String typeName = null;
        Integer type = null;
        int jdbcType = 0;
        int currPrecision = 0;
        Integer prevPrecisionObj = null;
        while (typeInfo.next()) {
            typeName = typeInfo.getString("TYPE_NAME");
            jdbcType = typeInfo.getInt("DATA_TYPE");
            try {
                currPrecision = typeInfo.getInt("PRECISION");
            }
            catch (Exception ex) {
                currPrecision = Integer.MAX_VALUE;
            }
            type = ValuePool.getInt(jdbcType);
            if (this._isAxion) {
                this._typeInfoMap.put(type, typeName);
                continue;
            }
            prevPrecisionObj = (Integer)tmpTypeSizeMap.get(type);
            if (prevPrecisionObj != null && prevPrecisionObj >= currPrecision) continue;
            this._typeInfoMap.put(type, typeName);
            tmpTypeSizeMap.put(type, ValuePool.getInt(currPrecision));
        }
    }

    private void buildTableIndex() throws AxionException {
        if (this._indexes == null && !this.tableExistsInRemoteDB()) {
            this._indexes = Collections.EMPTY_LIST;
        }
    }

    private final void clearCache() {
        this._colIndexToColIdMap = null;
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private AxionException convertException(String errMsg, SQLException sqlEx) {
        StringBuffer msg = new StringBuffer(100);
        msg.append(errMsg == null ? "" : errMsg);
        msg.append(" ( CODE " + sqlEx.getErrorCode());
        msg.append(" - SQLSTATE " + sqlEx.getSQLState() + " ) ");
        msg.append(" : " + sqlEx.getMessage());
        return new AxionException(msg.toString());
    }

    private void createOrLoadResultSet() throws AxionException {
        if (this._externalRs == null) {
            this._externalRs = this.getResultSet(this.getSelectSQL(this._where));
            this._rowCount = -1;
        }
    }

    private void setAutoCommit(Connection conn, boolean val) {
        if (this._conn == null) {
            return;
        }
        if (this._sybase == null) {
            try {
                String url = this._conn.getMetaData().getURL();
                this._sybase = url != null ? ((url = url.toLowerCase()).indexOf(":sybase:") > -1 ? Boolean.TRUE : Boolean.FALSE) : Boolean.FALSE;
            }
            catch (SQLException ex) {
                this._sybase = Boolean.FALSE;
            }
        }
        if (this._sybase.booleanValue()) {
            try {
                conn.commit();
                conn.setAutoCommit(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createRemoteTableIfNotExists() throws AxionException {
        this.assertConnection();
        Statement stmt = null;
        try {
            if (!this.tableExistsInRemoteDB()) {
                stmt = this._conn.createStatement();
                this.buildDBSpecificDatatypeMap();
                stmt.executeUpdate(this.getCreateSQL());
            }
        }
        catch (SQLException e) {
            throw this.convertException("Could not create remote table " + this.getName(), e);
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    private void createUpdatePS(List cols) throws SQLException {
        this._updateCols = cols;
        if (this._updatePS != null) {
            this._updatePS.close();
            this._updatePS = null;
        }
        this._updatePS = this._conn.prepareStatement(this.getUpdateSQL());
    }

    private void createInsertPS(List cols) throws SQLException {
        this._insertCols = cols;
        if (this._insertPS != null) {
            this._insertPS.close();
            this._insertPS = null;
        }
        this._insertPS = this._conn.prepareStatement(this.getInsertSQL());
    }

    private void doAddConstraint(Constraint constraint) throws AxionException {
        this._constraints.put(constraint.getName(), constraint);
        Iterator iter = this.getTableModificationListeners();
        while (iter.hasNext()) {
            TableModificationListener listener = (TableModificationListener)iter.next();
            listener.constraintAdded(new ConstraintEvent(this, constraint));
        }
    }

    private boolean doesRemoteTableExist(String name, String schemaPattern) throws SQLException {
        ResultSet tableExist = this._conn.getMetaData().getTables(this._conn.getCatalog(), schemaPattern, name, JDBC_TABLE_OBJECT_TYPE);
        boolean found = tableExist.next();
        if (found && this._indexes == null) {
            this._indexes = this.getIndexInfo(name, tableExist.getString("TABLE_SCHEM"));
        }
        this.closeResultSet(tableExist);
        return found;
    }

    private List getConstraintColumns(SelectableBasedConstraint constraint) {
        ArrayList<String> columnList = new ArrayList<String>();
        int I = constraint.getSelectableCount();
        for (int i = 0; i < I; ++i) {
            Selectable sel = constraint.getSelectable(i);
            if (!(sel instanceof ColumnIdentifier) || !this.hasColumn((ColumnIdentifier)sel)) continue;
            columnList.add(sel.getName());
        }
        return columnList;
    }

    private String getCreateSQL() throws SQLException {
        StringBuffer stmtBuf = new StringBuffer(30);
        String rTable = this._remoteTableName;
        String dbName = this._conn.getMetaData().getDatabaseProductName();
        boolean isdb2 = dbName.lastIndexOf("DB2") != -1;
        stmtBuf.append("CREATE TABLE ").append(rTable);
        stmtBuf.append(" ( ");
        int I = this.getColumnCount();
        for (int i = 0; i < I; ++i) {
            Column col = this.getColumn(i);
            int jdbcType = col.getDataType().getJdbcType();
            Integer jdbcTypeObj = ValuePool.getInt(jdbcType);
            if (i != 0) {
                stmtBuf.append(", ");
            }
            stmtBuf.append(col.getName());
            String typeName = this._typeInfoMap.containsKey(jdbcTypeObj) ? this._typeInfoMap.get(jdbcTypeObj) : col.getSqlType();
            stmtBuf.append(" ").append(typeName);
            int scale = col.getScale();
            int precision = col.getSize();
            if (precision > 0 && this.isPrecisionRequired(jdbcType, isdb2)) {
                stmtBuf.append("(").append(precision);
                if (scale > 0 && Utils.isScaleRequired(jdbcType)) {
                    stmtBuf.append(",").append(scale).append(") ");
                } else {
                    stmtBuf.append(")");
                }
            }
            if (Utils.isBinary(jdbcType) && isdb2) {
                stmtBuf.append("  FOR BIT DATA ");
            }
            if (this._notNullColumns.contains(col.getName())) {
                stmtBuf.append(" NOT NULL");
            }
            if (this._pk != null) {
                stmtBuf.append(" PRIMARY KEY (");
                this.appendColumnNames(this.getConstraintColumns(this._pk), stmtBuf);
                stmtBuf.append(") ");
            }
            if (this._uniqueConstraints.isEmpty()) continue;
            for (UniqueConstraint unique : this._uniqueConstraints) {
                stmtBuf.append(" UNIQUE (");
                this.appendColumnNames(this.getConstraintColumns(unique), stmtBuf);
                stmtBuf.append(") ");
            }
        }
        stmtBuf.append(" )");
        return stmtBuf.toString();
    }

    private RowIterator getIndexedRows(RowSource source, Selectable node) throws AxionException {
        if (node instanceof ComparisonFunction) {
            ComparisonFunction function = (ComparisonFunction)node;
            String column = null;
            Literal literal = null;
            Selectable left = function.getArgument(0);
            Selectable right = function.getArgument(1);
            if (left instanceof ColumnIdentifier && right instanceof Literal) {
                column = ((ColumnIdentifier)left).getName();
                literal = (Literal)right;
                return this.getIndexedRows(function, column, literal.evaluate());
            }
            if (left instanceof Literal && right instanceof ColumnIdentifier) {
                column = ((ColumnIdentifier)right).getName();
                literal = (Literal)left;
                return this.getIndexedRows(function, column, literal.evaluate());
            }
            return null;
        }
        return null;
    }

    private RowIterator getIndexedRows(ComparisonFunction function, String columnName, Object value) throws AxionException {
        String psKey = columnName + "_" + function.toString();
        PreparedStatement ps = (PreparedStatement)this._indexSelectPSs.get(psKey);
        if (ps == null) {
            String where = "";
            String strPS = "";
            CaseSensitiveColumn col = (CaseSensitiveColumn)this.getColumn(columnName);
            where = col.getCaseSensitiveName() + " " + function.getOperatorString() + " ? ";
            if (this._where != null && this._where.trim().length() != 0) {
                where = this._where + " AND " + where;
            }
            strPS = this.getSelectSQL(where);
            try {
                ps = this._conn.prepareStatement(strPS, 1003, 1007);
            }
            catch (SQLException ex) {
                throw this.convertException("while creating PS for remote DB:", ex);
            }
            this._indexSelectPSs.put(psKey, ps);
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        ResultSet rs = null;
        try {
            ps.setObject(1, value);
            rs = ps.executeQuery();
            while (rs.next()) {
                rows.add(this.getRowFromRS(-9999999, rs));
            }
            this.closeResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new AxionException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
        return new IndexRowIterator(rows);
    }

    private List getIndexInfo(String name, String schemaPattern) throws SQLException {
        ResultSet rs = this._conn.getMetaData().getIndexInfo(this._conn.getCatalog(), schemaPattern, name, false, true);
        ArrayList<String> indexes = new ArrayList<String>();
        while (rs.next()) {
            String colName = rs.getString("COLUMN_NAME");
            if (colName == null) continue;
            indexes.add(colName);
        }
        this.closeResultSet(rs);
        return indexes;
    }

    private PrimaryKeyConstraint getPrimaryKey() {
        for (Constraint constraint : this._constraints.values()) {
            if (!(constraint instanceof PrimaryKeyConstraint)) continue;
            return (PrimaryKeyConstraint)constraint;
        }
        return null;
    }

    private String getQualifiedTable() {
        if (this._qualifiedTableName == null) {
            String rTable = this._remoteTableName;
            if (this._schemaName != null && this._schemaName.trim().length() != 0) {
                rTable = this._schemaName + "." + rTable;
            }
            if (this._catalogName != null && this._catalogName.trim().length() != 0) {
                rTable = this._catalogName + "." + rTable;
            }
            this._qualifiedTableName = rTable;
        }
        return this._qualifiedTableName;
    }

    private ResultSet getResultSet(String sql) throws AxionException {
        this.assertConnection();
        if (this._stmt == null) {
            throw new AxionException("Invalid state: <null> statement for external table " + this.getName());
        }
        try {
            return this._stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            throw this.convertException("Could not load remote table " + this.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row getRowByOffset(int rowId) throws AxionException {
        this.assertExternalResultSet();
        try {
            ResultSet resultSet = this._externalRs;
            synchronized (resultSet) {
                if (this._externalRs.absolute(rowId + 1)) {
                    return this.getRowFromRS(rowId, this._externalRs);
                }
                return null;
            }
        }
        catch (Exception e) {
            throw new AxionException(e);
        }
    }

    private boolean handleTimestampSpecially() {
        boolean ret = false;
        DatabaseLink server = this._db.getDatabaseLink(this._dblink);
        if (server.getJdbcUrl().toUpperCase().indexOf("ORACLE") != -1) {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                if (!(this.getColumn(i).getDataType() instanceof TimestampType)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private Row getRowFromRS(int rowId, ResultSet rs) throws SQLException, AxionException {
        SimpleRow aRow = new SimpleRow(rowId, this.getColumnCount());
        Object colValue = null;
        Object externalColValue = null;
        DataType dataType = null;
        if (this.handleTimestampSpecially()) {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                dataType = this.getColumn(i).getDataType();
                if (dataType instanceof TimestampType) {
                    colValue = externalColValue = rs.getTimestamp(i + 1);
                } else {
                    externalColValue = rs.getObject(i + 1);
                    colValue = this.getColumn(i).getDataType().convert(externalColValue);
                }
                aRow.set(i, colValue);
            }
        } else {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                externalColValue = rs.getObject(i + 1);
                colValue = this.getColumn(i).getDataType().convert(externalColValue);
                aRow.set(i, colValue);
            }
        }
        return aRow;
    }

    private int getTableSize() {
        int tableSize = 0;
        ResultSet rs = null;
        try {
            this.assertConnection();
            if (this._rowCountPS == null) {
                StringBuffer sb = new StringBuffer(60);
                sb.append("SELECT COUNT(*) FROM ");
                sb.append(this.getQualifiedTable());
                if (this._where != null && !"".equals(this._where.trim())) {
                    sb.append(" WHERE ");
                    sb.append(this._where);
                }
                this._rowCountPS = this._conn.prepareStatement(sb.toString());
            }
            if ((rs = this._rowCountPS.executeQuery()).next()) {
                tableSize = rs.getInt(1);
            }
            this.closeResultSet(rs);
        }
        catch (Exception ex) {
            try {
                throw ExceptionConverter.convertToRuntimeException(ex);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
        return tableSize;
    }

    private String getTruncateSQL() {
        if (this._trunncateSQL == null) {
            StringBuffer truncateSql = new StringBuffer(20);
            DatabaseLink server = this._db.getDatabaseLink(this._dblink);
            String url = server.getJdbcUrl().toUpperCase();
            if (url.indexOf("ORACLE") != -1 || url.indexOf("AXIONDB") != -1) {
                truncateSql.append("TRUNCATE TABLE ");
            } else {
                truncateSql.append("DELETE FROM ");
            }
            truncateSql.append(this.getQualifiedTable());
            this._trunncateSQL = truncateSql.toString();
        }
        return this._trunncateSQL;
    }

    private boolean isColumnIndexed(String column) throws AxionException {
        this.buildTableIndex();
        return this._indexes.contains(column);
    }

    private boolean isPrecisionRequired(int jdbcType, boolean isdb2) {
        if (isdb2 && jdbcType == 2004 || jdbcType == 2005) {
            return true;
        }
        return Utils.isPrecisionRequired(jdbcType);
    }

    private void populateColumns(StringBuffer stmtBuf, String rTable) {
        if (this._insertCols != null) {
            int I = this._insertCols.size();
            for (int i = 0; i < I; ++i) {
                if (i != 0) {
                    stmtBuf.append(", ");
                }
                ColumnIdentifier colid = (ColumnIdentifier)this._insertCols.get(i);
                CaseSensitiveColumn col = (CaseSensitiveColumn)this.getColumn(colid.getName());
                if (rTable == null) {
                    stmtBuf.append(col.getCaseSensitiveName());
                    continue;
                }
                stmtBuf.append(rTable).append(".").append(col.getCaseSensitiveName());
            }
        } else {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                CaseSensitiveColumn col = (CaseSensitiveColumn)this.getColumn(i);
                if (i != 0) {
                    stmtBuf.append(", ");
                }
                if (rTable == null) {
                    stmtBuf.append(col.getCaseSensitiveName());
                    continue;
                }
                stmtBuf.append(rTable).append(".").append(col.getCaseSensitiveName());
            }
        }
    }

    private void populateSet(StringBuffer stmtBuf) {
        if (this._updateCols != null) {
            int I = this._updateCols.size();
            for (int i = 0; i < I; ++i) {
                if (i != 0) {
                    stmtBuf.append(", ");
                }
                ColumnIdentifier colid = (ColumnIdentifier)this._updateCols.get(i);
                CaseSensitiveColumn csCol = (CaseSensitiveColumn)this.getColumn(colid.getName());
                stmtBuf.append(csCol.getCaseSensitiveName()).append("=").append("?");
            }
        } else {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                CaseSensitiveColumn col = (CaseSensitiveColumn)this.getColumn(i);
                if (i != 0) {
                    stmtBuf.append(", ");
                }
                stmtBuf.append(col.getCaseSensitiveName()).append("=").append("?");
            }
        }
    }

    private void populateValues(StringBuffer stmtBuf) {
        if (this._insertCols != null) {
            int I = this._insertCols.size();
            for (int i = 0; i < I; ++i) {
                if (i != 0) {
                    stmtBuf.append(", ");
                }
                stmtBuf.append("?");
            }
        } else {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                if (i != 0) {
                    stmtBuf.append(", ");
                }
                stmtBuf.append("?");
            }
        }
    }

    private void populateWhere(StringBuffer stmtBuf) {
        if (this._pk != null) {
            int I = this._pk.getSelectableCount();
            for (int i = 0; i < I; ++i) {
                String colName = this._pk.getSelectable(i).getName();
                if (i != 0) {
                    stmtBuf.append(" AND ");
                }
                stmtBuf.append(colName).append("=").append("?");
            }
        } else if (!this._uniqueConstraints.isEmpty()) {
            UniqueConstraint uc = (UniqueConstraint)this._uniqueConstraints.get(0);
            int I = uc.getSelectableCount();
            for (int i = 0; i < I; ++i) {
                String colName = uc.getSelectable(i).getName();
                if (i != 0) {
                    stmtBuf.append(" AND ");
                }
                stmtBuf.append(colName).append("=").append("?");
            }
        } else {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                CaseSensitiveColumn col = (CaseSensitiveColumn)this.getColumn(i);
                if (i != 0) {
                    stmtBuf.append(" AND ");
                }
                stmtBuf.append("( ( ");
                stmtBuf.append(col.getCaseSensitiveName());
                stmtBuf.append(" = ? ) OR ((");
                stmtBuf.append(1);
                stmtBuf.append(" = ?) AND (");
                stmtBuf.append(col.getCaseSensitiveName());
                stmtBuf.append(" IS NULL))) ");
            }
        }
    }

    private void publishEvent(TableModifiedEvent e) throws AxionException {
        int I = this._tableModificationListeners.size();
        for (int i = 0; i < I; ++i) {
            e.visit((TableModificationListener)this._tableModificationListeners.get(i));
        }
    }

    private void setName(String name) {
        this._name = name;
    }

    private void setObject(PreparedStatement pstmt, int i, int columnIndex, Object obj) throws SQLException {
        if (obj == null) {
            int jdbcType = this.getColumn(columnIndex).getDataType().getJdbcType();
            pstmt.setNull(i + 1, jdbcType);
        } else {
            pstmt.setObject(i + 1, obj);
        }
    }

    private void setValueParamsForInsert(PreparedStatement pstmt, Row row) throws SQLException, AxionException {
        if (this._insertCols != null) {
            int I = this._insertCols.size();
            for (int i = 0; i < I; ++i) {
                ColumnIdentifier colid = (ColumnIdentifier)this._insertCols.get(i);
                int columnIndex = this.getColumnIndex(colid.getName());
                this.setObject(pstmt, i, columnIndex, row.get(columnIndex));
            }
        } else {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                CaseSensitiveColumn col = (CaseSensitiveColumn)this.getColumn(i);
                int columnIndex = this.getColumnIndex(col.getName());
                this.setObject(pstmt, i, columnIndex, row.get(this.getColumnIndex(col.getName())));
            }
        }
    }

    private void setValueParamsForUpdate(PreparedStatement pstmt, Row row) throws SQLException, AxionException {
        if (this._updateCols != null) {
            int I = this._updateCols.size();
            for (int i = 0; i < I; ++i) {
                ColumnIdentifier colid = (ColumnIdentifier)this._updateCols.get(i);
                this.setObject(pstmt, i, this.getColumnIndex(colid.getName()), row.get(this.getColumnIndex(colid.getName())));
            }
        } else {
            int I = row.size();
            for (int i = 0; i < I; ++i) {
                this.setObject(pstmt, i, i, row.get(i));
            }
        }
    }

    private void setWhereParams(PreparedStatement pstmt, Row oldrow, int size) throws AxionException, SQLException {
        if (this._pk != null) {
            int I = this._pk.getSelectableCount();
            for (int i = 0; i < I; ++i) {
                Object obj = oldrow.get(this.getColumnIndex(this._pk.getSelectable(i).getName()));
                pstmt.setObject(size + i + 1, obj);
            }
        } else if (!this._uniqueConstraints.isEmpty()) {
            UniqueConstraint uc = (UniqueConstraint)this._uniqueConstraints.get(0);
            int I = uc.getSelectableCount();
            for (int i = 0; i < I; ++i) {
                Object obj = oldrow.get(this.getColumnIndex(uc.getSelectable(i).getName()));
                pstmt.setObject(size + i + 1, obj);
            }
        } else {
            int base = 0;
            int colCnt = this.getColumnCount();
            for (int i = 0; i < colCnt; ++i) {
                Object obj = oldrow.get(i);
                base = size + i * 2;
                if (obj == null) {
                    int jdbcType = this.getColumn(i).getDataType().getJdbcType();
                    pstmt.setNull(base + 1, jdbcType);
                    pstmt.setInt(base + 2, 1);
                    continue;
                }
                pstmt.setObject(base + 1, obj);
                pstmt.setInt(base + 2, 0);
            }
        }
    }

    private boolean tableExistsInRemoteDB() throws AxionException {
        this.assertConnection();
        try {
            String schemaPattern = this.getSchemaWildcardForRemoteDB();
            if (this._schemaName != null && this._schemaName.trim().length() != 0) {
                schemaPattern = this._schemaName;
            }
            if (this.doesRemoteTableExist(this._remoteTableName.toUpperCase(), schemaPattern)) {
                this._remoteTableName = this._remoteTableName.toUpperCase();
                return true;
            }
            if (this.doesRemoteTableExist(this._remoteTableName, schemaPattern)) {
                return true;
            }
            if (schemaPattern != null) {
                if (this.doesRemoteTableExist(this._remoteTableName.toUpperCase(), schemaPattern.toUpperCase())) {
                    this._remoteTableName = this._remoteTableName.toUpperCase();
                    return true;
                }
                return this.doesRemoteTableExist(this._remoteTableName, schemaPattern.toUpperCase());
            }
            return false;
        }
        catch (SQLException e) {
            throw this.convertException("Remote table/view " + this._remoteTableName + " not found", e);
        }
    }

    static {
        PROPERTY_KEYS.add("DBLINK");
        PROPERTY_KEYS.add("REMOTETABLE");
        PROPERTY_KEYS.add("ORDERBY");
        PROPERTY_KEYS.add("CATALOG");
        PROPERTY_KEYS.add("SCHEMA");
        PROPERTY_KEYS.add("WHERE");
        PROPERTY_KEYS.add("CREATE_IF_NOT_EXIST");
        REQUIRED_KEYS.add("DBLINK");
        _log = Logger.getLogger(ExternalDatabaseTable.class.getName());
        JDBC_TABLE_OBJECT_TYPE = new String[]{"TABLE", "VIEW"};
    }

    private class CaseSensitiveColumn
    extends Column {
        private static final String CASE_SENSITIVE_NAME_CONFIG_KEY = "caseSensitiveName";

        public CaseSensitiveColumn(Column column) {
            super(column.getName(), column.getDataType());
            this.getConfiguration().putAll(column.getConfiguration());
            this.getConfiguration().put(CASE_SENSITIVE_NAME_CONFIG_KEY, column.getName());
            this.getConfiguration().put("name", column.getName().toUpperCase());
        }

        public String getCaseSensitiveName() {
            return (String)this.getConfiguration().get(CASE_SENSITIVE_NAME_CONFIG_KEY);
        }
    }

    private class ExternalTableIndex
    extends BaseIndex {
        public ExternalTableIndex(Column column) {
            super(column.getName(), column, false);
        }

        public IndexLoader getIndexLoader() {
            throw new UnsupportedOperationException("getIndexLoader");
        }

        public RowIterator getInorderRowIterator(RowSource source) throws AxionException {
            return null;
        }

        public RowIterator getRowIterator(RowSource source, Function fn, Object value) throws AxionException {
            return ExternalDatabaseTable.this.getIndexedRows((ComparisonFunction)fn, this.getIndexedColumn().getName(), value);
        }

        public void save(File dataDirectory) throws AxionException {
            throw new UnsupportedOperationException("save");
        }

        public void saveAfterTruncate(File dataDirectory) throws AxionException {
            throw new UnsupportedOperationException("saveAfterTruncate");
        }

        public boolean supportsFunction(Function fn) {
            return fn instanceof ComparisonFunction;
        }

        public void truncate() throws AxionException {
        }

        public String getType() {
            return ExternalDatabaseTable.XTERNAL_DB;
        }

        public void changeRowId(Table table, Row row, int oldId, int newId) throws AxionException {
            throw new UnsupportedOperationException("changeRowId");
        }
    }

    private class IndexRowIterator
    extends ListIteratorRowIterator {
        public IndexRowIterator(List list) {
            super(list.listIterator());
        }

        public void add(Row row) throws AxionException {
            ExternalDatabaseTable.this.addRow(row);
        }

        public void remove() {
            try {
                ExternalDatabaseTable.this.deleteRow(this.current());
            }
            catch (AxionException e) {
                throw ExceptionConverter.convertToRuntimeException(e);
            }
        }

        public void set(Row row) {
            try {
                ExternalDatabaseTable.this.updateRow(this.current(), row);
            }
            catch (AxionException e) {
                throw ExceptionConverter.convertToRuntimeException(e);
            }
        }
    }

    private class ExternalDatabaseTableOrganizationContext
    extends BaseTableOrganizationContext {
        private ExternalDatabaseTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            Set baseKeys = this.getBasePropertyKeys();
            HashSet keys = new HashSet(baseKeys.size() + PROPERTY_KEYS.size());
            keys.addAll(baseKeys);
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public Set getRequiredPropertyKeys() {
            Set baseRequiredKeys = this.getBaseRequiredPropertyKeys();
            HashSet keys = new HashSet(baseRequiredKeys.size() + REQUIRED_KEYS.size());
            keys.addAll(baseRequiredKeys);
            keys.addAll(REQUIRED_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            super.assertValidPropertyKeys(props);
            ExternalDatabaseTable.this._dblink = props.getProperty("DBLINK");
            DatabaseLink server = ExternalDatabaseTable.this._db.getDatabaseLink(ExternalDatabaseTable.this._dblink);
            if (server == null) {
                throw new AxionException("Database link " + ExternalDatabaseTable.this._dblink + " does not exist.");
            }
            ExternalDatabaseTable.this._where = props.getProperty("WHERE");
            ExternalDatabaseTable.this._remoteTableName = props.getProperty("REMOTETABLE");
            ExternalDatabaseTable.this._catalogName = props.getProperty("CATALOG");
            if (ExternalDatabaseTable.this._catalogName == null) {
                ExternalDatabaseTable.this._catalogName = server.getCatalogName();
            }
            ExternalDatabaseTable.this._schemaName = props.getProperty("SCHEMA");
            if (ExternalDatabaseTable.this._schemaName == null) {
                ExternalDatabaseTable.this._schemaName = server.getSchemaName();
            }
            if (ExternalDatabaseTable.this._where != null && ExternalDatabaseTable.this._where.trim().length() != 0) {
                ExternalDatabaseTable.this._isUpdatable = false;
            }
            if (ExternalDatabaseTable.this._dblink == null || ExternalDatabaseTable.this._dblink.trim().length() == 0 || !ExternalDatabaseTable.this._db.hasDatabaseLink(ExternalDatabaseTable.this._dblink)) {
                throw new AxionException("Please provide a valid server name");
            }
            ExternalDatabaseTable.this._remoteTableName = ExternalDatabaseTable.this._remoteTableName != null ? ExternalDatabaseTable.this._remoteTableName : ExternalDatabaseTable.this.getName();
            if (props.getProperty("CREATE_IF_NOT_EXIST") != null && "TRUE".equalsIgnoreCase(props.getProperty("CREATE_IF_NOT_EXIST"))) {
                ExternalDatabaseTable.this._isCreateIfNotExist = true;
            }
            ExternalDatabaseTable.this.setUp(server);
            _log.log(Level.FINE, "External DB Table " + ExternalDatabaseTable.this._remoteTableName + " created (Updatable=" + ExternalDatabaseTable.this._isUpdatable + ")");
        }

        public void updateProperties() {
            super.updateProperties();
            this.setProperty("DBLINK", ExternalDatabaseTable.this._dblink);
            this.setProperty("WHERE", ExternalDatabaseTable.this._where);
            this.setProperty("REMOTETABLE", ExternalDatabaseTable.this._remoteTableName);
            this.setProperty("CATALOG", ExternalDatabaseTable.this._catalogName);
            this.setProperty("SCHEMA", ExternalDatabaseTable.this._schemaName);
            this.setProperty("LOADTYPE", "REMOTE");
        }
    }
}

