/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseFlatfileTable;
import org.axiondb.engine.tables.FixedWidthFlatfileTableLoader;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.io.BufferedDataOutputStream;

public final class FixedWidthFlatfileTable
extends BaseFlatfileTable {
    public static final String PROP_HEADERBYTESOFFSET = "HEADERBYTESOFFSET";
    private static final Set PROPERTY_KEYS = new HashSet(2);
    private int _headerBytesOffset = 0;
    private char[] _lineCharArray;
    private int _recordLength;

    public FixedWidthFlatfileTable(String name, Database db) throws AxionException {
        super(name, db, new FixedWidthFlatfileTableLoader());
        this.setType("FIXED WIDTH TEXT TABLE");
    }

    public void addColumn(Column col, boolean metaUpdateNeeded) throws AxionException {
        super.addColumn(col, metaUpdateNeeded);
        this.updateRecordLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row getRowByOffset(int idToAssign, long ptr) throws AxionException {
        BufferedDataInputStream data = this.getInputStream();
        int colCount = this.getColumnCount();
        Row row = new SimpleRow(idToAssign, colCount);
        try {
            BufferedDataInputStream bufferedDataInputStream = data;
            synchronized (bufferedDataInputStream) {
                int colLength = 0;
                int linePtr = 0;
                char[] charArray = this.readLine(data, ptr);
                for (int i = 0; i < colCount; ++i) {
                    colLength = this.getColumnSize(i);
                    String columnValue = new String(charArray, linePtr, colLength);
                    if (this._trimWhiteSpace && (columnValue = columnValue.trim()).length() == 0) {
                        columnValue = null;
                    }
                    row = this.trySettingColumn(row, i, columnValue);
                    linePtr += colLength;
                }
            }
            return row;
        }
        catch (Exception e) {
            if (e instanceof AxionException) {
                throw (AxionException)e;
            }
            throw new AxionException(e);
        }
    }

    protected int nextLineLength(long fileOffset) throws AxionException {
        try {
            int nextChar;
            int recLength = 0;
            BufferedDataInputStream data = this.getInputStream();
            data.seek(fileOffset);
            do {
                nextChar = data.read();
                ++recLength;
                if (!this.isEOF(nextChar)) continue;
                if (recLength > 1) {
                    return recLength;
                }
                return -1;
            } while (!this.isEndOfRecord(recLength, nextChar, data));
            recLength = recLength == 1 ? recLength : this._recordLength;
            return recLength;
        }
        catch (Exception e) {
            throw new AxionException("Unable to parse data file: ", e);
        }
    }

    protected long ignoreRowsToSkip() throws AxionException {
        long offset = super.ignoreRowsToSkip();
        if (offset > 0L) {
            return offset;
        }
        if (this._headerBytesOffset > 0) {
            return this._headerBytesOffset;
        }
        return 0L;
    }

    protected void initializeTable() throws AxionException {
        this._lineCharArray = new char[this._recordLength];
        super.initializeTable();
    }

    protected boolean isEndOfRecord(int recLength, int nextChar, BufferedDataInputStream data) throws IOException {
        if (this.isEOF(nextChar)) {
            return true;
        }
        if (recLength >= this._recordLength) {
            if (!"".equals(this._lineSep) && this._lineSep.charAt(0) != nextChar) {
                throw new IOException("Corrupted data, record delimeter not found at specified record length.");
            }
            return true;
        }
        if (!"".equals(this._lineSep) && this._lineSep.charAt(0) == nextChar) {
            char[] charBuf = this._lineSep.toCharArray();
            long lastDataFileOffset = data.getPos();
            int I = this._lineSep.length();
            for (int i = 1; i < I; ++i) {
                if (charBuf[i] == (char)data.read()) continue;
                data.seek(lastDataFileOffset);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean loadExternalTable(Properties props) throws AxionException {
        this.context = new FixedwidthTableOrganizationContext();
        return super.loadExternalTable(props);
    }

    public Properties getTableProperties() {
        return this.context.getTableProperties();
    }

    protected void parseTableProperties(ObjectInputStream in) throws AxionException {
        try {
            this._lineSep = in.readUTF();
            this._isFirstLineHeader = Boolean.valueOf(in.readUTF());
            in.readUTF();
            this._headerBytesOffset = in.readInt();
            this._recordLength = in.readInt();
            this._fileName = in.readUTF();
            this.context = new FixedwidthTableOrganizationContext();
            this.context.updateProperties();
            this.context.readOrSetDefaultProperties(this.context.getTableProperties());
            this.createOrLoadDataFile();
            this._lineCharArray = new char[this._recordLength];
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse meta file for table " + this.getName(), e);
        }
    }

    protected synchronized void renameTableFiles(String oldName, String name) {
        super.renameTableFiles(oldName, name);
        this.updateRecordLength();
    }

    private void updateRecordLength() {
        if (this.context != null) {
            this._recordLength = 0;
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                this._recordLength += this.getColumnSize(i);
            }
            this._lineCharArray = new char[this._recordLength];
        }
    }

    protected void writeHeader(BufferedDataOutputStream dataFile) throws AxionException {
        if (this._isFirstLineHeader) {
            try {
                int I = this.getColumnCount();
                for (int i = 0; i < I; ++i) {
                    dataFile.write(this.writeColumn(i, this.getColumn(i).getName()));
                }
                dataFile.write(this._lineSep.getBytes());
            }
            catch (IOException ioex) {
                throw new AxionException("Unable to write header for table: " + this.getName(), ioex);
            }
        }
    }

    protected void writeRow(BufferedDataOutputStream out, Row row) throws AxionException {
        Object colValue = null;
        DataType type = null;
        try {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                colValue = row.get(i);
                type = this.getColumn(i).getDataType();
                out.write(this.writeColumn(i, type.toString(colValue)));
            }
            out.write(this._lineSep.getBytes());
        }
        catch (IOException e) {
            throw new AxionException("Error writing row: " + row, e);
        }
    }

    protected void writeTableProperties(ObjectOutputStream out) throws AxionException {
        try {
            if (this._lineSep != null && this._fileName != null) {
                out.writeUTF(this._lineSep);
                out.writeUTF(Boolean.toString(this._isFirstLineHeader));
                out.writeUTF(this._lineSep);
                out.writeInt(this._headerBytesOffset);
                out.writeInt(this._recordLength);
                out.writeUTF(this._fileName);
            }
        }
        catch (IOException e) {
            throw new AxionException("Unable to write meta file for table " + this.getName(), e);
        }
    }

    private int getColumnSize(int index) {
        return this.getColumn(index).getDataType().getColumnDisplaySize();
    }

    private char[] readLine(BufferedDataInputStream data, long fileOffset) throws AxionException {
        Arrays.fill(this._lineCharArray, ' ');
        int recLength = 0;
        try {
            data.seek(fileOffset);
            while (true) {
                int nextChar;
                if (this.isEndOfRecord(recLength, nextChar = data.read(), data)) {
                    if (recLength == 0) {
                        throw new AxionException("Empty line detected - invalid.");
                    }
                    if (this._lineSep.length() != 0 || this.isEOF(nextChar)) break;
                    data.seek(data.getPos() - 1L);
                    break;
                }
                this._lineCharArray[recLength++] = (char)nextChar;
            }
            return this._lineCharArray;
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to parse data file: ", ioex);
        }
    }

    private byte[] writeColumn(int colIndex, String value) {
        if (value == null) {
            value = " ";
        }
        byte[] byteData = new byte[this.getColumnSize(colIndex)];
        Arrays.fill(byteData, (byte)32);
        byte[] colValue = value.getBytes();
        int len = colValue.length <= byteData.length ? colValue.length : byteData.length;
        System.arraycopy(colValue, 0, byteData, 0, len);
        return byteData;
    }

    static {
        PROPERTY_KEYS.add(PROP_HEADERBYTESOFFSET);
    }

    private class FixedwidthTableOrganizationContext
    extends BaseFlatfileTable.BaseFlatfileTableOrganizationContext {
        private FixedwidthTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            Set baseKeys = super.getPropertyKeys();
            HashSet keys = new HashSet(baseKeys.size() + PROPERTY_KEYS.size());
            keys.addAll(baseKeys);
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            super.readOrSetDefaultProperties(props);
            int I = FixedWidthFlatfileTable.this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                FixedWidthFlatfileTable.this._recordLength += FixedWidthFlatfileTable.this.getColumnSize(i);
            }
            FixedWidthFlatfileTable.this._recordLength += FixedWidthFlatfileTable.this._lineSep.length();
            try {
                FixedWidthFlatfileTable.this._headerBytesOffset = Integer.parseInt(props.getProperty(FixedWidthFlatfileTable.PROP_HEADERBYTESOFFSET));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            FixedWidthFlatfileTable.this._isFirstLineHeader = Boolean.valueOf(props.getProperty("ISFIRSTLINEHEADER".toUpperCase(), "false"));
        }

        public void updateProperties() {
            super.updateProperties();
            this._props.setProperty("LOADTYPE", "FIXEDWIDTH");
            this._props.setProperty(FixedWidthFlatfileTable.PROP_HEADERBYTESOFFSET, Integer.toString(FixedWidthFlatfileTable.this._headerBytesOffset));
        }
    }
}

