/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SyncFailedException;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.Row;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseDiskTable;
import org.axiondb.engine.tables.DiskTable;
import org.axiondb.io.AxionFileSystem;
import org.axiondb.io.BufferedDataOutputStream;
import org.axiondb.types.FileLobLocator;
import org.axiondb.types.FileOffsetLobLocator;
import org.axiondb.types.FileOffsetLobLocatorFactory;
import org.axiondb.types.LOBType;
import org.axiondb.types.LobLocator;

public final class GlomLobsHelper {
    private static final FileOffsetLobLocatorFactory FILE_OFFSET_LOB_LOCATOR_FACTORY = new FileOffsetLobLocatorFactory();
    private DiskTable _table = null;

    public GlomLobsHelper(DiskTable table) {
        this._table = table;
    }

    public void glomLobs() throws Exception {
        BufferedDataOutputStream gdata = BaseDiskTable.FS.createBufferedDOS(new File(this.getTable().getRootDir(), this.getTable().getName() + ".DATA.GLOM"));
        File gpidxfile = this.getTable().getTableFile(".PIDX.GLOM");
        BufferedDataOutputStream[] glom = this.createGlommedLobFiles();
        AxionFileSystem.PidxList gpidx = BaseDiskTable.FS.newPidxList(gpidxfile, false);
        int I = this.getTable().getPidxList().size();
        for (int i = 0; i < I; ++i) {
            long oldoffset = this.getTable().getPidxList().get(i);
            if (oldoffset == Long.MAX_VALUE) {
                gpidx.add(Long.MAX_VALUE);
                continue;
            }
            SimpleRow grow = this.glomRow(glom, i, oldoffset);
            gpidx.add(gdata.getPos());
            this.writeGlommedRow(gdata, glom, grow);
        }
        this.closeFiles(glom);
        gdata.close();
        gpidx.close();
    }

    private void closeFiles(BufferedDataOutputStream[] glom) throws IOException {
        for (int i = 0; i < glom.length; ++i) {
            if (glom[i] == null) continue;
            glom[i].close();
        }
    }

    private BufferedDataOutputStream[] createGlommedLobFiles() throws AxionException {
        BufferedDataOutputStream[] glom = new BufferedDataOutputStream[this.getTable().getColumnCount()];
        for (int i = 0; i < glom.length; ++i) {
            Column col = this.getTable().getColumn(i);
            glom[i] = col.getDataType() instanceof LOBType ? BaseDiskTable.FS.createBufferedDOS(new File(this.getTable().getLobDir(), col.getName() + ".GLOM")) : null;
        }
        return glom;
    }

    private void glomLobColumn(BufferedDataOutputStream[] glom, Row row, SimpleRow grow, int k) throws AxionException, IOException, FileNotFoundException, SyncFailedException {
        if (null != glom[k]) {
            Column col = this.getTable().getColumn(k);
            FileLobLocator loc = (FileLobLocator)col.getDataType().convert(row.get(k));
            if (loc != null) {
                File oldfile = loc.getFile(((LOBType)col.getDataType()).getLobDir());
                long offset = glom[k].getPos();
                int length = 0;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(oldfile));
                int b = ((InputStream)in).read();
                while (b != -1) {
                    glom[k].write(b);
                    ++length;
                    b = ((InputStream)in).read();
                }
                ((InputStream)in).close();
                FileOffsetLobLocator gloc = new FileOffsetLobLocator(offset, length);
                grow.set(k, gloc);
            } else {
                grow.set(k, null);
            }
        }
    }

    private SimpleRow glomRow(BufferedDataOutputStream[] glom, int i, long oldoffset) throws AxionException, IOException, FileNotFoundException, SyncFailedException {
        Row row = this.getTable().getRowByOffset(i, oldoffset);
        SimpleRow grow = new SimpleRow(row);
        for (int k = 0; k < glom.length; ++k) {
            this.glomLobColumn(glom, row, grow, k);
        }
        return grow;
    }

    private void writeGlommedRow(BufferedDataOutputStream gdata, BufferedDataOutputStream[] glom, SimpleRow grow) throws IOException {
        int J = this.getTable().getColumnCount();
        for (int j = 0; j < J; ++j) {
            if (glom[j] != null) {
                gdata.writeBoolean(true);
                FILE_OFFSET_LOB_LOCATOR_FACTORY.write((LobLocator)grow.get(j), gdata);
                continue;
            }
            this.getTable().getColumn(j).getDataType().write(grow.get(j), gdata);
        }
    }

    private DiskTable getTable() {
        return this._table;
    }
}

