/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.ExternalTable;
import org.axiondb.Index;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowIterator;
import org.axiondb.TableFactory;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseTable;
import org.axiondb.engine.tables.BaseTableOrganizationContext;
import org.axiondb.engine.tables.SpreadsheetTableLoader;
import org.axiondb.event.RowInsertedEvent;
import org.axiondb.event.RowUpdatedEvent;
import org.axiondb.io.AxionFileSystem;
import org.axiondb.io.FileUtil;
import org.axiondb.types.CharacterType;
import org.axiondb.types.StringType;

public class SpreadsheetTable
extends BaseTable
implements ExternalTable {
    protected File _dataFile = null;
    protected File _dbdir = null;
    protected boolean _readOnly = false;
    private int _rowCount = -1;
    private int _currentRow = -1;
    private File _dir;
    protected String _fileName;
    protected String _sheetName;
    private Properties prop = new Properties();
    public static final String PROP_FILENAME = "FILENAME";
    public static final String PROP_SHEET = "SHEET";
    protected static final String META_FILE_EXT = ".META";
    protected static final String TYPE_FILE_EXT = ".TYPE";
    private SpreadsheetTableOrganizationContext context;
    private Sheet sheet;
    private Workbook workbook;
    private WritableWorkbook writeableWorkbook;
    protected static AxionFileSystem FS = new AxionFileSystem();
    protected static final int CURRENT_META_VERSION = 3;
    private static final Set PROPERTY_KEYS = new HashSet(3);

    public SpreadsheetTable(String name, Database db) throws AxionException {
        super(name);
        this.setType("SPREADSHEET TABLE");
        this._dbdir = db.getDBDirectory();
        this._readOnly = db.isReadOnly();
        this.createOrLoadTableFiles(name, db, new SpreadsheetTableLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyDeletes(IntCollection rowids) throws AxionException {
        SpreadsheetTable spreadsheetTable = this;
        synchronized (spreadsheetTable) {
            try {
                WritableWorkbook writeableWorkbook = this.getWriteableWorkbook();
                IntIterator iter = rowids.iterator();
                while (iter.hasNext()) {
                    int rowid = iter.next();
                    writeableWorkbook.getSheet(this._sheetName).removeRow(rowid - 1);
                    --this._rowCount;
                }
                writeableWorkbook.write();
                writeableWorkbook.close();
                this.refreshSheet();
            }
            catch (Exception ex) {
                throw new AxionException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyInserts(RowCollection rows) throws AxionException {
        SpreadsheetTable spreadsheetTable = this;
        synchronized (spreadsheetTable) {
            try {
                int colCount = this.sheet.getColumns();
                this.writeableWorkbook = this.getWriteableWorkbook();
                RowIterator iter = rows.rowIterator();
                while (iter.hasNext()) {
                    Row row = iter.next();
                    RowInsertedEvent event = new RowInsertedEvent(this, null, row);
                    WritableSheet writeableSheet = this.writeableWorkbook.getSheet(this._sheetName);
                    writeableSheet.insertRow(this._rowCount);
                    for (int i = 0; i < colCount; ++i) {
                        String colValue = String.valueOf(row.get(i));
                        Label label = new Label(i, this._rowCount, colValue);
                        writeableSheet.addCell((WritableCell)label);
                    }
                    ++this._rowCount;
                }
                this.writeableWorkbook.write();
                this.writeableWorkbook.close();
                this.refreshSheet();
            }
            catch (Exception ex) {
                throw new AxionException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyUpdates(RowCollection rows) throws AxionException {
        SpreadsheetTable spreadsheetTable = this;
        synchronized (spreadsheetTable) {
            try {
                int colCount = this.sheet.getColumns();
                this.writeableWorkbook = this.getWriteableWorkbook();
                RowIterator iter = rows.rowIterator();
                while (iter.hasNext()) {
                    Row newrow = iter.next();
                    Row oldrow = this.getRow(newrow.getIdentifier());
                    if (oldrow != null) {
                        RowUpdatedEvent event = new RowUpdatedEvent(this, oldrow, newrow);
                    }
                    WritableSheet writeableSheet = this.writeableWorkbook.getSheet(this._sheetName);
                    for (int i = 0; i < colCount; ++i) {
                        Label label = new Label(i, newrow.getIdentifier() - 1, String.valueOf(newrow.get(i)));
                        WritableCell cell = writeableSheet.getWritableCell(i, newrow.getIdentifier() - 1);
                        cell.setCellFormat(cell.getCellFormat());
                        if (cell.getType() == CellType.LABEL) {
                            Label l = (Label)cell;
                            l.setString(String.valueOf(newrow.get(i)));
                            continue;
                        }
                        if (cell.getType() != CellType.NUMBER) continue;
                        Number number = (Number)cell;
                        number.setValue(Double.valueOf(String.valueOf(newrow.get(i))).doubleValue());
                    }
                }
                this.writeableWorkbook.write();
                this.writeableWorkbook.close();
                this.refreshSheet();
            }
            catch (Exception ex) {
                throw new AxionException(ex);
            }
        }
    }

    public void freeRowId(int id) {
    }

    public int getNextRowId() {
        return this._currentRow + 1;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public void populateIndex(Index index) throws AxionException {
    }

    public Row getRow(int id) throws AxionException {
        Row row;
        try {
            int colCount = this.sheet.getColumns();
            row = new SimpleRow(id, colCount);
            for (int i = 0; i < colCount; ++i) {
                String columnValue = this.sheet.getCell(i, id - 1).getContents();
                row = this.trySettingColumn(id, row, i, columnValue);
            }
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
        this._currentRow = id;
        return row;
    }

    protected RowIterator getRowIterator() throws AxionException {
        return new BaseRowIterator(){
            Row _current = null;
            int _currentId = 0;
            int _currentIndex = 0;
            int _nextId = 1;
            int _nextIndex = 1;

            public Row current() {
                if (!this.hasCurrent()) {
                    throw new NoSuchElementException("No current row.");
                }
                return this._current;
            }

            public final int currentIndex() {
                return this._currentIndex;
            }

            public final boolean hasCurrent() {
                return null != this._current;
            }

            public final boolean hasNext() {
                return this.nextIndex() <= SpreadsheetTable.this.getRowCount();
            }

            public final boolean hasPrevious() {
                return this.nextIndex() > 1;
            }

            public Row last() throws AxionException {
                if (this.isEmpty()) {
                    throw new IllegalStateException("No rows in table.");
                }
                this._nextIndex = SpreadsheetTable.this.getRowCount();
                this._nextId = this._nextIndex++;
                this.previous();
                ++this._nextId;
                return this.current();
            }

            public Row next() throws AxionException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next row");
                }
                do {
                    ++this._nextId;
                    this._currentId = this._currentId;
                    this._current = SpreadsheetTable.this.getRowByOffset(this._currentId);
                } while (null == this._current);
                this._currentIndex = this._nextIndex++;
                return this._current;
            }

            public final int nextIndex() {
                return this._nextIndex;
            }

            public Row previous() throws AxionException {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous row");
                }
                do {
                    this._currentId = --this._nextId;
                    this._current = SpreadsheetTable.this.getRowByOffset(this._currentId);
                } while (null == this._current);
                --this._nextIndex;
                this._currentIndex = this._nextIndex;
                return this._current;
            }

            public final int previousIndex() {
                return this._nextIndex - 1;
            }

            public void remove() throws AxionException {
                if (0 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                SpreadsheetTable.this.deleteRow(this._current);
                --this._nextIndex;
                this._currentIndex = 0;
            }

            public void reset() {
                this._current = null;
                this._nextIndex = 1;
                this._currentId = 0;
                this._currentIndex = 0;
                this._nextId = 1;
            }

            public final void set(Row row) throws AxionException {
                if (0 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                SpreadsheetTable.this.updateRow(this._current, row);
            }

            public final int size() throws AxionException {
                return SpreadsheetTable.this.getRowCount();
            }

            public String toString() {
                return "SpreadsheetTable(" + SpreadsheetTable.this.getName() + ")";
            }

            private Row setCurrentRow() throws AxionException {
                Row row = SpreadsheetTable.this.getRowByOffset(this._currentId);
                if (row != null) {
                    this._current = row;
                    return this._current;
                }
                throw new IllegalStateException("No valid row at position " + this._currentIndex);
            }
        };
    }

    public void truncate() throws AxionException {
        try {
            Workbook workbook = Workbook.getWorkbook((File)this.getDataFile());
            int index = -1;
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                if (!workbook.getSheet(i).getName().equals(this._sheetName)) continue;
                index = i;
                break;
            }
            workbook.close();
            WritableWorkbook writeableWorkbook = this.getWriteableWorkbook();
            writeableWorkbook.removeSheet(index);
            writeableWorkbook.createSheet(this._sheetName, index);
            writeableWorkbook.write();
            writeableWorkbook.close();
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    public boolean loadExternalTable(Properties prop) throws AxionException {
        try {
            if (this.context == null) {
                this.context = new SpreadsheetTableOrganizationContext();
            }
            this.context.readOrSetDefaultProperties(prop);
            this.context.updateProperties();
            this.initializeTable();
            this.writeMetaFile();
            return true;
        }
        catch (Exception e) {
            try {
                this.drop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AxionException("Failed to create table using supplied properties. ", e);
        }
    }

    public void drop() throws AxionException {
        super.drop();
        if (!FileUtil.delete(this.getRootDir())) {
            throw new AxionException("Unable to delete \"" + this.getRootDir() + "\" during drop table " + this.getName());
        }
    }

    public Properties getTableProperties() {
        this.prop.clear();
        this.prop.put("LOADTYPE", "SPREADSHEET");
        this.prop.put(PROP_FILENAME, this._dataFile.getAbsolutePath());
        this.prop.put(PROP_SHEET, this._sheetName);
        return this.prop;
    }

    public void remount() throws AxionException {
        try {
            Workbook workbook = Workbook.getWorkbook((File)this.getDataFile(), (WorkbookSettings)this.getWorkbookSettings());
            this.sheet = workbook.getSheet(this._sheetName);
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    protected boolean isNullString(String str) {
        return str == null || str.trim().length() == 0;
    }

    private String getDefaultDataFileExtension() {
        return "xls";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrLoadTableFiles(String name, Database db, TableFactory factory) throws AxionException {
        Class<SpreadsheetTable> clazz = SpreadsheetTable.class;
        synchronized (SpreadsheetTable.class) {
            this._dir = new File(db.getDBDirectory(), name.toUpperCase());
            if (!this._dir.exists() && !this._dir.mkdirs()) {
                throw new AxionException("Unable to create directory \"" + this._dir + "\" for Table \"" + name + "\".");
            }
            File typefile = this.getTableFile(TYPE_FILE_EXT);
            if (!typefile.exists()) {
                this.writeNameToFile(typefile, factory);
            }
            this.loadOrMigrateMetaFile(db);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected void loadOrMigrateMetaFile(Database db) throws AxionException {
        this.migrate(db);
    }

    public void migrate(Database db) throws AxionException {
        File metaFile = this.getTableFile(META_FILE_EXT);
        if (!metaFile.exists()) {
            return;
        }
        int version = 3;
        ObjectInputStream in = null;
        try {
            in = FS.openObjectInputSteam(metaFile);
            version = in.readInt();
            if (version < 0 || version > 3) {
                throw new AxionException("Unrecognized version " + version);
            }
            if (version == 0) {
                this.parseV0MetaFile(in);
            } else {
                this.parseV1MetaFile(in, db);
            }
            this.parseTableProperties(in);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Unable to parse meta file " + metaFile + " for table " + this.getName(), e);
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse meta file " + metaFile + " for table " + this.getName(), e);
        }
        finally {
            FS.closeInputStream(in);
        }
        if (version < 3) {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                Column col = this.getColumn(i);
                col.getConfiguration().put("name", col.getName().toUpperCase());
            }
        }
        if (version != 3) {
            this.writeMetaFile();
        }
    }

    private void parseV0MetaFile(ObjectInputStream in) throws IOException, AxionException {
        int I = in.readInt();
        for (int i = 0; i < I; ++i) {
            String name = in.readUTF();
            String dtypename = in.readUTF();
            DataType type = null;
            try {
                Class<?> clazz = Class.forName(dtypename);
                type = (DataType)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AxionException("Can't load table " + this.getName() + ", data type " + dtypename + " not found.", e);
            }
            this.addColumn(new Column(name, type), false);
        }
    }

    protected void parseTableProperties(ObjectInputStream in) throws AxionException {
        try {
            this._fileName = in.readUTF();
            this._sheetName = in.readUTF();
            this.context = new SpreadsheetTableOrganizationContext();
            this.context.updateProperties();
            this.context.readOrSetDefaultProperties(this.context.getTableProperties());
            if (!this.getDataFile().exists()) {
                throw new AxionException("Source file does not exist.");
            }
            this.initializeTable();
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to parse meta file for table " + this.getName(), ioex);
        }
    }

    public void addColumn(Column col, boolean metaUpdateNeeded) throws AxionException {
        super.addColumn(col);
        if (metaUpdateNeeded) {
            this.writeMetaFile();
        }
    }

    private void parseV1MetaFile(ObjectInputStream in, Database db) throws AxionException, IOException, ClassNotFoundException {
        this.readColumns(in);
        this.readConstraints(in, db);
    }

    private void writeMetaFile() throws AxionException {
        ObjectOutputStream out = null;
        File metaFile = this.getTableFile(META_FILE_EXT);
        try {
            out = FS.createObjectOutputSteam(metaFile);
            out.writeInt(3);
            this.writeColumns(out);
            out.flush();
            this.writeConstraints(out);
            out.flush();
            this.writeTableProperties(out);
            out.flush();
        }
        catch (IOException e) {
            throw new AxionException("Unable to write meta file " + metaFile + " for table " + this.getName(), e);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    protected void writeTableProperties(ObjectOutputStream out) throws AxionException {
        try {
            if (this._fileName != null) {
                out.writeUTF(this._fileName);
                out.writeUTF(this._sheetName);
                out.flush();
            }
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to write meta file for table " + this.getName(), ioex);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    protected void writeNameToFile(File file, Object obj) throws AxionException {
        ObjectOutputStream out = null;
        try {
            out = FS.createObjectOutputSteam(file);
            out.writeUTF(obj.getClass().getName());
            out.flush();
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row getRowByOffset(int idToAssign) throws AxionException {
        Row row;
        SpreadsheetTable spreadsheetTable = this;
        synchronized (spreadsheetTable) {
            try {
                int colCount = this.sheet.getColumns();
                row = new SimpleRow(idToAssign, colCount);
                for (int i = 1; i <= colCount; ++i) {
                    String columnValue = this.sheet.getCell(i - 1, idToAssign - 1).getContents();
                    row = this.trySettingColumn(idToAssign, row, i - 1, columnValue);
                }
            }
            catch (Exception e) {
                if (e instanceof AxionException) {
                    throw (AxionException)e;
                }
                throw new AxionException(e);
            }
        }
        return row;
    }

    private Row trySettingColumn(int idToAssign, Row row, int i, String colValue) throws AxionException {
        DataType columnDataType = this.getColumn(i).getDataType();
        if ((colValue = this.evaluateForNull(colValue, columnDataType)) == null) {
            row.set(i, null);
        } else {
            Object val = columnDataType.convert(colValue);
            row.set(i, val);
        }
        return row;
    }

    private String evaluateForNull(String colValue, DataType datatype) {
        if (null == colValue) {
            return null;
        }
        if (datatype instanceof CharacterType) {
            int colWidth = datatype.getPrecision();
            return colWidth <= 0 || colValue.length() == colWidth && colValue.trim().length() == 0 ? null : colValue;
        }
        if (!(datatype instanceof StringType) && colValue.trim().length() == 0) {
            return null;
        }
        return colValue;
    }

    private WritableWorkbook getWriteableWorkbook() throws IOException, BiffException {
        if (this.workbook == null) {
            this.refreshSheet();
        }
        this.writeableWorkbook = Workbook.createWorkbook((File)this.getDataFile(), (Workbook)this.workbook, (WorkbookSettings)this.getWorkbookSettings());
        return this.writeableWorkbook;
    }

    protected void initializeTable() throws AxionException {
        try {
            this.workbook = Workbook.getWorkbook((File)this.getDataFile(), (WorkbookSettings)this.getWorkbookSettings());
            this.sheet = this.workbook.getSheet(this._sheetName);
            this._rowCount = this.sheet.getRows();
            this._currentRow = 0;
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    private void refreshSheet() throws IOException, BiffException {
        if (this.workbook != null) {
            this.workbook.close();
        }
        this.workbook = Workbook.getWorkbook((File)this.getDataFile(), (WorkbookSettings)this.getWorkbookSettings());
        this.sheet = this.workbook.getSheet(this._sheetName);
    }

    protected File getTableFile(String extension) {
        return new File(this.getRootDir(), this.getName().toUpperCase() + extension);
    }

    protected File getRootDir() {
        return this._dir;
    }

    private File getDataFile() {
        return this._dataFile;
    }

    private WorkbookSettings getWorkbookSettings() {
        WorkbookSettings settings = new WorkbookSettings();
        settings.setDrawingsDisabled(true);
        settings.setAutoFilterDisabled(true);
        settings.setSuppressWarnings(true);
        settings.setNamesDisabled(true);
        settings.setIgnoreBlanks(true);
        settings.setCellValidationDisabled(true);
        settings.setFormulaAdjust(false);
        settings.setPropertySets(false);
        return settings;
    }

    static {
        PROPERTY_KEYS.add(PROP_FILENAME);
        PROPERTY_KEYS.add(PROP_SHEET);
        PROPERTY_KEYS.add("LOADTYPE");
    }

    private class SpreadsheetTableOrganizationContext
    extends BaseTableOrganizationContext {
        private SpreadsheetTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            HashSet keys = new HashSet(PROPERTY_KEYS.size());
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            this.assertValidPropertyKeys(props);
            SpreadsheetTable.this._fileName = props.getProperty(SpreadsheetTable.PROP_FILENAME);
            SpreadsheetTable.this._dataFile = new File(SpreadsheetTable.this._fileName);
            if (SpreadsheetTable.this.isNullString(SpreadsheetTable.this._fileName)) {
                SpreadsheetTable.this._fileName = SpreadsheetTable.this.getName() + "." + SpreadsheetTable.this.getDefaultDataFileExtension();
            }
            SpreadsheetTable.this._sheetName = props.getProperty(SpreadsheetTable.PROP_SHEET);
        }

        public void updateProperties() {
            super.updateProperties();
            this._props.setProperty("LOADTYPE", "SPREADSHEET");
            this._props.setProperty(SpreadsheetTable.PROP_FILENAME, SpreadsheetTable.this._fileName);
            this._props.setProperty(SpreadsheetTable.PROP_SHEET, SpreadsheetTable.this._sheetName);
        }

        public Set getRequiredPropertyKeys() {
            HashSet keys = new HashSet(PROPERTY_KEYS.size());
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }
    }
}

