/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseFlatfileTable;
import org.axiondb.engine.tables.TaggedEBCDICTableLoader;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.io.BufferedDataOutputStream;
import org.axiondb.util.AsciiEbcdicEncoder;

public class TaggedEBCDICTable
extends BaseFlatfileTable {
    public static final String PROP_HEADERBYTESOFFSET = "HEADERBYTESOFFSET";
    public static final String PROP_RECORDLENGTH = "RECORDLENGTH";
    public static final String PROP_TAGLENGTH = "TAGLENGTH";
    public static final String PROP_MINTAGCOUNT = "MINTAGCOUNT";
    public static final String PROP_MAXTAGCOUNT = "MAXTAGCOUNT";
    public static final String PROP_RECORDTRAILERBYTECOUNT = "RECORDTRAILERBYTECOUNT";
    public static final String PROP_TAGBYTECOUNT = "TAGBYTECOUNT";
    public static final String PROP_ENCODING = "EN";
    private static final char EBCDIC_FILLER = '@';
    private static final char CR = '\r';
    private static final char NL = '\n';
    private static final Set PROPERTY_KEYS = new HashSet(8);
    private static final Set REQUIRED_KEYS = new HashSet(8);
    private int _tagID;
    private int _tagLength;
    private int _maxTagCount;
    private int _minTagCount;
    private int _tagByteCount;
    private int _recordTrailerByteCount;
    private int _recordLength;
    private String _encoding;
    protected long _pos;
    protected int _index;
    protected int _count;
    private byte[] _tagBuf = null;
    private int _headerBytesOffset;

    public TaggedEBCDICTable(String name, Database db) throws AxionException {
        super(name, db, new TaggedEBCDICTableLoader());
        this.setType("TAGGED EBCDIC TABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row getRowByOffset(int idToAssign, long ptr) throws AxionException {
        try {
            BufferedDataInputStream data = this.getInputStream();
            int colCount = this.getColumnCount();
            SimpleRow row = new SimpleRow(idToAssign, colCount);
            this._tagID = this._minTagCount;
            BufferedDataInputStream bufferedDataInputStream = data;
            synchronized (bufferedDataInputStream) {
                data.seek(ptr);
                while (this._tagID < this._maxTagCount) {
                    byte[] byteData = null;
                    byteData = this.readTaggedRowColumn(data);
                    if (byteData == null) break;
                    if (byteData == null) continue;
                    String columnValue = new String(byteData);
                    if (columnValue.length() == 0) {
                        columnValue = null;
                    }
                    this.trySettingColumn(row, this._tagID - 1, columnValue);
                    if (row != null) continue;
                    break;
                }
                this._headerBytesOffset += this._recordTrailerByteCount;
            }
            return row;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AxionException(e);
        }
    }

    private byte[] readTaggedRowColumn(BufferedDataInputStream rFile) throws IOException {
        this._tagBuf = new byte[this._tagLength];
        int bytesRead = rFile.read(this._tagBuf);
        byte[] byteData = null;
        if (bytesRead == -1) {
            return null;
        }
        this._tagID = this._tagBuf[0] << 8 | this._tagBuf[1];
        int colLength = this._tagBuf[this._tagByteCount] << 8 | this._tagBuf[this._tagByteCount + 1];
        this._headerBytesOffset += this._tagLength;
        if (this._tagID <= this._maxTagCount && this._tagID >= this._minTagCount && colLength >= 0) {
            byteData = new byte[colLength];
            bytesRead = rFile.read(byteData);
            if (bytesRead == -1) {
                return null;
            }
            if (this._encoding != null && byteData != null) {
                AsciiEbcdicEncoder.convertEbcdicToAscii(byteData);
            }
            this._headerBytesOffset += colLength;
        }
        return byteData;
    }

    protected long ignoreRowsToSkip() throws AxionException {
        long offset = super.ignoreRowsToSkip();
        if (offset > 0L) {
            return offset;
        }
        if (this._headerBytesOffset > 0) {
            return this._headerBytesOffset;
        }
        return 0L;
    }

    protected void initializeTable() throws AxionException {
        super.initializeTable();
        this._tagBuf = new byte[this._tagLength];
    }

    public long getCurrentParsePosition() {
        return this._headerBytesOffset;
    }

    private int getColumnSize(int index) {
        return this.getColumn(index).getDataType().getColumnDisplaySize();
    }

    public boolean loadExternalTable(Properties props) throws AxionException {
        this.context = new TaggedEBCDICTableContext();
        return super.loadExternalTable(props);
    }

    public Properties getTableProperties() {
        return this.context.getTableProperties();
    }

    protected void parseTableProperties(ObjectInputStream in) throws AxionException {
        try {
            this._tagLength = in.readInt();
            this._minTagCount = in.readInt();
            this._maxTagCount = in.readInt();
            this._recordTrailerByteCount = in.readInt();
            this._recordLength = in.readInt();
            this._tagByteCount = in.readInt();
            this._encoding = in.readUTF();
            this._headerBytesOffset = in.readInt();
            this._fileName = in.readUTF();
            this.context = new TaggedEBCDICTableContext();
            this.context.updateProperties();
            this.context.readOrSetDefaultProperties(this.context.getTableProperties());
            this.createOrLoadDataFile();
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse meta file for table " + this.getName(), e);
        }
    }

    protected synchronized void renameTableFiles(String oldName, String name) {
        super.renameTableFiles(oldName, name);
        this._recordLength = 0;
        int I = this.getColumnCount();
        for (int i = 0; i < I; ++i) {
            this._recordLength += this.getColumnSize(i);
        }
        this.context.setProperty(PROP_RECORDLENGTH, Integer.toString(this._recordLength));
    }

    protected void writeTableProperties(ObjectOutputStream out) throws AxionException {
        try {
            out.writeInt(this._tagLength);
            out.writeInt(this._minTagCount);
            out.writeInt(this._maxTagCount);
            out.writeInt(this._recordTrailerByteCount);
            out.writeInt(this._recordLength);
            out.writeInt(this._tagByteCount);
            if (this._fileName != null && this._encoding != null) {
                out.writeUTF(this._encoding);
                out.writeInt(this._headerBytesOffset);
                out.writeUTF(this._fileName);
            }
        }
        catch (IOException e) {
            throw new AxionException("Unable to write meta file for table " + this.getName(), e);
        }
    }

    protected void writeHeader(BufferedDataOutputStream dataFile) throws AxionException {
    }

    protected void writeRow(BufferedDataOutputStream out, Row row) throws AxionException {
        byte[] trailerBytes = new byte[this._recordTrailerByteCount];
        Arrays.fill(trailerBytes, (byte)64);
        try {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                Object data = row.get(i);
                DataType dataType = this.getColumn(i).getDataType();
                byte[] dataBytes = null;
                if (data instanceof byte[]) {
                    if (this._encoding != null && data != null) {
                        AsciiEbcdicEncoder.convertEbcdicToAscii((byte[])data);
                    }
                } else if (this._encoding != null && data != null) {
                    dataBytes = dataType.toString(data).getBytes();
                    AsciiEbcdicEncoder.convertEbcdicToAscii(dataBytes);
                } else {
                    dataBytes = dataType.toString(data).getBytes();
                }
                row.set(i, data);
                out.write(this.writeColumn(i, new String(dataBytes)));
            }
            out.write(trailerBytes);
        }
        catch (Exception e) {
            throw new AxionException(e.getMessage());
        }
    }

    private byte[] writeColumn(int colIndex, String value) {
        if (value == null) {
            value = " ";
        }
        byte[] byteData = new byte[this.getColumnSize(colIndex)];
        Arrays.fill(byteData, (byte)64);
        byte[] colValue = value.getBytes();
        int len = colValue.length <= byteData.length ? colValue.length : byteData.length;
        System.arraycopy(colValue, 0, byteData, 0, len);
        return byteData;
    }

    protected boolean isEndOfRecord(int recLength, int nextChar, BufferedDataInputStream data) {
        return recLength >= this._recordLength || this.isNewLine(nextChar) || this.isCarriageReturn(nextChar) || this.isEOF(nextChar);
    }

    protected boolean isCarriageReturn(int nextChar) {
        return nextChar == 13;
    }

    protected boolean isNewLine(int nextChar) {
        return nextChar == 10;
    }

    static {
        PROPERTY_KEYS.add(PROP_HEADERBYTESOFFSET);
        PROPERTY_KEYS.add(PROP_RECORDLENGTH);
        PROPERTY_KEYS.add(PROP_TAGLENGTH);
        PROPERTY_KEYS.add(PROP_MINTAGCOUNT);
        PROPERTY_KEYS.add(PROP_MAXTAGCOUNT);
        PROPERTY_KEYS.add(PROP_RECORDTRAILERBYTECOUNT);
        PROPERTY_KEYS.add(PROP_TAGBYTECOUNT);
        PROPERTY_KEYS.add(PROP_ENCODING);
    }

    private class TaggedEBCDICTableContext
    extends BaseFlatfileTable.BaseFlatfileTableOrganizationContext {
        private TaggedEBCDICTableContext() {
        }

        public Set getPropertyKeys() {
            Set baseKeys = super.getPropertyKeys();
            HashSet keys = new HashSet(baseKeys.size() + PROPERTY_KEYS.size());
            keys.addAll(baseKeys);
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public Set getRequiredPropertyKeys() {
            Set baseRequiredKeys = super.getRequiredPropertyKeys();
            HashSet keys = new HashSet(baseRequiredKeys.size() + REQUIRED_KEYS.size());
            keys.addAll(baseRequiredKeys);
            keys.addAll(REQUIRED_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            String headerBytesOffset;
            super.readOrSetDefaultProperties(props);
            try {
                String recLen = props.getProperty(TaggedEBCDICTable.PROP_RECORDLENGTH);
                if (TaggedEBCDICTable.this.isNullString(recLen)) {
                    TaggedEBCDICTable.this._recordLength = 0;
                } else {
                    TaggedEBCDICTable.this._recordLength = Integer.parseInt(recLen);
                }
            }
            catch (NumberFormatException e) {
                TaggedEBCDICTable.this._recordLength = 0;
            }
            if (TaggedEBCDICTable.this._recordLength == 0) {
                int I = TaggedEBCDICTable.this.getColumnCount();
                for (int i = 0; i < I; ++i) {
                    TaggedEBCDICTable.this._recordLength += TaggedEBCDICTable.this.getColumnSize(i);
                }
            }
            if (TaggedEBCDICTable.this.isNullString(headerBytesOffset = props.getProperty(TaggedEBCDICTable.PROP_HEADERBYTESOFFSET))) {
                TaggedEBCDICTable.this._headerBytesOffset = 0;
            } else {
                TaggedEBCDICTable.this._headerBytesOffset = Integer.parseInt(headerBytesOffset);
            }
            String tagLen = props.getProperty(TaggedEBCDICTable.PROP_TAGLENGTH);
            if (TaggedEBCDICTable.this.isNullString(tagLen)) {
                TaggedEBCDICTable.this._tagLength = 0;
            } else {
                TaggedEBCDICTable.this._tagLength = Integer.parseInt(tagLen);
            }
            String recordTrailerByteCount = props.getProperty(TaggedEBCDICTable.PROP_RECORDTRAILERBYTECOUNT);
            if (TaggedEBCDICTable.this.isNullString(recordTrailerByteCount)) {
                TaggedEBCDICTable.this._recordTrailerByteCount = 0;
            } else {
                TaggedEBCDICTable.this._recordTrailerByteCount = Integer.parseInt(recordTrailerByteCount);
            }
            String minTagCount = props.getProperty(TaggedEBCDICTable.PROP_MINTAGCOUNT);
            if (TaggedEBCDICTable.this.isNullString(minTagCount)) {
                TaggedEBCDICTable.this._minTagCount = 0;
            } else {
                TaggedEBCDICTable.this._minTagCount = Integer.parseInt(minTagCount);
            }
            String maxTagCount = props.getProperty(TaggedEBCDICTable.PROP_MAXTAGCOUNT);
            if (TaggedEBCDICTable.this.isNullString(minTagCount)) {
                TaggedEBCDICTable.this._maxTagCount = 0;
            } else {
                TaggedEBCDICTable.this._maxTagCount = Integer.parseInt(maxTagCount);
            }
            String tagByteCount = props.getProperty(TaggedEBCDICTable.PROP_TAGBYTECOUNT);
            if (TaggedEBCDICTable.this.isNullString(tagByteCount)) {
                TaggedEBCDICTable.this._tagByteCount = 0;
            } else {
                TaggedEBCDICTable.this._tagByteCount = Integer.parseInt(tagByteCount);
            }
            TaggedEBCDICTable.this._encoding = props.getProperty(TaggedEBCDICTable.PROP_ENCODING);
        }

        public void updateProperties() {
            super.updateProperties();
            this._props.setProperty("LOADTYPE", "TAGGEDEBCDIC");
            this._props.setProperty(TaggedEBCDICTable.PROP_HEADERBYTESOFFSET, Integer.toString(TaggedEBCDICTable.this._headerBytesOffset));
            this._props.setProperty(TaggedEBCDICTable.PROP_RECORDLENGTH, Integer.toString(TaggedEBCDICTable.this._recordLength));
            this._props.setProperty(TaggedEBCDICTable.PROP_TAGLENGTH, Integer.toString(TaggedEBCDICTable.this._tagLength));
            this._props.setProperty(TaggedEBCDICTable.PROP_MINTAGCOUNT, Integer.toString(TaggedEBCDICTable.this._minTagCount));
            this._props.setProperty(TaggedEBCDICTable.PROP_MAXTAGCOUNT, Integer.toString(TaggedEBCDICTable.this._maxTagCount));
            this._props.setProperty(TaggedEBCDICTable.PROP_RECORDTRAILERBYTECOUNT, Integer.toString(TaggedEBCDICTable.this._recordTrailerByteCount));
            this._props.setProperty(TaggedEBCDICTable.PROP_TAGBYTECOUNT, Integer.toString(TaggedEBCDICTable.this._tagByteCount));
            this._props.setProperty(TaggedEBCDICTable.PROP_ENCODING, TaggedEBCDICTable.this._encoding);
        }
    }
}

