/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.ExternalTable;
import org.axiondb.Index;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowIterator;
import org.axiondb.TableFactory;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseTable;
import org.axiondb.engine.tables.BaseTableOrganizationContext;
import org.axiondb.engine.tables.XMLTableLoader;
import org.axiondb.event.RowInsertedEvent;
import org.axiondb.event.RowUpdatedEvent;
import org.axiondb.io.AxionFileSystem;
import org.axiondb.io.FileUtil;
import org.axiondb.types.CharacterType;
import org.axiondb.types.StringType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTable
extends BaseTable
implements ExternalTable {
    protected File _dataFile = null;
    protected URI _uri = null;
    protected File _dbdir = null;
    protected boolean _readOnly = false;
    private File _dir;
    protected String _fileName;
    private String _rowName;
    private int _rowCount = -1;
    private int _currentRow = -1;
    private Properties prop = new Properties();
    public static final String PROP_FILENAME = "FILENAME";
    public static final String PROP_ROWNAME = "ROWNAME";
    public static final String PROP_READONLY = "TYPE";
    protected static final String META_FILE_EXT = ".META";
    protected static final String TYPE_FILE_EXT = ".TYPE";
    private String _readOnlyStatus;
    private XMLTableOrganizationContext context;
    private TransformerFactory tFactory;
    private Transformer transformer;
    private XMLStreamReader xmlStreamReader;
    private XMLInputFactory xmlInputFactory;
    private DocumentBuilderFactory factory;
    private Document document;
    private DocumentBuilder builder;
    private Element root;
    protected static AxionFileSystem FS = new AxionFileSystem();
    protected static final int CURRENT_META_VERSION = 3;
    private static final Set PROPERTY_KEYS = new HashSet(4);

    public XMLTable(String name, Database db) throws AxionException {
        super(name);
        this.setType("XML TABLE");
        this._dbdir = db.getDBDirectory();
        this._readOnly = db.isReadOnly();
        this.createOrLoadTableFiles(name, db, new XMLTableLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyDeletes(IntCollection rowids) throws AxionException {
        if (this._readOnlyStatus.equalsIgnoreCase("READONLY")) {
            throw new AxionException("Operation not supported");
        }
        XMLTable xMLTable = this;
        synchronized (xMLTable) {
            try {
                IntIterator iter = rowids.iterator();
                while (iter.hasNext()) {
                    int rowid = iter.next();
                    this.root.removeChild(this.getRowNodeForId(rowid, this.root));
                    --this._rowCount;
                }
                this.document.getDocumentElement().normalize();
                this.writeDomToFile();
            }
            catch (Exception ex) {
                throw new AxionException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyInserts(RowCollection rows) throws AxionException {
        if (this._readOnlyStatus.equalsIgnoreCase("READONLY")) {
            throw new AxionException("Operation not supported");
        }
        XMLTable xMLTable = this;
        synchronized (xMLTable) {
            try {
                int colCount = this.getColumnCount();
                RowIterator iter = rows.rowIterator();
                while (iter.hasNext()) {
                    Row row = iter.next();
                    Element rowElem = this.document.createElement(this._rowName);
                    this.root.appendChild(rowElem);
                    RowInsertedEvent event = new RowInsertedEvent(this, null, row);
                    for (int i = 0; i < colCount; ++i) {
                        Element columnElem = this.document.createElement(this.getColumn(i).getName());
                        rowElem.appendChild(columnElem);
                        columnElem.appendChild(this.document.createTextNode(String.valueOf(row.get(i))));
                    }
                    ++this._rowCount;
                }
                this.document.getDocumentElement().normalize();
                this.writeDomToFile();
            }
            catch (Exception ex) {
                throw new AxionException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyUpdates(RowCollection rows) throws AxionException {
        if (this._readOnlyStatus.equalsIgnoreCase("READONLY")) {
            throw new AxionException("Operation not supported");
        }
        XMLTable xMLTable = this;
        synchronized (xMLTable) {
            try {
                int colCount = this.getColumnCount();
                RowIterator iter = rows.rowIterator();
                while (iter.hasNext()) {
                    Row newrow = iter.next();
                    Row oldrow = this.getRow(newrow.getIdentifier());
                    if (oldrow != null) {
                        RowUpdatedEvent event = new RowUpdatedEvent(this, oldrow, newrow);
                    }
                    Element rowElem = (Element)this.getRowNodeForId(newrow.getIdentifier(), this.root);
                    block6: for (int i = 0; i < colCount; ++i) {
                        Node colNode = rowElem.getElementsByTagName(this.getColumn(i).getName()).item(0);
                        NodeList colChildren = colNode.getChildNodes();
                        for (int j = 0; j < colChildren.getLength(); ++j) {
                            Node node = colChildren.item(j);
                            if (node.getNodeType() != 3) continue;
                            node.setNodeValue(String.valueOf(newrow.get(i)));
                            continue block6;
                        }
                    }
                }
                this.document.getDocumentElement().normalize();
                this.writeDomToFile();
            }
            catch (Exception ex) {
                throw new AxionException(ex);
            }
        }
    }

    @Override
    public void freeRowId(int id) {
    }

    @Override
    public void drop() throws AxionException {
        super.drop();
        try {
            if (this.xmlStreamReader != null) {
                this.xmlStreamReader.close();
            }
        }
        catch (XMLStreamException ex) {
            throw new AxionException(ex);
        }
        if (!FileUtil.delete(this.getRootDir())) {
            throw new AxionException("Unable to delete \"" + this.getRootDir() + "\" during drop table " + this.getName());
        }
    }

    @Override
    public int getNextRowId() {
        return this._currentRow + 1;
    }

    @Override
    public int getRowCount() {
        return this._rowCount;
    }

    @Override
    public void populateIndex(Index index) throws AxionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row getRowByOffset(int idToAssign) throws AxionException {
        Row row;
        XMLTable xMLTable = this;
        synchronized (xMLTable) {
            try {
                int colCount = this.getColumnCount();
                row = new SimpleRow(idToAssign, colCount);
                LinkedList<String> columns = this.getColumnValues(idToAssign);
                for (int i = 1; i <= colCount; ++i) {
                    String columnValue = columns.get(i - 1);
                    row = this.trySettingColumn(idToAssign, row, i - 1, columnValue);
                }
            }
            catch (Exception e) {
                if (e instanceof AxionException) {
                    throw (AxionException)e;
                }
                throw new AxionException(e);
            }
        }
        this._currentRow = idToAssign;
        return row;
    }

    @Override
    public Row getRow(int id) throws AxionException {
        Row row;
        try {
            int colCount = this.getColumnCount();
            row = new SimpleRow(id, colCount);
            LinkedList<String> columns = this.getColumnValues(id);
            for (int i = 1; i <= colCount; ++i) {
                String columnValue = columns.get(i - 1);
                row = this.trySettingColumn(id, row, i - 1, columnValue);
            }
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
        this._currentRow = id;
        return row;
    }

    @Override
    protected RowIterator getRowIterator() throws AxionException {
        return new BaseRowIterator(){
            Row _current = null;
            int _currentId = 0;
            int _currentIndex = 0;
            int _nextId = 1;
            int _nextIndex = 1;

            public Row current() {
                if (!this.hasCurrent()) {
                    throw new NoSuchElementException("No current row.");
                }
                return this._current;
            }

            public final int currentIndex() {
                return this._currentIndex;
            }

            public final boolean hasCurrent() {
                return null != this._current;
            }

            public final boolean hasNext() {
                return this.nextIndex() <= XMLTable.this.getRowCount();
            }

            public final boolean hasPrevious() {
                return this.nextIndex() > 1;
            }

            public Row last() throws AxionException {
                if (this.isEmpty()) {
                    throw new IllegalStateException("No rows in table.");
                }
                this._nextIndex = XMLTable.this.getRowCount();
                this._nextId = this._nextIndex++;
                this.previous();
                ++this._nextId;
                return this.current();
            }

            public Row next() throws AxionException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next row");
                }
                do {
                    ++this._nextId;
                    this._currentId = this._currentId;
                    this._current = XMLTable.this.getRowByOffset(this._currentId);
                } while (null == this._current);
                this._currentIndex = this._nextIndex++;
                return this._current;
            }

            public final int nextIndex() {
                return this._nextIndex;
            }

            public Row previous() throws AxionException {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous row");
                }
                do {
                    this._currentId = --this._nextId;
                    this._current = XMLTable.this.getRowByOffset(this._currentId);
                } while (null == this._current);
                --this._nextIndex;
                this._currentIndex = this._nextIndex;
                return this._current;
            }

            public final int previousIndex() {
                return this._nextIndex - 1;
            }

            public void remove() throws AxionException {
                if (0 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                XMLTable.this.deleteRow(this._current);
                --this._nextIndex;
                this._currentIndex = 0;
            }

            public void reset() {
                this._current = null;
                this._nextIndex = 1;
                this._currentId = 0;
                this._currentIndex = 0;
                this._nextId = 1;
            }

            public final void set(Row row) throws AxionException {
                if (0 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                XMLTable.this.updateRow(this._current, row);
            }

            public final int size() throws AxionException {
                return XMLTable.this.getRowCount();
            }

            public String toString() {
                return "XMLTable(" + XMLTable.this.getName() + ")";
            }

            private Row setCurrentRow() throws AxionException {
                Row row = XMLTable.this.getRowByOffset(this._currentId);
                if (row != null) {
                    this._current = row;
                    return this._current;
                }
                throw new IllegalStateException("No valid row at position " + this._currentIndex);
            }
        };
    }

    @Override
    public void truncate() throws AxionException {
        this.getDataFile().delete();
        try {
            this.getDataFile().createNewFile();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(new FileOutputStream(this.getDataFile()));
            writer.writeStartDocument("1.0");
            writer.writeStartElement(this.getName());
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    @Override
    public boolean loadExternalTable(Properties prop) throws AxionException {
        try {
            if (this.context == null) {
                this.context = new XMLTableOrganizationContext();
            }
            this.context.readOrSetDefaultProperties(prop);
            this.context.updateProperties();
            this.initializeTable();
            this.writeMetaFile();
            return true;
        }
        catch (Exception e) {
            try {
                this.drop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AxionException("Failed to create table using supplied properties. ", e);
        }
    }

    @Override
    public Properties getTableProperties() {
        this.prop.clear();
        this.prop.put("LOADTYPE", "XML");
        if (this._dataFile.exists()) {
            this.prop.put(PROP_FILENAME, this._dataFile.getAbsolutePath());
        } else {
            this.prop.put(PROP_FILENAME, this._uri.getPath());
        }
        this.prop.put(PROP_ROWNAME, this._rowName);
        this.prop.put(PROP_READONLY, this._readOnlyStatus);
        return this.prop;
    }

    @Override
    public void remount() throws AxionException {
    }

    protected boolean isNullString(String str) {
        return str == null || str.trim().length() == 0;
    }

    private String getDefaultDataFileExtension() {
        return "xml";
    }

    private Row trySettingColumn(int idToAssign, Row row, int i, String colValue) throws AxionException {
        DataType columnDataType = this.getColumn(i).getDataType();
        if ((colValue = this.evaluateForNull(colValue, columnDataType)) == null) {
            row.set(i, null);
        } else {
            Object val = columnDataType.convert(colValue);
            row.set(i, val);
        }
        return row;
    }

    private String evaluateForNull(String colValue, DataType datatype) {
        if (null == colValue) {
            return null;
        }
        if (datatype instanceof CharacterType) {
            int colWidth = datatype.getPrecision();
            return colWidth <= 0 || colValue.length() == colWidth && colValue.trim().length() == 0 ? null : colValue;
        }
        if (!(datatype instanceof StringType) && colValue.trim().length() == 0) {
            return null;
        }
        return colValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrLoadTableFiles(String name, Database db, TableFactory factory) throws AxionException {
        Class<XMLTable> clazz = XMLTable.class;
        synchronized (XMLTable.class) {
            this._dir = new File(db.getDBDirectory(), name.toUpperCase());
            if (!this._dir.exists() && !this._dir.mkdirs()) {
                throw new AxionException("Unable to create directory \"" + this._dir + "\" for Table \"" + name + "\".");
            }
            File typefile = this.getTableFile(TYPE_FILE_EXT);
            if (!typefile.exists()) {
                this.writeNameToFile(typefile, factory);
            }
            this.loadOrMigrateMetaFile(db);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected void loadOrMigrateMetaFile(Database db) throws AxionException {
        this.migrate(db);
    }

    public void migrate(Database db) throws AxionException {
        File metaFile = this.getTableFile(META_FILE_EXT);
        if (!metaFile.exists()) {
            return;
        }
        int version = 3;
        ObjectInputStream in = null;
        try {
            in = FS.openObjectInputSteam(metaFile);
            version = in.readInt();
            if (version < 0 || version > 3) {
                throw new AxionException("Unrecognized version " + version);
            }
            if (version == 0) {
                this.parseV0MetaFile(in);
            } else {
                this.parseV1MetaFile(in, db);
            }
            this.parseTableProperties(in);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Unable to parse meta file " + metaFile + " for table " + this.getName(), e);
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse meta file " + metaFile + " for table " + this.getName(), e);
        }
        finally {
            FS.closeInputStream(in);
        }
        if (version < 3) {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                Column col = this.getColumn(i);
                col.getConfiguration().put("name", col.getName().toUpperCase());
            }
        }
        if (version != 3) {
            this.writeMetaFile();
        }
    }

    private void parseV0MetaFile(ObjectInputStream in) throws IOException, AxionException {
        int I = in.readInt();
        for (int i = 0; i < I; ++i) {
            String name = in.readUTF();
            String dtypename = in.readUTF();
            DataType type = null;
            try {
                Class<?> clazz = Class.forName(dtypename);
                type = (DataType)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AxionException("Can't load table " + this.getName() + ", data type " + dtypename + " not found.", e);
            }
            this.addColumn(new Column(name, type), false);
        }
    }

    protected void parseTableProperties(ObjectInputStream in) throws AxionException {
        try {
            this._fileName = in.readUTF();
            this._rowName = in.readUTF();
            this._readOnlyStatus = in.readUTF();
            this.context = new XMLTableOrganizationContext();
            this.context.updateProperties();
            this.context.readOrSetDefaultProperties(this.context.getTableProperties());
            if (!this.getDataFile().getPath().startsWith("file:") && !this.getDataFile().exists()) {
                throw new AxionException("Source file does not exist.");
            }
            this.initializeTable();
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to parse meta file for table " + this.getName(), ioex);
        }
    }

    public void addColumn(Column col, boolean metaUpdateNeeded) throws AxionException {
        super.addColumn(col);
        if (metaUpdateNeeded) {
            this.writeMetaFile();
        }
    }

    private void parseV1MetaFile(ObjectInputStream in, Database db) throws AxionException, IOException, ClassNotFoundException {
        this.readColumns(in);
        this.readConstraints(in, db);
    }

    private void writeMetaFile() throws AxionException {
        ObjectOutputStream out = null;
        File metaFile = this.getTableFile(META_FILE_EXT);
        try {
            out = FS.createObjectOutputSteam(metaFile);
            out.writeInt(3);
            this.writeColumns(out);
            out.flush();
            this.writeConstraints(out);
            out.flush();
            this.writeTableProperties(out);
            out.flush();
        }
        catch (IOException e) {
            throw new AxionException("Unable to write meta file " + metaFile + " for table " + this.getName(), e);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    protected void writeTableProperties(ObjectOutputStream out) throws AxionException {
        try {
            if (this._fileName != null) {
                out.writeUTF(this._fileName);
                out.writeUTF(this._rowName);
                out.writeUTF(this._readOnlyStatus);
            }
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to write meta file for table " + this.getName(), ioex);
        }
    }

    protected void writeNameToFile(File file, Object obj) throws AxionException {
        ObjectOutputStream out = null;
        try {
            out = FS.createObjectOutputSteam(file);
            out.writeUTF(obj.getClass().getName());
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    protected File getTableFile(String extension) {
        return new File(this.getRootDir(), this.getName().toUpperCase() + extension);
    }

    protected File getRootDir() {
        return this._dir;
    }

    private File getDataFile() {
        return this._dataFile;
    }

    private URI getURI() throws URISyntaxException {
        return this._uri;
    }

    protected void initializeTable() throws AxionException {
        try {
            this.parseXMLFile();
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    private void parseXMLFile() throws XMLStreamException, FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        if (this._readOnlyStatus.equalsIgnoreCase("READONLY")) {
            this.parseUsingStax();
            this._rowCount = 0;
            this._currentRow = 0;
            int event = -1;
            while (this.xmlStreamReader.hasNext()) {
                event = this.xmlStreamReader.next();
                if (event != 1 || !this.xmlStreamReader.getLocalName().equals(this._rowName)) continue;
                ++this._rowCount;
            }
            this.parseUsingStax();
        } else {
            this.parseUsingDOM();
            this._rowCount = 0;
            this._currentRow = 0;
            if (this.root != null) {
                NodeList rows = this.root.getElementsByTagName(this._rowName);
                for (int i = 0; i < rows.getLength(); ++i) {
                    Node rowNode = rows.item(i);
                    if (rowNode.getNodeType() != 1) continue;
                    ++this._rowCount;
                }
            }
        }
    }

    private void writeDomToFile() throws TransformerConfigurationException, TransformerException, ParserConfigurationException, SAXException, IOException, XMLStreamException {
        if (this.tFactory == null) {
            this.tFactory = TransformerFactory.newInstance();
            this.transformer = this.tFactory.newTransformer();
        }
        this.transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(this.document);
        try {
            StreamResult result = null;
            result = this.getDataFile().exists() ? new StreamResult(this.getDataFile()) : new StreamResult(new File(this.getURI()));
            this.transformer.transform(source, result);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private Node getRowNodeForId(int idToAssign, Element root) throws AxionException {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            String xpathExpString = "//" + this._rowName + "[" + String.valueOf(idToAssign) + "]";
            XPathExpression xPathExpression = xPath.compile(xpathExpString);
            return (Node)xPathExpression.evaluate(root, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new AxionException(ex);
        }
    }

    private LinkedList<String> getColumnValues(int rowId) throws AxionException {
        LinkedList<String> columns = new LinkedList();
        if (this._readOnlyStatus.equalsIgnoreCase("READWRITE")) {
            Element row = (Element)this.getRowNodeForId(rowId, this.root);
            block0: for (int i = 0; i < this.getColumnCount(); ++i) {
                Element column = (Element)row.getElementsByTagName(this.getColumn(i).getName()).item(0);
                if (column != null) {
                    NodeList colElems = column.getChildNodes();
                    for (int j = 0; j < colElems.getLength(); ++j) {
                        Node nd = colElems.item(j);
                        if (nd.getNodeType() != 3) continue;
                        columns.add(nd.getTextContent());
                        continue block0;
                    }
                    continue;
                }
                columns.add("");
            }
        } else {
            columns = this.readUsingStax(rowId);
        }
        return columns;
    }

    private void parseUsingDOM() throws ParserConfigurationException, SAXException, IOException {
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.builder = this.factory.newDocumentBuilder();
            this.document = this.getDataFile().exists() ? this.builder.parse(this.getDataFile()) : this.builder.parse(this.getURI().toURL().openStream());
            this.root = this.document.getDocumentElement();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void parseUsingStax() throws FileNotFoundException, XMLStreamException {
        if (this.xmlStreamReader != null) {
            this.xmlStreamReader.close();
        }
        FileInputStream fileInputStream = new FileInputStream(this.getDataFile());
        if (this.xmlInputFactory == null) {
            this.xmlInputFactory = XMLInputFactory.newInstance();
            this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
            this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            this.xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
            this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        }
        this.xmlStreamReader = this.xmlInputFactory.createFilteredReader(this.xmlInputFactory.createXMLStreamReader(fileInputStream), new XMLElementFilter());
    }

    private LinkedList<String> readUsingStax(int rowId) throws AxionException {
        LinkedList<String> columns = new LinkedList<String>();
        int rowCount = this._currentRow;
        int event = -1;
        try {
            if (this._currentRow > rowId) {
                rowCount = 0;
                this.parseUsingStax();
            }
            while (this.xmlStreamReader.hasNext()) {
                event = this.xmlStreamReader.next();
                if (event == 1 && this.xmlStreamReader.getLocalName().equals(this._rowName)) {
                    ++rowCount;
                }
                if (rowCount != rowId) continue;
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                event = this.xmlStreamReader.next();
                while (event != 1 || !this.xmlStreamReader.getLocalName().equals(this.getColumn(i).getName())) {
                    event = this.xmlStreamReader.next();
                }
                String elemText = this.xmlStreamReader.getElementText();
                elemText = elemText == null ? "" : elemText;
                columns.add(elemText);
            }
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
        return columns;
    }

    static {
        PROPERTY_KEYS.add(PROP_FILENAME);
        PROPERTY_KEYS.add(PROP_ROWNAME);
        PROPERTY_KEYS.add(PROP_READONLY);
        PROPERTY_KEYS.add("LOADTYPE");
    }

    private static class XMLElementFilter
    implements StreamFilter {
        private XMLElementFilter() {
        }

        public boolean accept(XMLStreamReader reader) {
            return reader.isStartElement();
        }
    }

    private class XMLTableOrganizationContext
    extends BaseTableOrganizationContext {
        private XMLTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            HashSet keys = new HashSet(PROPERTY_KEYS.size());
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            this.assertValidPropertyKeys(props);
            XMLTable.this._fileName = props.getProperty(XMLTable.PROP_FILENAME);
            XMLTable.this._dataFile = new File(XMLTable.this._fileName);
            if (!XMLTable.this._dataFile.exists()) {
                try {
                    XMLTable.this._uri = new URI(XMLTable.this._fileName);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            XMLTable.this._rowName = props.getProperty(XMLTable.PROP_ROWNAME);
            XMLTable.this._readOnlyStatus = props.getProperty(XMLTable.PROP_READONLY);
            if (XMLTable.this.isNullString(XMLTable.this._fileName)) {
                XMLTable.this._fileName = XMLTable.this.getName() + "." + XMLTable.this.getDefaultDataFileExtension();
            }
        }

        public void updateProperties() {
            super.updateProperties();
            this._props.setProperty("LOADTYPE", "XML");
            this._props.setProperty(XMLTable.PROP_FILENAME, XMLTable.this._fileName);
            this._props.setProperty(XMLTable.PROP_ROWNAME, XMLTable.this._rowName);
            this._props.setProperty(XMLTable.PROP_READONLY, XMLTable.this._readOnlyStatus);
        }

        public Set getRequiredPropertyKeys() {
            HashSet keys = new HashSet(PROPERTY_KEYS.size());
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }
    }
}

