/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.AnyType;
import org.axiondb.types.StringType;
import org.axiondb.util.Base64;

public class Base64DecodeFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType STRING_TYPE = new StringType();

    public Base64DecodeFunction() {
        super("BASE64DECODE");
    }

    public ConcreteFunction makeNewInstance() {
        return new Base64DecodeFunction();
    }

    public DataType getDataType() {
        return AnyType.INSTANCE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object val = this.getArgument(0).evaluate(row);
        String strval = (String)STRING_TYPE.convert(val);
        if (null == strval) {
            return null;
        }
        return Base64.decodeBase64(strval.getBytes());
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

