/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;
import org.axiondb.util.Base64;

public class Base64EncodeFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new StringType();

    public Base64EncodeFunction() {
        super("BASE64ENCODE");
    }

    public ConcreteFunction makeNewInstance() {
        return new Base64EncodeFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel = this.getArgument(0);
        Object val = sel.evaluate(row);
        if (val instanceof byte[]) {
            return new String(Base64.encodeBase64((byte[])val, false));
        }
        if (null == val) {
            return null;
        }
        try {
            val = sel.getDataType().toBlob(val);
            return new String(Base64.encodeBase64(this.readBlob((Blob)val), false));
        }
        catch (SQLException e) {
            throw new AxionException(e);
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBlob(Blob blob) throws IOException, SQLException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            int b = in.read();
            while (b != -1) {
                buf.write((byte)b);
                b = in.read();
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return buf.toByteArray();
    }
}

