/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.FunctionFactory;
import org.axiondb.functions.ArithmeticFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BigDecimalType;

public class DivideFunction
extends ArithmeticFunction
implements ScalarFunction,
FunctionFactory {
    public DivideFunction() {
        super("DIVIDE");
    }

    public ConcreteFunction makeNewInstance() {
        return new DivideFunction();
    }

    protected BigDecimal operate(BigDecimal left, BigDecimal right) throws AxionException {
        try {
            BigDecimal result = left.divide(right, 6);
            int precision = result.unscaledValue().abs().toString().length();
            int scale = left.scale() <= precision ? left.scale() : result.scale();
            this.setDataType(new BigDecimalType(precision, scale));
            return result;
        }
        catch (ArithmeticException e) {
            throw new AxionException(22012);
        }
    }
}

