/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.EqualFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.AnyType;

public class NullIfFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private DataType _returnType = AnyType.INSTANCE;

    public NullIfFunction() {
        super("NULLIF");
    }

    public ConcreteFunction makeNewInstance() {
        return new NullIfFunction();
    }

    public DataType getDataType() {
        return this._returnType;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel1 = this.getArgument(0);
        EqualFunction fn = new EqualFunction();
        fn.addArgument(sel1);
        fn.addArgument(this.getArgument(1));
        Boolean result = (Boolean)fn.evaluate(row);
        if (result == null || !result.booleanValue()) {
            Object val = sel1.evaluate(row);
            this._returnType = sel1.getDataType();
            return val;
        }
        return null;
    }

    public boolean isValid() {
        return this.getArgumentCount() == 2;
    }
}

