/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.ArrayUnsignedIntList;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.LongList;
import org.axiondb.AxionException;
import org.axiondb.io.AxionInputStream;
import org.axiondb.io.AxionOutputStream;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.io.BufferedDataOutputStream;
import org.axiondb.io.FileUtil;
import org.axiondb.util.ExceptionConverter;

public class AxionFileSystem {
    private static final long MAX_LONG = Long.MAX_VALUE;

    public void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closeOutputStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BufferedDataOutputStream createBufferedDOS(File file) throws AxionException {
        try {
            return new BufferedDataOutputStream(this.open(file, true));
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
    }

    public boolean createNewFile(File file) throws AxionException {
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
    }

    public ObjectOutputStream createObjectOutputSteam(File file) throws IOException {
        return new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public DataOutputStream createDataOutputSteam(File file) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public PidxList newPidxList(File file, boolean readonly) throws AxionException {
        return new PidxList(file, readonly);
    }

    public AxionInputStream open(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        return new AxionFileInputStream(file);
    }

    public AxionOutputStream open(File file, boolean overwrite) throws IOException {
        File parent;
        if (file.exists() && overwrite) {
            file.delete();
            file.createNewFile();
        }
        if ((parent = file.getParentFile()) != null) {
            parent.mkdirs();
        }
        return new AxionFileOutputStream(file);
    }

    public AxionOutputStream openAppend(File file) throws IOException {
        return this.open(file, false);
    }

    public BufferedDataInputStream openBufferedDIS(File file) throws AxionException {
        try {
            return new BufferedDataInputStream(this.open(file));
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
    }

    public BufferedDataOutputStream openBufferedDOS(File file, long startPos) throws AxionException {
        try {
            AxionOutputStream out = this.open(file, true);
            out.seek(startPos);
            return new BufferedDataOutputStream(out);
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
    }

    public BufferedDataOutputStream openBufferedDOSAppend(File file, int bufferSize) throws AxionException {
        try {
            AxionOutputStream out = this.open(file, false);
            out.seek(file.length());
            return new BufferedDataOutputStream(out, bufferSize);
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
    }

    public ObjectInputStream openObjectInputSteam(File file) throws IOException {
        return new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
    }

    public DataInputStream openDataInputSteam(File file) throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
    }

    public IntList parseIntFile(File file) throws AxionException {
        int count = (int)(file.length() / 4L);
        ArrayIntList list = new ArrayIntList(count);
        BufferedDataInputStream in = null;
        try {
            in = this.openBufferedDIS(file);
            for (int i = 0; i < count; ++i) {
                list.add(in.readInt());
            }
            ArrayIntList i = list;
            return i;
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse " + file, e);
        }
        finally {
            this.closeInputStream(in);
        }
    }

    public PidxList parseLongPidxList(File file, boolean readOnly) throws AxionException {
        int count = (int)(file.length() / 8L);
        return new PidxList(file, readOnly);
    }

    public PidxList parseLongPidx(File file, boolean readOnly) throws AxionException {
        int count = (int)(file.length() / 4L);
        byte[] rawdata = new byte[count * 4];
        this.readAll(file, rawdata);
        ArrayUnsignedIntList list = new ArrayUnsignedIntList(count);
        int m = count * 4;
        for (int i = 0; i < m; i += 4) {
            long val = ((long)rawdata[i + 3] & 0xFFL) + (((long)rawdata[i + 2] & 0xFFL) << 8) + (((long)rawdata[i + 1] & 0xFFL) << 16) + (((long)rawdata[i + 0] & 0xFFL) << 24) & Long.MAX_VALUE;
            list.add(val);
        }
        FileUtil.truncate(file, 0L);
        this.writeAllList(list, file);
        return new PidxList(file, readOnly);
    }

    public void writeAllList(LongList list, File file) throws AxionException {
        try {
            BufferedDataOutputStream _out = this.openBufferedDOSAppend(file, 1024);
            int I = list.size();
            for (int i = 0; i < I; ++i) {
                _out.writeLong(list.get(i) & Long.MAX_VALUE);
            }
            _out.flush();
            _out.close();
            _out = null;
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
    }

    public void readAll(File file, byte[] rawdata) throws AxionException {
        AxionInputStream in = null;
        try {
            in = this.open(file);
            in.read(rawdata);
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
        finally {
            this.closeInputStream(in);
        }
    }

    public void writeIntFile(File file, IntList list) throws AxionException {
        BufferedDataOutputStream out = null;
        try {
            out = this.createBufferedDOS(file);
            int I = list.size();
            for (int i = 0; i < I; ++i) {
                out.writeInt(list.get(i));
            }
        }
        catch (IOException e) {
            throw new AxionException("Unable to write to " + file, e);
        }
        finally {
            this.closeOutputStream(out);
        }
    }

    public void writeUnsignedInt(BufferedDataOutputStream out, long offset, int value) throws AxionException {
        try {
            out.seek(offset);
            out.writeInt(value);
        }
        catch (IOException e) {
            throw new AxionException("Unable to write to " + out, e);
        }
    }

    public void writeToLong(BufferedDataOutputStream out, long offset, long value) throws AxionException {
        try {
            out.seek(offset);
            out.writeLong(value);
        }
        catch (IOException e) {
            throw new AxionException("Unable to write to " + out, e);
        }
    }

    public void writeUnsignedIntFile(File file, LongList list) throws AxionException {
        BufferedDataOutputStream out = null;
        try {
            out = this.createBufferedDOS(file);
            int I = list.size();
            for (int i = 0; i < I; ++i) {
                out.writeLong(list.get(i) & Long.MAX_VALUE);
            }
        }
        catch (IOException e) {
            throw new AxionException("Unable to write to " + file, e);
        }
        finally {
            this.closeOutputStream(out);
        }
    }

    public void writeLongFile(File file, LongList list) throws AxionException {
        BufferedDataOutputStream out = null;
        try {
            out = this.createBufferedDOS(file);
            int I = list.size();
            for (int i = 0; i < I; ++i) {
                out.writeLong(list.get(i) & Long.MAX_VALUE);
            }
        }
        catch (IOException e) {
            throw new AxionException("Unable to write to " + file, e);
        }
        finally {
            this.closeOutputStream(out);
        }
    }

    public long readLongFile(BufferedDataInputStream in, long offset) throws AxionException {
        try {
            in.seek(offset);
            return in.readLong();
        }
        catch (IOException e) {
            throw new AxionException("AxionFileSystem->Unable to read from " + in, e);
        }
    }

    class AxionFileOutputStream
    extends AxionOutputStream {
        private RandomAccessFile _raf;

        public AxionFileOutputStream(File file) throws IOException {
            this._raf = new RandomAccessFile(file, "rw");
        }

        public void close() throws IOException {
            this._raf.close();
        }

        public void flush() throws IOException {
        }

        public long getPos() throws IOException {
            return this._raf.getFilePointer();
        }

        public void seek(long pos) throws IOException {
            this._raf.seek(pos);
        }

        public void truncate(long length) throws IOException {
            this._raf.setLength(length);
        }

        public void write(byte[] b) throws IOException {
            this._raf.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this._raf.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this._raf.write(b);
        }
    }

    class AxionFileInputStream
    extends AxionInputStream {
        FileInputStream _fis;

        public AxionFileInputStream(File f) throws IOException {
            this._fis = new FileInputStream(f);
        }

        public int available() throws IOException {
            return this._fis.available();
        }

        public void close() throws IOException {
            this._fis.close();
        }

        public long getPos() throws IOException {
            return this._fis.getChannel().position();
        }

        public int read() throws IOException {
            return this._fis.read();
        }

        public int read(byte[] b) throws IOException {
            return this._fis.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this._fis.read(b, off, len);
        }

        public void seek(long pos) throws IOException {
            this._fis.getChannel().position(pos);
        }

        public long skip(long n) throws IOException {
            return this._fis.skip(n);
        }

        public FileInputStream getFileStream() {
            return this._fis;
        }
    }

    public class PidxList {
        private BufferedDataOutputStream _out = null;
        private BufferedDataInputStream _in = null;
        AtomicBoolean _isDirty = new AtomicBoolean(true);
        File _pidxFile;
        int _size = 0;

        public PidxList(File pidxFile, boolean readOnly) throws AxionException {
            this.openPidxFile(pidxFile, readOnly);
            this._pidxFile = pidxFile;
            this._size = (int)(this._pidxFile.length() / 8L);
        }

        public void add(long dataFileOffset) {
            try {
                AxionFileSystem.this.writeToLong(this._out, (long)this.size() * 8L, dataFileOffset & Long.MAX_VALUE);
                this._isDirty.set(true);
                ++this._size;
            }
            catch (AxionException e) {
                throw ExceptionConverter.convertToRuntimeException(e);
            }
        }

        public void close() throws IOException {
            if (this._out != null) {
                this._out.close();
                this._out = null;
            }
            if (this._in != null) {
                this._in.close();
                this._in = null;
            }
        }

        public void flush() throws IOException {
            this._out.flush();
        }

        public synchronized long get(int index) {
            try {
                if (this._isDirty.get()) {
                    this.flush();
                    if (this._in != null) {
                        this._in.close();
                        this._in = null;
                    }
                    this._in = AxionFileSystem.this.openBufferedDIS(this._pidxFile);
                    this._isDirty.set(false);
                }
                return AxionFileSystem.this.readLongFile(this._in, (long)index * 8L);
            }
            catch (Exception e) {
                throw ExceptionConverter.convertToRuntimeException(e);
            }
        }

        public void set(int rowid, long dataFileOffset) {
            try {
                AxionFileSystem.this.writeToLong(this._out, (long)rowid * 8L, dataFileOffset & Long.MAX_VALUE);
                this._isDirty.set(true);
            }
            catch (Exception e) {
                throw ExceptionConverter.convertToRuntimeException(e);
            }
        }

        public int size() {
            return this._size;
        }

        private synchronized void openPidxFile(File pidxFile, boolean readOnly) throws AxionException {
            if (!readOnly) {
                this._out = AxionFileSystem.this.openBufferedDOSAppend(pidxFile, 1024);
            }
        }
    }
}

