/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.io;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.Row;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.types.CharacterType;

public class CharStreamTokenizer {
    private static final String EMPTY_STRING = "";
    private static final String COMMA = ",";
    private static final char NL = '\uffff';
    protected static final int EOF = -1;
    protected static final char FILLER = ' ';
    private char[] _lineCharArray = new char[80];
    public static final int LINE_CHAR_ARRAY_SIZE = 80;
    private char[][] _lineSepsChar;
    private char[] _fieldSepChar = new String(",").toCharArray();
    private char[] _qualifierChar = "".toCharArray();
    private boolean _isQuoted = false;
    private String _qualifier;
    private Pattern _qqPattern;

    public CharStreamTokenizer(char[] fieldSepChar, char[][] lineSepsChar, char[] qualifierChar, boolean isQuoted) {
        this._fieldSepChar = fieldSepChar;
        this._lineSepsChar = lineSepsChar;
        this._qualifier = new String(qualifierChar);
        this._qualifierChar = qualifierChar;
        this._isQuoted = isQuoted;
    }

    public CharStreamTokenizer() {
        this._lineSepsChar = new char[1][1];
        this._lineSepsChar[0] = System.getProperty("line.separator").toCharArray();
    }

    public void skipLine(BufferedDataInputStream data) throws IOException {
        while (!this.isEndOfRecord(data.read(), data)) {
        }
    }

    public boolean isEndOfRecord(int nextChar, BufferedDataInputStream data) throws IOException {
        if (-1 == nextChar) {
            return true;
        }
        boolean foundEOL = false;
        for (int k = 0; k < this._lineSepsChar.length && !foundEOL; ++k) {
            if (this._lineSepsChar[k].length == 0 || this._lineSepsChar[k][0] != nextChar) continue;
            foundEOL = true;
            long lastDataFileOffset = data.getPos();
            int I = this._lineSepsChar[k].length;
            for (int i = 1; i < I; ++i) {
                if (this._lineSepsChar[k][i] == (char)data.read()) continue;
                data.seek(lastDataFileOffset);
                foundEOL = false;
            }
        }
        return foundEOL;
    }

    public String[] readAndSplitLine(BufferedDataInputStream data, long offset, int colCount, boolean trimWhiteSpace) throws AxionException, IOException {
        data.seek(offset);
        String[] row = new String[colCount];
        char[] charArray = this.readLine(data, offset);
        if (charArray[0] == '\uffff') {
            throw new AxionException("Empty line detected - invalid.");
        }
        DataType[] datatypes = new CharacterType[colCount];
        CharTokenizer charTokenizer = new CharTokenizer(charArray, trimWhiteSpace, datatypes);
        for (int i = 0; i < colCount && charTokenizer.hasMoreTokens(); ++i) {
            row[i] = (String)charTokenizer.nextToken(i);
        }
        return row;
    }

    public Row readAndSplitLine(BufferedDataInputStream data, long offset, int colCount, boolean trimWhiteSpace, DataType[] datatypes) throws AxionException, IOException {
        data.seek(offset);
        SimpleRow row = new SimpleRow(colCount);
        char[] charArray = this.readLine(data, offset);
        if (charArray[0] == '\uffff') {
            throw new AxionException("Empty line detected - invalid.");
        }
        CharTokenizer charTokenizer = new CharTokenizer(charArray, trimWhiteSpace, datatypes);
        for (int i = 0; i < colCount && charTokenizer.hasMoreTokens(); ++i) {
            row.set(i, charTokenizer.nextToken(i));
        }
        return row;
    }

    public boolean isNumber(int type) {
        switch (type) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public Object convert(char[] val, int start, int end, boolean isNumber) throws AxionException {
        int st;
        int len = end;
        for (st = start; st < len && val[st] <= ' '; ++st) {
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        if (st == len) {
            return null;
        }
        if (isNumber) {
            try {
                return new BigDecimal(val, st, len - st);
            }
            catch (NumberFormatException e) {
                throw new AxionException(e);
            }
        }
        return new String(val, st, len - st);
    }

    private char[] readLine(BufferedDataInputStream data, long fileOffset) throws AxionException {
        Arrays.fill(this._lineCharArray, ' ');
        int recLength = 0;
        try {
            data.seek(fileOffset);
            while (true) {
                int nextChar;
                if (this.isEndOfRecord(nextChar = data.read(), data)) break;
                if (recLength + 2 > this._lineCharArray.length) {
                    char[] newlineCharArray = new char[recLength + 80];
                    System.arraycopy(this._lineCharArray, 0, newlineCharArray, 0, this._lineCharArray.length);
                    this._lineCharArray = newlineCharArray;
                }
                this._lineCharArray[recLength++] = (char)nextChar;
            }
            this._lineCharArray[recLength] = 65535;
            return this._lineCharArray;
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse data file: ", e);
        }
    }

    protected boolean isEOF(int nextChar) {
        return nextChar == -1;
    }

    protected boolean isNullString(String str) {
        return str == null || str.trim().length() == 0;
    }

    protected boolean isNewLine(int nextChar) {
        return nextChar == 65535;
    }

    public class CharTokenizer {
        char[] _charArray;
        private int _currentPosition;
        private int _maxPosition;
        private DataType[] _datatypes;
        boolean _trimWhiteSpace;

        public CharTokenizer(char[] thecharArray, boolean trimWhiteSpace, DataType[] datatypes) {
            this._charArray = thecharArray;
            this._maxPosition = this._charArray.length;
            this._currentPosition = 0;
            this._datatypes = datatypes;
            this._trimWhiteSpace = trimWhiteSpace;
        }

        public boolean hasMoreTokens() {
            return this._currentPosition < this._maxPosition;
        }

        public Object nextToken(int colIndex) throws AxionException {
            int start;
            int end = start = this._currentPosition;
            int pos = this._currentPosition;
            boolean inQuotedString = false;
            boolean endQuotedString = false;
            boolean treatAsUnquoted = false;
            boolean wasEscaped = false;
            while (pos < this._maxPosition) {
                if (CharStreamTokenizer.this.isNewLine(this._charArray[pos])) {
                    if (CharStreamTokenizer.this._isQuoted && !endQuotedString) {
                        this._maxPosition = pos;
                        this._currentPosition = pos;
                        end = pos;
                        break;
                    }
                    this._currentPosition = this._maxPosition;
                }
                if (CharStreamTokenizer.this._isQuoted && this.isQualifier(pos)) {
                    if (!inQuotedString) {
                        start = pos += CharStreamTokenizer.this._qualifierChar.length;
                        inQuotedString = true;
                        continue;
                    }
                    if (this.isQualifier(pos + CharStreamTokenizer.this._qualifierChar.length)) {
                        pos += CharStreamTokenizer.this._qualifierChar.length * 2;
                        wasEscaped = true;
                        continue;
                    }
                    end = pos;
                    pos += CharStreamTokenizer.this._qualifierChar.length;
                    inQuotedString = false;
                    endQuotedString = true;
                    continue;
                }
                if (CharStreamTokenizer.this._isQuoted && endQuotedString && CharStreamTokenizer.this._fieldSepChar[0] != this._charArray[pos] && !CharStreamTokenizer.this.isNewLine(this._charArray[pos])) {
                    ++pos;
                    continue;
                }
                if (CharStreamTokenizer.this._isQuoted && endQuotedString) {
                    if (this.isDelimiter(pos)) {
                        pos += CharStreamTokenizer.this._fieldSepChar.length;
                        break;
                    }
                    if (CharStreamTokenizer.this.isNewLine(this._charArray[pos])) break;
                }
                if (CharStreamTokenizer.this._isQuoted && !inQuotedString) {
                    treatAsUnquoted = true;
                }
                if ((!CharStreamTokenizer.this._isQuoted || treatAsUnquoted) && pos < this._maxPosition) {
                    if (this.isDelimiter(pos)) {
                        end = pos;
                        pos += CharStreamTokenizer.this._fieldSepChar.length;
                        break;
                    }
                    if (CharStreamTokenizer.this.isNewLine(this._charArray[pos])) {
                        end = pos;
                        break;
                    }
                }
                ++pos;
            }
            this._currentPosition = pos;
            if (pos == this._maxPosition) {
                end = this._maxPosition;
            }
            int jdbcType = this._datatypes[colIndex].getJdbcType();
            DataType type = this._datatypes[colIndex];
            if (start != end) {
                if (CharStreamTokenizer.this.isNumber(jdbcType)) {
                    return CharStreamTokenizer.this.convert(this._charArray, start, end, true);
                }
                if (type instanceof CharacterType || this._trimWhiteSpace) {
                    Object token = CharStreamTokenizer.this.convert(this._charArray, start, end, false);
                    if (wasEscaped) {
                        return CharStreamTokenizer.this._qqPattern.matcher((String)token).replaceAll(CharStreamTokenizer.this._qualifier);
                    }
                    return token;
                }
                return new String(this._charArray, start, end - start);
            }
            if (endQuotedString) {
                return CharStreamTokenizer.EMPTY_STRING;
            }
            return null;
        }

        private boolean isDelimiter(int position) {
            boolean delimiterFound = true;
            int J = CharStreamTokenizer.this._fieldSepChar.length;
            for (int j = 0; j < J; ++j) {
                if (CharStreamTokenizer.this._fieldSepChar[j] == this._charArray[position++]) continue;
                delimiterFound = false;
                break;
            }
            return delimiterFound;
        }

        private boolean isQualifier(int position) {
            boolean qualifierFound = true;
            int J = CharStreamTokenizer.this._qualifierChar.length;
            for (int j = 0; j < J; ++j) {
                if (CharStreamTokenizer.this._qualifierChar[j] == this._charArray[position++]) continue;
                qualifierFound = false;
                break;
            }
            return qualifierFound;
        }
    }
}

