/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.jdbc;

import java.io.File;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.Transaction;
import org.axiondb.TransactionConflictException;
import org.axiondb.engine.Databases;
import org.axiondb.jdbc.AxionDatabaseMetaData;
import org.axiondb.jdbc.AxionPreparedStatement;
import org.axiondb.jdbc.AxionStatement;
import org.axiondb.util.ExceptionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxionConnection
implements Connection {
    private Database _db;
    private String _url;
    private Transaction _currentTransaction;
    private int _isolationLevel = 8;
    private boolean _autoCommit = true;
    private SQLWarning _warning;

    protected AxionConnection(String name, File path, String url) throws AxionException {
        this.setUrl(url);
        this.setDatabase(Databases.getOrCreateDatabase(name, path));
    }

    public AxionConnection(Database db, String url) {
        this.setDatabase(db);
        this.setUrl(url);
    }

    public AxionConnection(Database db) {
        this(db, null);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._warning = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            if (!this._db.getTransactionManager().isShutdown()) {
                this.rollback(false);
            }
            try {
                this._db.checkpoint();
            }
            catch (AxionException e) {
                throw ExceptionConverter.convert(e);
            }
            this._db = null;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.commit(true);
    }

    @Override
    public void rollback() throws SQLException {
        this.rollback(true);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        resultSetType = this.validateResultSetType(resultSetType);
        resultSetConcurrency = this.validateResultSetConcurrency(resultSetConcurrency);
        return new AxionStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this._autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "";
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new AxionDatabaseMetaData(this, this._db);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this._isolationLevel;
    }

    public Map getTypeMap() throws SQLException {
        return Collections.EMPTY_MAP;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Already closed");
        }
        return this._warning;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._db == null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        resultSetType = this.validateResultSetType(resultSetType);
        resultSetConcurrency = this.validateResultSetConcurrency(resultSetConcurrency);
        return new AxionPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    private int validateResultSetType(int resultSetType) throws SQLException {
        switch (resultSetType) {
            case 1003: 
            case 1005: {
                break;
            }
            case 1004: {
                this.createAndAddSQLWarning("Result set type TYPE_SCROLL_INSENSITIVE is currently not supported; returning TYPE_SCROLL_SENSITIVE instead.");
                resultSetType = 1005;
                break;
            }
            default: {
                throw new SQLException("Unknown or unsupported result set type: " + resultSetType);
            }
        }
        return resultSetType;
    }

    private int validateResultSetConcurrency(int resultSetConcurrency) throws SQLException {
        switch (resultSetConcurrency) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw new SQLException("Unknown or unsupported concurrency type: " + resultSetConcurrency);
            }
        }
        return resultSetConcurrency;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this._autoCommit = autoCommit;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (level != 8) {
            throw new SQLException("Transcation isolation level " + level + " is not supported.");
        }
        this._isolationLevel = level;
    }

    public void setTypeMap(Map types) throws SQLException {
    }

    public String getURL() {
        return this._url;
    }

    public Database getDatabase() {
        return this._db;
    }

    Transaction getCurrentTransaction() throws AxionException {
        if (null == this._currentTransaction) {
            this._currentTransaction = this._db.getTransactionManager().createTransaction();
        }
        return this._currentTransaction;
    }

    Transaction forgetCurrentTransaction() {
        Transaction temp = this._currentTransaction;
        this._currentTransaction = null;
        return temp;
    }

    void commitIfAuto() throws SQLException {
        if (this.getAutoCommit() && !this._db.getTransactionManager().isShutdown()) {
            this.commit(false);
        }
    }

    protected synchronized void addWarning(SQLWarning newWarning) {
        if (newWarning != null) {
            if (this._warning != null) {
                this._warning.setNextWarning(newWarning);
            } else {
                this._warning = newWarning;
            }
        }
    }

    private void createAndAddSQLWarning(String string) {
        this.addWarning(new SQLWarning(string));
    }

    private void assertNotAutoCommit() throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("This method should only be used when auto-commit mode has been disabled.");
        }
    }

    private void commit(boolean checkmode) throws SQLException {
        if (checkmode) {
            this.assertNotAutoCommit();
        }
        try {
            if (null != this._currentTransaction) {
                this._db.getTransactionManager().commitTransaction(this._currentTransaction);
                this._currentTransaction = null;
            }
        }
        catch (TransactionConflictException e) {
            throw ExceptionConverter.convert(new AxionException(e, 51000));
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    private void rollback(boolean checkmode) throws SQLException {
        if (checkmode) {
            this.assertNotAutoCommit();
        }
        try {
            if (null != this._currentTransaction) {
                this._db.getTransactionManager().abortTransaction(this._currentTransaction);
                this._currentTransaction = null;
            }
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException("createStatement(int,int,int) is currently not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("getHoldability is currently not supported");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLException("prepareCall(String,int,int,int) is currently not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLException("prepareStatement(String,int,int,int) is currently not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        throw new SQLException("prepareStatement(String,int) is currently not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        throw new SQLException("prepareStatement(String,int[]) is currently not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        throw new SQLException("prepareStatement(String,String[]) is currently not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new SQLException("releaseSavepoint(Savepoint) is currently not supported");
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
        throw new SQLException("rollback(Savepoint) is currently not supported");
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        throw new SQLException("setHoldability(int) is currently not supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("setSavepoint is currently not supported");
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new SQLException("setSavepoint(String) is currently not supported");
    }

    private void setUrl(String url) {
        this._url = url;
    }

    private void setDatabase(Database db) {
        this._db = db;
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return "";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Unsupported.");
    }
}

