/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.jdbc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import org.axiondb.AxionCommand;
import org.axiondb.AxionException;
import org.axiondb.jdbc.AxionConnection;
import org.axiondb.jdbc.AxionStatement;
import org.axiondb.types.ByteArrayBlob;
import org.axiondb.util.ExceptionConverter;
import org.axiondb.util.ValuePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxionPreparedStatement
extends AxionStatement
implements Statement,
PreparedStatement {
    private AxionCommand _cmd;
    private Parameters _params;
    private static final Object UNBOUND = new Object();

    protected AxionPreparedStatement(AxionConnection conn, String sql) throws SQLException {
        super(conn);
        this.initStatement(sql);
    }

    protected AxionPreparedStatement(AxionConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency);
        this.initStatement(sql);
    }

    private void initStatement(String sql) throws SQLException {
        this._cmd = this.parseCommand(sql);
        this._params = new Parameters(this._cmd.getBindVariables().size());
    }

    private void setParameter(int i, Object value) throws SQLException {
        this.assertOpen();
        this._params.set(i, value);
    }

    private void bindVariables(Parameters params) throws SQLException {
        try {
            params.assertBindVariablesSet();
            this._cmd.bindAll(params.getValues());
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public void close() throws SQLException {
        this._cmd = null;
        super.close();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("execute(String) not valid for PreparedStatements");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("executeQuery(String) not valid for PreparedStatements");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("executeUpdate(String) not valid for PreparedStatements");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("addBatch(String) not valid for PreparedStatements");
    }

    @Override
    public void addBatch() throws SQLException {
        this.closeCurrentResultSet();
        this.addToBatchContext(this._params);
        this._params = new Parameters(this._params.size());
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this._cmd.clearBindings();
            this._params.clearBindings();
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        SQLException exception = null;
        int[] results = new int[this.getBatchCount()];
        int i = 0;
        Iterator iter = this.getBatchContext();
        while (iter.hasNext()) {
            Parameters params = (Parameters)iter.next();
            try {
                this.bindVariables(params);
                results[i] = this.executeUpdate(this._cmd);
                this.clearParameters();
            }
            catch (SQLWarning w) {
                this.addWarning(w);
            }
            catch (SQLException e) {
                exception = e;
                results[i] = -3;
            }
            ++i;
        }
        this.clearBatchContext();
        if (null != exception) {
            throw new BatchUpdateException(exception.getMessage(), results);
        }
        return results;
    }

    @Override
    public boolean execute() throws SQLException {
        this.clearCurrentResult();
        this.bindVariables(this._params);
        return this.execute(this._cmd);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.clearCurrentResult();
        this.bindVariables(this._params);
        return this.executeQuery(this._cmd);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.clearCurrentResult();
        this.bindVariables(this._params);
        return this.executeUpdate(this._cmd);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.hasCurrentResultSet()) {
            return this.getCurrentResultSet().getMetaData();
        }
        if (this._params.size() == 0) {
            ResultSet rs = this.executeQuery();
            return rs.getMetaData();
        }
        throw new SQLException("No current ResultSet");
    }

    @Override
    public void setArray(int i, Array arr) throws SQLException {
        this.setParameter(i, arr);
    }

    @Override
    public void setAsciiStream(int n, InputStream in, int length) throws SQLException {
        try {
            this.setCharacterStream(n, (Reader)new InputStreamReader(in, "ASCII"), length);
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public void setBigDecimal(int i, BigDecimal big) throws SQLException {
        this.setParameter(i, big);
    }

    @Override
    public void setBinaryStream(int n, InputStream in, int length) throws SQLException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(length);
        try {
            int b = in.read();
            for (int i = 0; i < length && b != -1; ++i) {
                buffer.write(b);
                b = in.read();
            }
        }
        catch (IOException e) {
            throw ExceptionConverter.convert(e);
        }
        this.setBlob(n, new ByteArrayBlob(buffer.toByteArray()));
    }

    @Override
    public void setBlob(int i, Blob blob) throws SQLException {
        this.setParameter(i, blob);
    }

    @Override
    public void setBoolean(int i, boolean bool) throws SQLException {
        this.setParameter(i, ValuePool.getBoolean(bool));
    }

    @Override
    public void setByte(int i, byte b) throws SQLException {
        this.setParameter(i, new Byte(b));
    }

    @Override
    public void setBytes(int i, byte[] bytes) throws SQLException {
        this.setParameter(i, bytes);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int length) throws SQLException {
        StringBuffer buf = new StringBuffer(length);
        try {
            reader = new BufferedReader(reader);
            int c = reader.read();
            for (int i = 0; i < length && c != -1; ++i) {
                buf.append((char)c);
                c = reader.read();
            }
        }
        catch (IOException e) {
            throw ExceptionConverter.convert(e);
        }
        this.setString(n, buf.toString());
    }

    @Override
    public void setClob(int i, Clob clob) throws SQLException {
        this.setParameter(i, clob);
    }

    @Override
    public void setDate(int i, Date date) throws SQLException {
        this.setParameter(i, date);
    }

    @Override
    public void setDate(int i, Date date, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(int i, double d) throws SQLException {
        this.setParameter(i, new Double(d));
    }

    @Override
    public void setFloat(int i, float f) throws SQLException {
        this.setParameter(i, new Float(f));
    }

    @Override
    public void setInt(int i, int value) throws SQLException {
        this.setParameter(i, new Integer(value));
    }

    @Override
    public void setLong(int i, long l) throws SQLException {
        this.setParameter(i, new Long(l));
    }

    @Override
    public void setNull(int i, int sqlType) throws SQLException {
        this.setParameter(i, null);
    }

    @Override
    public void setNull(int i, int sqlType, String typeName) throws SQLException {
        this.setParameter(i, null);
    }

    @Override
    public void setObject(int i, Object o) throws SQLException {
        this.setParameter(i, o);
    }

    @Override
    public void setObject(int i, Object o, int targetSqlType) throws SQLException {
        this.setParameter(i, o);
    }

    @Override
    public void setObject(int i, Object o, int targetSqlType, int scale) throws SQLException {
        this.setParameter(i, o);
    }

    @Override
    public void setRef(int i, Ref ref) throws SQLException {
        throw new SQLException("setRef is currently not supported");
    }

    @Override
    public void setShort(int i, short s) throws SQLException {
        this.setParameter(i, new Short(s));
    }

    @Override
    public void setString(int i, String str) throws SQLException {
        this.setParameter(i, str);
    }

    @Override
    public void setTime(int i, Time time) throws SQLException {
        this.setParameter(i, time);
    }

    @Override
    public void setTime(int i, Time time, Calendar cal) throws SQLException {
        throw new SQLException("setTime(int,Time,Calendar) is currently not supported");
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp) throws SQLException {
        this.setParameter(i, timestamp);
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp, Calendar cal) throws SQLException {
        throw new SQLException("setTimestamp(int,Timestamp,Calendar) is currently not supported");
    }

    @Override
    public void setURL(int i, URL url) throws SQLException {
        this.setParameter(i, url);
    }

    @Override
    public void setUnicodeStream(int n, InputStream in, int length) throws SQLException {
        try {
            this.setCharacterStream(n, (Reader)new InputStreamReader(in, "UnicodeBig"), length / 2);
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new EmptyParameterMetaData();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    protected class Parameters {
        private Object[] _vals;

        public Parameters(int size) {
            this._vals = new Object[size];
            Arrays.fill(this._vals, UNBOUND);
        }

        public Object get(int i) {
            return this._vals[i];
        }

        public void set(int i, Object val) throws SQLException {
            if (i < 1 || i > this._vals.length) {
                throw new SQLException("Invalid index for Parameter");
            }
            this._vals[i - 1] = val;
        }

        public void assertBindVariablesSet() throws SQLException {
            int I = this._vals.length;
            for (int i = 0; i < I; ++i) {
                if (this._vals[i] != UNBOUND) continue;
                throw new SQLException("Unbound variable found.");
            }
        }

        public final void clearBindings() {
            Arrays.fill(this._vals, UNBOUND);
        }

        public int size() {
            return this._vals.length;
        }

        public Object[] getValues() {
            return this._vals;
        }
    }

    protected class EmptyParameterMetaData
    implements ParameterMetaData {
        protected EmptyParameterMetaData() {
        }

        public int getParameterCount() throws SQLException {
            return 0;
        }

        public int isNullable(int arg0) throws SQLException {
            return 0;
        }

        public boolean isSigned(int arg0) throws SQLException {
            return false;
        }

        public int getPrecision(int arg0) throws SQLException {
            return 0;
        }

        public int getScale(int arg0) throws SQLException {
            return 0;
        }

        public int getParameterType(int arg0) throws SQLException {
            return 1111;
        }

        public String getParameterTypeName(int arg0) throws SQLException {
            return "";
        }

        public String getParameterClassName(int arg0) throws SQLException {
            return "";
        }

        public int getParameterMode(int arg0) throws SQLException {
            return 1;
        }
    }
}

