/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.tools.BaseReport;
import org.axiondb.tools.BatchSqlCommandRunner;
import org.axiondb.tools.Console;

public class ParallelBatchSqlCommandRunner {
    private static Logger _log = Logger.getLogger(BatchSqlCommandRunner.class.getName());
    private StringBuffer _buf = new StringBuffer();
    private static String _lockObject = "";
    private Console _console;
    private PrintWriter _writer = null;
    private BaseReport _report = null;

    public ParallelBatchSqlCommandRunner(Console console) throws SQLException {
        this._console = console;
    }

    public ParallelBatchSqlCommandRunner(Console console, PrintWriter pw) {
        this._console = console;
        this._writer = pw == null ? new PrintWriter(System.out, true) : pw;
        this._report = new BaseReport(this._writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommands(BufferedReader reader) throws IOException, Exception {
        long startTime = System.currentTimeMillis();
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            String cmd = null;
            while (!(cmd = this.readCommand(reader)).equals("")) {
                cmds.add(cmd);
            }
            ExecutorService _threadPool = Executors.newFixedThreadPool(cmds.size());
            int I = cmds.size();
            for (int i = 0; i < I; ++i) {
                Job job = new Job((String)cmds.get(i), this._console.getNewConnection());
                _threadPool.execute(job);
            }
            _threadPool.shutdown();
            String string = _lockObject;
            synchronized (string) {
                while (!_threadPool.isTerminated()) {
                    try {
                        _lockObject.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger("global").log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        catch (Exception e) {
            this._report.reportException(e);
            throw e;
        }
        finally {
            reader.close();
            long endTime = System.currentTimeMillis();
            this._writer.println("\n\nExecution time: " + (endTime - startTime) + " ms.");
        }
    }

    public void runCommands(InputStream stream) throws IOException, Exception {
        this.runCommands(new BufferedReader(new InputStreamReader(stream, "UTF8")));
    }

    public void close() {
    }

    String readLine(BufferedReader reader) throws IOException {
        String result = reader.readLine();
        if (result != null) {
            result.trim();
        }
        return result;
    }

    String readCommand(BufferedReader reader) throws IOException {
        this._buf.setLength(0);
        String line = null;
        boolean done = false;
        boolean inQuote = false;
        while (!done && (line = this.readLine(reader)) != null) {
            if (line.indexOf("/*") != -1) continue;
            this._buf.append(line);
            this._buf.append(' ');
            inQuote = this.isInQuotes(line, inQuote);
            done = !inQuote && line.trim().endsWith(";");
        }
        return this._buf.toString().trim();
    }

    boolean isInQuotes(String line, boolean inQuotes) {
        boolean result = inQuotes;
        int quotePos = -1;
        int startPos = 0;
        while ((quotePos = line.indexOf("'", startPos)) > -1) {
            result = !result;
            startPos = quotePos + 1;
        }
        return result;
    }

    private class Job
    implements Runnable {
        String _cmd = null;
        Connection _conn;

        public Job(String cmd, Connection conn) {
            this._cmd = cmd;
            this._conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Statement stmt = null;
            try {
                long startTime = System.currentTimeMillis();
                this._conn.setAutoCommit(false);
                stmt = this._conn.createStatement();
                boolean hasResultSet = stmt.execute(this._cmd);
                this._conn.commit();
                long endTime = System.currentTimeMillis();
                if (hasResultSet) {
                    ResultSet rset = stmt.getResultSet();
                    ParallelBatchSqlCommandRunner.this._report.reportResultSet(rset);
                    rset.close();
                } else {
                    int ct = stmt.getUpdateCount();
                    ParallelBatchSqlCommandRunner.this._report.reportUpdateCount(ct);
                }
                ParallelBatchSqlCommandRunner.this._writer.println("Execution time: " + (endTime - startTime) + " ms.");
            }
            catch (Exception ex) {
                BaseReport baseReport = ParallelBatchSqlCommandRunner.this._report;
                synchronized (baseReport) {
                    ParallelBatchSqlCommandRunner.this._report.reportException(ex);
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

