/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.TimestampType;

public class DateType
extends TimestampType {
    private static final Object LOCK_DATE_PARSING = new Object();
    private static final Object LOCK_DATE_FORMATTING = new Object();
    private static final DateFormat[] DATE_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", LOCALE), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", LOCALE), new SimpleDateFormat("yyyy-MM-dd", LOCALE), new SimpleDateFormat("MM-dd-yyyy", LOCALE), new SimpleDateFormat("dd-MM-yyyy", LOCALE), new SimpleDateFormat("dd-MM-yyyy HH:mm:ss", LOCALE), new SimpleDateFormat("dd-MMM-yy HH:mm:ss", LOCALE), new SimpleDateFormat("dd-MMM-yy", LOCALE), new SimpleDateFormat("dd-MMM-yyyy", LOCALE), new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS", LOCALE), new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", LOCALE), new SimpleDateFormat("MM/dd/yyyy", LOCALE), new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS", LOCALE), new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", LOCALE), new SimpleDateFormat("dd/MM/yyyy", LOCALE), new SimpleDateFormat("HH:mm:ss", LOCALE), DateFormat.getTimeInstance(3, LOCALE)};
    private static final DateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private int _precision = 11;
    static final long INCREMENT_DAY = 86400000L;
    static final long serialVersionUID = 7318179645848578342L;

    public static long normalizeToUTCZeroHour(long rawTimeMillis) {
        long remainder = rawTimeMillis % 86400000L;
        return remainder == 0L ? rawTimeMillis : rawTimeMillis - remainder;
    }

    public boolean accepts(Object value) {
        if (null == value) {
            return true;
        }
        if (value instanceof Number) {
            return true;
        }
        if (value instanceof String) {
            return true;
        }
        if (value instanceof Date) {
            return true;
        }
        if (value instanceof java.sql.Date) {
            return true;
        }
        return value instanceof Time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.sql.Date convertToDate(Object value) throws AxionException {
        Calendar cal = Calendar.getInstance();
        if (null == value) {
            return null;
        }
        if (value instanceof Number) {
            cal.setTimeInMillis(((Number)value).longValue());
        } else if (value instanceof Timestamp) {
            cal.setTimeInMillis(((Timestamp)value).getTime());
        } else if (value instanceof java.sql.Date) {
            cal.setTimeInMillis(((java.sql.Date)value).getTime());
        } else if (value instanceof Time) {
            cal.setTimeInMillis(((Time)value).getTime());
        } else if (value instanceof Date) {
            cal.setTimeInMillis(((Date)value).getTime());
        } else if (value instanceof String) {
            Date dVal = null;
            for (int i = 0; dVal == null && i < DATE_PARSING_FORMATS.length; ++i) {
                Object object = LOCK_DATE_PARSING;
                synchronized (object) {
                    dVal = DATE_PARSING_FORMATS[i].parse((String)value, new ParsePosition(0));
                    continue;
                }
            }
            if (dVal == null) {
                throw new AxionException(22007);
            }
            cal.setTimeInMillis(dVal.getTime());
        } else {
            throw new AxionException(22007);
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public Object convert(Object value) throws AxionException {
        try {
            if (value instanceof java.sql.Date) {
                return value;
            }
            return this.convertToDate(value);
        }
        catch (AxionException e) {
            throw new AxionException("Can't convert " + value.getClass().getName() + " " + value + ".");
        }
    }

    public int getColumnDisplaySize() {
        return this.getPrecision();
    }

    public int getPrecision() {
        return this._precision;
    }

    public void setPrecision(int newPrec) {
        this._precision = newPrec;
    }

    public int getJdbcType() {
        return 91;
    }

    public DataType makeNewInstance() {
        return new DateType();
    }

    public Object successor(Object value) throws IllegalArgumentException {
        try {
            return new java.sql.Date(this.toDate(value).getTime() + 86400000L);
        }
        catch (AxionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public boolean supportsSuccessor() {
        return true;
    }

    public BigDecimal toBigDecimal(Object value) throws AxionException {
        java.sql.Date dval;
        try {
            dval = (java.sql.Date)this.convert(value);
        }
        catch (IllegalArgumentException e) {
            throw new AxionException("Can't convert \"" + value + "\" to BigDecimal.", e);
        }
        return dval != null ? BigDecimal.valueOf(dval.getTime()) : null;
    }

    public java.sql.Date toDate(Object value) throws AxionException {
        return this.convertToDate(value);
    }

    public String toString() {
        return "date";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Object value) throws AxionException {
        java.sql.Date dval = this.convertToDate(value);
        if (null == dval) {
            return null;
        }
        String ret = null;
        Object object = LOCK_DATE_FORMATTING;
        synchronized (object) {
            ret = ISO_DATE_FORMAT.format(dval);
        }
        return ret;
    }

    public Time toTime(Object value) throws AxionException {
        return new Time(this.convertToDate(value).getTime());
    }

    public Timestamp toTimestamp(Object value) throws AxionException {
        return new Timestamp(this.convertToDate(value).getTime());
    }

    public Object read(DataInput in) throws IOException {
        java.sql.Date result = null;
        int nanos = in.readInt();
        if (Integer.MIN_VALUE != nanos) {
            long millis = in.readLong();
            result = new java.sql.Date(millis);
        }
        return result;
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeInt(Integer.MIN_VALUE);
        } else {
            try {
                java.sql.Date val = (java.sql.Date)this.convert(value);
                out.writeInt(0);
                out.writeLong(val.getTime());
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTimeZone(String id) {
        TimeZone tZone = TimeZone.getTimeZone(id);
        if (tZone != null) {
            Object object = LOCK_DATE_PARSING;
            synchronized (object) {
                for (int i = 0; i < DATE_PARSING_FORMATS.length; ++i) {
                    DATE_PARSING_FORMATS[i].setTimeZone(tZone);
                }
            }
            object = LOCK_DATE_FORMATTING;
            synchronized (object) {
                ISO_DATE_FORMAT.setTimeZone(tZone);
            }
        }
    }

    static {
        for (int i = 0; i < DATE_PARSING_FORMATS.length; ++i) {
            DATE_PARSING_FORMATS[i].setLenient(false);
        }
    }
}

