/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseDataType;

public class TimestampType
extends BaseDataType
implements Comparator {
    public static final Locale LOCALE = Locale.UK;
    private static TimeZone TIMEZONE = TimeZone.getDefault();
    private static final Object LOCK_TIMESTAMP_PARSING = new Object();
    private static final Object LOCK_TIMESTAMP_FORMATTING = new Object();
    private static final DateFormat[] TIMESTAMP_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", LOCALE), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", LOCALE), new SimpleDateFormat("yyyy-MM-dd", LOCALE), new SimpleDateFormat("MM-dd-yyyy HH:mm:ss.SSS", LOCALE), new SimpleDateFormat("MM-dd-yyyy HH:mm:ss", LOCALE), new SimpleDateFormat("MM-dd-yyyy", LOCALE), new SimpleDateFormat("HH:mm:ss", LOCALE), new SimpleDateFormat("dd-MM-yyyy HH:mm:ss", LOCALE), new SimpleDateFormat("dd-MM-yyyy", LOCALE), new SimpleDateFormat("dd-MMM-yy HH:mm:ss", LOCALE), new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", LOCALE), new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS", LOCALE), new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", LOCALE), new SimpleDateFormat("MM/dd/yyyy", LOCALE), new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS", LOCALE), new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", LOCALE), new SimpleDateFormat("dd/MM/yyyy", LOCALE), DateFormat.getTimeInstance(3, LOCALE)};
    private int _precision = 10;
    private static final SimpleDateFormat ISO_TIMESTAMP_FORMATTING_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", LOCALE);
    int columnDisplaySize = 29;
    private static final long serialVersionUID = -4933113827044335868L;

    public int getJdbcType() {
        return 93;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Long";
    }

    public String toString() {
        return "timestamp";
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public void setColumnDisplaySize(int colDispSize) {
        this.columnDisplaySize = colDispSize;
    }

    public int getPrecision() {
        return this._precision;
    }

    public void setPrecision(int newPrec) {
        this._precision = newPrec;
    }

    public boolean accepts(Object value) {
        if (null == value) {
            return true;
        }
        if (value instanceof Number) {
            return true;
        }
        if (value instanceof Date) {
            return true;
        }
        return value instanceof String;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof Number) {
            return new Timestamp(((Number)value).longValue());
        }
        if (value instanceof Timestamp) {
            return value;
        }
        if (value instanceof java.sql.Date) {
            return new Timestamp(((java.sql.Date)value).getTime());
        }
        if (value instanceof Time) {
            return new Timestamp(((Time)value).getTime());
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof String) {
            Date dVal = null;
            for (int i = 0; dVal == null && i < TIMESTAMP_PARSING_FORMATS.length; ++i) {
                Object object = LOCK_TIMESTAMP_PARSING;
                synchronized (object) {
                    dVal = TIMESTAMP_PARSING_FORMATS[i].parse((String)value, new ParsePosition(0));
                    continue;
                }
            }
            if (dVal == null) {
                throw new AxionException(22007);
            }
            this.setColumnDisplaySize(((String)value).length());
            this.setPrecision(((String)value).length());
            return new Timestamp(dVal.getTime());
        }
        throw new AxionException(22007);
    }

    public BigDecimal toBigDecimal(Object value) throws AxionException {
        Timestamp tval;
        try {
            tval = (Timestamp)this.convert(value);
        }
        catch (AxionException e) {
            throw new AxionException("Can't convert \"" + value + "\" to BigDecimal.", e);
        }
        long time_ms = tval.getTime();
        long time_ns = tval.getNanos() / 1000000;
        Long time = new Long(time_ms + time_ns);
        return super.toBigDecimal(time);
    }

    private Timestamp convertToTimestamp(Object value) throws AxionException {
        try {
            Timestamp tval = (Timestamp)this.convert(value);
            return tval;
        }
        catch (IllegalArgumentException e) {
            throw new AxionException("Can't convert \"" + value + "\" to Timestamp.", e);
        }
    }

    public java.sql.Date toDate(Object value) throws AxionException {
        return new java.sql.Date(this.convertToTimestamp(value).getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Object value) throws AxionException {
        Timestamp val = this.convertToTimestamp(value);
        if (val == null) {
            return null;
        }
        String ret = null;
        Object object = LOCK_TIMESTAMP_FORMATTING;
        synchronized (object) {
            ret = ISO_TIMESTAMP_FORMATTING_FORMAT.format(val);
        }
        return ret;
    }

    public Timestamp toTimestamp(Object value) throws AxionException {
        return this.convertToTimestamp(value);
    }

    public Time toTime(Object value) throws AxionException {
        return new Time(this.convertToTimestamp(value).getTime());
    }

    public boolean supportsSuccessor() {
        return true;
    }

    public Object successor(Object value) throws IllegalArgumentException {
        Timestamp v = (Timestamp)value;
        Timestamp result = new Timestamp(v.getTime());
        if (v.getNanos() == 999999999) {
            result.setTime(result.getTime() + 1L);
            result.setNanos(0);
        } else {
            result.setNanos(v.getNanos() + 1);
        }
        return result;
    }

    public Object read(DataInput in) throws IOException {
        Timestamp result = null;
        int nanos = in.readInt();
        if (Integer.MIN_VALUE != nanos) {
            long time = in.readLong();
            result = new Timestamp(time);
            result.setNanos(nanos);
        }
        return result;
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeInt(Integer.MIN_VALUE);
        } else {
            try {
                Timestamp val = (Timestamp)this.convert(value);
                out.writeInt(val.getNanos());
                out.writeLong(val.getTime());
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public DataType makeNewInstance() {
        return new TimestampType();
    }

    public int compare(Object left, Object right) {
        long leftmillis = this.getMillis(left);
        int leftnanos = this.getNanos(left);
        long rightmillis = this.getMillis(right);
        int rightnanos = this.getNanos(right);
        if (leftmillis == rightmillis) {
            if (leftnanos > rightnanos) {
                return 1;
            }
            if (leftnanos == rightnanos) {
                return 0;
            }
            return -1;
        }
        if (leftmillis > rightmillis) {
            return 1;
        }
        return -1;
    }

    private long getMillis(Object obj) {
        return ((Date)obj).getTime();
    }

    private int getNanos(Object obj) {
        if (obj instanceof Timestamp) {
            return ((Timestamp)obj).getNanos();
        }
        return 0;
    }

    protected Comparator getComparator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTimeZone(String id) {
        TimeZone tZone = TimeZone.getTimeZone(id);
        if (tZone != null) {
            Object object = LOCK_TIMESTAMP_PARSING;
            synchronized (object) {
                TIMEZONE = tZone;
                for (int i = 0; i < TIMESTAMP_PARSING_FORMATS.length; ++i) {
                    TIMESTAMP_PARSING_FORMATS[i].setTimeZone(TIMEZONE);
                }
            }
            object = LOCK_TIMESTAMP_FORMATTING;
            synchronized (object) {
                ISO_TIMESTAMP_FORMATTING_FORMAT.setTimeZone(TIMEZONE);
            }
        }
    }

    public static TimeZone getTimeZone() {
        return TIMEZONE;
    }

    static {
        for (int i = 0; i < TIMESTAMP_PARSING_FORMATS.length; ++i) {
            TIMESTAMP_PARSING_FORMATS[i].setLenient(false);
        }
    }
}

