/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBundles
extends Task {
    private static HashSet knownKeys;
    private static String[] moduleKeys;
    private File srcdir;

    public void setSrcdir(File f) {
        if (!f.isDirectory()) {
            throw new IllegalArgumentException(f + " must be a directory");
        }
        this.srcdir = f;
    }

    public void execute() throws BuildException {
        this.log("Scanning " + this.srcdir.getAbsolutePath(), 3);
        Map<String, File> knownNames = this.parseManifest(this.srcdir);
        ArrayList<File> bundles = new ArrayList<File>();
        TreeMap<File, String[]> sources = new TreeMap<File, String[]>();
        try {
            File dir = new File(this.srcdir, "src");
            if (dir.exists()) {
                this.scanSubdirs(dir, bundles, sources);
            }
            if ((dir = new File(this.srcdir, "libsrc")).exists()) {
                this.scanSubdirs(dir, bundles, sources);
            }
            this.check(bundles, sources, knownNames);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void scan(File file, Collection<File> bundles, Map<File, String[]> sources) throws Exception {
        File bundle = new File(file, "Bundle.properties");
        if (!bundle.exists()) {
            this.log("No bundle in " + file.getAbsolutePath() + ". OK", 3);
        } else {
            bundles.add(bundle);
        }
        this.addSources(file, sources);
    }

    private void check(Collection<File> bundles, Map<File, String[]> files, Map<String, File> knownNames) {
        try {
            for (File bundle : bundles) {
                for (Map.Entry<String, Integer> entry : this.entries(bundle).entrySet()) {
                    String key = entry.getKey();
                    int line = entry.getValue();
                    this.log("Looking for " + key, 4);
                    boolean found = false;
                    if (bundle.equals(knownNames.get(key))) {
                        this.log("Checked name " + key + " OK", 3);
                        found = true;
                    } else {
                        for (String src : files.get(bundle.getParentFile())) {
                            if (src.indexOf("\"" + key + "\"") < 0) continue;
                            this.log("Checking " + key + " OK", 3);
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    block5: for (Map.Entry<File, String[]> entry2 : files.entrySet()) {
                        File dir = entry2.getKey();
                        for (String src : entry2.getValue()) {
                            if (src.indexOf("\"" + key + "\"") < 0) continue;
                            this.log(bundle.getPath() + ":" + line + ": " + key + " used from " + dir.getPath(), 1);
                            found = true;
                            continue block5;
                        }
                    }
                    if (found) continue;
                    this.log(bundle.getPath() + ":" + line + ": " + key + " NOT FOUND");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void scanSubdirs(File file, Collection<File> bundles, Map<File, String[]> srcs) throws Exception {
        this.log("scanSubdirs " + file, 4);
        File[] subdirs = file.listFiles(new FilenameFilter(){

            public boolean accept(File f, String name) {
                return new File(f, name).isDirectory();
            }
        });
        for (int i = 0; i < subdirs.length; ++i) {
            this.scan(subdirs[i], bundles, srcs);
            this.scanSubdirs(subdirs[i], bundles, srcs);
        }
    }

    private void addSources(File dir, Map<File, String[]> map) throws Exception {
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
        String[] srcs = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            int len;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(files[i]));
            byte[] arr = new byte[2048];
            srcs[i] = "";
            while ((len = ((InputStream)is).read(arr)) != -1) {
                srcs[i] = srcs[i] + new String(arr, 0, len);
            }
        }
        map.put(dir, srcs);
    }

    private Map<String, Integer> entries(File bundle) throws IOException {
        String l;
        LinkedHashMap<String, Integer> entries = new LinkedHashMap<String, Integer>();
        BufferedReader r = new BufferedReader(new FileReader(bundle));
        boolean multi = false;
        int line = 0;
        while ((l = r.readLine()) != null) {
            ++line;
            if (l.startsWith("#")) continue;
            int i = l.indexOf(61);
            if (i > 0 && !multi) {
                String key = l.substring(0, i).trim();
                entries.put(key, line);
            }
            if (l.endsWith("\\")) {
                multi = true;
                continue;
            }
            multi = false;
        }
        return entries;
    }

    private Map<String, File> parseManifest(File dir) {
        HashMap<String, File> files = new HashMap<String, File>(10);
        try {
            String lb;
            File mf = new File(this.srcdir, "manifest.mf");
            if (!mf.exists()) {
                this.log("Manifest file not found", 3);
                return files;
            }
            this.log("Found manifest", 3);
            Manifest m = new Manifest(new FileInputStream(mf));
            Attributes attr = m.getMainAttributes();
            String string = lb = attr == null ? null : attr.getValue("OpenIDE-Module-Localizing-Bundle");
            if (lb != null) {
                File lbundle = new File(this.srcdir.getAbsolutePath() + File.separator + "src" + File.separatorChar + lb);
                this.log("Recognized localizing bundle " + lbundle, 3);
                for (int i = 0; i < moduleKeys.length; ++i) {
                    files.put(moduleKeys[i], lbundle);
                }
            }
            String xml = attr == null ? null : attr.getValue("OpenIDE-Module-Layer");
            File xmlFile = null;
            if (xml != null) {
                xmlFile = new File(this.srcdir.getAbsolutePath() + File.separator + "src" + File.separator + xml);
            }
            if (xmlFile != null && xmlFile.exists()) {
                SAXParserFactory f = SAXParserFactory.newInstance();
                f.setValidating(false);
                SAXParser p = f.newSAXParser();
                XMLReader reader = p.getXMLReader();
                reader.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) {
                        CheckBundles.this.log("resolveEntity " + publicId + ", " + systemId, 4);
                        return new InputSource(new ByteArrayInputStream(new byte[0]));
                    }
                });
                reader.setContentHandler(new SAXHandler(files));
                reader.parse(new InputSource(xmlFile.toURI().toString()));
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        return files;
    }

    static {
        moduleKeys = new String[]{"OpenIDE-Module-Name", "OpenIDE-Module-Display-Category", "OpenIDE-Module-Long-Description", "OpenIDE-Module-Short-Description", "OpenIDE-Module-Package-Dependency-Message"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SAXHandler
    extends DefaultHandler {
        private String path;
        private Map<String, File> map;

        public SAXHandler(Map<String, File> map) {
            this.map = map;
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.path = "";
        }

        @Override
        public void endElement(String uri, String lname, String name) throws SAXException {
            super.endElement(uri, lname, name);
            if ("folder".equals(name) || "file".equals(name)) {
                int i = this.path.lastIndexOf(47);
                this.path = i > 0 ? this.path.substring(0, i) : "";
            }
        }

        @Override
        public void startElement(String uri, String lname, String name, org.xml.sax.Attributes attributes) throws SAXException {
            String a;
            super.startElement(uri, lname, name, attributes);
            if ("folder".equals(name) || "file".equals(name)) {
                String f = attributes.getValue("name");
                if (name != null) {
                    this.path = this.path + (this.path.length() == 0 ? f : "/" + f);
                }
            } else if ("attr".equals(name) && "SystemFileSystem.localizingBundle".equals(a = attributes.getValue("name"))) {
                String val = attributes.getValue("stringvalue");
                String lfilename = CheckBundles.this.srcdir.getAbsolutePath() + File.separator + "src" + File.separator + val.replace('.', File.separatorChar) + ".properties";
                File lfile = new File(lfilename);
                CheckBundles.this.log("Recognized file " + this.path + " with name localized in " + lfile, 3);
                for (int i = 0; i < moduleKeys.length; ++i) {
                    this.map.put(this.path, lfile);
                }
            }
        }
    }
}

