/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.help.HelpSet;
import javax.help.HelpSetFactory;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.help.TreeItemFactory;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.netbeans.nbbuild.CheckLinks;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CheckHelpSets
extends Task {
    private List<FileSet> filesets = new ArrayList<FileSet>();

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        for (FileSet fs : this.filesets) {
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            File dir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File helpset = new File(dir, files[i]);
                try {
                    this.checkHelpSet(helpset);
                    continue;
                }
                catch (BuildException be) {
                    throw be;
                }
                catch (Exception e) {
                    throw new BuildException("Error checking helpset", (Throwable)e, new Location(helpset.getAbsolutePath()));
                }
            }
        }
    }

    private void checkHelpSet(File hsfile) throws Exception {
        this.log("Checking helpset: " + hsfile);
        HelpSet hs = new HelpSet(null, hsfile.toURI().toURL());
        Map map = hs.getCombinedMap();
        this.log("Parsed helpset, checking map IDs in TOC/Index navigators...");
        NavigatorView[] navs = hs.getNavigatorViews();
        for (int i = 0; i < navs.length; ++i) {
            String name = navs[i].getName();
            File navfile = new File(hsfile.getParentFile(), (String)navs[i].getParameters().get("data"));
            if (!navfile.exists()) {
                throw new BuildException("Navigator " + name + " not found", new Location(navfile.getAbsolutePath()));
            }
            if (navs[i] instanceof IndexView) {
                this.log("Checking index navigator " + name, 3);
                IndexView.parse((URL)navfile.toURI().toURL(), (HelpSet)hs, (Locale)Locale.getDefault(), (TreeItemFactory)new VerifyTIFactory(hs, map, navfile, false));
                continue;
            }
            if (navs[i] instanceof TOCView) {
                this.log("Checking TOC navigator " + name, 3);
                TOCView.parse((URL)navfile.toURI().toURL(), (HelpSet)hs, (Locale)Locale.getDefault(), (TreeItemFactory)new VerifyTIFactory(hs, map, navfile, true));
                continue;
            }
            this.log("Skipping non-TOC/Index view: " + name, 3);
        }
        this.log("Checking for duplicate map IDs...");
        HelpSet.parse((URL)hsfile.toURI().toURL(), null, (HelpSetFactory)new VerifyHSFactory());
        this.log("Checking links from help map and between HTML files...");
        Enumeration e = map.getAllIDs();
        HashSet<URI> okurls = new HashSet<URI>(1000);
        HashSet<URI> badurls = new HashSet<URI>(1000);
        HashSet<URI> cleanurls = new HashSet<URI>(1000);
        while (e.hasMoreElements()) {
            Map.ID id = (Map.ID)e.nextElement();
            URL u = map.getURLFromID(id);
            if (u == null) {
                throw new BuildException("Bogus map ID: " + id.id, new Location(hsfile.getAbsolutePath()));
            }
            this.log("Checking ID " + id.id, 3);
            ArrayList<String> errors = new ArrayList<String>();
            CheckLinks.scan(this, null, null, id.id, "", u.toURI(), okurls, badurls, cleanurls, false, false, false, 2, Collections.<Mapper>emptyList(), errors);
            for (String error : errors) {
                this.log(error, 1);
            }
        }
    }

    private final class VerifyHSFactory
    extends HelpSet.DefaultHelpSetFactory {
        private Set<String> ids = new HashSet<String>(1000);

        private VerifyHSFactory() {
        }

        public void processMapRef(HelpSet hs, Hashtable attrs) {
            try {
                URL map = new URL(hs.getHelpSetURL(), (String)attrs.get("location"));
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(false);
                SAXParser parser = factory.newSAXParser();
                parser.parse(new InputSource(map.toExternalForm()), (DefaultHandler)new Handler(map.getFile()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private final class Handler
        extends DefaultHandler {
            private final String map;

            public Handler(String map) {
                this.map = map;
            }

            public void startElement(String uri, String lname, String name, Attributes attributes) throws SAXException {
                String target;
                if (name.equals("mapID") && (target = attributes.getValue("target")) != null) {
                    if (VerifyHSFactory.this.ids.add(target)) {
                        CheckHelpSets.this.log("Found map ID: " + target, 4);
                    } else {
                        CheckHelpSets.this.log(this.map + ": duplicated ID: " + target, 1);
                    }
                }
            }

            public InputSource resolveEntity(String pub, String sys) throws SAXException {
                if (pub.equals("-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN") || pub.equals("-//Sun Microsystems Inc.//DTD JavaHelp Map Version 2.0//EN")) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
                return null;
            }
        }
    }

    private final class VerifyTIFactory
    implements TreeItemFactory {
        private final HelpSet hs;
        private final Map map;
        private final File navfile;
        private final boolean toc;

        public VerifyTIFactory(HelpSet hs, Map map, File navfile, boolean toc) {
            this.hs = hs;
            this.map = map;
            this.navfile = navfile;
            this.toc = toc;
        }

        public TreeItem createItem(String str, Hashtable hashtable, HelpSet helpSet, Locale locale) {
            String target = (String)hashtable.get("target");
            if (target != null) {
                if (!this.map.isValidID(target, this.hs)) {
                    CheckHelpSets.this.log(this.navfile + ": invalid map ID: " + target, 1);
                } else {
                    CheckHelpSets.this.log("OK map ID: " + target, 3);
                }
            }
            return this.createItem();
        }

        public Enumeration listMessages() {
            return Collections.enumeration(Collections.emptyList());
        }

        public void processPI(HelpSet helpSet, String str, String str2) {
        }

        public void reportMessage(String str, boolean param) {
            CheckHelpSets.this.log(str, param ? 3 : 1);
        }

        public void processDOCTYPE(String str, String str1, String str2) {
        }

        public void parsingStarted(URL uRL) {
        }

        public DefaultMutableTreeNode parsingEnded(DefaultMutableTreeNode defaultMutableTreeNode) {
            return defaultMutableTreeNode;
        }

        public TreeItem createItem() {
            if (this.toc) {
                return new TOCItem();
            }
            return new IndexItem();
        }
    }
}

