/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.IndexItem;
import javax.help.Map;
import javax.help.TOCItem;
import javax.help.TreeItem;
import javax.help.TreeItemFactory;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.netbeans.nbbuild.CheckLinks;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckHelpSetsBin
extends Task {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private ClassLoader globalClassLoader;
    private java.util.Map<String, ClassLoader> classLoaderMap;
    private Set<String> excludedModulesSet;

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    private URLClassLoader createGlobalClassLoader(File dir, String[] files) {
        int i;
        ArrayList globalFileList = new ArrayList();
        URL[] globalClassPath = null;
        for (i = 0; i < files.length; ++i) {
            ArrayList<File> fileList = new ArrayList<File>();
            File moduleJar = new File(dir, files[i]);
            fileList.add(moduleJar);
            boolean hsFound = false;
            JarFile jar = null;
            Manifest manifest = null;
            try {
                jar = new JarFile(moduleJar);
                manifest = jar.getManifest();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (manifest == null) {
                this.log("Manifest is not present in jar. Skipping.", 1);
                continue;
            }
            File parent = moduleJar.getParentFile();
            Attributes attrs = manifest.getMainAttributes();
            String value = attrs.getValue("OpenIDE-Module");
            if (value == null) {
                this.log("Attribute OpenIDE-Module is not present in manifest. Skipping.", 1);
                continue;
            }
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                JarEntry je = en.nextElement();
                if (!je.getName().endsWith(".hs")) continue;
                hsFound = true;
            }
            value = attrs.getValue("Class-Path");
            if (value != null) {
                StringTokenizer tok = new StringTokenizer(value);
                while (tok.hasMoreElements()) {
                    String s = tok.nextToken();
                    File extJar = new File(parent, s);
                    fileList.add(extJar);
                    try {
                        jar = new JarFile(extJar);
                    }
                    catch (IOException ex) {
                        this.log("Error: Cannot open file: " + extJar, 1);
                        ex.printStackTrace();
                    }
                    Enumeration<JarEntry> en2 = jar.entries();
                    while (en2.hasMoreElements()) {
                        JarEntry je = en2.nextElement();
                        if (!je.getName().endsWith(".hs")) continue;
                        hsFound = true;
                    }
                }
            }
            if (!hsFound) continue;
            globalFileList.addAll(fileList);
        }
        globalClassPath = new URL[globalFileList.size()];
        for (i = 0; i < globalFileList.size(); ++i) {
            try {
                globalClassPath[i] = ((File)globalFileList.get(i)).toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return new URLClassLoader(globalClassPath, ((Object)((Object)this)).getClass().getClassLoader().getParent(), new NbDocsStreamHandler.Factory());
    }

    private java.util.Map<String, ClassLoader> createClassLoaderMap(File dir, String[] files) {
        HashMap<String, ClassLoader> m = new HashMap<String, ClassLoader>();
        for (int i = 0; i < files.length; ++i) {
            String key;
            ArrayList<File> fileList = new ArrayList<File>();
            File moduleJar = new File(dir, files[i]);
            fileList.add(moduleJar);
            boolean hsFound = false;
            URL[] classPath = null;
            JarFile jar = null;
            Manifest manifest = null;
            try {
                jar = new JarFile(moduleJar);
                manifest = jar.getManifest();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (manifest == null) {
                this.log("Manifest is not present in jar. Skipping.", 1);
                continue;
            }
            File parent = moduleJar.getParentFile();
            Attributes attrs = manifest.getMainAttributes();
            String value = attrs.getValue("Class-Path");
            if (value != null) {
                StringTokenizer tok = new StringTokenizer(value);
                while (tok.hasMoreElements()) {
                    String s = tok.nextToken();
                    File extJar = new File(parent, s);
                    fileList.add(extJar);
                }
                classPath = new URL[fileList.size()];
                for (int j = 0; j < fileList.size(); ++j) {
                    try {
                        classPath[j] = ((File)fileList.get(j)).toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if ((key = attrs.getValue("OpenIDE-Module")) == null) {
                this.log("Attribute OpenIDE-Module is not present in manifest. Skipping.", 1);
                continue;
            }
            int pos = key.indexOf("/");
            if (pos != -1) {
                key = key.substring(0, pos);
            }
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                JarEntry je = en.nextElement();
                if (!je.getName().endsWith(".hs")) continue;
                hsFound = true;
            }
            value = attrs.getValue("Class-Path");
            if (value != null) {
                StringTokenizer tok = new StringTokenizer(value);
                while (tok.hasMoreElements()) {
                    String s = tok.nextToken();
                    File extJar = new File(parent, s);
                    try {
                        jar = new JarFile(extJar);
                    }
                    catch (IOException ex) {
                        this.log("Error: Cannot open file: " + extJar, 1);
                        ex.printStackTrace();
                    }
                    Enumeration<JarEntry> en2 = jar.entries();
                    while (en2.hasMoreElements()) {
                        JarEntry je = en2.nextElement();
                        if (!je.getName().endsWith(".hs")) continue;
                        hsFound = true;
                    }
                }
            }
            if (!hsFound) continue;
            ClassLoader clParent = ((Object)((Object)this)).getClass().getClassLoader().getParent();
            URLClassLoader moduleClassLoader = new URLClassLoader(classPath, clParent, new NbDocsStreamHandler.Factory());
            m.put(key, moduleClassLoader);
        }
        return m;
    }

    private Set<String> parseExcludeModulesProperty(String prop) {
        this.excludedModulesSet = new HashSet<String>();
        if (prop == null) {
            return this.excludedModulesSet;
        }
        String[] arr = prop.split(",");
        for (int i = 0; i < arr.length; ++i) {
            this.excludedModulesSet.add(arr[i]);
        }
        return this.excludedModulesSet;
    }

    public void execute() throws BuildException {
        try {
            URL.setURLStreamHandlerFactory(new NbDocsStreamHandler.Factory());
        }
        catch (Error ex) {
            this.log("StreamHandlerFactory already set", 1);
        }
        String p = this.getProject().getProperty("javahelpbin.exclude.modules");
        this.excludedModulesSet = this.parseExcludeModulesProperty(p);
        for (FileSet fs : this.filesets) {
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            File dir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            this.globalClassLoader = this.createGlobalClassLoader(dir, files);
            this.classLoaderMap = this.createClassLoaderMap(dir, files);
            for (int i = 0; i < files.length; ++i) {
                ArrayList<File> fileList = new ArrayList<File>();
                File moduleJar = new File(dir, files[i]);
                fileList.add(moduleJar);
                Object classPath = null;
                JarFile jar = null;
                Manifest manifest = null;
                try {
                    jar = new JarFile(moduleJar);
                    manifest = jar.getManifest();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                if (manifest == null) {
                    this.log("Manifest is not present in jar. Skipping.", 1);
                    continue;
                }
                File parent = moduleJar.getParentFile();
                Attributes attrs = manifest.getMainAttributes();
                String key = attrs.getValue("OpenIDE-Module");
                if (key == null) {
                    this.log("Attribute OpenIDE-Module is not present in manifest. Skipping.", 1);
                    continue;
                }
                int pos = key.indexOf("/");
                if (pos != -1) {
                    key = key.substring(0, pos);
                }
                if (this.excludedModulesSet.contains(key)) {
                    this.log("", 1);
                    this.log("* * * *", 1);
                    this.log("Skip module: " + key, 1);
                    this.log("* * * *", 1);
                    continue;
                }
                URLClassLoader classLoader = (URLClassLoader)this.classLoaderMap.get(key);
                if (classLoader == null) continue;
                this.log("", 1);
                this.log("* * * *", 1);
                this.log("Parsing module: " + key, 1);
                this.log("* * * *", 1);
                Enumeration<JarEntry> en = jar.entries();
                while (en.hasMoreElements()) {
                    JarEntry je = en.nextElement();
                    if (!je.getName().endsWith(".hs")) continue;
                    URLClassLoader moduleClassLoader = (URLClassLoader)this.classLoaderMap.get(key);
                    URL hsURL = moduleClassLoader.findResource(je.getName());
                    this.checkHelpSetURL(hsURL, this.globalClassLoader, moduleClassLoader, this.classLoaderMap, moduleJar);
                }
                String value = attrs.getValue("Class-Path");
                if (value == null) continue;
                StringTokenizer tok = new StringTokenizer(value);
                while (tok.hasMoreElements()) {
                    String s = tok.nextToken();
                    File extJar = new File(parent, s);
                    try {
                        jar = new JarFile(extJar);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    Enumeration<JarEntry> en2 = jar.entries();
                    while (en2.hasMoreElements()) {
                        JarEntry je = en2.nextElement();
                        if (!je.getName().endsWith(".hs")) continue;
                        ClassLoader moduleClassLoader = this.classLoaderMap.get(key);
                        URL hsURL = moduleClassLoader.getResource(je.getName());
                        this.checkHelpSetURL(hsURL, this.globalClassLoader, moduleClassLoader, this.classLoaderMap, extJar);
                    }
                }
            }
        }
    }

    private void checkHelpSetURL(URL hsURL, ClassLoader globalClassLoader, ClassLoader moduleClassLoader, java.util.Map classLoaderMap, File extJar) {
        HelpSet hs = null;
        try {
            hs = new HelpSet(moduleClassLoader, hsURL);
        }
        catch (HelpSetException ex) {
            ex.printStackTrace();
        }
        Map map = hs.getCombinedMap();
        Enumeration e = map.getAllIDs();
        HashSet<URI> okurls = new HashSet<URI>(1000);
        HashSet<URI> badurls = new HashSet<URI>(1000);
        HashSet<URI> cleanurls = new HashSet<URI>(1000);
        while (e.hasMoreElements()) {
            Map.ID id = (Map.ID)e.nextElement();
            URL u = null;
            try {
                u = id.getURL();
            }
            catch (MalformedURLException ex) {
                this.log("id:" + id, 1);
                ex.printStackTrace();
            }
            if (u == null) {
                throw new BuildException("Bogus map ID: " + id.id, new Location(extJar.getAbsolutePath()));
            }
            this.log("Checking ID " + id.id, 3);
            try {
                ArrayList<String> errors = new ArrayList<String>();
                CheckLinks.scan(this, globalClassLoader, classLoaderMap, id.id, "", new URI(u.toExternalForm()), okurls, badurls, cleanurls, false, false, false, 2, Collections.<Mapper>emptyList(), errors);
                for (String error : errors) {
                    this.log(error, 1);
                }
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class NbDocsStreamHandler
    extends URLStreamHandler {
        protected URLConnection openConnection(URL u) throws IOException {
            if (u.getProtocol().equals("nbdocs")) {
                return new NbDocsURLConnection(u);
            }
            throw new IOException();
        }

        private static class NbDocsURLConnection
        extends URLConnection {
            private URLConnection real = null;
            private IOException exception = null;

            public NbDocsURLConnection(URL u) {
                super(u);
            }

            public synchronized void connect() throws IOException {
                if (this.exception != null) {
                    IOException e = this.exception;
                    this.exception = null;
                    throw e;
                }
                if (!this.connected) {
                    this.real.connect();
                    this.connected = true;
                }
            }

            private void tryToConnect() {
                if (this.connected || this.exception != null) {
                    return;
                }
                try {
                    this.connect();
                }
                catch (IOException ioe) {
                    this.exception = ioe;
                }
            }

            public String getHeaderField(int n) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderField(n);
                }
                return null;
            }

            public String getHeaderFieldKey(int n) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderFieldKey(n);
                }
                return null;
            }

            public String getHeaderField(String key) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderField(key);
                }
                return null;
            }

            public InputStream getInputStream() throws IOException {
                this.connect();
                return this.real.getInputStream();
            }

            public OutputStream getOutputStream() throws IOException {
                this.connect();
                return this.real.getOutputStream();
            }

            public String getContentType() {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getContentType();
                }
                return "application/octet-stream";
            }

            public int getContentLength() {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getContentLength();
                }
                return 0;
            }
        }

        public static class Factory
        implements URLStreamHandlerFactory {
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if (protocol.equals("nbdocs")) {
                    return new NbDocsStreamHandler();
                }
                return null;
            }
        }
    }

    private final class VerifyHSFactory
    extends HelpSet.DefaultHelpSetFactory {
        private Set<String> ids = new HashSet<String>(1000);

        private VerifyHSFactory() {
        }

        public void processMapRef(HelpSet hs, Hashtable attrs) {
            try {
                URL map = new URL(hs.getHelpSetURL(), (String)attrs.get("location"));
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(false);
                SAXParser parser = factory.newSAXParser();
                parser.parse(new InputSource(map.toExternalForm()), (DefaultHandler)new Handler(map.getFile()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private final class Handler
        extends DefaultHandler {
            private final String map;

            public Handler(String map) {
                this.map = map;
            }

            public void startElement(String uri, String lname, String name, org.xml.sax.Attributes attributes) throws SAXException {
                String target;
                if (name.equals("mapID") && (target = attributes.getValue("target")) != null) {
                    if (VerifyHSFactory.this.ids.add(target)) {
                        CheckHelpSetsBin.this.log("Found map ID: " + target, 4);
                    } else {
                        CheckHelpSetsBin.this.log(this.map + ": duplicated ID: " + target, 1);
                    }
                }
            }

            public InputSource resolveEntity(String pub, String sys) throws SAXException {
                if (pub.equals("-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN") || pub.equals("-//Sun Microsystems Inc.//DTD JavaHelp Map Version 2.0//EN")) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
                return null;
            }
        }
    }

    private final class VerifyTIFactory
    implements TreeItemFactory {
        private final HelpSet hs;
        private final Map map;
        private final File navfile;
        private final boolean toc;

        public VerifyTIFactory(HelpSet hs, Map map, File navfile, boolean toc) {
            this.hs = hs;
            this.map = map;
            this.navfile = navfile;
            this.toc = toc;
        }

        public TreeItem createItem(String str, Hashtable hashtable, HelpSet helpSet, Locale locale) {
            String target = (String)hashtable.get("target");
            if (target != null) {
                if (!this.map.isValidID(target, this.hs)) {
                    CheckHelpSetsBin.this.log(this.navfile + ": invalid map ID: " + target, 1);
                } else {
                    CheckHelpSetsBin.this.log("OK map ID: " + target, 3);
                }
            }
            return this.createItem();
        }

        public Enumeration listMessages() {
            return Collections.enumeration(Collections.emptyList());
        }

        public void processPI(HelpSet helpSet, String str, String str2) {
        }

        public void reportMessage(String str, boolean param) {
            CheckHelpSetsBin.this.log(str, param ? 3 : 1);
        }

        public void processDOCTYPE(String str, String str1, String str2) {
        }

        public void parsingStarted(URL uRL) {
        }

        public DefaultMutableTreeNode parsingEnded(DefaultMutableTreeNode defaultMutableTreeNode) {
            return defaultMutableTreeNode;
        }

        public TreeItem createItem() {
            if (this.toc) {
                return new TOCItem();
            }
            return new IndexItem();
        }
    }
}

