/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class CheckLicense
extends Task {
    private final List<FileSet> filesets = new ArrayList<FileSet>(1);
    private String fragment;
    private List<Convert> fragments;
    private FailType fail;

    public void addFileSet(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setFragment(String f) {
        this.fragment = f;
    }

    public void setFail(FailType t) {
        this.fail = t;
    }

    public Convert createConvert() {
        Convert f = new Convert();
        if (this.fragments == null) {
            this.fragments = new ArrayList<Convert>();
        }
        this.fragments.add(f);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.fragment == null) {
            if (this.fragments == null) {
                throw new BuildException("You must supply a fragment", this.getLocation());
            }
            this.executeReplace();
            return;
        }
        if (this.filesets.isEmpty()) {
            throw new BuildException("You must supply at least one fileset", this.getLocation());
        }
        Iterator<FileSet> it = this.filesets.iterator();
        String failMsg = null;
        try {
            while (it.hasNext()) {
                DirectoryScanner scanner = it.next().getDirectoryScanner(this.getProject());
                File baseDir = scanner.getBasedir();
                String[] files = scanner.getIncludedFiles();
                this.log("Looking for " + this.fragment + " in " + files.length + " files in " + baseDir.getAbsolutePath());
                for (int i = 0; i < files.length; ++i) {
                    File f = new File(baseDir, files[i]);
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            if (line.indexOf(this.fragment) == -1) continue;
                            if (this.fail == null || !"whenpresent".equals(this.fail.getValue())) break;
                            if (failMsg != null) {
                                this.log(failMsg, 0);
                            }
                            failMsg = "License found in " + f;
                            break;
                        }
                        if (line != null) continue;
                        String msg = f.getAbsolutePath() + ":1: no license notice found";
                        if (this.fail != null && "whenmissing".equals(this.fail.getValue())) {
                            throw new BuildException(msg);
                        }
                        if (this.fail != null) continue;
                        this.log(msg, 0);
                        continue;
                    }
                    finally {
                        br.close();
                    }
                }
            }
            if (failMsg != null) {
                throw new BuildException(failMsg);
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Could not open files to check licenses", (Throwable)ioe, this.getLocation());
        }
    }

    private void executeReplace() throws BuildException {
        Iterator<FileSet> it = this.filesets.iterator();
        try {
            byte[] workingArray = new byte[1024];
            while (it.hasNext()) {
                DirectoryScanner scanner = it.next().getDirectoryScanner(this.getProject());
                File baseDir = scanner.getBasedir();
                String[] files = scanner.getIncludedFiles();
                this.log("Replacing code in " + files.length + " files in " + baseDir.getAbsolutePath());
                for (int i = 0; i < files.length; ++i) {
                    File file = new File(baseDir, files[i]);
                    this.log("Processing " + file, 3);
                    FileInputStream is = new FileInputStream(file);
                    int workingLength = is.read(workingArray);
                    if (workingLength == -1) continue;
                    String workingString = new String(workingArray, 0, workingLength);
                    boolean changed = false;
                    String prefix = null;
                    block4: for (Convert f : this.fragments) {
                        Matcher matcher = f.orig.matcher(workingString);
                        while (matcher.find()) {
                            if (f.prefix) {
                                if (prefix != null) {
                                    throw new BuildException("Only one convert element can be prefix!");
                                }
                                if (matcher.groupCount() != 1) {
                                    throw new BuildException("There should be one group for the prefix element. Was: " + matcher.groupCount());
                                }
                                prefix = matcher.group(1);
                            }
                            String before = workingString.substring(0, matcher.start());
                            String after = workingString.substring(matcher.end());
                            String middle = this.wrapWithPrefix(f.repl, prefix, before.length() == 0 || before.endsWith("\n"));
                            if (!middle.equals(matcher.group(0))) {
                                workingString = before + middle + after;
                                this.log("Matched " + middle, 3);
                                changed = true;
                            } else {
                                this.log("Matched, but no change: " + middle, 3);
                            }
                            if (!f.all) continue block4;
                            matcher = f.orig.matcher(workingString);
                        }
                    }
                    byte[] rest = null;
                    if (is.available() > 0 && changed) {
                        rest = new byte[is.available()];
                        int read = is.read(rest);
                        assert (read == rest.length);
                    }
                    is.close();
                    if (!changed) continue;
                    this.log("Rewriting " + file);
                    FileOutputStream os = new FileOutputStream(file);
                    workingString = Pattern.compile(" +$", 8).matcher(workingString + "X").replaceAll("");
                    os.write(workingString.substring(0, workingString.length() - 1).getBytes());
                    if (rest != null) {
                        os.write(rest);
                    }
                    os.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Could not open files to check licenses", (Throwable)ioe, this.getLocation());
        }
    }

    private String wrapWithPrefix(String repl, String prefix, boolean startWithPrefix) {
        if (prefix == null) {
            return repl;
        }
        String[] all = repl.split("\n");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < all.length; ++i) {
            if (startWithPrefix) {
                sb.append(prefix);
            }
            sb.append(all[i]);
            if (i < all.length - 1) {
                sb.append('\n');
            }
            startWithPrefix = true;
        }
        return sb.toString();
    }

    public static final class FailType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"whenmissing", "whenpresent"};
        }
    }

    public static final class Convert {
        Pattern orig;
        String repl;
        boolean prefix;
        boolean all;

        public void setToken(String orig) {
            this.orig = Pattern.compile(orig, 40);
        }

        public void setReplace(String repl) {
            this.repl = repl.replace("\\n", "\n").replace("\\t", "\t");
        }

        public void setPrefix(boolean b) {
            this.prefix = b;
        }

        public void setReplaceAll(boolean b) {
            this.all = b;
        }

        public Line createLine() {
            return new Line();
        }

        public final class Line {
            public void setText(String t) {
                Convert.this.repl = Convert.this.repl == null ? t : Convert.this.repl + "\n" + t;
            }
        }
    }
}

