/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Mapper;
import org.netbeans.nbbuild.JUnitReportWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckLinks
extends MatchingTask {
    private File basedir;
    private boolean checkexternal = true;
    private boolean checkspaces = true;
    private boolean checkforbidden = true;
    private List<Mapper> mappers = new LinkedList<Mapper>();
    private List<Filter> filters = new ArrayList<Filter>();
    private File report;
    private static Pattern hrefOrAnchor = Pattern.compile("<(a|img)(\\s+shape=\"rect\")?\\s+(href|name|src)=\"([^\"#]*)(#[^\"]+)?\"(\\s+shape=\"rect\")?\\s*/?>", 2);
    private static Pattern lineBreak = Pattern.compile("^", 8);

    public void setCheckexternal(boolean ce) {
        this.checkexternal = ce;
    }

    public void setCheckspaces(boolean s) {
        this.checkspaces = s;
    }

    public void setCheckforbidden(boolean s) {
        this.checkforbidden = s;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public Filter createFilter() {
        Filter f = new Filter();
        this.filters.add(f);
        return f;
    }

    public void setReport(File report) {
        this.report = report;
    }

    public Mapper createMapper() {
        Mapper m = new Mapper(this.getProject());
        this.mappers.add(m);
        return m;
    }

    public void execute() throws BuildException {
        if (this.basedir == null) {
            throw new BuildException("Must specify the basedir attribute");
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.basedir);
        scanner.scan();
        String message = "Scanning for broken links in " + this.basedir + " ...";
        if (!this.checkexternal) {
            message = message + " (external URLs will be skipped)";
        }
        this.log(message);
        String[] files = scanner.getIncludedFiles();
        HashSet<URI> okurls = new HashSet<URI>(1000);
        HashSet<URI> badurls = new HashSet<URI>(100);
        HashSet<URI> cleanurls = new HashSet<URI>(100);
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(this.basedir, files[i]);
            URI fileurl = file.toURI();
            this.log("Scanning " + file, 3);
            try {
                CheckLinks.scan((Task)this, null, null, this.getLocation().toString(), "", fileurl, okurls, badurls, cleanurls, this.checkexternal, this.checkspaces, this.checkforbidden, 1, this.mappers, this.filters, errors);
                continue;
            }
            catch (IOException ioe) {
                throw new BuildException("Could not scan " + file + ": " + ioe, (Throwable)ioe, this.getLocation());
            }
        }
        String testMessage = null;
        if (!errors.isEmpty()) {
            StringBuilder b = new StringBuilder("There were broken links");
            for (String error : errors) {
                b.append("\n" + error);
            }
            testMessage = b.toString();
        }
        JUnitReportWriter.writeReport((Task)this, this.report, Collections.singletonMap("testBrokenLinks", testMessage));
    }

    public static void scan(Task task, ClassLoader globalClassLoader, Map classLoaderMap, String referrer, String referrerLocation, URI u, Set<URI> okurls, Set<URI> badurls, Set<URI> cleanurls, boolean checkexternal, boolean checkspaces, boolean checkforbidden, int recurse, List<Mapper> mappers, List<String> errors) throws IOException {
        CheckLinks.scan(task, globalClassLoader, classLoaderMap, referrer, referrerLocation, u, okurls, badurls, cleanurls, checkexternal, checkspaces, checkforbidden, recurse, mappers, Collections.<Filter>emptyList(), errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void scan(Task task, ClassLoader globalClassLoader, Map classLoaderMap, String referrer, String referrerLocation, URI u, Set<URI> okurls, Set<URI> badurls, Set<URI> cleanurls, boolean checkexternal, boolean checkspaces, boolean checkforbidden, int recurse, List<Mapper> mappers, List<Filter> filters, List<String> errors) throws IOException {
        PrintWriter pw;
        StringWriter sw;
        String content;
        String mimeType;
        URI base;
        String b;
        int i;
        if (okurls.contains(u) && recurse == 0) {
            return;
        }
        if (referrer.startsWith("jar:file:") && u.getScheme() == null && !u.toString().startsWith("#")) {
            int pos;
            if (u.toString().length() == 0) {
                System.out.println("Invalid URL: Empty URL referred from: " + referrer);
                return;
            }
            if (!u.isAbsolute() && (pos = referrer.indexOf("!")) != -1) {
                String base2 = referrer.substring(0, pos + 1);
                String path1 = referrer.substring(pos + 1, referrer.length());
                File f1 = new File(path1);
                File p = f1.getParentFile();
                File f2 = new File(p, u.getPath());
                String path2 = null;
                try {
                    path2 = f2.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (System.getProperty("os.name").startsWith("Windows")) {
                    path2 = path2.substring(2).replace('\\', '/');
                }
                try {
                    u = new URI(base2 + path2);
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (u.toString().startsWith("#")) {
            try {
                u = new URI(referrer + u.toString());
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
        if ((i = (b = u.toString()).lastIndexOf(35)) != -1) {
            b = b.substring(0, i);
        }
        try {
            base = new URI(b);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        String frag = u.getFragment();
        String basepath = base.toString();
        if ("file".equals(base.getScheme())) {
            try {
                basepath = new File(base).getAbsolutePath();
            }
            catch (IllegalArgumentException e) {
                errors.add(CheckLinks.normalize(referrer, mappers) + referrerLocation + ": malformed URL: " + base + " (" + e.getLocalizedMessage() + ")");
            }
        }
        if (badurls.contains(u) || badurls.contains(base)) {
            errors.add(CheckLinks.normalize(referrer, mappers) + referrerLocation + ": broken link (already reported): " + u);
            return;
        }
        if (checkforbidden) {
            Filter f;
            Boolean decision;
            Iterator<Filter> i$ = filters.iterator();
            while (i$.hasNext() && !Boolean.TRUE.equals(decision = (f = i$.next()).isOk(u))) {
                if (!Boolean.FALSE.equals(decision)) continue;
                errors.add(CheckLinks.normalize(referrer, mappers) + referrerLocation + ": forbidden link: " + base);
                badurls.add(base);
                badurls.add(u);
                return;
            }
        }
        if (!(checkexternal || "file".equals(u.getScheme()) || "jar".equals(u.getScheme()) || "nbdocs".equals(u.getScheme()))) {
            task.log("Skipping external link: " + base, 3);
            cleanurls.add(base);
            okurls.add(base);
            okurls.add(u);
            return;
        }
        if ("nbdocs".equals(u.getScheme())) {
            URL res;
            String name;
            if (classLoaderMap == null || globalClassLoader == null) {
                return;
            }
            if (u.toURL().getHost() == null) {
                errors.add("Missing host in nbdocs protocol URL. URI: " + u);
                errors.add("Referrer: " + referrer);
                name = u.getPath();
                if (name.startsWith("/")) {
                    name = name.substring(1, name.length());
                }
                if ((res = globalClassLoader.getResource(name)) == null) {
                    errors.add("Link not found globally. URI: " + u);
                    errors.add("Referrer: " + referrer);
                    return;
                }
                try {
                    u = base = res.toURI();
                    basepath = base.toString();
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                }
                Set keySet = classLoaderMap.keySet();
                for (Object key : keySet) {
                    URL moduleRes;
                    URLClassLoader cl = (URLClassLoader)classLoaderMap.get(key);
                    if (cl == null || (moduleRes = cl.findResource(name)) == null) continue;
                    task.log("INFO: Link found in module:" + key + ". URI: " + u, 2);
                    task.log("INFO: Referrer: " + referrer, 2);
                    break;
                }
            } else {
                name = u.getPath();
                if (name.startsWith("/")) {
                    name = name.substring(1, name.length());
                }
                res = null;
                URLClassLoader moduleClassLoader = (URLClassLoader)classLoaderMap.get(u.toURL().getHost());
                if (moduleClassLoader == null) {
                    errors.add("Module " + u.toURL().getHost() + " not found among modules containing helpsets. URI: " + u);
                    errors.add("Referrer: " + referrer);
                }
                if (moduleClassLoader != null && (res = moduleClassLoader.findResource(name)) != null) {
                    try {
                        u = base = res.toURI();
                        basepath = base.toString();
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
                if (res == null) {
                    if (moduleClassLoader != null) {
                        errors.add("Link not found in module " + u.toURL().getHost() + " URI: " + u);
                        errors.add("Referrer: " + referrer);
                    }
                    if ((res = globalClassLoader.getResource(name)) == null) {
                        errors.add("Link not found globally. URI: " + u);
                        errors.add("Referrer: " + referrer);
                        return;
                    }
                    try {
                        u = base = res.toURI();
                        basepath = base.toString();
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    Set keySet = classLoaderMap.keySet();
                    for (Object key : keySet) {
                        URL moduleRes;
                        URLClassLoader cl = (URLClassLoader)classLoaderMap.get(key);
                        if (cl == null || (moduleRes = cl.findResource(name)) == null) continue;
                        task.log("INFO: Link found in module:" + key + ". URI: " + u, 2);
                        task.log("INFO: Referrer: " + referrer, 2);
                        break;
                    }
                }
            }
        }
        task.log("Checking " + u + " (recursion level " + recurse + ")", 3);
        try {
            URLConnection conn = base.toURL().openConnection();
            conn.connect();
            mimeType = conn.getContentType();
            InputStream is = conn.getInputStream();
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            try {
                int read;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((read = is.read(buf)) != -1) {
                    baos.write(buf, 0, read);
                }
                content = baos.toString(enc);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ioe) {
            errors.add(CheckLinks.normalize(referrer, mappers) + referrerLocation + ": Broken link: " + base);
            task.log("WARNING: URI: " + u, 3);
            task.log("ERROR: " + ioe, 3);
            badurls.add(base);
            badurls.add(u);
            sw = new StringWriter(500);
            pw = new PrintWriter(sw);
            ioe.printStackTrace(pw);
            task.log(sw.toString(), 3);
            return;
        }
        catch (NullPointerException exc) {
            errors.add("NPE Link referred from: " + CheckLinks.normalize(referrer, mappers) + referrerLocation + " Broken link: " + base);
            task.log("WARNING: URI: " + u);
            task.log("ERROR: " + exc, 1);
            badurls.add(base);
            badurls.add(u);
            sw = new StringWriter(500);
            pw = new PrintWriter(sw);
            exc.printStackTrace(pw);
            task.log(sw.toString(), 1);
            return;
        }
        okurls.add(base);
        HashMap<URI, String> others = null;
        if (recurse > 0 && cleanurls.add(base)) {
            others = new HashMap<URI, String>(100);
        }
        if (recurse == 0 && frag == null) {
            return;
        }
        if (!"text/html".equals(mimeType)) {
            task.log("Not checking contents of " + base, 3);
        } else {
            task.log("Parsing " + base, 3);
            Matcher m = hrefOrAnchor.matcher(content);
            HashSet<String> names = new HashSet<String>(100);
            while (m.find()) {
                String fixedUri;
                String type = m.group(3);
                if (type.equalsIgnoreCase("name")) {
                    String name = CheckLinks.unescape(m.group(4));
                    if (names.add(name)) {
                        try {
                            okurls.add(new URI(base + "#" + name.replaceAll(" ", "%20")));
                        }
                        catch (URISyntaxException e) {
                            errors.add(CheckLinks.normalize(basepath, mappers) + CheckLinks.findLocation(content, m.start(4)) + ": bad anchor name: " + e.getMessage());
                        }
                        continue;
                    }
                    if (recurse != 1) continue;
                    errors.add(CheckLinks.normalize(basepath, mappers) + CheckLinks.findLocation(content, m.start(4)) + ": duplicate anchor name: " + name);
                    continue;
                }
                int previousCommentStart = content.lastIndexOf("<!--", m.start(0));
                int previousCommentEnd = content.lastIndexOf("-->", m.start(0));
                boolean commentedOut = false;
                if (previousCommentEnd < previousCommentStart) {
                    commentedOut = true;
                }
                if (others == null || commentedOut) continue;
                String otherbase = CheckLinks.unescape(m.group(4));
                String otheranchor = CheckLinks.unescape(m.group(5));
                String uri = otheranchor == null ? otherbase : otherbase + otheranchor;
                String location = CheckLinks.findLocation(content, m.start(4));
                if (uri.indexOf(32) != -1) {
                    fixedUri = uri.replaceAll(" ", "%20");
                    if (checkspaces) {
                        errors.add(CheckLinks.normalize(basepath, mappers) + location + ": spaces in URIs should be encoded as \"%20\": " + uri);
                    }
                } else {
                    fixedUri = uri;
                }
                try {
                    URI o;
                    URI relUri = new URI(fixedUri);
                    if (relUri.isOpaque() || others.containsKey(o = base.resolve(relUri).normalize())) continue;
                    others.put(o, location);
                }
                catch (URISyntaxException e) {
                    errors.add(CheckLinks.normalize(basepath, mappers) + location + ": bad relative URI: " + e.getMessage());
                }
            }
        }
        if (!okurls.contains(u)) {
            errors.add(CheckLinks.normalize(referrer, mappers) + referrerLocation + ": broken link: " + u);
            badurls.add(u);
        }
        if (others != null) {
            for (Map.Entry entry : others.entrySet()) {
                URI other = (URI)entry.getKey();
                String location = (String)entry.getValue();
                CheckLinks.scan(task, globalClassLoader, classLoaderMap, basepath, location, other, okurls, badurls, cleanurls, checkexternal, checkspaces, checkforbidden, recurse == 1 ? 0 : 2, mappers, filters, errors);
            }
        }
    }

    private static String normalize(String path, List<Mapper> mappers) throws IOException {
        try {
            for (Mapper m : mappers) {
                String[] nue = m.getImplementation().mapFileName(path);
                if (nue == null) continue;
                for (int i = 0; i < nue.length; ++i) {
                    File f = new File(nue[i]);
                    if (!f.isFile()) continue;
                    return new File(f.toURI().normalize()).getAbsolutePath();
                }
            }
            return path;
        }
        catch (BuildException e) {
            throw new IOException(e.toString());
        }
    }

    private static String unescape(String text) {
        int search;
        if (text == null) {
            return null;
        }
        int pos = 0;
        while ((search = text.indexOf(38, pos)) != -1) {
            String repl;
            int semi = text.indexOf(59, search + 1);
            if (semi == -1) {
                return text;
            }
            String entity = text.substring(search + 1, semi);
            if (entity.equals("amp")) {
                repl = "&";
            } else if (entity.equals("quot")) {
                repl = "\"";
            } else if (entity.equals("lt")) {
                repl = "<";
            } else if (entity.equals("gt")) {
                repl = ">";
            } else if (entity.equals("apos")) {
                repl = "'";
            } else {
                pos = semi + 1;
                continue;
            }
            text = text.substring(0, search) + repl + text.substring(semi + 1);
            pos = search + repl.length();
        }
        return text;
    }

    private static String findLocation(CharSequence content, int pos) {
        Matcher lbm = lineBreak.matcher(content);
        int line = 0;
        int col = 1;
        while (lbm.find() && lbm.start() <= pos) {
            ++line;
            col = pos - lbm.start() + 1;
        }
        return ":" + line + ":" + col;
    }

    public final class Filter {
        private Boolean accept;
        private Pattern pattern;

        public void setAccept(boolean a) {
            this.accept = a;
        }

        public void setPattern(String s) {
            this.pattern = Pattern.compile(s, 2);
        }

        final Boolean isOk(URI u) throws BuildException {
            if (this.accept == null) {
                throw new BuildException("Each filter must have accept attribute");
            }
            if (this.pattern == null) {
                throw new BuildException("Each filter must have pattern attribute");
            }
            if (this.pattern.matcher(u.toString()).matches()) {
                CheckLinks.this.log("Matched " + u + " accepted: " + this.accept, 3);
                return this.accept;
            }
            return null;
        }
    }
}

