/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckModuleConfigs
extends Task {
    private File nbroot;

    public void setNbroot(File f) {
        this.nbroot = f;
    }

    public void execute() throws BuildException {
        if (this.nbroot == null) {
            throw new BuildException("Must define 'nbroot' param", this.getLocation());
        }
        File buildPropertiesFile = new File(this.nbroot, "nbbuild" + File.separatorChar + "build.properties");
        File clusterPropertiesFile = new File(this.nbroot, "nbbuild" + File.separatorChar + "cluster.properties");
        File goldenFile = new File(this.nbroot, "nbbuild" + File.separatorChar + "build" + File.separatorChar + "generated" + File.separatorChar + "moduleconfigs.txt");
        File masterProjectXml = new File(this.nbroot, "ide" + File.separatorChar + "allmodules" + File.separatorChar + "nbproject" + File.separatorChar + "project.xml");
        Hashtable properties = this.getProject().getProperties();
        Map<String, Set<String>> configs = this.loadModuleConfigs(properties, buildPropertiesFile);
        Map<String, Set<String>> clusters = this.loadModuleClusters(properties, clusterPropertiesFile);
        TreeSet<String> allClusterModules = new TreeSet<String>();
        for (Set<String> s : clusters.values()) {
            allClusterModules.addAll(s);
        }
        try {
            this.writeModuleConfigs(goldenFile, configs, buildPropertiesFile);
        }
        catch (IOException e) {
            throw new BuildException("Could not write to " + goldenFile, (Throwable)e, this.getLocation());
        }
        try {
            this.writeMasterProjectXml(masterProjectXml, allClusterModules);
        }
        catch (SAXException e) {
            throw new BuildException("Could not write to " + masterProjectXml, (Throwable)e, this.getLocation());
        }
        catch (IOException e) {
            throw new BuildException("Could not write to " + masterProjectXml, (Throwable)e, this.getLocation());
        }
        TreeSet<Object> s = new TreeSet(configs.get("javadoc"));
        s.removeAll((Collection)configs.get("stable"));
        s.removeAll((Collection)configs.get("daily-alpha-nbms"));
        if (!s.isEmpty()) {
            this.log(buildPropertiesFile + ": warning: javadoc config contains entries not in stable and daily-alpha-nbms configs: " + s);
        }
        Set<String> stable = configs.get("all");
        s = new TreeSet<String>(stable);
        s.removeAll(allClusterModules);
        if (!s.isEmpty()) {
            this.log(buildPropertiesFile + ": warning: 'all' config not equal to listed cluster modules: " + s);
        }
        s = new TreeSet<String>((Collection<String>)allClusterModules);
        s.removeAll(stable);
        if (!s.isEmpty()) {
            this.log(buildPropertiesFile + ": warning: 'all' config not equal to listed cluster modules: " + s);
        }
        Set<String> platform = configs.get("platform");
        Set<String> platformCluster = clusters.get("nb.cluster.platform");
        s = new TreeSet<String>(platform);
        s.removeAll(platformCluster);
        if (!s.isEmpty()) {
            this.log(buildPropertiesFile + ": warning: platform config not equal to platform cluster modules: " + s);
        }
        s = new TreeSet<String>(platformCluster);
        s.removeAll(platform);
        if (!s.isEmpty()) {
            this.log(buildPropertiesFile + ": warning: platform config not equal to platform cluster modules: " + s);
        }
    }

    private Set<String> split(String list, boolean warnIfUnsorted, String what) {
        ArrayList<Object> elements = Collections.list(new StringTokenizer(list, ", "));
        if (warnIfUnsorted) {
            ArrayList<Object> sorted = new ArrayList<Object>(elements);
            Collections.sort(sorted);
            if (!((Object)sorted).equals(elements)) {
                this.log("warning: unsorted list: " + elements);
            }
        }
        HashSet<Object> set = new HashSet<Object>(elements);
        for (Object o : set) {
            elements.remove(o);
        }
        if (!elements.isEmpty()) {
            this.log("warning: duplicates found in " + what + ": " + elements);
        }
        return set;
    }

    private Map<String, Set<String>> loadModuleConfigs(Map<String, String> buildProperties, File buildPropertiesFile) {
        TreeMap<String, Set<String>> configs = new TreeMap<String, Set<String>>();
        for (String k : buildProperties.keySet()) {
            String prefix;
            if (!k.startsWith(prefix = "config.modules.")) continue;
            String config = k.substring(prefix.length());
            TreeSet<String> modules = new TreeSet<String>(this.split(buildProperties.get(k), false, k));
            String fixedK = "config.fixedmodules." + config;
            String fixed = buildProperties.get(fixedK);
            if (fixed != null) {
                modules.addAll(this.split(fixed, false, fixedK));
            } else {
                this.log(buildPropertiesFile + ": warning: have " + k + " but no " + fixedK, 1);
            }
            configs.put(config, modules);
        }
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeModuleConfigs(File goldenFile, Map<String, Set<String>> configs, File buildPropertiesFile) throws IOException {
        this.log("Writing moduleconfigs " + configs.keySet() + " from " + buildPropertiesFile + " to " + goldenFile);
        goldenFile.getParentFile().mkdirs();
        FileWriter w = new FileWriter(goldenFile);
        try {
            PrintWriter pw = new PrintWriter(w);
            pw.println("# To update, run: ant -f nbbuild/build.xml check-module-configs");
            for (Map.Entry<String, Set<String>> entry : configs.entrySet()) {
                String config = entry.getKey();
                for (String module : entry.getValue()) {
                    pw.println(config + ':' + module);
                }
            }
            pw.flush();
        }
        finally {
            ((Writer)w).close();
        }
    }

    private Map<String, Set<String>> loadModuleClusters(Map<String, String> clusterProperties, File clusterPropertiesFile) {
        String fullConfig = "clusters.config.full.list";
        String l = clusterProperties.get(fullConfig);
        if (l == null) {
            this.log(clusterPropertiesFile + ": warning: no definition for clusters.config.full.list", 1);
            return Collections.emptyMap();
        }
        TreeMap<String, Set<String>> clusters = new TreeMap<String, Set<String>>();
        for (String cluster : this.split(l, false, fullConfig)) {
            l = clusterProperties.get(cluster);
            if (l == null) {
                this.log(clusterPropertiesFile + ": warning: no definition for " + cluster, 1);
                continue;
            }
            clusters.put(cluster, new TreeSet<String>(this.split(l, true, fullConfig)));
        }
        return clusters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMasterProjectXml(File masterProjectXml, Set<String> allClusterModules) throws IOException, SAXException {
        this.log("Writing module list  to " + masterProjectXml);
        Document doc = XMLUtil.parse(new InputSource(masterProjectXml.toURI().toString()), false, true, null, null);
        NodeList nl = doc.getElementsByTagName("subprojects");
        if (nl.getLength() != 1) {
            throw new IOException("No or multiple <subprojects>");
        }
        Element sp = (Element)nl.item(0);
        nl = sp.getChildNodes();
        while (nl.getLength() > 0) {
            sp.removeChild(nl.item(0));
        }
        sp.appendChild(doc.createComment(" To update, run: ant -f nbbuild/build.xml check-module-configs "));
        for (String module : allClusterModules) {
            if (new File(this.nbroot, (module + "/nbproject/project.xml").replace('/', File.separatorChar)).isFile()) {
                Element e = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "project");
                String path = "../../" + module;
                e.appendChild(doc.createTextNode(path.replaceFirst("^\\.\\./\\.\\./ide/", "../")));
                sp.appendChild(e);
                continue;
            }
            sp.appendChild(doc.createComment(" Unprojectized: " + module + " "));
        }
        FileOutputStream os = new FileOutputStream(masterProjectXml);
        try {
            XMLUtil.write(doc, (OutputStream)os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }
}

