/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;

public class CleanAll
extends Task {
    private List<String> modules = new ArrayList<String>();
    private List<String> failedmodules = new ArrayList<String>();
    private String targetname = "clean";
    private File topdir = null;
    private File[] topdirs = null;
    private boolean resolvedependencies = false;
    private String deptargetprefix = "";
    private Hashtable targets;
    private boolean failonerror = true;

    public void setModules(String s) {
        StringTokenizer tok = new StringTokenizer(s, ", ");
        this.modules = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            this.modules.add(tok.nextToken());
        }
    }

    public void setTargetname(String s) {
        this.targetname = s;
    }

    public void setDepTargetPrefix(String s) {
        this.deptargetprefix = s;
    }

    public void setResolveDependencies(boolean b) {
        this.resolvedependencies = b;
    }

    public void setFailOnError(boolean b) {
        this.failonerror = b;
    }

    public void setTopdir(File f) {
        this.topdir = f;
    }

    public void setTopdirs(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        int count = st.countTokens();
        this.topdirs = new File[count];
        for (int i = 0; i < count; ++i) {
            this.topdirs[i] = new File(st.nextToken().trim());
        }
    }

    private void resolveDependencies() throws BuildException {
        Target dummy = new Target();
        String dummyName = "nbmerge-" + this.getOwningTarget().getName();
        this.targets = this.getProject().getTargets();
        while (this.targets.contains(dummyName)) {
            dummyName = dummyName + "-x";
        }
        dummy.setName(dummyName);
        for (String module : this.modules) {
            dummy.addDependency(this.deptargetprefix + module);
        }
        this.getProject().addTarget(dummy);
        Vector fullList = this.getProject().topoSort(dummyName, this.targets);
        Vector doneList = this.getProject().topoSort(this.getOwningTarget().getName(), this.targets);
        ArrayList todo = new ArrayList(fullList.subList(0, fullList.indexOf(dummy)));
        todo.removeAll(doneList.subList(0, doneList.indexOf(this.getOwningTarget())));
        for (Target t : todo) {
            String module;
            String _targetname = t.getName();
            if (!_targetname.startsWith(this.deptargetprefix) || this.modules.indexOf(module = _targetname.substring(this.deptargetprefix.length())) >= 0) continue;
            this.modules.add(module);
            this.log("Adding dependency module \"" + module + "\" to the list of modules for cleaning", 3);
        }
    }

    public void execute() throws BuildException {
        if (this.topdirs == null && this.topdir != null) {
            this.topdirs = new File[1];
            this.topdirs[0] = this.topdir;
        }
        if (this.topdir == null && this.topdirs == null) {
            throw new BuildException("You must set at least one topdir attribute", this.getLocation());
        }
        if (this.resolvedependencies) {
            this.resolveDependencies();
        }
        for (int j = 0; j < this.topdirs.length; ++j) {
            this.topdir = this.topdirs[j];
            for (String module : this.modules) {
                Ant ant = (Ant)this.getProject().createTask("ant");
                ant.init();
                ant.setLocation(this.getLocation());
                File fl = new File(this.topdir.getAbsolutePath() + File.separatorChar + module + File.separatorChar + "build.xml");
                if (!fl.exists()) continue;
                ant.setDir(new File(this.topdir, module));
                ant.setTarget(this.targetname);
                try {
                    this.log("Process '" + module + "' location with '" + this.targetname + "' target", 2);
                    ant.execute();
                }
                catch (BuildException be) {
                    if (this.failonerror) {
                        throw new BuildException(be.getMessage(), (Throwable)be, this.getLocation());
                    }
                    this.log("Target \"" + this.targetname + "\" failed in module \"" + module + "\"", 1);
                    this.log(fl.getAbsolutePath());
                    this.log(be.getMessage());
                    String fname = fl.getAbsolutePath();
                    this.failedmodules.add(fname);
                }
            }
        }
        if (this.failedmodules.size() > 0) {
            this.log("<cleanall> SOME MODULES FAILED TO BUILD, BUT THEIR BuildException WAS CAUGHT", 1);
            this.log("<cleanall> cleanfailedmodules=\"" + this.failedmodules.toString() + "\"", 1);
        }
    }
}

