/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyIcons
extends MatchingTask {
    private int depth = 0;
    private List<File> projectDirList = new ArrayList<File>();
    private List<ProjectIconInfo> prjIconInfoList = new ArrayList<ProjectIconInfo>();
    File baseDir = null;
    File destDir = null;
    int userDepth = 2;
    String iconIncludes = "src/**/*.png,src/**/*.gif";
    String iconExcludes = "";
    String prjIncludes = "";
    String prjExcludes = "";
    boolean showEmpty = false;

    public void setNbsrcroot(File f) {
        this.baseDir = f;
    }

    public void setDestdir(File f) {
        this.destDir = f;
    }

    public void setDepth(int n) {
        this.userDepth = n;
    }

    public void setIconincludes(String s) {
        this.iconIncludes = s;
    }

    public void setIconexcludes(String s) {
        this.iconExcludes = s;
    }

    public void setPrjincludes(String s) {
        this.prjIncludes = s;
    }

    public void setPrjExcludes(String s) {
        this.prjExcludes = s;
    }

    public void setShowempty(boolean b) {
        this.showEmpty = b;
    }

    public void execute() throws BuildException {
        if (this.baseDir == null || this.destDir == null) {
            this.log("Nbsrcroot or destdir are not specified.");
            return;
        }
        this.scanForProjectDirs(this.baseDir);
        for (File f : this.projectDirList) {
            this.processProjectDir(f);
        }
        this.copyToDestDir(this.prjIconInfoList);
        this.dumpListToHTML(this.prjIconInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageInfo readImageInfo(File fl) throws IOException {
        Object dim = null;
        ImageInfo imageInfo = null;
        ByteArrayInputStream bais = null;
        try {
            bais = this.readSomeBytes(fl);
            if (this.isGIF(bais)) {
                imageInfo = new ImageInfo(this.readGIFDimension(bais), 1);
            } else if (this.isPNG(bais)) {
                imageInfo = new ImageInfo(this.readPNGDimension(bais), 2);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            bais.close();
        }
        return imageInfo;
    }

    private ByteArrayInputStream readSomeBytes(File fl) throws IOException {
        byte[] buffer = new byte[30];
        FileInputStream fis = null;
        fis = new FileInputStream(fl);
        fis.read(buffer);
        fis.close();
        return new ByteArrayInputStream(buffer);
    }

    private boolean isGIF(InputStream is) throws IOException {
        is.reset();
        byte[] buf = new byte[3];
        is.read(buf);
        int[] signatureBuffer = CopyIcons.parseUnsigned(buf);
        return (char)signatureBuffer[0] == 'G' && (char)signatureBuffer[1] == 'I' && (char)signatureBuffer[2] == 'F';
    }

    private boolean isPNG(InputStream is) throws IOException {
        is.reset();
        byte[] buf = new byte[8];
        is.read(buf);
        int[] signatureBuffer = CopyIcons.parseUnsigned(buf);
        return signatureBuffer[0] == 137 && signatureBuffer[1] == 80 && signatureBuffer[2] == 78 && signatureBuffer[3] == 71 && signatureBuffer[4] == 13 && signatureBuffer[5] == 10 && signatureBuffer[6] == 26 && signatureBuffer[7] == 10;
    }

    private Dimension readGIFDimension(InputStream is) throws IOException {
        is.read(new byte[3]);
        byte[] buf = new byte[2];
        is.read(buf);
        int[] widthBuf = CopyIcons.parseUnsigned(buf);
        int width = (widthBuf[1] << 8) + widthBuf[0];
        buf = new byte[2];
        is.read(buf);
        int[] heightBuf = CopyIcons.parseUnsigned(buf);
        int height = (heightBuf[1] << 8) + heightBuf[0];
        return new Dimension(width, height);
    }

    private Dimension readPNGDimension(InputStream is) throws IOException {
        is.read(new byte[4]);
        is.read(new byte[4]);
        byte[] buf = new byte[4];
        is.read(buf);
        int[] widthBuf = CopyIcons.parseUnsigned(buf);
        int width = (widthBuf[0] << 24) + (widthBuf[1] << 16) + (widthBuf[2] << 8) + widthBuf[3];
        buf = new byte[4];
        is.read(buf);
        int[] heightBuf = CopyIcons.parseUnsigned(buf);
        int height = (heightBuf[0] << 24) + (heightBuf[1] << 16) + (heightBuf[2] << 8) + heightBuf[3];
        return new Dimension(width, height);
    }

    private static int[] parseUnsigned(byte[] src) {
        int[] val = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            val[i] = src[i] < 0 && src[i] >= -128 ? 256 + src[i] : src[i];
        }
        return val;
    }

    private void dumpListToHTML(List<ProjectIconInfo> lst) {
        File reportFile = new File(this.destDir, "index.html");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(reportFile);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        PrintWriter pw = new PrintWriter(new BufferedOutputStream(fos));
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<style type=\"text/css\">\nbody { font-family: Tahoma, Verdana, sans-serif }\n</style>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h2>List of icons in NetBeans projects</h2>");
        pw.println("<h3>NetBeans Source Root: " + this.baseDir + "<br/>");
        pw.println("Destination Directory: " + this.destDir + "</h3>");
        pw.println("<p style=\"width: 70%\"><b>Description:</b><br/> New Image is image in the Destination Directory, Orig. Image is image in NetBeans Source Root. By replacing the image in Destination Directory under coresponding module and path you can prepare rebranded icons in paralel directory structure and then copy them over to NetBeans Source Root. Orig. Image is in the table just for comparison and reference what image was already changed.</p>");
        for (ProjectIconInfo info : this.prjIconInfoList) {
            if (!this.showEmpty && info.matchingIcons.size() == 0) continue;
            pw.println("<p>Module name: <b>" + info.prjPath + "</b></p>");
            pw.println("<p style=\"margin-left: 20px\">");
            if (info.matchingIcons.size() == 0) {
                pw.println("<i>--- No icons ---</i>");
                pw.println("</p>");
                continue;
            }
            pw.println("<table width=\"80%\"border=\"1\" cellpadding=\"3\" cellspacing=\"0\">");
            pw.println("<tr><td><b>Resource Path</b></td><td align=\"center\"><b>&nbsp;New Image&nbsp;</b></td><td align=\"center\"><b>&nbsp;Orig. image&nbsp;</b></td><td align=\"center\"><b>&nbsp;W x H&nbsp;</b></td><td align=\"center\"><b>&nbsp;Extension&nbsp;</b></td><td align=\"center\"><b>&nbsp;Real Type&nbsp;</b></td></tr>");
            for (ImageInfo goodInfo : info.matchingIcons) {
                String iconPath = goodInfo.getPath();
                String copiedIconPath = info.prjPath + File.separator + iconPath;
                String originalIconPath = this.baseDir.getAbsolutePath() + File.separator + info.prjPath + File.separator + iconPath;
                pw.println("<tr>");
                pw.println("<td>");
                pw.println("<a href=\"" + copiedIconPath + "\">" + iconPath + "</a>");
                pw.println("</td>");
                pw.println("<td align=\"center\">");
                pw.println("<img src=\"" + copiedIconPath + "\"/>");
                pw.println("</td>");
                pw.println("<td align=\"center\">");
                pw.println("<img src=\"file://" + originalIconPath + "\"/>");
                pw.println("</td>");
                pw.println("<td align=\"center\">" + goodInfo.getWidth() + " x " + goodInfo.getHeight() + "</td>");
                pw.println("<td align=\"center\">" + goodInfo.getExt().toUpperCase() + "</td>");
                if (!goodInfo.getExt().equalsIgnoreCase(goodInfo.getType())) {
                    pw.println("<td align=\"center\"><font color=\"Orange\">" + goodInfo.getType() + "</font></td>");
                } else {
                    pw.println("<td align=\"center\">" + goodInfo.getType() + "</td>");
                }
                pw.println("</tr>");
            }
            pw.println("</table>");
            pw.println("</p>");
        }
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
        pw.close();
        this.log("---> Report was written to file: " + reportFile.getAbsolutePath());
    }

    private void copyToDestDir(List<ProjectIconInfo> prjInfoList) {
        FileSet fs = null;
        Iterator<ProjectIconInfo> iter = prjInfoList.iterator();
        while (iter.hasNext()) {
            fs = new FileSet();
            this.log("Setting basedir for fileset: " + this.baseDir, 3);
            ProjectIconInfo prjIconInfo = iter.next();
            fs.setDir(new File(this.baseDir, prjIconInfo.prjPath));
            int numFilesToCopy = prjIconInfo.matchingIcons.size() + prjIconInfo.notmatchingIcons.size();
            for (ImageInfo info : prjIconInfo.matchingIcons) {
                this.log("Adding file to matching fileset: " + info.getPath(), 3);
                fs.setIncludes(info.getPath());
            }
            for (ImageInfo info : prjIconInfo.notmatchingIcons) {
                this.log("Adding file to notmatching fileset: " + info.getPath(), 3);
                fs.setIncludes(info.getPath());
            }
            if (numFilesToCopy <= 0) continue;
            Copy copy = (Copy)this.getProject().createTask("copy");
            copy.addFileset(fs);
            File dest = new File(this.destDir, prjIconInfo.prjPath);
            dest.mkdir();
            copy.setTodir(dest);
            copy.init();
            copy.setLocation(this.getLocation());
            copy.execute();
        }
    }

    private void scanForProjectDirs(File fl) {
        if (this.depth > this.userDepth) {
            return;
        }
        File[] allFiles = fl.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        ++this.depth;
        for (File f : allFiles) {
            if (this.isProjectDir(f)) {
                this.projectDirList.add(f);
                this.log(f.toString(), 3);
                this.scanForProjectDirs(f);
                continue;
            }
            this.scanForProjectDirs(f);
        }
        --this.depth;
    }

    private boolean isProjectDir(File fl) {
        File[] prjDirs = fl.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return "nbproject".equals(name);
            }
        });
        if (prjDirs.length != 1) {
            return false;
        }
        String[] prjFiles = prjDirs[0].list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return "project.xml".equals(name);
            }
        });
        return prjFiles.length == 1;
    }

    private void processProjectDir(File f) {
        String prjPath = null;
        prjPath = f.getAbsolutePath().substring(this.baseDir.getAbsolutePath().length() + 1);
        this.log("Processing project dir: " + prjPath);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(f);
        ds.setIncludes(this.getAsArray(this.iconIncludes));
        ds.setExcludes(this.getAsArray(this.iconExcludes));
        ds.setCaseSensitive(false);
        ds.scan();
        String[] files = ds.getIncludedFiles();
        this.log("    Found " + files.length + " files in " + f);
        ArrayList<ImageInfo> goodIcons = new ArrayList<ImageInfo>();
        ArrayList<ImageInfo> badIcons = new ArrayList<ImageInfo>();
        for (String file : files) {
            String ext = file.substring(file.lastIndexOf(46) + 1);
            if (!ext.equalsIgnoreCase("gif") && !ext.equalsIgnoreCase("png")) continue;
            File iconFile = new File(f, file);
            try {
                ImageInfo imageInfo = null;
                imageInfo = this.readImageInfo(iconFile);
                if (imageInfo == null) continue;
                imageInfo.setPath(file);
                imageInfo.setExt(ext);
                int w = imageInfo.getWidth();
                int h = imageInfo.getHeight();
                if (w == 8 && h == 8 || w == 16 && h == 16 || w == 24 && h == 24 || w == 32 && h == 32) {
                    goodIcons.add(imageInfo);
                    continue;
                }
                badIcons.add(imageInfo);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        ProjectIconInfo prjIconInfo = new ProjectIconInfo(prjPath, goodIcons, badIcons);
        this.prjIconInfoList.add(prjIconInfo);
    }

    private String[] getAsArray(String s) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer stok = new StringTokenizer(s, ",");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken().trim();
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectIconInfo {
        public String prjPath;
        public List<ImageInfo> matchingIcons;
        public List<ImageInfo> notmatchingIcons;

        public ProjectIconInfo(String pth, List<ImageInfo> mi, List<ImageInfo> nmi) {
            this.prjPath = pth;
            this.matchingIcons = mi;
            this.notmatchingIcons = nmi;
        }
    }

    private static class ImageInfo {
        public static final int GIF = 1;
        public static final int PNG = 2;
        private Dimension dim;
        private int type;
        private String path;
        private String ext;

        public ImageInfo(Dimension dm, int tp) {
            this(null, dm, tp);
        }

        public ImageInfo(String pth, Dimension dm, int tp) {
            this.path = pth;
            this.dim = dm;
            this.type = tp;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String pth) {
            this.path = pth;
        }

        public int getHeight() {
            return this.dim.height;
        }

        public int getWidth() {
            return this.dim.width;
        }

        public String getType() {
            if (this.type == 1) {
                return "GIF";
            }
            if (this.type == 2) {
                return "PNG";
            }
            return "";
        }

        public String getExt() {
            return this.ext;
        }

        public String setExt(String ex) {
            this.ext = ex;
            return this.ext;
        }
    }
}

