/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.netbeans.nbbuild.JUnitReportWriter;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteUnreferencedClusterFiles
extends Task {
    private DirSet clusters;
    private PatternSet patterns;
    private File report;

    public void addConfiguredClusters(DirSet clusters) {
        this.clusters = clusters;
    }

    public void addConfiguredSelection(PatternSet p) {
        this.patterns = p;
    }

    public void setReport(File report) {
        this.report = report;
    }

    public void execute() throws BuildException {
        StringBuilder missingFiles = new StringBuilder();
        StringBuilder extraFiles = new StringBuilder();
        StringBuilder duplicatedFiles = new StringBuilder();
        for (String incl : this.clusters.getDirectoryScanner().getIncludedDirectories()) {
            File cluster = new File(this.clusters.getDir(), incl);
            File updateTracking = new File(cluster, "update_tracking");
            if (!updateTracking.isDirectory()) continue;
            HashMap<String, String> files = new HashMap<String, String>();
            for (File module : updateTracking.listFiles()) {
                if (!module.getName().endsWith(".xml")) continue;
                try {
                    Document doc = XMLUtil.parse(new InputSource(module.toURI().toString()), false, false, null, null);
                    String cnb = doc.getDocumentElement().getAttribute("codename").replaceFirst("/[0-9]+$", "");
                    NodeList nl = doc.getElementsByTagName("file");
                    for (int i = 0; i < nl.getLength(); ++i) {
                        String file = ((Element)nl.item(i)).getAttribute("name");
                        if (new File(cluster, file).isFile()) {
                            String prev = files.put(file, cnb);
                            if (prev == null) continue;
                            duplicatedFiles.append("\ntwo registrations of the same file: " + file + " (from " + prev + " and " + cnb + ")");
                            continue;
                        }
                        missingFiles.append("\n" + cnb + ": missing " + file);
                    }
                }
                catch (Exception x) {
                    throw new BuildException("Parsing " + module + ": " + x, (Throwable)x, this.getLocation());
                }
            }
            this.scanForExtraFiles(cluster, "", files.keySet(), cluster.getName(), extraFiles);
        }
        LinkedHashMap<String, String> pseudoTests = new LinkedHashMap<String, String>();
        pseudoTests.put("testMissingFiles", missingFiles.length() > 0 ? "Some files were missing" + missingFiles : null);
        pseudoTests.put("testExtraFiles", extraFiles.length() > 0 ? "Some extra files were present" + extraFiles : null);
        pseudoTests.put("testDuplicatedFiles", duplicatedFiles.length() > 0 ? "Some files were registered in two or more NBMs" + duplicatedFiles : null);
        JUnitReportWriter.writeReport(this, this.report, pseudoTests);
    }

    private void scanForExtraFiles(File d, String prefix, Set<String> files, String cluster, StringBuilder extraFiles) {
        if (prefix.equals("update_tracking/")) {
            return;
        }
        for (String n : d.list()) {
            File f = new File(d, n);
            if (f.getName().equals(".lastModified")) continue;
            if (f.isDirectory()) {
                this.scanForExtraFiles(f, prefix + n + "/", files, cluster, extraFiles);
                continue;
            }
            String path = prefix + n;
            if (this.patterns != null) {
                for (String p : this.patterns.getExcludePatterns(this.getProject())) {
                    if (!SelectorUtils.matchPath((String)p, (String)path)) continue;
                    return;
                }
            }
            if (files.contains(path)) continue;
            extraFiles.append("\n" + cluster + ": untracked file " + path);
            f.delete();
        }
    }
}

