/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.netbeans.nbbuild.ModuleListParser;

public class ExportedAPICondition
extends ProjectComponent
implements Condition {
    public boolean eval() throws BuildException {
        ModuleListParser mlp;
        Hashtable props = this.getProject().getProperties();
        if (((String)props.get("public.packages")).equals("-")) {
            this.log("No exported packages", 3);
            return false;
        }
        String friends = (String)props.get("friends");
        if (friends == null) {
            this.log("Public API", 3);
            return true;
        }
        try {
            mlp = new ModuleListParser(props, 0, this.getProject());
        }
        catch (IOException x) {
            throw new BuildException((Throwable)x, this.getLocation());
        }
        String mycluster = mlp.findByCodeNameBase(((String)props.get("code.name.base.dashes")).replace('-', '.')).getClusterName();
        for (String friend : friends.split(", ")) {
            ModuleListParser.Entry entry = mlp.findByCodeNameBase(friend);
            if (entry == null) {
                this.log("External friend " + friend, 3);
                return true;
            }
            String cluster = entry.getClusterName();
            if (mycluster.equals(cluster)) continue;
            this.log("Friend " + friend + " is in cluster " + cluster + " rather than " + mycluster, 3);
            return true;
        }
        this.log("No friends outside cluster", 3);
        return false;
    }
}

