/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.types.Path;

public class GenerateJavadoc
extends Task {
    private File dest;
    private List<String> modules = new ArrayList<String>();
    private String packageNames = null;
    private List<File> topdirs = new ArrayList<File>();

    public void setDestdir(File f) {
        this.dest = f;
    }

    public void setModules(String s) {
        StringTokenizer tok = new StringTokenizer(s, ",");
        this.modules = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            this.modules.add(tok.nextToken());
        }
    }

    public void setPackageNames(String s) {
        this.packageNames = s;
    }

    public void setTopdir(File t) {
        this.topdirs.add(t);
    }

    public Topdir createTopdir() {
        return new Topdir();
    }

    public void execute() throws BuildException {
        if (this.topdirs.isEmpty()) {
            throw new BuildException("You must set at least one topdir attribute", this.getLocation());
        }
        Path path = new Path(this.getProject());
        for (File topdir : this.topdirs) {
            for (String module : this.modules) {
                File sources = new File(new File(topdir, module), "javadoc-temp/");
                if (!sources.exists()) {
                    sources = new File(new File(topdir, module), "src/");
                    if (sources.exists()) {
                        path.append(new Path(this.getProject(), sources.getPath()));
                    }
                    if (!(sources = new File(new File(topdir, module), "libsrc/")).exists()) continue;
                    path.append(new Path(this.getProject(), sources.getPath()));
                    continue;
                }
                path.append(new Path(this.getProject(), sources.getPath()));
            }
        }
        Javadoc javaDoc = (Javadoc)this.getProject().createTask("javadoc");
        javaDoc.setSourcepath(path);
        javaDoc.setDestdir(this.dest);
        if (this.packageNames != null) {
            javaDoc.setPackagenames(this.packageNames);
        } else {
            javaDoc.setPackagenames("org.netbeans.*,com.sun.*");
        }
        javaDoc.setUse(true);
        javaDoc.setMaxmemory("256M");
        javaDoc.execute();
    }

    public class Topdir {
        public void setPath(File t) {
            GenerateJavadoc.this.topdirs.add(t);
        }
    }
}

