/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GetDependsClusters
extends Task {
    private String name = null;
    private String propertiesList = null;
    private String thisModuleName = null;

    public void setList(String propertiesList) {
        this.propertiesList = propertiesList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void execute() throws BuildException {
        if (this.name == null) {
            throw new BuildException("Name of property to set have to be specified", this.getLocation());
        }
        if (this.propertiesList == null) {
            throw new BuildException("List of clusters have to be specified", this.getLocation());
        }
        this.thisModuleName = this.getOwningTarget().getName();
        if (!this.thisModuleName.startsWith("all-")) {
            throw new BuildException("This task could be used only in targets \"all-{modulename}\"", this.getLocation());
        }
        this.thisModuleName = this.thisModuleName.substring("all-".length());
        StringTokenizer tokens = new StringTokenizer(this.propertiesList, " \t\n\f\r,");
        while (tokens.hasMoreTokens()) {
            String property = tokens.nextToken().trim();
            String list = this.getProject().getProperty(property);
            if (list == null) {
                throw new BuildException("Property: " + property + " is not defined anywhere", this.getLocation());
            }
            StringTokenizer modTokens = new StringTokenizer(list, " \t\n\f\r,");
            while (modTokens.hasMoreTokens()) {
                String module = modTokens.nextToken();
                this.log(property + " " + module, 3);
                if (!module.equals(this.thisModuleName)) continue;
                String clusterDepends = this.getProject().getProperty(property + ".depends");
                if (clusterDepends == null) {
                    throw new BuildException("Property: " + property + ".depends have to be defined", this.getLocation());
                }
                this.log("Property: " + this.name + " will be set to " + clusterDepends, 3);
                this.getProject().setProperty(this.name, clusterDepends);
                return;
            }
        }
        this.log("No cluster list with this module: " + this.thisModuleName + " was found. Assume that this module " + this.thisModuleName + " depends on all clusters: " + this.propertiesList, 1);
        this.log("Property: " + this.name + " will be set to " + this.propertiesList, 3);
        this.getProject().setProperty(this.name, this.propertiesList);
    }
}

