/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class IncrementSpecificationVersions
extends Task {
    private File nbroot;
    private List<String> modules;
    private int stickyLevel = -1;

    public void setNbroot(File f) {
        this.nbroot = f;
    }

    public void setModules(String m) {
        this.modules = new ArrayList<String>();
        for (Object o : Collections.list(new StringTokenizer(m, ", "))) {
            this.modules.add((String)o);
        }
    }

    public void setBranch(boolean b) {
        this.setStickyLevel(b ? 2 : 1);
    }

    public void setStickyLevel(int stickyLevel) {
        if (this.stickyLevel != -1) {
            throw new BuildException("Only one stickyLevel or branch attribute can be used!");
        }
        this.stickyLevel = stickyLevel;
    }

    public void execute() throws BuildException {
        if (this.nbroot == null || this.modules == null) {
            throw new BuildException("Missing params 'nbroot' or 'modules'", this.getLocation());
        }
        block2: for (String module : this.modules) {
            File dir = new File(this.nbroot, module.replace('/', File.separatorChar));
            if (!dir.isDirectory()) {
                this.log("No such directory " + dir + "; skipping", 1);
                continue;
            }
            try {
                File mf;
                File pp = new File(dir, "nbproject" + File.separatorChar + "project.properties");
                if (pp.isFile()) {
                    String[] lines = IncrementSpecificationVersions.gulp(pp, "ISO-8859-1");
                    for (int i = 0; i < lines.length; ++i) {
                        Matcher m1 = Pattern.compile("(spec\\.version\\.base=)(.+)").matcher(lines[i]);
                        if (!m1.matches()) continue;
                        String old = m1.group(2);
                        String nue = IncrementSpecificationVersions.increment(old, this.stickyLevel, false);
                        if (nue != null) {
                            lines[i] = m1.group(1) + nue;
                            IncrementSpecificationVersions.spit(pp, "ISO-8859-1", lines);
                            this.log("Incrementing " + old + " -> " + nue + " in " + pp);
                            continue block2;
                        }
                        this.log(pp + ":" + (i + 1) + ": Unsupported old version number " + old + " (must be x.y.0 in trunk or x.y.z in branch); skipping", 1);
                        continue block2;
                    }
                } else if (!new File(dir, "nbproject" + File.separatorChar + "project.xml").isFile()) {
                    this.log("No such file " + pp + "; unprojectized module?", 1);
                }
                if ((mf = new File(dir, "manifest.mf")).isFile()) {
                    String[] lines = IncrementSpecificationVersions.gulp(mf, "UTF-8");
                    for (int i = 0; i < lines.length; ++i) {
                        Matcher m1 = Pattern.compile("(OpenIDE-Module-Specification-Version: )(.+)").matcher(lines[i]);
                        if (!m1.matches()) continue;
                        String old = m1.group(2);
                        String nue = IncrementSpecificationVersions.increment(old, this.stickyLevel, true);
                        if (nue != null) {
                            lines[i] = m1.group(1) + nue;
                            IncrementSpecificationVersions.spit(mf, "UTF-8", lines);
                            this.log("Incrementing " + old + " -> " + nue + " in " + mf);
                            continue block2;
                        }
                        this.log(mf + ":" + (i + 1) + ": Unsupported old version number " + old + " (must be x.y in trunk or x.y.z in branch); skipping", 1);
                        continue block2;
                    }
                } else {
                    this.log("No such file " + mf + "; not a real module?", 1);
                }
                this.log("Could not find any specification version in " + dir + "; skipping", 1);
            }
            catch (IOException e) {
                throw new BuildException("While processing " + dir + ": " + e, (Throwable)e, this.getLocation());
            }
        }
    }

    static String increment(String old, int stickyLevel, boolean manifest) throws NumberFormatException {
        String nue = null;
        switch (stickyLevel) {
            case 1: {
                if (manifest) {
                    Matcher mC = Pattern.compile("([0-9]+\\.)([0-9]+)").matcher(old);
                    Matcher mW1 = Pattern.compile("([0-9]+)").matcher(old);
                    Matcher mW2 = Pattern.compile("([0-9]+\\.)([0-9]+)\\.([0-9\\.]+)").matcher(old);
                    if (mC.matches()) {
                        nue = mC.group(1) + (Integer.parseInt(mC.group(2)) + 1);
                        break;
                    }
                    if (mW1.matches()) {
                        nue = mW1.group(1) + ".1";
                        break;
                    }
                    if (!mW2.matches()) break;
                    nue = mW2.group(1) + (Integer.parseInt(mW2.group(2)) + 1);
                    break;
                }
                Matcher mC = Pattern.compile("([0-9]+\\.)([0-9]+)(\\.0)").matcher(old);
                Matcher mW1 = Pattern.compile("([0-9]+)").matcher(old);
                Matcher mW2 = Pattern.compile("([0-9]+\\.)([0-9]+)").matcher(old);
                Matcher mW3 = Pattern.compile("([0-9]+\\.)([0-9]+)\\.([0-9\\.]+)").matcher(old);
                if (mC.matches()) {
                    nue = mC.group(1) + (Integer.parseInt(mC.group(2)) + 1) + mC.group(3);
                    break;
                }
                if (mW1.matches()) {
                    nue = mW1.group(1) + ".1.0";
                    break;
                }
                if (mW2.matches()) {
                    nue = mW2.group(1) + (Integer.parseInt(mW2.group(2)) + 1) + ".0";
                    break;
                }
                if (!mW3.matches()) break;
                nue = mW3.group(1) + (Integer.parseInt(mW3.group(2)) + 1) + ".0";
                break;
            }
            case 2: {
                if (manifest) {
                    Matcher mC1 = Pattern.compile("([0-9]+\\.[0-9]+\\.)([0-9]+)").matcher(old);
                    Matcher mC2 = Pattern.compile("([0-9]+\\.[0-9]+)").matcher(old);
                    Matcher mW1 = Pattern.compile("([0-9]+)").matcher(old);
                    Matcher mW2 = Pattern.compile("([0-9]+\\.[0-9]+\\.)([0-9]+)\\.([0-9\\.]+)").matcher(old);
                    if (mC1.matches()) {
                        nue = mC1.group(1) + (Integer.parseInt(mC1.group(2)) + 1);
                        break;
                    }
                    if (mC2.matches()) {
                        nue = mC2.group(1) + ".1";
                        break;
                    }
                    if (mW1.matches()) {
                        nue = mW1.group(1) + ".0.1";
                        break;
                    }
                    if (!mW2.matches()) break;
                    nue = mW2.group(1) + (Integer.parseInt(mW2.group(2)) + 1);
                    break;
                }
                Matcher mC = Pattern.compile("([0-9]+\\.[0-9]+\\.)([0-9]+)").matcher(old);
                Matcher mW1 = Pattern.compile("([0-9]+)").matcher(old);
                Matcher mW2 = Pattern.compile("([0-9]+\\.[0-9]+)").matcher(old);
                Matcher mW3 = Pattern.compile("([0-9]+\\.[0-9]+\\.)([0-9]+)\\.([0-9\\.]+)").matcher(old);
                if (mC.matches()) {
                    nue = mC.group(1) + (Integer.parseInt(mC.group(2)) + 1);
                    break;
                }
                if (mW1.matches()) {
                    nue = mW1.group(1) + ".0.1";
                    break;
                }
                if (mW2.matches()) {
                    nue = mW2.group(1) + ".1";
                    break;
                }
                if (!mW3.matches()) break;
                nue = mW3.group(1) + (Integer.parseInt(mW3.group(2)) + 1);
                break;
            }
            default: {
                if (stickyLevel < 1) {
                    throw new BuildException("Invalid sticky level: " + stickyLevel);
                }
                int[] segments = new int[stickyLevel + 1];
                StringTokenizer tok = new StringTokenizer(old, ".");
                for (int i = 0; i < segments.length && tok.hasMoreElements(); ++i) {
                    segments[i] = Integer.parseInt(tok.nextToken());
                }
                int n = stickyLevel;
                segments[n] = segments[n] + 1;
                nue = "";
                String pref = "";
                for (int i = 0; i < segments.length; ++i) {
                    nue = nue + pref;
                    nue = nue + segments[i];
                    pref = ".";
                }
            }
        }
        return nue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] gulp(File file, String enc) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, enc));
            ArrayList<String> l = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                l.add(line);
            }
            String[] stringArray = l.toArray(new String[l.size()]);
            return stringArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void spit(File file, String enc, String[] lines) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)os, enc));
            for (String line : lines) {
                w.println(line);
            }
            w.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }
}

