/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.Property;
import org.netbeans.nbbuild.ModuleListParser;

public final class InsertModuleAllTargets
extends Task {
    boolean checkModules = false;

    public void setCheckModules(boolean check) {
        this.checkModules = check;
    }

    public void execute() throws BuildException {
        try {
            Project prj = this.getProject();
            Set existingTargets = prj.getTargets().keySet();
            if (existingTargets.contains("all-openide.util")) {
                this.log("Already seem to have inserted targets into this project; will not do it twice", 3);
                return;
            }
            Hashtable props = prj.getProperties();
            if (this.checkModules) {
                boolean missingModules = false;
                String[] clusters = ((String)props.get("nb.clusters.list")).split(", *");
                String nb_all = (String)props.get("nb_all");
                if (nb_all == null) {
                    throw new BuildException("Can't file 'nb_all' property, probably not in the NetBeans build system");
                }
                File nbRoot = new File(nb_all);
                for (String cluster : clusters) {
                    String[] clusterModules;
                    if (props.get(cluster) == null) {
                        throw new BuildException("Cluster '" + cluster + "' has got empty list of modules. Check configuration of that cluster.", this.getLocation());
                    }
                    for (String module : clusterModules = ((String)props.get(cluster)).split(", *")) {
                        File moduleBuild = new File(nbRoot, module + File.separator + "build.xml");
                        if (moduleBuild.exists() && moduleBuild.isFile()) continue;
                        missingModules = true;
                        this.log("This module is missing from checkout: " + module + " - at least can't find: " + moduleBuild.getAbsolutePath());
                    }
                }
                if (missingModules) {
                    String clusterConfig = (String)props.get("cluster.config");
                    throw new BuildException("Some modules according your cluster config '" + clusterConfig + "' are missing from checkout, see messages above.", this.getLocation());
                }
            }
            HashMap<String, String> clustersOfModules = new HashMap<String, String>();
            for (Map.Entry pair : props.entrySet()) {
                String cluster = (String)pair.getKey();
                if (!cluster.startsWith("nb.cluster.") || cluster.endsWith(".depends") || cluster.endsWith(".dir")) continue;
                for (String module : ((String)pair.getValue()).split(", *")) {
                    clustersOfModules.put(module, cluster);
                }
            }
            ModuleListParser mlp = new ModuleListParser(props, 0, prj);
            TreeMap<String, ModuleListParser.Entry> entries = new TreeMap<String, ModuleListParser.Entry>();
            for (ModuleListParser.Entry entry : mlp.findAll()) {
                String path = entry.getNetbeansOrgPath();
                if (path == null) continue;
                entries.put(path, entry);
            }
            for (ModuleListParser.Entry entry : entries.values()) {
                String path = entry.getNetbeansOrgPath();
                assert (path != null) : entry;
                String trg = "all-" + path;
                if (existingTargets.contains(trg)) {
                    this.log("Not adding target " + trg + " because one already exists", 2);
                    continue;
                }
                String[] prereqsAsCnb = entry.getBuildPrerequisites();
                StringBuffer namedDeps = new StringBuffer("init");
                String myCluster = (String)clustersOfModules.get(path);
                for (String cnb : prereqsAsCnb) {
                    ModuleListParser.Entry other = mlp.findByCodeNameBase(cnb);
                    if (other == null) {
                        this.log("Cannot find build prerequisite " + cnb + " of " + entry, 1);
                        continue;
                    }
                    String otherPath = other.getNetbeansOrgPath();
                    if (otherPath == null) continue;
                    String otherCluster = (String)clustersOfModules.get(otherPath);
                    if (myCluster != null && otherCluster != null && !myCluster.equals(otherCluster)) continue;
                    namedDeps.append(",all-");
                    namedDeps.append(otherPath);
                }
                String namedDepsS = namedDeps.toString();
                this.log("Adding target " + trg + " with depends=\"" + namedDepsS + "\"", 3);
                Target t = new Target();
                t.setName(trg);
                t.setLocation(this.getLocation());
                t.setDepends(namedDepsS);
                prj.addTarget(t);
                if (myCluster != null) {
                    CallTarget call = (CallTarget)prj.createTask("antcall");
                    call.setTarget("build-one-cluster-dependencies");
                    call.setInheritAll(false);
                    Property param = call.createParam();
                    param.setName("one.cluster.dependencies");
                    param.setValue((String)props.get(myCluster + ".depends"));
                    param = call.createParam();
                    param.setName("one.cluster.name");
                    param.setValue("this-cluster");
                    t.addTask((Task)call);
                }
                Echo echo = (Echo)prj.createTask("echo");
                echo.setMessage("Building " + path + "...");
                t.addTask((Task)echo);
                Ant ant = (Ant)prj.createTask("ant");
                ant.setDir(prj.resolveFile("../" + path));
                ant.setTarget("netbeans");
                t.addTask((Task)ant);
            }
        }
        catch (IOException e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }
}

