/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class JavadocIndex
extends Task {
    private File target;
    private FileSet set;
    private Map<String, List<Clazz>> classes = new HashMap<String, List<Clazz>>(101);

    public void setTarget(File f) {
        this.target = f;
    }

    public void addPackagesList(FileSet set) throws BuildException {
        if (this.set != null) {
            throw new BuildException("Package list can be associated only once");
        }
        this.set = set;
    }

    public void execute() throws BuildException {
        if (this.target == null) {
            throw new BuildException("Target must be set");
        }
        if (this.set == null) {
            throw new BuildException("Set of files must be provided: " + this.set);
        }
        DirectoryScanner scan = this.set.getDirectoryScanner(this.getProject());
        File bdir = scan.getBasedir();
        for (String n : scan.getIncludedFiles()) {
            File f = new File(bdir, n);
            this.parseForClasses(f);
        }
        try {
            this.log("Generating list of all classes to " + this.target);
            PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.target)));
            if (this.target.getName().endsWith(".xml")) {
                this.printClassesAsXML(ps);
            } else {
                this.printClassesAsHtml(ps);
            }
            ps.close();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void parseForClasses(File f) throws BuildException {
        this.log("Parsing file: " + f, 4);
        try {
            String line;
            String urlPrefix;
            BufferedReader is = new BufferedReader(new FileReader(f));
            try {
                String fullDir = f.getParentFile().getCanonicalPath();
                String fullTgz = this.target.getParentFile().getCanonicalPath();
                if (!fullDir.startsWith(fullTgz)) {
                    throw new BuildException("The directory of target file must be above all parsed files. Directory: " + fullTgz + " the file dir: " + fullDir);
                }
                urlPrefix = fullDir.substring(fullTgz.length() + 1);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
            String mask = ".*<A HREF=\"([^\"]*)\" title=\"(class|interface) in ([^\"]*)\"[><I]*>([\\p{Alnum}\\.]*)</.*A>.*";
            Pattern p = Pattern.compile(mask, 2);
            int matches = 0;
            while ((line = is.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    ++matches;
                    this.log("Accepted line: " + line, 4);
                    if (m.groupCount() != 4) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Line " + line + " has " + m.groupCount() + " groups and not four");
                        for (int i = 0; i <= m.groupCount(); ++i) {
                            sb.append("\n  " + i + " grp: " + m.group(i));
                        }
                        throw new BuildException(sb.toString());
                    }
                    Clazz c = new Clazz(m.group(3), m.group(4), "interface".equals(m.group(2)), urlPrefix + "/" + m.group(1));
                    if (c.name == null) {
                        throw new NullPointerException("Null name for " + line + "\nclass: " + c);
                    }
                    if (c.name.length() == 0) {
                        throw new IllegalStateException("Empty name for " + line + "\nclass: " + c);
                    }
                    this.log("Adding class: " + c, 4);
                    List<Clazz> l = this.classes.get(c.pkg);
                    if (l == null) {
                        l = new ArrayList<Clazz>();
                        this.classes.put(c.pkg, l);
                    }
                    l.add(c);
                    continue;
                }
                this.log("Refused line: " + line, 4);
            }
            if (matches == 0) {
                throw new BuildException("No classes defined in file: " + f);
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void printClassesAsHtml(PrintStream ps) {
        ps.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        ps.println("<HTML>\n<HEAD><TITLE>List of All Classes</TITLE></HEAD>");
        ps.println();
        for (String pkg : new TreeSet<String>(this.classes.keySet())) {
            ps.println("<H2>" + pkg + "</H2>");
            for (Clazz c : new TreeSet(this.classes.get(pkg))) {
                ps.print("<A HREF=\"" + c.url + "\">");
                if (c.isInterface) {
                    ps.print("<I>");
                }
                ps.print(c.name);
                if (c.isInterface) {
                    ps.print("</I>");
                }
                ps.println("</A>");
            }
        }
        ps.println("</HTML>");
    }

    private void printClassesAsXML(PrintStream ps) {
        ps.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ps.println("<classes>");
        for (String pkg : new TreeSet<String>(this.classes.keySet())) {
            for (Clazz c : new TreeSet(this.classes.get(pkg))) {
                ps.print("<class name=\"");
                ps.print(c.name);
                ps.print("\"");
                ps.print(" url=\"");
                ps.print(c.url);
                ps.print("\"");
                ps.print(" interface=\"");
                ps.print(c.isInterface);
                ps.print("\"");
                ps.print(" package=\"");
                ps.print(c.pkg);
                ps.print("\"");
                ps.println(" />");
            }
        }
        ps.println("</classes>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Clazz
    implements Comparable<Clazz> {
        public final String pkg;
        public final String name;
        public final String url;
        public final boolean isInterface;

        public Clazz(String pkg, String name, boolean isInterface, String url) {
            this.pkg = pkg;
            this.name = name;
            this.isInterface = isInterface;
            this.url = url;
        }

        @Override
        public int compareTo(Clazz o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "PKG: " + this.pkg + " NAME: " + this.name + " INTERFACE: " + this.isInterface + " url: " + this.url;
        }
    }
}

