/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.mail.MailMessage;

public class Kvetcher
extends Task
implements BuildListener {
    private Explanation explanation = null;
    private String target;
    private String from = null;
    private String subject = "Errors in sources";
    private String mailhost = "localhost";
    private List<Culprit> culprits = new ArrayList<Culprit>(20);
    private List<String> messages = new ArrayList<String>(1000);

    public Explanation createExplanation() {
        this.explanation = new Explanation();
        return this.explanation;
    }

    public void setTarget(String t) {
        this.target = t;
    }

    public void setFrom(String f) {
        this.from = f;
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public void setMailhost(String mh) {
        this.mailhost = mh;
    }

    public Culprit createCulprit() {
        Culprit c = new Culprit();
        this.culprits.add(c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.target == null) {
            throw new BuildException("set the target");
        }
        if (this.culprits.isEmpty()) {
            throw new BuildException("add some culprits");
        }
        Iterator<Culprit> it = this.culprits.iterator();
        while (it.hasNext()) {
            if (it.next().isValid()) continue;
            throw new BuildException("invalid <culprit>");
        }
        this.getProject().addBuildListener((BuildListener)this);
        boolean success = false;
        try {
            this.getProject().executeTarget(this.target);
            success = true;
        }
        finally {
            this.getProject().removeBuildListener((BuildListener)this);
        }
        if (success) {
            this.sendMail();
        }
    }

    public void messageLogged(BuildEvent buildEvent) {
        int pri = buildEvent.getPriority();
        if (pri == 1 || pri == 0) {
            this.messages.add(buildEvent.getMessage());
        }
    }

    private void sendMail() throws BuildException {
        for (Culprit c : this.culprits) {
            try {
                MailMessage mail = null;
                PrintStream ps = null;
                block3: for (String msg : this.messages) {
                    for (Regexp r : c.regexp) {
                        Matcher m = r.pattern.matcher(msg);
                        if (!m.find()) continue;
                        if (mail == null) {
                            this.log("Sending mail to " + c.to.get((int)0).name);
                            mail = new MailMessage(this.mailhost);
                            if (this.from == null) {
                                this.from = "kvetcher@" + this.mailhost;
                            }
                            mail.from(this.from);
                            for (Address a : c.to) {
                                mail.to(a.name);
                            }
                            for (Address a : c.cc) {
                                mail.cc(a.name);
                            }
                            mail.setSubject(this.subject);
                            ps = mail.getPrintStream();
                            if (this.explanation != null) {
                                ps.println(this.explanation.text.toString());
                            }
                            ps.println();
                        }
                        ps.println(r.group == -1 ? msg : m.group(r.group));
                        continue block3;
                    }
                }
                if (mail == null) continue;
                mail.sendAndClose();
            }
            catch (IOException ioe) {
                throw new BuildException("While sending mail", (Throwable)ioe, this.getLocation());
            }
        }
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public final class Regexp {
        Pattern pattern;
        int group = -1;

        public void setPattern(String p) throws BuildException {
            try {
                this.pattern = Pattern.compile(p);
            }
            catch (PatternSyntaxException rese) {
                throw new BuildException((Throwable)rese, Kvetcher.this.getLocation());
            }
        }

        public void setGroup(int g) {
            this.group = g;
        }

        boolean isValid() {
            return this.pattern != null;
        }
    }

    public final class Address {
        String name;

        public void setName(String n) {
            this.name = n;
        }

        boolean isValid() {
            return this.name != null;
        }
    }

    public final class Culprit {
        List<Address> to = new ArrayList<Address>(1);
        List<Address> cc = new ArrayList<Address>(1);
        List<Regexp> regexp = new ArrayList<Regexp>(5);

        public Address createTo() {
            Address a = new Address();
            this.to.add(a);
            return a;
        }

        public Address createCC() {
            Address a = new Address();
            this.cc.add(a);
            return a;
        }

        public Regexp createRegexp() {
            Regexp r = new Regexp();
            this.regexp.add(r);
            return r;
        }

        boolean isValid() {
            if (this.to.isEmpty() && this.cc.isEmpty() || this.regexp.isEmpty()) {
                return false;
            }
            Iterator<Object> it = this.to.iterator();
            while (it.hasNext()) {
                if (it.next().isValid()) continue;
                return false;
            }
            it = this.cc.iterator();
            while (it.hasNext()) {
                if (it.next().isValid()) continue;
                return false;
            }
            it = this.regexp.iterator();
            while (it.hasNext()) {
                if (((Regexp)it.next()).isValid()) continue;
                return false;
            }
            return true;
        }
    }

    public final class Explanation {
        StringBuffer text = new StringBuffer();

        public void addText(String s) {
            this.text.append(Kvetcher.this.getProject().replaceProperties(s));
        }
    }
}

