/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public class L10nTask
extends Task {
    File nbmsDir = null;
    File tmpDir = null;
    File patternsFile = null;
    File kitFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        BufferedReader lnr = null;
        try {
            if (this.nbmsDir == null) {
                throw new BuildException("Required variable not set.  Set 'nbmsdir' in the calling build script file");
            }
            if (!this.nbmsDir.exists() || !this.nbmsDir.isDirectory()) {
                throw new BuildException("'nbmsdir' has to exist and be directory where are all NBMs stored");
            }
            if (this.patternsFile == null) {
                throw new BuildException("Required variable not set.  Set 'patternsFile' in the calling build script file");
            }
            if (!this.patternsFile.exists() || !this.patternsFile.isFile()) {
                throw new BuildException("'patternsFile' has to exist and be file with patterns what should be included in the kit");
            }
            if (this.kitFile == null) {
                throw new BuildException("Required variable not set.  Set 'kitFile' in the calling build script file");
            }
            lnr = new LineNumberReader(new FileReader(this.patternsFile));
            String line = null;
            HashMap<String, HashSet<String>> includes = new HashMap<String, HashSet<String>>();
            HashMap<String, HashSet<String>> excludes = new HashMap<String, HashSet<String>>();
            HashSet<String> excludeFiles = new HashSet<String>();
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                Set<String> files;
                String[] p;
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                if (!line.startsWith("exclude ")) {
                    p = line.split(":");
                    if (p.length != 2) {
                        if (line.endsWith(":")) {
                            includes.put(line.substring(0, line.length() - 1), null);
                            continue;
                        }
                        throw new BuildException("Wrong pattern '" + line + "' found in pattern file: " + this.patternsFile.getAbsolutePath());
                    }
                    files = (HashSet<String>)includes.get(p[0]);
                    if (files == null) {
                        files = new HashSet<String>();
                        includes.put(p[0], (HashSet<String>)files);
                    }
                    files.add(p[1]);
                    continue;
                }
                p = (line = line.substring("exclude ".length())).split(":");
                if (p.length != 2) {
                    if (line.endsWith(":")) {
                        excludes.put(line.substring(0, line.length() - 1), null);
                        excludeFiles.add(line.substring(0, line.length() - 1));
                        continue;
                    }
                    throw new BuildException("Wrong pattern '" + line + "' found in pattern file: " + this.patternsFile.getAbsolutePath());
                }
                files = (Set)excludes.get(p[0]);
                if (files == null) {
                    files = new HashSet();
                    excludes.put(p[0], (HashSet<String>)files);
                }
                files.add(p[1]);
            }
            lnr.close();
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(this.nbmsDir);
            ds.setIncludes(new String[]{"**/*.nbm"});
            ds.scan();
            String[] nbms = ds.getIncludedFiles();
            Expand unzip = (Expand)this.getProject().createTask("unzip");
            for (String nbm : nbms) {
                File nbmFile = new File(this.nbmsDir, nbm);
                File nbmDir = new File(this.tmpDir, nbm);
                nbmDir.mkdirs();
                unzip.setSrc(nbmFile);
                unzip.setDest(nbmDir);
                unzip.execute();
            }
            ds.setBasedir(this.tmpDir);
            String[] includesKeys = includes.keySet().toArray(new String[]{""});
            String[] excludesKeys = excludes.keySet().toArray(new String[]{""});
            if (includesKeys[0] != null) {
                ds.setIncludes(includesKeys);
            }
            if (excludeFiles.size() > 0) {
                ds.setExcludes(excludeFiles.toArray(new String[]{""}));
            }
            ds.scan();
            if (this.kitFile.exists()) {
                this.kitFile.delete();
            }
            Zip zip = (Zip)this.getProject().createTask("zip");
            zip.setDestFile(this.kitFile);
            for (String file : ds.getIncludedFiles()) {
                ZipFileSet zipFileSet = new ZipFileSet();
                boolean matching = false;
                for (String include : includesKeys) {
                    if (!SelectorUtils.matchPath((String)include, (String)file)) continue;
                    Set incPattern = (Set)includes.get(include);
                    if (incPattern != null) {
                        matching = true;
                        zipFileSet.appendIncludes(incPattern.toArray(new String[]{""}));
                        continue;
                    }
                    FileSet fileSet = new FileSet();
                    fileSet.setDir(this.tmpDir);
                    fileSet.setIncludes(file);
                    zip.addFileset(fileSet);
                }
                if (!matching) continue;
                for (String exclude : excludesKeys) {
                    Set excPattern;
                    if (!SelectorUtils.matchPath((String)exclude, (String)file) || (excPattern = (Set)excludes.get(exclude)) == null) continue;
                    zipFileSet.appendExcludes(excPattern.toArray(new String[]{""}));
                }
                File oneFile = new File(this.tmpDir, file);
                zipFileSet.setSrc(oneFile);
                file = file.replaceAll("^visualweb", "vw");
                file = file.replaceAll("visualweb-", "vw-");
                file = file.replaceAll("ravehelp-rave_nbpack", "rh");
                file = file.replaceAll("org-netbeans-modules-", "");
                file = file.replaceAll("/netbeans/modules/", "/");
                file = file.replaceAll("\\.nbm/", "/");
                file = file.replaceAll("\\.jar", "");
                zipFileSet.setPrefix(file);
                zip.addZipfileset(zipFileSet);
            }
            zip.execute();
            Delete delete = (Delete)this.getProject().createTask("delete");
            delete.setDir(this.tmpDir);
            delete.execute();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(L10nTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(L10nTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                lnr.close();
            }
            catch (IOException ex) {
                Logger.getLogger(L10nTask.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setNbmsdir(File nbmsDir) {
        this.nbmsDir = nbmsDir;
    }

    public void setTmpdir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public void setPatternsFile(File patternsFile) {
        this.patternsFile = patternsFile;
    }

    public void setKitFile(File kitFile) {
        this.kitFile = kitFile;
    }
}

