/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerIndex
extends Task {
    List<FileSet> filesets = new ArrayList<FileSet>();
    private File output;

    public void addConfiguredModules(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setOutput(File f) {
        this.output = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.filesets.isEmpty()) {
            throw new BuildException();
        }
        TreeMap<String, String> files = new TreeMap<String, String>();
        TreeMap<String, SortedMap<String, String>> labels = new TreeMap<String, SortedMap<String, String>>();
        final TreeMap<String, Integer> positions = new TreeMap<String, Integer>();
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            for (String path : ds.getIncludedFiles()) {
                File jar = new File(basedir, path);
                try {
                    JarFile jf = new JarFile(jar);
                    try {
                        String modname;
                        Manifest mf = jf.getManifest();
                        if (mf == null || (modname = mf.getMainAttributes().getValue("OpenIDE-Module")) == null) continue;
                        String cnb = modname.replaceFirst("/\\d+$", "");
                        String layer = mf.getMainAttributes().getValue("OpenIDE-Module-Layer");
                        if (layer == null) continue;
                        this.parse(jf.getInputStream(jf.getEntry(layer)), files, labels, positions, cnb, jf);
                    }
                    finally {
                        jf.close();
                    }
                }
                catch (Exception x) {
                    throw new BuildException("Reading " + jar + ": " + x, (Throwable)x, this.getLocation());
                }
            }
        }
        int maxlength = 0;
        for (String cnb : files.values()) {
            maxlength = Math.max(maxlength, this.shortenCNB(cnb).length());
        }
        try {
            PrintWriter pw = this.output != null ? new PrintWriter(this.output) : null;
            TreeSet<String> layerPaths = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String p1, String p2) {
                    StringTokenizer tok1 = new StringTokenizer(p1, "/");
                    StringTokenizer tok2 = new StringTokenizer(p2, "/");
                    String prefix = "";
                    while (tok1.hasMoreTokens()) {
                        String piece1 = tok1.nextToken();
                        if (tok2.hasMoreTokens()) {
                            String piece2 = tok2.nextToken();
                            if (piece1.equals(piece2)) {
                                prefix = prefix + piece1 + "/";
                                continue;
                            }
                            Integer pos1 = this.pos(prefix + piece1);
                            Integer pos2 = this.pos(prefix + piece2);
                            if (pos1 == null) {
                                if (pos2 == null) {
                                    return piece1.compareTo(piece2);
                                }
                                return 1;
                            }
                            if (pos2 == null) {
                                return -1;
                            }
                            int diff = pos1 - pos2;
                            if (diff != 0) {
                                return diff;
                            }
                            return piece1.compareTo(piece2);
                        }
                        return 1;
                    }
                    if (tok2.hasMoreTokens()) {
                        return -1;
                    }
                    assert (p1.equals(p2)) : p1 + " vs. " + p2;
                    return 0;
                }

                Integer pos(String path) {
                    return positions.containsKey(path) ? (Integer)positions.get(path) : (Integer)positions.get(path + "/");
                }
            });
            layerPaths.addAll(files.keySet());
            TreeSet remaining = new TreeSet(files.keySet());
            remaining.removeAll(layerPaths);
            assert (remaining.isEmpty()) : remaining;
            for (String path : layerPaths) {
                SortedMap cnb2Label;
                String cnb = (String)files.get(path);
                String line = String.format("%-" + maxlength + "s %s", this.shortenCNB(cnb), this.shortenPath(path));
                Integer pos = (Integer)positions.get(path);
                if (pos != null) {
                    line = line + String.format(" @%d", pos);
                }
                if ((cnb2Label = (SortedMap)labels.get(path)) != null) {
                    if (cnb2Label.size() == 1 && ((String)cnb2Label.keySet().iterator().next()).equals(cnb)) {
                        line = line + String.format(" (\"%s\")", cnb2Label.values().iterator().next());
                    } else {
                        for (Map.Entry labelEntry : cnb2Label.entrySet()) {
                            line = line + String.format(" (%s: \"%s\")", this.shortenCNB((String)labelEntry.getKey()), labelEntry.getValue());
                        }
                    }
                }
                if (pw != null) {
                    pw.println(line);
                    continue;
                }
                this.log(line);
            }
            if (pw != null) {
                pw.close();
            }
        }
        catch (FileNotFoundException x) {
            throw new BuildException((Throwable)x, this.getLocation());
        }
        if (this.output != null) {
            this.log(this.output + ": layer index written");
        }
    }

    private String shortenCNB(String cnb) {
        if (cnb != null) {
            return cnb.replaceFirst("^org\\.netbeans\\.", "o.n.").replaceFirst("^org\\.openide\\.", "o.o.").replaceFirst("\\.modules\\.", ".m.");
        }
        return "";
    }

    private String shortenPath(String path) {
        return path.replaceAll("(^|/)org-netbeans-", "$1o-n-").replaceAll("(^|/)org-openide-", "$1o-o-").replaceAll("-modules-", "-m-").replaceAll("(^|/)org\\.netbeans\\.", "$1o.n.").replaceAll("(^|/)org\\.openide\\.", "$1o.o.").replaceAll("\\.modules\\.", ".m.");
    }

    private void parse(InputStream is, final Map<String, String> files, final SortedMap<String, SortedMap<String, String>> labels, final Map<String, Integer> positions, final String cnb, final JarFile jf) throws Exception {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setValidating(false);
        f.setNamespaceAware(false);
        f.newSAXParser().parse(is, new DefaultHandler(){
            String prefix = "";

            void register(String path) {
                if (files.containsKey(path)) {
                    files.put(path, null);
                } else {
                    files.put(path, cnb);
                }
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String intvalue;
                if (qName.equals("folder")) {
                    String n = attributes.getValue("name");
                    this.prefix = this.prefix + n + "/";
                    this.register(this.prefix);
                } else if (qName.equals("file")) {
                    String n = attributes.getValue("name");
                    this.prefix = this.prefix + n;
                    this.register(this.prefix);
                } else if (qName.equals("attr") && attributes.getValue("name").equals("SystemFileSystem.localizingBundle")) {
                    String bundlepath = attributes.getValue("stringvalue").replace('.', '/') + ".properties";
                    Properties props = new Properties();
                    try {
                        ZipEntry entry = jf.getEntry(bundlepath);
                        if (entry == null) {
                            LayerIndex.this.log(bundlepath + " not found in reference from " + this.prefix + " in " + cnb, 1);
                            return;
                        }
                        props.load(jf.getInputStream(entry));
                    }
                    catch (IOException x) {
                        throw new SAXException(x);
                    }
                    String key = this.prefix.replaceAll("/$", "");
                    String label = props.getProperty(key);
                    if (label == null) {
                        LayerIndex.this.log("Key " + key + " not found in " + bundlepath + " from " + cnb, 1);
                        return;
                    }
                    TreeMap<String, String> cnb2label = (TreeMap<String, String>)labels.get(this.prefix);
                    if (cnb2label == null) {
                        cnb2label = new TreeMap<String, String>();
                        labels.put(this.prefix, cnb2label);
                    }
                    cnb2label.put(cnb, label);
                } else if (qName.equals("attr") && attributes.getValue("name").equals("position") && (intvalue = attributes.getValue("intvalue")) != null && !intvalue.equals("0")) {
                    try {
                        positions.put(this.prefix, Integer.parseInt(intvalue));
                    }
                    catch (NumberFormatException x) {
                        throw new SAXException(x);
                    }
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equals("folder")) {
                    this.prefix = this.prefix.replaceFirst("[^/]+/$", "");
                } else if (qName.equals("file")) {
                    this.prefix = this.prefix.replaceFirst("[^/]+$", "");
                }
            }

            public InputSource resolveEntity(String pub, String sys) throws IOException, SAXException {
                return new InputSource(new StringReader(""));
            }
        });
    }
}

