/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.netbeans.nbbuild.JHIndexer;

public class LocJHIndexer
extends MatchingTask {
    protected File basedir = null;
    protected String dbdir = null;
    protected String locales = null;
    protected String jhall = null;

    public void setJhall(String jhall) {
        this.jhall = jhall;
    }

    protected String getJhall() {
        String ret = null;
        String prop = null;
        if (this.jhall != null) {
            ret = this.jhall;
        } else {
            prop = this.getProject().getProperty("locjhindexer.jhall");
            if (prop != null) {
                ret = prop;
            }
        }
        return ret;
    }

    public void setBasedir(File dir) {
        this.basedir = dir;
    }

    public void setDbdir(String dir) {
        this.dbdir = dir;
    }

    public void setLocales(String s) {
        this.locales = s;
    }

    protected String getLocales() {
        if (this.locales != null) {
            return this.locales;
        }
        return this.getProject().getProperty("locjhindexer.locales");
    }

    public void execute() throws BuildException {
        String locs = this.getLocales();
        String helpset_locs = null;
        StringTokenizer tokenizer = null;
        String loc = null;
        if (this.getJhall() == null) {
            throw new BuildException("Must specify the jhall attribute");
        }
        if (this.dbdir == null || this.dbdir.trim().equals("")) {
            throw new BuildException("Must specify the dbdir attribute");
        }
        if (this.basedir == null) {
            throw new BuildException("Must specify the basedir attribute");
        }
        if (locs == null || locs.trim().equals("")) {
            throw new BuildException("Must specify the locales attribute");
        }
        this.getProject().addTaskDefinition("jhindexer", JHIndexer.class);
        tokenizer = new StringTokenizer(locs, ", ");
        while (tokenizer.hasMoreTokens()) {
            loc = tokenizer.nextToken();
            if (!this.hasHelpset(loc)) continue;
            if (helpset_locs == null) {
                helpset_locs = new String(loc);
                continue;
            }
            helpset_locs = helpset_locs + "," + loc;
        }
        if (helpset_locs != null) {
            tokenizer = new StringTokenizer(helpset_locs, ", ");
            while (tokenizer.hasMoreTokens()) {
                loc = tokenizer.nextToken();
                this.RunForLocale(loc);
            }
        }
    }

    protected boolean hasHelpset(String loc) {
        boolean ret = false;
        LocHelpsetFilter filter = new LocHelpsetFilter(loc);
        File[] files = this.basedir.listFiles(filter);
        if (files != null && files.length > 0) {
            ret = true;
        }
        return ret;
    }

    protected void RunForLocale(String locale) throws BuildException {
        JHIndexer jhindexer = (JHIndexer)this.getProject().createTask("jhindexer");
        jhindexer.init();
        jhindexer.setIncludes(locale + "/**/*.htm*");
        jhindexer.setExcludes(locale + "/" + this.dbdir + "/" + "," + locale + "/credits.htm*");
        jhindexer.setBasedir(new File(this.basedir + "/"));
        jhindexer.setDb(new File(this.basedir + "/" + locale + "/" + this.dbdir));
        jhindexer.setLocale(locale);
        this.setJHLib(jhindexer);
        jhindexer.execute();
    }

    protected void setJHLib(JHIndexer jhindexer) {
        String dir;
        String regexp;
        LinkedList<String> dirs = new LinkedList<String>();
        LinkedList<String> regexps = new LinkedList<String>();
        String jhlib = this.getJhall();
        StringTokenizer st = new StringTokenizer(jhlib, " \t\n,");
        while (st.hasMoreTokens()) {
            int idx;
            regexp = st.nextToken();
            dir = regexp.substring(0, idx = regexp.lastIndexOf("/"));
            File file = new File(dir);
            if (!file.exists()) continue;
            dirs.add(dir);
            regexps.add(regexp.substring(idx + 1));
        }
        if (dirs.size() > 0) {
            Path path = jhindexer.createClasspath();
            for (int i = 0; i < dirs.size(); ++i) {
                dir = (String)dirs.get(i);
                regexp = (String)regexps.get(i);
                FileSet fs = new FileSet();
                fs.setDir(new File(dir));
                fs.setIncludes(regexp);
                path.addFileset(fs);
            }
        } else {
            throw new BuildException("jhall not found.");
        }
    }

    protected class LocHelpsetFilter
    implements FilenameFilter {
        protected String locale = null;

        public LocHelpsetFilter(String loc) {
            this.locale = loc;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith("_" + this.locale + ".hs");
        }
    }
}

