/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.MakeLNBM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocMakeNBM
extends Task {
    protected String locales = null;
    protected String mainDir = null;
    protected File topDir = null;
    protected String fileName = null;
    protected String moduleName = null;
    protected String baseFileName = null;
    protected boolean deleteInfo = false;
    protected String nbmIncludes = null;
    protected String modInfo = null;
    protected String findLocBundle = ".";
    protected File locBundle = null;
    protected String locIncludes = null;

    public void setLocales(String s) {
        this.locales = s;
    }

    public void setMainDir(String s) {
        this.mainDir = s;
    }

    public void setTopDir(File f) {
        this.topDir = f;
    }

    public void setModule(String module) {
        this.moduleName = module;
        this.log("Setting moduleName = '" + this.moduleName + "'", 3);
    }

    public void setFile(String s) {
        this.fileName = s;
        this.log("Setting fileName = '" + this.fileName + "'", 3);
        if (!this.fileName.substring(this.fileName.length() - 4).equals(".nbm")) {
            throw new BuildException("Incorrect NBM file name \"" + s + "\". NBM file name must end in '.nbm'");
        }
        this.baseFileName = this.fileName.substring(0, this.fileName.length() - 4);
    }

    public void setDeleteInfo(boolean b) {
        this.deleteInfo = b;
    }

    public void setNbmIncludes(String s) {
        this.nbmIncludes = s;
    }

    public void setModInfo(String s) {
        this.modInfo = s;
    }

    public void setLocBundle(File f) {
        this.locBundle = f;
    }

    public void setFindLocBundle(String s) {
        this.findLocBundle = s;
    }

    public void setLocIncludes(String s) {
        this.locIncludes = s;
    }

    public void execute() throws BuildException {
        try {
            this.really_execute();
        }
        catch (BuildException be) {
            be.printStackTrace();
            throw be;
        }
    }

    public void really_execute() throws BuildException {
        LinkedList<String> build_locales = new LinkedList<String>();
        if (this.mainDir == null) {
            this.mainDir = new String("netbeans");
        }
        if (this.topDir == null) {
            this.topDir = this.getProject().getBaseDir();
        }
        if (this.modInfo == null && this.moduleName != null) {
            Manifest mani;
            JarFile jf;
            File f = new File(this.topDir, this.moduleName.replace('/', File.separatorChar));
            try {
                jf = new JarFile(f);
            }
            catch (IOException ioe) {
                throw new BuildException("I/O error during opening module jarfile", (Throwable)ioe, this.getLocation());
            }
            try {
                mani = jf.getManifest();
            }
            catch (IOException ioe) {
                throw new BuildException("I/O error getting manifest from file '" + f.getAbsolutePath() + "'", (Throwable)ioe, this.getLocation());
            }
            if (mani != null) {
                Attributes attr = mani.getMainAttributes();
                String cname = attr.getValue("OpenIDE-Module");
                String sver = attr.getValue("OpenIDE-Module-Specification-Version");
                if (cname != null && !cname.equals("") && sver != null && !sver.equals("")) {
                    this.modInfo = cname + '/' + sver;
                    this.log("Gathered module information from module jarfile. Codename = '" + cname + "' and specification version = '" + sver + "'", 3);
                } else {
                    throw new BuildException("Module in file '" + f.getAbsolutePath() + "' does not have either OpenIDE-Module attribute or OpenIDE-Module-Specification-Version attributes or missing both.", this.getLocation());
                }
            }
        }
        if (this.printMissingDirWarning()) {
            return;
        }
        String locs = this.getLocales();
        if (locs == null || locs.trim().equals("")) {
            throw new BuildException("Must specify 1 or more locales.");
        }
        if (this.fileName == null) {
            throw new BuildException("Must specify the file attribute.");
        }
        this.getProject().addTaskDefinition("makelnbm", MakeLNBM.class);
        StringTokenizer stok = new StringTokenizer(locs, ",");
        while (stok.hasMoreTokens()) {
            String loc = stok.nextToken();
            this.log("Checking if module has files in locale '" + loc + "'", 3);
            if (this.hasFilesInLocale(loc)) {
                build_locales.add(loc);
                this.log("Module has files in locale '" + loc + "'", 3);
                continue;
            }
            this.log("Module has no files in locale '" + loc + "'", 3);
        }
        ListIterator iterator = build_locales.listIterator();
        while (iterator.hasNext()) {
            this.buildNbm((String)iterator.next());
        }
    }

    protected void buildNbm(String locale) throws BuildException {
        File licenseFile;
        LinkedList<String> list = new LinkedList<String>();
        String includes = new String();
        if (this.deleteInfo) {
            Delete del = (Delete)this.getProject().createTask("delete");
            del.init();
            del.setDir(new File(this.topDir.getAbsolutePath() + File.separator + "Info"));
            del.execute();
            del.setDir(new File(this.topDir.getAbsolutePath() + File.separator + "Info_" + locale));
            del.execute();
        } else {
            this.switchInfo(true, locale);
        }
        MakeLNBM makenbm = (MakeLNBM)this.getProject().createTask("makelnbm");
        makenbm.init();
        makenbm.setModInfo(this.modInfo);
        makenbm.setLangCode(locale);
        String fname = this.getLocalizedFileName(locale);
        makenbm.setFile(new File(this.getProject().getBaseDir().getAbsolutePath() + File.separator + fname));
        makenbm.setTopdir(this.topDir);
        makenbm.setIsStandardInclude(false);
        String distbase = this.getProject().getProperty("dist.base");
        if (distbase != null) {
            int idx = fname.lastIndexOf(47);
            makenbm.setDistribution(distbase + "/" + fname.substring(idx + 1));
        }
        if ((licenseFile = this.getLicenseFile(locale)) != null) {
            MakeLNBM.Blurb blurb = makenbm.createLicense();
            blurb.setFile(licenseFile);
        }
        if (this.locBundle != null) {
            this.setLocBundle(makenbm, this.getSpecificLocBundleFile(this.locBundle, locale));
        } else {
            this.setLocBundle(makenbm, this.findLocBundle(makenbm, locale));
        }
        if (this.getKeystore() != null && this.getStorepass() != null && this.getAlias() != null) {
            MakeLNBM.Signature sign = makenbm.createSignature();
            sign.setKeystore(new File(this.getKeystore()));
            sign.setStorepass(this.getStorepass());
            sign.setAlias(this.getAlias());
        }
        this.addLocalePatterns(list, locale);
        boolean first_time = true;
        for (String s1 : list) {
            if (!first_time) {
                includes = includes + ",";
            }
            includes = includes + s1;
            first_time = false;
        }
        if (this.nbmIncludes != null && !this.nbmIncludes.trim().equals("")) {
            if (!first_time) {
                includes = includes + ",";
            }
            includes = includes + this.nbmIncludes;
        }
        makenbm.setIncludes(includes);
        makenbm.execute();
        this.switchInfo(false, locale);
    }

    protected File getLicenseFile(String locale) {
        String license_prop_name = locale + ".license.file";
        String license_prop = this.getProject().getProperty(license_prop_name);
        File license = null;
        if (license_prop != null) {
            license = new File(license_prop);
        }
        return license;
    }

    protected void switchInfo(boolean to_info, String locale) {
        if (to_info) {
            File dir = new File(this.topDir.getAbsolutePath() + File.separator + "Info_" + locale);
            dir.renameTo(new File(this.topDir.getAbsolutePath() + File.separator + "Info"));
        } else {
            File dir = new File(this.topDir.getAbsolutePath() + File.separator + "Info");
            dir.renameTo(new File(this.topDir.getAbsolutePath() + File.separator + "Info_" + locale));
        }
    }

    protected String getLocalizedFileName(String locale) {
        return this.baseFileName + "_" + locale + ".nbm";
    }

    protected String getLocales() {
        if (this.locales != null) {
            return this.locales;
        }
        return this.getGlobalProp("locmakenbm.locales");
    }

    protected boolean hasFilesInLocale(String loc) {
        boolean ret = true;
        FileSet fs = new FileSet();
        fs.setDir(this.topDir);
        this.addLocalePatterns(fs, loc);
        String[] inc_files = fs.getDirectoryScanner(this.getProject()).getIncludedFiles();
        if (inc_files.length == 0) {
            ret = false;
        }
        return ret;
    }

    protected void addLocalePatterns(FileSet fs, String loc) {
        LinkedList<String> list = new LinkedList<String>();
        this.addLocalePatterns(list, loc);
        for (String s : list) {
            fs.createInclude().setName(s);
        }
    }

    protected void addLocalePatterns(LinkedList<String> list, String loc) {
        String re = new String();
        re = "**/*_" + loc + ".*";
        list.add(re);
        re = "**/" + loc + "/";
        list.add(re);
        this.addLocIncludes(list, loc);
        if (loc.equals("ja")) {
            this.addLocalePatterns(list, "ja_JP.PCK");
            this.addLocalePatterns(list, "ja_JP.eucJP");
            this.addLocalePatterns(list, "ja_JP.SJIS");
            this.addLocalePatterns(list, "ja_JP.UTF-8");
            this.addLocalePatterns(list, "ja_JP.UTF8");
        }
    }

    protected void addLocIncludes(LinkedList<String> list, String loc) {
        if (this.locIncludes == null) {
            return;
        }
        StringTokenizer tkzr = new StringTokenizer(this.locIncludes, ",\n\t ");
        while (tkzr.hasMoreTokens()) {
            String locInc = tkzr.nextToken();
            int idx = locInc.indexOf(":");
            if (idx != -1) {
                String incLocale = locInc.substring(0, idx);
                String incPattern = locInc.substring(idx + 1);
                if (!incLocale.equals(loc)) continue;
                list.add(incPattern);
                continue;
            }
            list.add(locInc);
        }
    }

    protected String getGlobalProp(String name) {
        String ret = this.getProject().getProperty(name);
        if (ret != null) {
            if (ret.trim().equals("")) {
                ret = null;
            } else if (ret.indexOf("${") != -1) {
                ret = null;
            }
        }
        return ret;
    }

    protected String getKeystore() {
        return this.getGlobalProp("locmakenbm.keystore");
    }

    protected String getStorepass() {
        return this.getGlobalProp("locmakenbm.storepass");
    }

    protected String getAlias() {
        return this.getGlobalProp("locmakenbm.alias");
    }

    protected boolean printMissingDirWarning() {
        boolean ret = false;
        if (!this.topDir.exists()) {
            this.log("WARNING: Skipping this task: Directory " + this.topDir.getPath() + " doesn't exist.");
            ret = true;
        }
        return ret;
    }

    protected void setLocBundle(MakeLNBM makenbm, File bundle) {
        if (bundle != null && bundle.exists()) {
            makenbm.setLocBundle(bundle);
        } else {
            this.log("WARNING: Localizing bundle not found: " + (bundle == null ? "" : bundle.getPath()));
        }
    }

    protected String getSrcDir(File file) {
        char[] buf = new char[200];
        String s = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader(fis);
            int len = isr.read(buf);
            if (len != -1) {
                int idx;
                if (buf[len - 1] == '\n') {
                    --len;
                }
                if ((idx = (s = new String(buf, 0, len)).indexOf("=")) != -1) {
                    s = s.substring(idx + 1);
                    s.trim();
                } else {
                    s = null;
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
            throw new BuildException();
        }
        return s;
    }

    protected File findLocBundle(MakeLNBM makenbm, String locale) {
        int index;
        String srcdir = null;
        File srcdirfile = new File(this.topDir.getAbsolutePath() + File.separator + "srcdir.properties");
        if (srcdirfile.exists()) {
            srcdir = this.getSrcDir(srcdirfile);
        }
        String s = (index = this.modInfo.indexOf("/")) != -1 ? this.modInfo.substring(0, index) : new String(this.modInfo);
        s = s.replace('.', '/');
        File locdir = new File(this.getRelPath(srcdir + "/" + s, this.findLocBundle).replace('/', File.separatorChar));
        return this.getDefaultLocBundleFile(locdir, locale);
    }

    protected File getDefaultLocBundleFile(File dir, String locale) {
        return new File(dir.getPath() + File.separator + "Bundle_" + locale + ".properties");
    }

    protected File getSpecificLocBundleFile(File enBundle, String locale) {
        String path = enBundle.getPath();
        int idx = path.lastIndexOf(46);
        if (idx != -1) {
            return new File(path.substring(0, idx) + "_" + locale + path.substring(idx));
        }
        return new File(path + "_" + locale);
    }

    protected String getRelPath(String path1, String path2) {
        int idx2;
        if (path2.equals(".")) {
            return path1;
        }
        while ((idx2 = path2.indexOf("..")) != -1) {
            int idx1;
            idx2 = (path2 = path2.substring(2)).indexOf("/");
            if (idx2 == 0) {
                path2 = path2.substring(1);
            }
            if ((idx1 = path1.lastIndexOf("/")) == -1) continue;
            path1 = path1.substring(0, idx1);
        }
        return path1 + "/" + path2;
    }
}

