/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizedJar
extends MatchingTask {
    private List<FileSet> localeKits = new LinkedList<FileSet>();
    private List<LocaleOrB> locales = new LinkedList<LocaleOrB>();
    private List<LocaleOrB> brandings = new LinkedList<LocaleOrB>();
    private File jarFile;
    private File baseDir;
    private boolean doCompress = false;
    private static long emptyCrc = new CRC32().getValue();
    private List<FileSet> filesets = new LinkedList<FileSet>();
    private File manifest;
    private boolean checkPathLocale = true;
    private boolean warnMissingDir = false;
    private boolean warnMissingDirSet = false;
    private boolean preserveModuleJar = true;
    private boolean alwaysIncludeManifest = false;

    public void addLocalekit(FileSet fs) {
        this.localeKits.add(fs);
    }

    public LocaleOrB createLocale() {
        LocaleOrB l = new LocaleOrB();
        this.locales.add(l);
        return l;
    }

    public LocaleOrB createBranding() {
        LocaleOrB l = new LocaleOrB();
        this.brandings.add(l);
        return l;
    }

    public void setJarfile(File jarFile) {
        if (!jarFile.getName().endsWith(".jar")) {
            throw new BuildException("jarfile attribute must be a file with *.jar extension");
        }
        if (jarFile.getParentFile() == null) {
            throw new BuildException("jarfile attribute must have a containing directory");
        }
        this.jarFile = jarFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCompress(boolean compress) {
        this.doCompress = compress;
    }

    public void setPreserveModuleJar(boolean pmj) {
        this.preserveModuleJar = pmj;
    }

    public void setAlwaysIncludeManifest(boolean aim) {
        this.alwaysIncludeManifest = aim;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public void setCheckPathLocale(boolean doit) {
        this.checkPathLocale = doit;
    }

    public void setWarnMissingDir(boolean b) {
        this.warnMissingDir = b;
        this.warnMissingDirSet = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.jarFile == null) {
            throw new BuildException("You must specify the JAR file to create!");
        }
        if (this.manifest != null && !this.manifest.isFile()) {
            throw new BuildException("The specified manifest does not actually exist.");
        }
        if (this.shouldWarnMissingDir() && this.warnIfMissingDir()) {
            return;
        }
        this.addGlobalLocaleAndBranding();
        HashMap<String, File> allFiles = new HashMap<String, File>();
        ArrayList<DirectoryScanner> scanners = new ArrayList<DirectoryScanner>(this.filesets.size() + 1);
        if (this.baseDir != null) {
            scanners.add(this.getDirectoryScanner(this.baseDir));
        }
        for (FileSet fileSet : this.filesets) {
            scanners.add(fileSet.getDirectoryScanner(this.getProject()));
        }
        for (FileScanner fileScanner : scanners) {
            File thisBaseDir = fileScanner.getBasedir();
            String[] files = fileScanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].replace(File.separatorChar, '/');
                if (name.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                    this.log("Warning: ignoring META-INF/MANIFEST.MF found among scanned files", 1);
                    continue;
                }
                allFiles.put(name, new File(thisBaseDir, files[i]));
            }
        }
        HashSet<File> localeKitFiles = new HashSet<File>();
        for (FileSet fileSet : this.localeKits) {
            DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
            File thisBaseDir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                localeKitFiles.add(new File(thisBaseDir, files[i]));
            }
        }
        LinkedList<String> locales2 = new LinkedList<String>();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (LocaleOrB lob : this.locales) {
            locales2.add(lob.n);
        }
        for (LocaleOrB lob : this.brandings) {
            linkedList.add(lob.n);
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InverseLengthComparator
        implements Comparator<String> {
            InverseLengthComparator() {
            }

            @Override
            public int compare(String s1, String s2) {
                return s2.length() - s1.length();
            }
        }
        Collections.sort(locales2, new InverseLengthComparator());
        Collections.sort(linkedList, new InverseLengthComparator());
        HashSet<File> jars = new HashSet<File>();
        HashMap<File, String> localeMarks = new HashMap<File, String>();
        HashMap<File, String> brandingMarks = new HashMap<File, String>();
        HashMap<File, TreeMap<String, File>> router = new HashMap<File, TreeMap<String, File>>();
        for (Map.Entry entry : allFiles.entrySet()) {
            String path = (String)entry.getKey();
            this.log("==> Examining file: " + path, 4);
            File file = (File)entry.getValue();
            String testpath = path;
            int idx = testpath.lastIndexOf(47);
            if (idx != -1) {
                testpath = testpath.substring(idx + 1);
            }
            if ((idx = testpath.lastIndexOf(46)) != -1) {
                testpath = testpath.substring(0, idx);
            }
            String thisLocale = null;
            for (String tryLocale : locales2) {
                if (!testpath.endsWith("_" + tryLocale)) continue;
                thisLocale = tryLocale;
                testpath = testpath.substring(0, testpath.length() - 1 - tryLocale.length());
                break;
            }
            String thisBranding = null;
            for (String tryBranding : linkedList) {
                if (!testpath.endsWith("_" + tryBranding)) continue;
                thisBranding = tryBranding;
                break;
            }
            File thisjar = null;
            String localeDir = this.checkInLocaleDir(file, locales2);
            if (localeDir != null) {
                thisLocale = localeDir;
            }
            if (thisLocale != null) {
                this.log("    Locale: " + thisLocale, 4);
            } else {
                this.log("    Locale not set", 4);
            }
            if (thisBranding != null) {
                this.log("    Branding: " + thisBranding, 4);
            } else {
                this.log("    Branding not set", 4);
            }
            if (localeKitFiles.contains(file)) {
                this.log("    Localizable file.", 4);
            }
            if (thisLocale != null || thisBranding != null || localeKitFiles.contains(file)) {
                String name = this.jarFile.getName();
                name = name.substring(0, name.length() - 4);
                if (thisBranding != null) {
                    name = name + '_' + thisBranding;
                }
                if (thisLocale != null) {
                    name = name + '_' + thisLocale;
                }
                name = name + ".jar";
                if (this.preserveModuleJar && thisBranding == null && thisLocale == null) {
                    thisjar = null;
                    this.log("    Preserving module file (1): " + this.jarFile.getName(), 4);
                } else {
                    thisjar = new File(new File(this.jarFile.getParentFile(), "locale"), name);
                    localeMarks.put(thisjar, thisLocale != null ? thisLocale : "-");
                    brandingMarks.put(thisjar, thisBranding != null ? thisBranding : "-");
                }
            } else if (this.preserveModuleJar) {
                thisjar = null;
                this.log("    Preserving module file (2): " + this.jarFile.getName(), 4);
            } else {
                thisjar = this.jarFile;
                localeMarks.put(thisjar, null);
                brandingMarks.put(thisjar, null);
            }
            if (thisjar == null) continue;
            this.log("    Adding file " + thisjar.getName() + " to 'jars' HashSet", 4);
            jars.add(thisjar);
            TreeMap<String, File> files = (TreeMap<String, File>)router.get(thisjar);
            if (files == null) {
                files = new TreeMap<String, File>();
                router.put(thisjar, files);
            }
            files.put(path, file);
        }
        ArrayList jars2 = new ArrayList(jars);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FileNameComparator
        implements Comparator<File> {
            FileNameComparator() {
            }

            @Override
            public int compare(File f1, File f2) {
                return f1.toString().compareTo(f2.toString());
            }
        }
        Collections.sort(jars2, new FileNameComparator());
        for (File jar : jars2) {
            Map files = (Map)router.get(jar);
            if (jar.exists()) {
                long time = jar.lastModified();
                if (this.manifest == null || this.manifest.lastModified() <= time) {
                    boolean upToDate = true;
                    for (File f : files.values()) {
                        if (f.lastModified() <= time) continue;
                        upToDate = false;
                        break;
                    }
                    if (upToDate) continue;
                }
            }
            this.log("Building localized/branded jar: " + jar);
            IOException closing = null;
            try {
                jar.getParentFile().mkdirs();
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(jar));
                try {
                    Attributes attr;
                    Manifest mani;
                    long time;
                    InputStream is;
                    out.setMethod(this.doCompress ? 8 : 0);
                    String localeMark = (String)localeMarks.get(jar);
                    String brandingMark = (String)brandingMarks.get(jar);
                    HashSet<String> addedDirs = new HashSet<String>();
                    if (this.manifest != null && localeMark == null && brandingMark == null) {
                        is = new FileInputStream(this.manifest);
                        time = this.manifest.lastModified();
                        try {
                            mani = new Manifest(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    if (this.manifest != null && this.alwaysIncludeManifest) {
                        is = new FileInputStream(this.manifest);
                        time = this.manifest.lastModified();
                        try {
                            mani = new Manifest(is);
                        }
                        finally {
                            is.close();
                        }
                        attr = mani.getMainAttributes();
                        if (attr.containsKey("OpenIDE-Module") && (localeMark != null || brandingMark != null)) {
                            String lbmsg = "";
                            if (localeMark != null) {
                                lbmsg = "locale: '" + localeMark + "' ";
                            }
                            if (brandingMark != null) {
                                lbmsg = "branding: '" + brandingMark + "' ";
                            }
                            this.log("WARNING: Ignoring supplied NetBeans module manifest for " + lbmsg + "jarfile '" + jar + "'. Using default Ant manifest bolilerplate. " + "Use -verbose option to see more details.", 2);
                            this.log("WARNING(verbose): Supplied manifest file '" + this.manifest.getAbsolutePath() + "' contains " + "key OpenIDE-Module, which cannot be included in manifest of localized " + "and/or branded jar. Ignoring whole manifest for now. To fix this you have " + "to avoid using NetBeans module manifest file together with attribute " + "'allwaysincludemanifest' set to 'true' and non-empty properties 'locjar.locales' " + "and 'locjar.brands'. You can accomplish that by i.e. using Ant's <jar> task " + "for regular NetBeans module jarfile packaging and use NetBeans' Ant extension " + "task <" + this.getTaskName() + "> for localized and/or branded jars. Using default " + "Ant's manifest boilerplate instead.", 3);
                            try {
                                is.close();
                            }
                            finally {
                                is = MatchingTask.class.getResourceAsStream("/org/apache/tools/ant/defaultManifest.mf");
                                time = System.currentTimeMillis();
                                try {
                                    mani = new Manifest(is);
                                }
                                finally {
                                    is.close();
                                }
                            }
                        }
                    } else {
                        is = MatchingTask.class.getResourceAsStream("/org/apache/tools/ant/defaultManifest.mf");
                        time = System.currentTimeMillis();
                        try {
                            mani = new Manifest(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    if (!(attr = mani.getMainAttributes()).containsKey(Attributes.Name.MANIFEST_VERSION)) {
                        attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                    }
                    if (localeMark != null) {
                        attr.putValue("X-Informational-Archive-Locale", localeMark);
                    }
                    if (brandingMark != null) {
                        attr.putValue("X-Informational-Archive-Branding", brandingMark);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    mani.write(baos);
                    byte[] bytes = baos.toByteArray();
                    this.addToJar(new ByteArrayInputStream(bytes), new ByteArrayInputStream(bytes), out, "META-INF/MANIFEST.MF", time, addedDirs);
                    for (Map.Entry entry : files.entrySet()) {
                        String path = (String)entry.getKey();
                        File file = (File)entry.getValue();
                        this.addToJar(new FileInputStream(file), new FileInputStream(file), out, path, file.lastModified(), addedDirs);
                    }
                    this.writeSrcDir();
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        closing = ex;
                    }
                }
                if (closing == null) continue;
                throw closing;
            }
            catch (IOException ioe) {
                String msg = "Problem creating JAR: " + ioe.getMessage();
                if (!jar.delete()) {
                    msg = msg + " (and the JAR is probably corrupt but I could not delete it)";
                }
                throw new BuildException(msg, (Throwable)ioe, this.getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToJar(InputStream in1, InputStream in2, ZipOutputStream out, String path, long lastModified, Set<String> addedDirs) throws IOException {
        try {
            int read;
            if (path.endsWith("/")) {
                throw new IOException("Bad path: " + path);
            }
            int pos = -1;
            while ((pos = path.indexOf(47, pos + 1)) != -1) {
                String dir = path.substring(0, pos + 1);
                if (addedDirs.contains(dir)) continue;
                addedDirs.add(dir);
                ZipEntry ze = new ZipEntry(dir);
                ze.setSize(0L);
                ze.setMethod(0);
                ze.setCrc(emptyCrc);
                ze.setTime(lastModified);
                out.putNextEntry(ze);
            }
            ZipEntry ze = new ZipEntry(path);
            ze.setMethod(this.doCompress ? 8 : 0);
            ze.setTime(lastModified);
            long size = 0L;
            CRC32 crc = new CRC32();
            byte[] buf = new byte[4096];
            while ((read = in1.read(buf)) != -1) {
                crc.update(buf, 0, read);
                size += (long)read;
            }
            in1.close();
            ze.setCrc(crc.getValue());
            ze.setSize(size);
            out.putNextEntry(ze);
            while ((read = in2.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
        finally {
            in2.close();
            in1.close();
        }
    }

    protected String checkInLocaleDir(File file, List<String> locales) {
        if (!this.checkPathLocale) {
            return null;
        }
        String ret = null;
        String path = file.getPath();
        for (String loc : locales) {
            String locale_dir = new String(File.separator);
            locale_dir = locale_dir + loc;
            int idx = path.indexOf(locale_dir = locale_dir + File.separator);
            if (idx == -1) continue;
            ret = loc;
            break;
        }
        return ret;
    }

    protected void addGlobalLocaleAndBranding() {
        this.addGlobals(this.getGlobalLocaleVarName(), this.locales);
        this.addGlobals(this.getOldGlobalLocaleVarName(), this.locales);
        this.addGlobals(this.getGlobalBrandingVarName(), this.brandings);
        this.addGlobals(this.getOldGlobalBrandingVarName(), this.brandings);
    }

    protected String getGlobalLocaleVarName() {
        return new String("locjar.locales");
    }

    protected String getGlobalBrandingVarName() {
        return new String("locjar.brands");
    }

    protected String getOldGlobalLocaleVarName() {
        return new String("locjar_global_locales");
    }

    protected String getOldGlobalBrandingVarName() {
        return new String("locjar_global_brands");
    }

    protected void addGlobals(String var_name, List<LocaleOrB> list) {
        String prop = null;
        StringTokenizer tokenizer = null;
        String tok = null;
        LocaleOrB lorb = null;
        prop = this.getProject().getProperty(var_name);
        if (prop != null && !prop.equals("")) {
            tokenizer = new StringTokenizer(prop, ", ");
            while (tokenizer.hasMoreTokens()) {
                tok = tokenizer.nextToken();
                lorb = new LocaleOrB();
                lorb.setName(tok);
                list.add(lorb);
            }
        }
    }

    protected boolean shouldWarnMissingDir() {
        boolean ret = false;
        if (this.warnMissingDirSet) {
            ret = this.warnMissingDir;
        } else {
            String s = this.getProject().getProperty("locjar.warnMissingDir");
            if (s != null && !s.trim().equals("")) {
                this.getProject();
                ret = Project.toBoolean((String)s);
            }
        }
        return ret;
    }

    protected boolean warnIfMissingDir() {
        boolean ret = false;
        if (this.baseDir != null && !this.baseDir.exists()) {
            ret = true;
            this.printMissingDirWarning(this.baseDir);
        }
        for (FileSet fileset : this.filesets) {
            File dir = fileset.getDir(this.getProject());
            if (dir == null || dir.exists()) continue;
            ret = true;
            this.printMissingDirWarning(dir);
        }
        return ret;
    }

    protected void printMissingDirWarning(File dir) {
        this.log("WARNING: Skipping this task: Directory " + dir.getPath() + " doesn't exist.");
    }

    protected boolean shouldWriteSrcDir() {
        boolean ret = false;
        String s = this.getProject().getProperty("locjar.writeSrcDir");
        if (s != null) {
            this.getProject();
            if (Project.toBoolean((String)s)) {
                ret = true;
            }
        }
        return ret;
    }

    protected void writeSrcDir() {
        if (this.shouldWriteSrcDir() && this.jarFile != null && this.baseDir != null) {
            String name = this.jarFile.getPath();
            int fromIdx = this.getNetbeansStartIdx();
            int idx = name.indexOf(File.separator + "netbeans" + File.separator, fromIdx);
            if (idx != -1) {
                try {
                    File file = new File(name.substring(0, idx) + File.separator + "srcdir.properties");
                    FileOutputStream fos = new FileOutputStream(file);
                    OutputStreamWriter osw = new OutputStreamWriter(fos);
                    osw.write("srcdir=" + this.baseDir + "\n");
                    osw.close();
                    fos.close();
                }
                catch (Exception e) {
                    System.out.println("ERROR: " + e.getMessage());
                    e.printStackTrace();
                    throw new BuildException();
                }
            } else {
                throw new BuildException("ERROR: Couldn't find netbeans dir to write srcdir.properties to.");
            }
        }
    }

    protected int getNetbeansStartIdx() {
        int startIdx = 0;
        int idx = this.baseDir.getPath().lastIndexOf(File.separator + "netbeans" + File.separator);
        if (idx != -1) {
            startIdx = idx + 1;
        }
        return startIdx;
    }

    public class LocaleOrB {
        String n;

        public void setName(String n) {
            this.n = n;
        }
    }
}

